//
//  PPContactRowObject+Office365.m
//  Pods
//
//  Created by sanhue on 2019/8/1.
//

#import "PPContactRowObject+Office365.h"

@implementation PPContactRowObject (Office365)


//================================================================================
//
//================================================================================
- (PPContactSubType)office365ContactSubTypeWithLocalizedPlaceholder:(NSString *)placeholder
{
    PPContactSubType subType = PPContactSubType_None;
    
    switch(self.contactMainType)
    {
        case PPContactMainType_Name:
        {
            // name section
            if([placeholder isEqualToString:WCCV_MLS_Name_Last])
            {
                subType = PPContactSubType_Name_LastName;
            }
            else if([placeholder isEqualToString:WCCV_MLS_Name_First])
            {
                subType = PPContactSubType_Name_FirstName;
            }
            else if([placeholder isEqualToString:WCCV_MLS_Name_FirstPhonetic])
            {
                subType = PPContactSubType_Name_FirstNamePhonetic;
            }
            else if([placeholder isEqualToString:WCCV_MLS_Name_LastPhonetic])
            {
                subType = PPContactSubType_Name_LastNamePhonetic;
            }
            else if([placeholder isEqualToString:WCCV_MLS_Name_Suffix_Office365])
            {
                subType = PPContactSubType_Name_Surffix;
            }
            else if([placeholder isEqualToString:WCCV_MLS_Name_Middle])
            {
                subType = PPContactSubType_Name_MiddleName;
            }
            
            break;
        }
        default:
        {
            subType = [self contactSubTypeWithLocalizedPlaceholder:placeholder];
            break;
        }
    }
    return subType;
}

//================================================================================
//
//================================================================================
- (NSString *)office365PlaceholderForPPContactSubType:(PPContactSubType)contactSubType countryCode:(NSString *)countryCode
{
    NSString *placeholder = nil;
    
    do
    {
        switch(contactSubType)
        {
                //客制其他稱謂字串
            case PPContactSubType_Name_Surffix:
            {
                placeholder = WCCV_MLS_Name_Suffix_Office365;
                
                break;
            }
            default:
            {
                placeholder = [self placeholderForPPContactSubType:contactSubType countryCode:countryCode];
                break;
            }
        }
    } while (0);
    
    return placeholder;
}
@end
