//
//  Office365EditDataModel.m
//  
//
//  Created by Howard on 2019/2/18.
//

#import "Office365EditDataModel.h"

#define WCO365_FMC_Default              1
#define WCO365_FMC_Phone_Work           2
#define WCO365_FMC_Phone_Home           2
#define WCO365_FMC_Email                3

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation Office365EditDataModel


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method


//==============================================================================
// MARK: office欄位數限制
//==============================================================================
+ (NSInteger)fieldMaxCountWithMainType:(PPContactMainType)mainType labelType:(PPContactLabelType)labelType
{
    switch (mainType)
    {
        case PPContactMainType_Name:
        {
            return WCO365_FMC_Default;
        }
        case PPContactMainType_Email:
        {
            return WCO365_FMC_Email;
        }
        case PPContactMainType_Company:
        {
            return WCO365_FMC_Default;
        }
        default:
        {
            switch (labelType)
            {
                    // phone limit
                case PPContactLabelType_Phone_Work:
                {
                    return WCO365_FMC_Phone_Work;
                }
                case PPContactLabelType_Phone_Home:
                {
                    return WCO365_FMC_Phone_Home;
                }
                case PPContactLabelType_Phone_Mobile:
                    // address limit
                case PPContactLabelType_Address_Home:
                case PPContactLabelType_Address_Other:
                case PPContactLabelType_Address_Work:
                    // Other
                case PPContactLabelType_Other_NickName:
                case PPContactLabelType_Other_Birthday:
                case PPContactLabelType_Other_URL_Work:
                {
                    return WCO365_FMC_Default;
                }
                default:
                    return 0;
            }
        }
    }
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
+ (NSUInteger)labelType:(PPContactLabelType)labelType
         countForFields:(NSArray <ContactDataExchangeModel *> *)fields
{
    NSUInteger count = 0;
    
    for(ContactDataExchangeModel *dataExchangeModel in fields)
    {
        if(dataExchangeModel.labelType==labelType)
        {
            count++;
        }
    }
    
    return count;
}


//================================================================================
//
//================================================================================
+ (NSUInteger)labelType:(PPContactLabelType)labelType countForSectionModel:(PPSectionModel *)sectionModel
{
    NSUInteger count = 0;
    
    for(PPRowModel *rowModel in sectionModel.rowModels)
    {
        PPContactRowObject *rowObject = rowModel.object;
        
        if(rowObject.contactLabelType==labelType)
        {
            count++;
        }
    }
    
    return count;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
+ (NSMutableArray *)defaultTitleArrayForPPContactMainType:(PPContactMainType)contactMainType
{
    NSMutableArray *workArray = [NSMutableArray array];
    
    do
    {
        if(workArray==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        switch (contactMainType)
        {

            case PPContactMainType_Other:
            {
                //MARK:other的預設欄位要在這邊設定
                [workArray addObjectsFromArray:@[PPContactLabelText_Other_NickName,
                                                 PPContactLabelText_Other_URL_Work,
                                                 PPContactLabelText_Other_Birthday]];
                
                break;
            }
            default:
            {
                [workArray addObjectsFromArray:[super defaultTitleArrayForPPContactMainType:contactMainType]];
                break;
            }
        }
        
    } while (0);
    
    return workArray;
    
}


//================================================================================
// MARK: 欄位cell type
//================================================================================
+ (PPContactTableViewCellStyle)contactTableViewCellStyleForContactMainType:(PPContactMainType)contactMainType labelType:(PPContactLabelType)labelType
{
    PPContactTableViewCellStyle style = PPContactTableViewCellStyle_Default;
    
    switch (contactMainType)
    {
        case PPContactMainType_Other:
        {
            switch (labelType)
            {
                case PPContactLabelType_Other_Birthday:
                {
                    // 生日的style
                    style = PPContactTableViewCellStyle_DateAndTimeTextField;//PPContactTableViewCellStyle_DatePicker
                    break;
                }
                default:
                {
                    style = PPContactTableViewCellStyle_TextField;
                    break;
                }
            }
            break;
        }
        case PPContactMainType_Email:
        {
            style = PPContactTableViewCellStyle_TextField;
            break;
        }
        case PPContactMainType_Note:
        case PPContactMainType_PublicNote:
        {
            style = PPContactTableViewCellStyle_TextView;
            break;
        }
        case PPContactMainType_Name:
        case PPContactMainType_Address:
        case PPContactMainType_Company:
        {
            style = PPContactTableViewCellStyle_MultiTextFields;
            break;
        }
        case PPContactMainType_Phone:
        {
            style = PPContactTableViewCellStyle_PhoneTextField;
            break;
        }
        case PPContactMainType_HeadImage:
        {
            style = PPContactTableViewCellStyle_HeadImageName;
            break;
        }
        default:
        {
            style = PPContactTableViewCellStyle_Default;
            break;
        }
    }
    
    return style;
}


//================================================================================
// MARK: 解析資料
// 超過office支援的最大欄位數時才要出現勾選
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForParsingFields:(NSArray *)fields
                                               ppContactMainType:(PPContactMainType)contactMainType
                                                    showPhonetic:(BOOL)showPhonetic
{
    PPContactSectionModel *sectionModel = nil;
    
    //////////////////////////////////////////////////
    
    UITableViewCellEditingStyle editingStyle = UITableViewCellEditingStyleNone;
    
    //////////////////////////////////////////////////
    switch (contactMainType)
    {
            // MARK: 地址
        case PPContactMainType_Address:
        {
            sectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
            
            if(sectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(ContactDataExchangeModel *contactDataExchangeModel in fields)
            {
                [contactDataExchangeModel.propertyDictionary removeObjectForKey:@(0)];
                
                //////////////////////////////////////////////////

                UITableViewCellEditingStyle editingStyle = UITableViewCellEditingStyleNone;
                
                if([self labelType:contactDataExchangeModel.labelType countForFields:fields]>[[self class] fieldMaxCountWithMainType:contactMainType labelType:contactDataExchangeModel.labelType])
                {
                    editingStyle = UITableViewCellEditingStyleDelete + UITableViewCellEditingStyleInsert;
                }
                //////////////////////////////////////////////////

                PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                                   ppContactLabelType:contactDataExchangeModel.labelType
                                                                                            tableViewCellEditingStyle:editingStyle
                                                                                          ppContactTableViewCellStyle:PPContactTableViewCellStyle_MultiTextFields
                                                                                                             selected:contactDataExchangeModel.valid];
                
                
                if(newContactRowObject==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                for (id key in contactDataExchangeModel.propertyDictionary.allKeys)
                {
                    [newContactRowObject.inputValueDictionary setObject:[contactDataExchangeModel.propertyDictionary objectForKey:key] forKey:key];
                }
                
                //////////////////////////////////////////////////
                
                NSString *detailText = nil;
                
                //////////////////////////////////////////////////
               
                //!!若是地址欄位要補齊顯示欄位格數，顯示才不會出錯
                
                NSString *city = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_City]];
                
                if(city==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_City]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *street = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Street]];
                
                if(street==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Street]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *zip = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Zip]];
                
                if(zip==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Zip]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *state = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_State]];
                
                if(state==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_State]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *country = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Country]];
                
                if(country==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Country]];
                }
                
                //////////////////////////////////////////////////

                NSString *countryCode = [newContactRowObject.inputValueDictionary objectForKey:@(PPContactSubType_Address_CountryCode)];
                
                if(countryCode.length<=0)
                {
                    countryCode = [PPCountryCodeConvert defaultCountryCode];
                    
                    [newContactRowObject.inputValueDictionary setObject:countryCode
                                                              forKey:@(PPContactSubType_Address_CountryCode)];
                    
                    //////////////////////////////////////////////////
                    
                    [newContactRowObject.inputValueDictionary setObject:@([PPCountryCodeConvert defaultRecogLangWithCountryCode:countryCode])
                                                              forKey:@(PPContactSubType_Address_RecognitionLanguageCode)];
                }
                
                //////////////////////////////////////////////////
                
                for (id key in contactDataExchangeModel.imageRectDictionary.allKeys)
                {
                    [newContactRowObject.imageRectDictionary setObject:[contactDataExchangeModel.imageRectDictionary objectForKey:key] forKey:key];
                }
                
                //////////////////////////////////////////////////
                
                NSString *labelText = contactDataExchangeModel.labelText;
                
                if(labelText==nil && labelText.length<=0)
                {
                    labelText = [PPContactRowObject labelTextFromPPContactLabelType:contactDataExchangeModel.labelType ppContactMainType:contactMainType];
                }
                
                //////////////////////////////////////////////////
                
                PPRowModel *newRowModel = [PPRowModel rowModelWithRow:sectionModel.rowModels.count
                                                                 text:labelText
                                                           detailText:detailText
                                                               object:newContactRowObject];
                
                [newRowModel setPPContactFieldSource:contactDataExchangeModel.contactFieldSource];
                
                if(newRowModel!=nil)
                {
                    [sectionModel.rowModels addObject:newRowModel];
                }
                
            }
            break;
        }
            // MARK: 姓名
        case PPContactMainType_Name:
        {
            if(fields.count>[[self class] fieldMaxCountWithMainType:contactMainType labelType:PPContactLabelType_None])
            {
                editingStyle = UITableViewCellEditingStyleDelete | UITableViewCellEditingStyleInsert;
            }
           
            //////////////////////////////////////////////////

            sectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
            
            if(sectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(ContactDataExchangeModel *contactDataExchangeModel in fields)
            {
                
                PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                                   ppContactLabelType:contactDataExchangeModel.labelType
                                                                                            tableViewCellEditingStyle:editingStyle
                                                                                          ppContactTableViewCellStyle:PPContactTableViewCellStyle_MultiTextFields
                                                                                                             selected:contactDataExchangeModel.valid];
                
                
                if(newContactRowObject==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                for (id key in contactDataExchangeModel.propertyDictionary.allKeys)
                {
                    [newContactRowObject.inputValueDictionary setObject:[contactDataExchangeModel.propertyDictionary objectForKey:key] forKey:key];
                }
                
                //////////////////////////////////////////////////
                
                NSString *detailText = nil;
                
                //////////////////////////////////////////////////
                // MARK: name的子欄位要這邊有塞，才會出現
                
                NSString *firstName = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_FirstName]];
                
                if(firstName==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_FirstName]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *lastName = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_LastName]];
                
                if(lastName==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_LastName]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *middleName = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_MiddleName]];
                
                if(middleName==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_MiddleName]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *surffix = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_Surffix]];
                
                if(surffix==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_Surffix]];
                }
                //////////////////////////////////////////////////
                
                
                NSString *firstNamePhonetic = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_FirstNamePhonetic]];
                
                if(firstNamePhonetic==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_FirstNamePhonetic]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *lastNamePhonetic = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_LastNamePhonetic]];
                
                if(lastNamePhonetic==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_LastNamePhonetic]];
                }
                
                //////////////////////////////////////////////////
                
                for (id key in contactDataExchangeModel.imageRectDictionary.allKeys)
                {
                    [newContactRowObject.imageRectDictionary setObject:[contactDataExchangeModel.imageRectDictionary objectForKey:key] forKey:key];
                }
                
                //////////////////////////////////////////////////
                
                NSString *labelText = contactDataExchangeModel.labelText;
                
                if(labelText==nil && labelText.length<=0)
                {
                    labelText = [PPContactRowObject labelTextFromPPContactLabelType:contactDataExchangeModel.labelType ppContactMainType:contactMainType];
                }
                
                //////////////////////////////////////////////////
                
                PPRowModel *newRowModel = [PPRowModel rowModelWithRow:sectionModel.rowModels.count
                                                                 text:labelText
                                                           detailText:detailText
                                                               object:newContactRowObject];
                
                [newRowModel setPPContactFieldSource:contactDataExchangeModel.contactFieldSource];
                
                if(newRowModel!=nil)
                {
                    [sectionModel.rowModels addObject:newRowModel];
                }
                
            }
            
            break;
        }
            // Other
        default:
        {
            if(fields.count>[[self class] fieldMaxCountWithMainType:contactMainType labelType:PPContactLabelType_None])
            {
                editingStyle = UITableViewCellEditingStyleDelete | UITableViewCellEditingStyleInsert;
            }
            
            sectionModel = [super ppContactSectionModelForParsingFields:fields
                                                      ppContactMainType:contactMainType
                                                           showPhonetic:showPhonetic];
            
            //////////////////////////////////////////////////
            
            for(PPRowModel *rowModel in sectionModel.rowModels)
            {
                PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
                PPContactLabelType labeType = PPContactLabelType_None;
                
                if(contactMainType==PPContactMainType_Phone ||contactMainType==PPContactMainType_Other)
                {
                    labeType = contactRowObject.contactLabelType;
                }
                
                NSInteger fieldMaxCount = [[self class] fieldMaxCountWithMainType:contactMainType labelType:labeType];
                if([self labelType:contactRowObject.contactLabelType countForSectionModel:sectionModel]>fieldMaxCount)
                {
                    editingStyle = UITableViewCellEditingStyleInsert | UITableViewCellEditingStyleDelete;
                }
                else
                {
                    editingStyle = UITableViewCellEditingStyleNone;
                }
      
                contactRowObject.editingStyle = editingStyle;
            }
            
            break;
        }
    }
    
    return sectionModel;
}


//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForPPContactMainType:(PPContactMainType)contactMainType
{
    PPContactSectionModel *contactSectionModel = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        //!!使用者欄位無法自已新增，只能從外部給予
        if(contactMainType==PPContactMainType_UserDefine)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSArray *itemTextLabelArray   = [self defaultTitleArrayForPPContactMainType:contactMainType];
        
        if(itemTextLabelArray==nil || itemTextLabelArray.count<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        UITableViewCellEditingStyle tableViewCellEditingStyle = UITableViewCellEditingStyleNone;
        
        //////////////////////////////////////////////////
        
        contactSectionModel = [self ppContactSectionModelForPPContactMainType:contactMainType
                                                                itemTextArray:itemTextLabelArray
                                                    tableViewCellEditingStyle:tableViewCellEditingStyle
                                                         ppContactFieldSource:PPContactFieldSource_None];
        
    } while (0);
    
    return contactSectionModel;
}

//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForPPContactMainType:(PPContactMainType)contactMainType
                                                       itemTextArray:(NSArray *)itemTextArray
                                           tableViewCellEditingStyle:(UITableViewCellEditingStyle)editingStyle
                                                ppContactFieldSource:(PPContactFieldSource)contactFieldSource
{
    
    PPContactSectionModel *contactSectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
    
    do
    {
        @autoreleasepool
        {
            //新增欄位只要取一個就行了
            if(editingStyle==UITableViewCellEditingStyleInsert)
            {
                itemTextArray = @[[itemTextArray firstObject]];
            }
            
            //////////////////////////////////////////////////
            
            for(NSString *text in itemTextArray)
            {
                PPContactLabelType contactLabelType = [PPContactRowObject ppContactLabelTypeForPPContactMainType:contactMainType labelText:text];

                PPContactTableViewCellStyle style = [self contactTableViewCellStyleForContactMainType:contactMainType labelType:contactLabelType];

                //////////////////////////////////////////////////
                
                PPContactRowObject *contactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                                ppContactLabelType:contactLabelType
                                                                                         tableViewCellEditingStyle:editingStyle
                                                                                       ppContactTableViewCellStyle:style
                                                                                                          selected:NO];
                
                if(contactRowObject==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                switch (contactMainType)
                {
                    case PPContactMainType_Name:
                    {
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Name_LastName)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Name_FirstName)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Name_MiddleName)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Name_FirstNamePhonetic)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Name_LastNamePhonetic)];
                        break;
                    }
                    case PPContactMainType_Phone:
                    {
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactLabelType_Phone_Work)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactLabelType_Phone_Mobile)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactLabelType_Phone_Home)];
                        break;
                    }
                    case PPContactMainType_Email:
                    {
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactLabelType_Email_Work)];
                        break;
                    }
                    case PPContactMainType_Company:
                    {
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Company_Name)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Company_Department)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Company_JobTitle)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Company_NamePhonetic)];
                        break;
                    }
                    case PPContactMainType_Address:
                    {
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Address_Country)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Address_Zip)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Address_State)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Address_City)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Address_Street)];
                        break;
                    }
                    case PPContactMainType_Other:
                    {
                        contactRowObject.selected  = YES;
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_None)];
                        break;
                    }
                    case PPContactMainType_HeadImage:
                    {
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_None)];
                        break;
                    }
                    default:
                    {
                        break;
                    }
                }
        
                //////////////////////////////////////////////////
                
                PPRowModel *rowModel = [PPRowModel rowModelWithRow:contactSectionModel.rowModels.count text:text detailText:nil object:contactRowObject];
                
                [rowModel setPPContactFieldSource:contactFieldSource];
                
                if(rowModel!=nil)
                {
                    [contactSectionModel.rowModels addObject:rowModel];
                }
            }
        }
        
    } while (0);
    
    return contactSectionModel;
}

@end
