//
//  WCContactEditViewController.m
//
//  Created by Howard.Lin on 13/9/26.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "WCContactEditViewController.h"

// Define
#import "ContactApperanceDefine.h"
#import "PPCountryCodeConvert.h"
#import "WCAppearanceDefine.h"
#import "WCContactEditViewController+ResouceDefine.h"
#import "WCContactEditViewController+PrivateParameterDefine.h"
#import "WCContactEditViewController+SettingKey.h"
#import "WCContactViewController+ResourceDefine.h"
#import "WCContactViewController+PrivateParameterDefine.h"
#import "WCContactViewController+PublicParameterDefine.h"

// Controller
#import "NoteViewController.h"
#import "PPSelectController.h"
#import "PPSettingsController.h"
#import "PPAlertController.h"
#import "PPLogController.h"
#import "WCABDataController.h"
#import "WCContactEditFieldViewController.h"
#import "WCToastController.h"

// View
#import "ContactDataPickerTableViewCell.h"
#import "ContactDatePickerTableViewCell.h"
#import "ContactDateAndTimeTextFieldTableViewCell.h"
#import "ContactPhoneTextFieldTableViewCell.h"
#import "ContactMultipleTextFieldButtonTableViewCell.h"
#import "ContactTextFieldTableViewCell.h"
#import "ContactTextViewTableViewCell.h"
#import "PPHeadImageNameTabelViewCell.h"
#import "PPBusyView.h"
#import "PPSwitchTableViewCell.h"
#import "PPTableViewCell.h"
#import "ContactEditNavigationBarView.h"
#import "PPCommentButton.h"

// Model
#import "ContactEditFieldAddedCellDataModel.h"
#import "ContactEditFieldCellTitleDataModel.h"
#import "ContactEditFieldUserDefineDataModel.h"

// Category
#import "NSDate+Format.h"
#import "NSError+Custom.h"
#import "NSString+Additions.h"
#import "PPSectionController+Contact.h"
#import "PPRowModel+Contact.h"
#import "UIColor+HexString.h"
#import "WCContactEditViewController+DoubleSideLayout.h"
#import "WCContactEditViewController+UsualLayout.h"
#import "WCContactEditViewController+ContactEditViewDelegate.h"

#if defined (PRODUCTLINE_WCSF)
#import "WCContactEditViewController+Salesforce.h"
#elif defined (PRODUCTLINE_WCO365)
#import "WCContactEditViewController+Office365.h"
#import "PPContactRowObject+Office365.h"
#elif defined (PRODUCTLINE_WCT)
#import "WCContactEditViewController+WCT.h"
#endif
////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCContactEditViewController ()
<
ContactEditHeaderViewDelegate,
ContactEditViewDataSource,
ContactEditViewDelegate,
ContactEditNavigationBarViewDelegate,
NoteViewControllerDelegate,
PPCountrySelectorViewControllerDelegate,
PPSelectControllerDelegate,
PPSwitchTableViewCellDelegate,
PPTopButtonsActionSheetDelegate,
PPImageTabelViewCellImageSource,
WCContactEditFieldViewControllerDelegate
>

@property (nonatomic,retain)           WCContactEditFieldViewController   *contactEditFieldViewController;
@property (nonatomic,retain)           PPSelectController                 *selectController;
@property (nonatomic,readwrite,retain) ContactEditHeaderView              *contactEditHeaderView;
@property (nonatomic,readwrite,retain) ContactEditView                    *contactEditView;
@property (nonatomic,retain)           ContactEditNavigationBarView       *contactEditNavigationBarView;
@property (nonatomic,retain)           PPBusyView                         *busyView;
@property (nonatomic,readwrite,retain) WCContactEditDoubleSideView        *contactEditDoubleSideView;
@property (nonatomic,assign)           BOOL                               checkAutoFocusWhenEmptyNameField;
@property (nonatomic,assign)           BOOL                               textViewShouldBegingEditing;
@property (nonatomic,assign)           BOOL                               textFieldShouldBeginEditing;

@property (nonatomic,assign)           BOOL                               keyboardShown;
@property (nonatomic,assign)           BOOL                               afterRotatedUpdateShowImage; // 旋轉時雙頁模式下，要更新圖片
@property (nonatomic,assign)           BOOL                               favoritedContact;
@property (nonatomic,assign)           BOOL                               findingNextFocus; //尋找下個 Focus
@property (nonatomic,assign,readwrite) WCContactEditViewControllerLayout  contactEditViewControllerLayout;
@property (nonatomic,retain)           NSIndexPath                        *currentSelectIndexPath;
@property (nonatomic,retain)           NSOperationQueue                   *operationQueue;
@property (nonatomic,retain)           CAGradientLayer                    *gradientLayer;
@property (nonatomic,assign)           UIInterfaceOrientation             toInterfaceOrientation;
@property (nonatomic,assign)           CGSize                             keyboardSize;
@property (nonatomic,assign)           CGRect                             focusImageRect;
@property (nonatomic,assign)           PPContactFieldSource               foucsContactFieldSource;
@property (nonatomic,assign)           CGPoint                            tableViewContentOffset;
@property (nonatomic,retain)           NSMutableArray                     *contactMainTypeOrders;
@property (nonatomic,retain)           UIView                             *toastSuperView;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCContactEditViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self = [super init])
    {
        [PPSettingsController setDefaultIntegerValue:1 withKey:WCContactViewController_SettingsKey_GuideMore];
        [PPSettingsController setDefaultIntegerValue:1 withKey:WCContactViewController_SettingsKey_GuideAddFrontCard];
        [PPSettingsController setDefaultIntegerValue:1 withKey:WCContactViewController_SettingsKey_GuideAddRearCard];
        [PPSettingsController setDefaultIntegerValue:1 withKey:WCContactViewController_SettingsKey_GuideFlipCard];

        
        [PPSettingsController setDefaultIntegerValue:1 withKey:WCContactViewController_SettingsKey_GuideSendToColleague];
        [PPSettingsController setDefaultIntegerValue:1 withKey:WCContactViewController_SettingsKey_GuideSaveAndAddNext];

        [PPSettingsController setDefaultIntegerValue:1 withKey:WCContactViewController_SettingsKey_GuideSaveSalesforce];
        [PPSettingsController setDefaultIntegerValue:1 withKey:WCContactViewController_SettingsKey_GuideSalesforceTarget];
        
        //////////////////////////////////////////////////
        
        _contactEditSectionController = [[WCContactEditSectionController alloc] init];
        
        //////////////////////////////////////////////////
        
        self.editing = YES;
#if defined (PRODUCTLINE_WCO365)
        self.showDeleteHeadImageItem = NO;
#else
        self.showDeleteHeadImageItem = YES;
#endif
        //////////////////////////////////////////////////
        
        _operationQueue = [[NSOperationQueue alloc] init];
        
        //////////////////////////////////////////////////
        
        _checkAutoFocusWhenEmptyNameField = YES;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.navigationController.delegate = nil;
    
    //////////////////////////////////////////////////
    
    _dataSource = nil;
    
    _delegate = nil;
    
    [self unRegisterNotifications];
    
    [_contactEditFieldViewController release];
    _contactEditFieldViewController = nil;
    
    [_contactEditSectionController release];
    _contactEditSectionController = nil;
    
    [_currentSelectIndexPath release];
    _currentSelectIndexPath = nil;
    
    [_contactEditView removeFromSuperview];
    [_contactEditView release];
    _contactEditView = nil;
    
    [_contactEditNavigationBarView removeFromSuperview];
    [_contactEditNavigationBarView release];
    _contactEditNavigationBarView = nil;
    
    [_contactEditHeaderView removeFromSuperview];
    [_contactEditHeaderView release];
    _contactEditHeaderView = nil;
    
    [_operationQueue cancelAllOperations];
    [_operationQueue release];
    _operationQueue = nil;
    
    [_selectController release];
    _selectController = nil;
    
    [_gradientLayer release];
    _gradientLayer = nil;
    
    [_syncAccountName release];
    _syncAccountName = nil;
    
    [_busyView release];
    _busyView = nil;
    
    [_contactEditDoubleSideView release];
    _contactEditDoubleSideView = nil;
    
    [_contactMainTypeOrders release];
    _contactMainTypeOrders = nil;
    
    [_toastSuperView release];
    _toastSuperView = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [self registerNotifications];
    
    //////////////////////////////////////////////////
    
    self.textFieldShouldBeginEditing = NO;
    self.textViewShouldBegingEditing = NO;
    
    //////////////////////////////////////////////////
    
    self.contactEditFieldViewController = [[[WCContactEditFieldViewController alloc] init] autorelease];
    
    //////////////////////////////////////////////////
    
    self.contactEditNavigationBarView = [[[ContactEditNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds
                                                                                      layout:self.contactEditViewControllerLayout] autorelease];
    
    //////////////////////////////////////////////////
    
    if(self.contactEditNavigationBarView!=nil)
    {
        self.contactEditNavigationBarView.delegate  = self;
            
        self.contactEditNavigationBarView.favoriteButton.selected = self.favoritedContact;
        
        //////////////////////////////////////////////////
        
        // 如果是WCContactEditViewControllerLayout_Browse的話，顯示為瀏覽
        if (self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_Browse)
        {
            [_contactEditNavigationBarView.cancelButton setTitle:WCCV_MLS_Browse maxWidth:0];
        }
        //////////////////////////////////////////////////
        
        //覆蓋NavigationBarView上方列
        if(self.navigationController!=nil)
        {
            UIBarButtonItem *leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.contactEditNavigationBarView];
            
            if(leftBarButtonItem!=nil)
            {
                self.navigationItem.leftBarButtonItem = leftBarButtonItem;
                [leftBarButtonItem release];
            }
        }
    }
    
    //////////////////////////////////////////////////
    
    if(self.contactEditView==nil)
    {
        self.contactEditView = [[[ContactEditView alloc] initWithFrame:CGRectZero] autorelease];
        
        if(self.contactEditView!=nil)
        {
            self.contactEditView.dataSource = self;
            self.contactEditView.delegate   = self;
            
            //////////////////////////////////////////////////
            
            if(self.contactEditView.superview==nil)
            {
                [self.view addSubview:self.contactEditView];
            }
        }
    }
    
    //////////////////////////////////////////////////
    
    if(self.contactEditView!=nil)
    {
        [self fetchContactHeadImagesData];
    }
    
    //////////////////////////////////////////////////
    
    if(self.contactEditHeaderView==nil)
    {
        _contactEditHeaderView = [[ContactEditHeaderView alloc] init];
    }
    
    if(self.contactEditHeaderView!=nil)
    {
        self.contactImageProtocol           = self.contactEditHeaderView;
        
        self.contactEditHeaderView.delegate = self;
        
        self.contactEditHeaderView.hidden = ![self existFrontCardImage];
        self.contactEditHeaderView.contactCardScrollView.imageMode = PPImageScrollViewImageMode_ScaleAspectFit;
        
        /////////////////////////////////////////////////
        
        UIImage *defaultCardImage = [self imageForPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Default];
        
        [self.contactEditHeaderView.contactCardScrollView setImage:defaultCardImage];
        
        [self.view addSubview:self.contactEditHeaderView];
    }
    
    //////////////////////////////////////////////////
    
    self.contactEditDoubleSideView = [[[WCContactEditDoubleSideView alloc] init] autorelease];
    
    if(self.contactEditDoubleSideView!=nil)
    {
        //平板情況上，加在本身的 View 上，手機加在鍵盤上
        if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
        {
            [self.view addSubview:self.contactEditDoubleSideView];
        }
    }
    
    //////////////////////////////////////////////////
    
    self.toastSuperView = [[[UIView alloc] init] autorelease];
    
    if(self.toastSuperView!=nil)
    {
        self.toastSuperView.userInteractionEnabled = NO;
        self.toastSuperView.backgroundColor = [UIColor clearColor];
        
        [self.view addSubview:self.toastSuperView];
    }
    
    //////////////////////////////////////////////////
    
    if(UIInterfaceOrientationIsPortrait(self.interfaceOrientation)==YES)
    {
        self.contactEditDoubleSideView.hidden = YES;
        self.contactEditHeaderView.hidden = ![self existFrontCardImage];
        
        //////////////////////////////////////////////////
        
        self.contactImageProtocol = self.contactEditHeaderView;
    }
    else
    {
        self.contactEditDoubleSideView.hidden = NO;
        self.contactEditHeaderView.hidden = YES;
        
        //////////////////////////////////////////////////
        
        self.contactImageProtocol = self.contactEditDoubleSideView;
    }
    
    //////////////////////////////////////////////////
    
    if(self.contactImageProtocol!=nil)
    {
        [self fetchContactCardImagesData];
    }
    
    //////////////////////////////////////////////////
    
    //更新目前完成按鈕狀態
    [self updateDoneButtonEnable];
    
    //////////////////////////////////////////////////
    
    self.toInterfaceOrientation = self.interfaceOrientation;
    
    //////////////////////////////////////////////////
    
    if(self.contactEditHeaderView.hidden==NO)
    {
        [self.navigationController.navigationBar setBackgroundColor:[UIColor clearColor]];
        [self.navigationController.navigationBar setTranslucent:YES];
        [self.navigationController.navigationBar setBackgroundImage:[[UIImage new] autorelease] forBarMetrics:UIBarMetricsDefault];
        [self.navigationController.navigationBar setShadowImage:[[UIImage new] autorelease]];
        [self.navigationController.navigationBar setBarTintColor:[UIColor clearColor]];
        [[self.navigationController.navigationBar subviews] firstObject].backgroundColor = [UIColor clearColor];
        //////////////////////////////////////////////////
        
        if(self.contactEditNavigationBarView.backgroundImageView.layer!=nil)
        {
            if (self.gradientLayer==nil)
            {
                self.gradientLayer        = [CAGradientLayer layer];
                self.gradientLayer.colors = [NSArray arrayWithObjects:(id)[[UIColor colorWithWhite:0.0f alpha:0.4f] CGColor],
                                             (id)[[UIColor colorWithWhite:0.0f alpha:0.0f] CGColor], nil]; // 由上到下的漸層顏色
                
                if([[[UIDevice currentDevice] systemVersion] floatValue]>=11.0)
                {
                    self.gradientLayer.hidden = YES;
                }
                
                [self.contactEditNavigationBarView.backgroundImageView.layer insertSublayer:self.gradientLayer atIndex:0];
                
                //////////////////////////////////////////////////
                
                CGRect frame = self.contactEditNavigationBarView.bounds;
                frame.size.height = self.view.bounds.size.height/3;
                self.gradientLayer.frame = frame;
                
            }
        }
    }
    else
    {
        [self.navigationController.navigationBar setTranslucent:NO];
        [self.navigationController.navigationBar setBackgroundImage:nil forBarMetrics:UIBarMetricsDefault];
        [self.navigationController.navigationBar setShadowImage:nil];
        self.navigationController.navigationBar.barTintColor = WCAppearanceDefine_NavigationBarColor;
    }
}


//================================================================================
//
//================================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
    
    if(self.dataState==WCContactViewControllerDataState_NotExist)
    {
        __block typeof(self) blockself = self;
        
        [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                  title:@""
                                                message:WCCV_MLS_FailedToLoadDatWithID
                                 showFromViewController:self
                                               animated:YES
                                            alertAction:[UIAlertAction actionWithTitle:WCCV_MLS_OK style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            
            //取消所有讀圖動作
            [blockself.operationQueue cancelAllOperations];
            
            //////////////////////////////////////////////////
            
            [blockself requestSendAction:WCContactEditViewControllerAction_GoBack];
            
        }],nil];
    }
    else
    {
#if defined (PRODUCTLINE_WCSF)
        if([self addSalesforceGuidesData]==YES)
        {
            [PPGuideController manuallyShowGuideWithViewController:self];
        }
#elif defined (PRODUCTLINE_WCO365)
       if([self addOffice365GuidesData]==YES)
        {
            [PPGuideController manuallyShowGuideWithViewController:self];
        }
#elif defined (PRODUCTLINE_WCT)
        if([self addWCTGuidesData]==YES)
        {
            [PPGuideController manuallyShowGuideWithViewController:self];
        }
#else
        if([self addWCGuidesData]==YES)
        {
            [PPGuideController manuallyShowGuideWithViewController:self];
        }
#endif
        
        else if(self.checkAutoFocusWhenEmptyNameField==YES)
        {
            self.checkAutoFocusWhenEmptyNameField = NO;
            
            [self autoFocusEmptyNameField];
        }
        
        //////////////////////////////////////////////////
        
        self.textFieldShouldBeginEditing = YES;
        self.textViewShouldBegingEditing = YES;
    }
    
    //////////////////////////////////////////////////
    
    // reset navigationBar clipBounds
    if([[[UIDevice currentDevice] systemVersion] floatValue]>=11.0)
    {
        if(self.contactEditHeaderView.hidden==NO)
        {
            UIView *targetView = self.contactEditNavigationBarView.superview;
            
            while (targetView)
            {
                targetView.clipsToBounds = NO;
                targetView = targetView.superview;
            };
            
            self.gradientLayer.hidden = NO;
        }
    }
}


//================================================================================
//
//================================================================================
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    
    //////////////////////////////////////////////////
    
    if(UIInterfaceOrientationIsPortrait(self.toInterfaceOrientation)==NO)
    {
        [self customLayoutIsDobuleSide:YES];
    }
    else
    {
        [self customLayoutIsDobuleSide:NO];
    }
    
    //////////////////////////////////////////////////
    
    self.toastSuperView.frame = CGRectMake(self.contactEditHeaderView.frame.origin.x,
                                           self.contactEditHeaderView.frame.origin.y,
                                           self.view.bounds.size.width,
                                           self.contactEditHeaderView.frame.size.height+self.contactEditView.frame.size.height-self.contactEditView.contactEditTableView.contentInset.bottom);
    
    //////////////////////////////////////////////////
    
    if(self.topButtonsActionSheet.superview!=nil)
    {
        [self.topButtonsActionSheet performSelectorOnMainThread:@selector(reLayoutSubViews)
                                                     withObject:nil
                                                  waitUntilDone:NO];
    }
}


//================================================================================
//
//================================================================================
- (void)viewDidLayoutSubviews
{
    [super viewDidLayoutSubviews];
    
    //////////////////////////////////////////////////
    
    if(self.afterRotatedUpdateShowImage==YES)
    {
        self.afterRotatedUpdateShowImage = NO;
        
        //////////////////////////////////////////////////
        
        if(self.showFrontCard==YES)
        {
            UIImage *frontCardImage = [self imageForPPContactMainType:PPContactMainType_FrontCardImage
                                                     ppContactSubType:PPContactSubType_FrontCardImage_Thumbnail];
            
            if(frontCardImage==nil)
            {
                frontCardImage = [self imageForPPContactMainType:PPContactMainType_FrontCardImage
                                                ppContactSubType:PPContactSubType_FrontCardImage_Original];
            }
            
            if(frontCardImage==nil)
            {
                frontCardImage = [self imageForPPContactMainType:PPContactMainType_FrontCardImage
                                                ppContactSubType:PPContactSubType_FrontCardImage_Default];
            }
            
            //////////////////////////////////////////////////
            
            [self.contactImageProtocol setContactFrontCardImage:frontCardImage];
        }
        else
        {
            UIImage *rearCardImage = [self imageForPPContactMainType:PPContactMainType_BackCardImage
                                                    ppContactSubType:PPContactSubType_BackCardImage_Thumbnail];
            
            if(rearCardImage==nil)
            {
                rearCardImage = [self imageForPPContactMainType:PPContactMainType_BackCardImage
                                               ppContactSubType:PPContactSubType_BackCardImage_Original];
            }
            
            if(rearCardImage==nil)
            {
                rearCardImage = [self imageForPPContactMainType:PPContactMainType_FrontCardImage
                                               ppContactSubType:PPContactSubType_FrontCardImage_Default];
            }
            
            //////////////////////////////////////////////////
            
            [self.contactImageProtocol setContactRearCardImage:rearCardImage];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    
    //////////////////////////////////////////////////
    
    self.contactEditFieldViewController = nil;
    
    //////////////////////////////////////////////////
    
    [self.contactEditDoubleSideView removeFromSuperview];
    self.contactEditDoubleSideView = nil;
    
    [self.toastSuperView removeFromSuperview];
    self.toastSuperView = nil;
    
    //////////////////////////////////////////////////
    
    self.contactImageProtocol = nil;
    
    //////////////////////////////////////////////////
    
    [self unRegisterNotifications];
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [super viewDidDisappear:animated];
    
    //////////////////////////////////////////////////
    
    [self.gradientLayer removeFromSuperlayer];
    self.gradientLayer = nil;
    
    //////////////////////////////////////////////////
    self.navigationItem.leftBarButtonItem = nil;
    
    [self.contactEditNavigationBarView removeFromSuperview];
    self.contactEditNavigationBarView = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification Method

//================================================================================
//
//================================================================================
- (void)keyboardWillShown:(NSNotification *)notification
{
    do
    {
        if(self.currentSelectIndexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        // 顯示圖片範圍
        if(self.focusImageRect.size.width==0 && self.focusImageRect.size.height==0)
        {
            switch (self.foucsContactFieldSource)
            {
                case PPContactFieldSource_BackSide:
                {
                    [self showCardImageScrollViewForShowingFrontCard:NO];
                    
                    break;
                }
                case PPContactFieldSource_FrontSide:
                case PPContactFieldSource_UserCreate:
                default:
                {
                    [self showCardImageScrollViewForShowingFrontCard:YES];
                    
                    break;
                }
            }
        }
        else
        {
            switch (self.foucsContactFieldSource)
            {
                case PPContactFieldSource_BackSide:
                {
                    [self showPartCardImageScrollViewForImage:[self imageForPPContactMainType:PPContactMainType_BackCardImage ppContactSubType:PPContactSubType_BackCardImage_Original]
                                                         rect:self.focusImageRect];
                    
                    break;
                }
                case PPContactFieldSource_FrontSide:
                case PPContactFieldSource_UserCreate:
                default:
                {
                    [self showPartCardImageScrollViewForImage:[self imageForPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Original]
                                                         rect:self.focusImageRect];
                    
                    break;
                }
            }
        }
    }
    while (0);
    
}


//================================================================================
//
//================================================================================
- (void)keyboardWillChangeFrame:(NSNotification *)notification
{
    self.keyboardShown = YES;
    
    //////////////////////////////////////////////////
    
    NSDictionary* info = [notification userInfo];
    
    CGSize keyboardSize = [[info objectForKey:UIKeyboardFrameEndUserInfoKey] CGRectValue].size;
    
    // IOS 7 特殊解, 橫式回傳鍵盤 size 有錯
    if([[[UIDevice currentDevice] systemVersion] floatValue]<8.0 &&
       UIInterfaceOrientationIsPortrait(self.interfaceOrientation)==NO)
    {
        self.keyboardSize = CGSizeMake(MAX(keyboardSize.width, keyboardSize.height), MIN(keyboardSize.width, keyboardSize.height));
    }
    else
    {
        self.keyboardSize = keyboardSize;
    }
    
    //////////////////////////////////////////////////
    
    [self customLayoutIsDobuleSide:[self isDoubleSideMode]];
    
    //////////////////////////////////////////////////
    
    UIEdgeInsets contentInsets;
    
    if(keyboardSize.height>keyboardSize.width)
    {
        contentInsets = UIEdgeInsetsMake(0.0, 0.0, keyboardSize.width, 0.0);
    }
    else
    {
        contentInsets = UIEdgeInsetsMake(0.0, 0.0, keyboardSize.height, 0.0);
    }
    
    //////////////////////////////////////////////////
    
    self.contactEditView.contactEditTableView.contentInset          = contentInsets;
    self.contactEditView.contactEditTableView.scrollIndicatorInsets = contentInsets;
    
    //////////////////////////////////////////////////
    
    self.toastSuperView.frame = CGRectMake(self.contactEditHeaderView.frame.origin.x,
                                           self.contactEditHeaderView.frame.origin.y,
                                           self.view.bounds.size.width,
                                           self.contactEditHeaderView.frame.size.height+self.contactEditView.frame.size.height-contentInsets.bottom);
    
    //////////////////////////////////////////////////
    
    UITableViewCell *cell = [self.contactEditView.contactEditTableView cellForRowAtIndexPath:self.currentSelectIndexPath];
    
    //////////////////////////////////////////////////
    
    CGRect cellFrame = cell.frame;
    
    //////////////////////////////////////////////////
    
    //多欄位的cell要修正起始點
    if([cell isKindOfClass:[ContactMultipleTextFieldButtonTableViewCell class]]==YES)
    {
        //尋找目前 focus 的textfield
        ContactMultipleTextFieldButtonTableViewCell *multipleTextFieldButtonTableViewCell = (ContactMultipleTextFieldButtonTableViewCell *)cell;
        
        for(NSUInteger textFieldIndex=0 ; textFieldIndex<multipleTextFieldButtonTableViewCell.textFieldButtonViews.count ; textFieldIndex++)
        {
            PPTextFieldButtonView *textFieldButtonView = [multipleTextFieldButtonTableViewCell.textFieldButtonViews objectAtIndex:textFieldIndex];
            
            if([[textFieldButtonView textField] isFirstResponder]==YES)
            {
                if([self.contactEditView.contactEditTableView respondsToSelector:@selector(estimatedRowHeight)]==YES)
                {
                    cellFrame.origin.y    += (self.contactEditView.contactEditTableView.estimatedRowHeight *textFieldIndex);
                    
                    cellFrame.size.height = self.contactEditView.contactEditTableView.estimatedRowHeight;
                }
                else
                {
                    cellFrame.origin.y    += (self.contactEditView.contactEditTableView.rowHeight * textFieldIndex);
                    
                    cellFrame.size.height = self.contactEditView.contactEditTableView.rowHeight;
                }
                
                break;
            }
        }
    }
    
    //////////////////////////////////////////////////
    
    if(cell!=nil)
    {
        CGFloat height = self.view.bounds.size.height;
        
        height -= MIN(keyboardSize.width, keyboardSize.height);
        
        //////////////////////////////////////////////////
        
        CGRect rect = CGRectMake(0, self.contactEditView.contactEditTableView.contentOffset.y, self.view.bounds.size.width, height);
        
        //////////////////////////////////////////////////
        
        if (!CGRectContainsPoint(rect, cellFrame.origin))
        {
            PPContactSectionModel *contactSectionModel = nil;
            
            if(self.currentSelectIndexPath.section<[self.contactEditSectionController sectionModelsForSearching:NO].count)
            {
                contactSectionModel = [[self.contactEditSectionController sectionModelsForSearching:NO] objectAtIndex:self.currentSelectIndexPath.section];
            }
            
            //////////////////////////////////////////////////
            
            __block typeof(self) blockself = self;
            
            //!!因為備註欄位編輯的第一個位置在cell最上方，若用scrollRect計算，會沒辦法找到最適合的捲動位置
            if(contactSectionModel!=nil &&
               (contactSectionModel.contactMainType==PPContactMainType_Note ||
                contactSectionModel.contactMainType==PPContactMainType_PublicNote))
            {
                
                dispatch_async(dispatch_get_main_queue(), ^{
                    [blockself.contactEditView.contactEditTableView scrollToRowAtIndexPath:blockself.currentSelectIndexPath
                                                                          atScrollPosition:UITableViewScrollPositionTop
                                                                                  animated:NO];
                    
                    //////////////////////////////////////////////////
                    
                    blockself.tableViewContentOffset = blockself.contactEditView.contactEditTableView.contentOffset;
                });
            }
            else
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    
                    //                    [blockself.contactEditView.contactEditTableView beginUpdates];
                    
                    [blockself.contactEditView.contactEditTableView scrollRectToVisible:cellFrame
                                                                               animated:NO];
                    
                    //                    [blockself.contactEditView.contactEditTableView endUpdates];
                    
                    //////////////////////////////////////////////////
                    
                    blockself.tableViewContentOffset = blockself.contactEditView.contactEditTableView.contentOffset;
                });
            }
        }
    }
    
    //////////////////////////////////////////////////
    
    if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPhone)
    {
        self.contactEditDoubleSideView.frame = CGRectMake(0,
                                                          ContactKeyboardToolBarViewButtonHeight,
                                                          self.view.bounds.size.width,
                                                          self.keyboardSize.height-ContactKeyboardToolBarViewButtonHeight);
    }
}





//================================================================================
//
//================================================================================
- (void)keyboardWillHidden:(NSNotification *)notification
{
    do
    {
        //新增欄位輸入時，會取新的欄位當 Focus，此時會觸發 keyboardHidden 又馬上 keyboardShown, 所以keyboardHidden 不做 frame 變化，防止 keyboardShown 又設回原來的 frame, 造成視覺暫留的錯誤
        
        if(self.findingNextFocus==YES)
        {
            self.findingNextFocus = NO;
            
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.keyboardShown = NO;
        
        //////////////////////////////////////////////////
        
        UIEdgeInsets contentInsets = UIEdgeInsetsZero;
        self.contactEditView.contactEditTableView.contentInset = contentInsets;
        self.contactEditView.contactEditTableView.scrollIndicatorInsets = contentInsets;
        
        //////////////////////////////////////////////////
        
        [self showCardImageScrollViewForShowingFrontCard:self.showFrontCard];
        
        //////////////////////////////////////////////////
        
        if([self isDoubleSideMode]==YES)
        {
            self.contactEditDoubleSideView.keyboardHeight = 0;
            
            [self doubleSideLayoutSubView];
        }
        else
        {
            [self usualLayoutSubview];
        }
        
        //////////////////////////////////////////////////
        
        [self.contactImageProtocol setPPImageScrollViewImageMode:PPImageScrollViewImageMode_ScaleAspectFit];
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)registerNotifications
{
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWillShown:)
                                                 name:UIKeyboardWillShowNotification
                                               object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWillChangeFrame:)
                                                 name:UIKeyboardWillChangeFrameNotification
                                               object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWillHidden:)
                                                 name:UIKeyboardWillHideNotification
                                               object:nil];
    
    //////////////////////////////////////////////////
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(receiveTextFieldArriveMaxLengthNofication:)
                                                 name:WCCV_InputTextFieldArriveMaxLengthNotification
                                               object:nil];
}


//================================================================================
//
//================================================================================
- (void)unRegisterNotifications
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Rotated Method

//================================================================================
//
//================================================================================
- (void)willRotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation duration:(NSTimeInterval)duration
{
    [super willRotateToInterfaceOrientation:toInterfaceOrientation duration:duration];
    
    //////////////////////////////////////////////////
    
    self.toInterfaceOrientation = toInterfaceOrientation;
    
    //////////////////////////////////////////////////
    
    //顯示名片圖的視圖才有可能不同一個，所以待旋轉後 Frame 異動，才設定名片
    self.afterRotatedUpdateShowImage = YES;
    
    //////////////////////////////////////////////////
    
    if(UIInterfaceOrientationIsPortrait(self.toInterfaceOrientation)==YES &&
       [self existFrontCardImage]==YES)
    {
        [self.navigationController.navigationBar setTranslucent:YES];
    }
    else
    {
        [self.navigationController.navigationBar setTranslucent:NO];
    }
    
    //////////////////////////////////////////////////
    
    if([[[UIDevice currentDevice] systemVersion] floatValue]>=8.0)
    {
        [self refreshKeyboardDisplay];
    }
}


//================================================================================
//
//================================================================================
- (void)didRotateFromInterfaceOrientation:(UIInterfaceOrientation)fromInterfaceOrientation
{
    [super didRotateFromInterfaceOrientation:fromInterfaceOrientation];
    
    //////////////////////////////////////////////////
    
    if([[[UIDevice currentDevice] systemVersion] floatValue]<8.0)
    {
        [self refreshKeyboardDisplay];
    }
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method


//================================================================================
//
//================================================================================
- (void)customLayoutIsDobuleSide:(BOOL)dobuleSide
{
    if(dobuleSide==YES)
    {
        self.contactEditDoubleSideView.hidden = NO;
        
        self.contactEditHeaderView.hidden = YES;
        
        //////////////////////////////////////////////////
        
        self.contactImageProtocol = self.contactEditDoubleSideView;
        
        //////////////////////////////////////////////////
        
        if(self.keyboardShown==YES)
        {
            [self doubleSideKeyboardWillShowLayoutSubViewWithKeyboardSize:self.keyboardSize];
        }
        else
        {
            [self doubleSideLayoutSubView];
        }
    }
    else
    {
        self.contactEditDoubleSideView.hidden = YES;
        
        //////////////////////////////////////////////////
        
        [self updateContactEditHeadViewHidden];
        self.contactImageProtocol = self.contactEditHeaderView;
        
        //////////////////////////////////////////////////
        
        if(self.keyboardShown==YES)
        {
            [self usualKeyboardWillShowLayoutSubview];
            
        }
        else
        {
            [self usualLayoutSubview];
        }
    }
}


//================================================================================
//
//================================================================================
- (WCContactEditViewControllerAction)actionWithEndEdit
{
    WCContactEditViewControllerAction action = WCContactEditViewControllerAction_GoBack;
    
    @autoreleasepool
    {
        do
        {
            BOOL emptyTextData = [self emptyTextData];
            
            if(emptyTextData==YES &&
               [self imageForPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Original]==nil &&
               [self imageForPPContactMainType:PPContactMainType_BackCardImage ppContactSubType:PPContactSubType_BackCardImage_Original]==nil &&
               [self imageForPPContactMainType:PPContactMainType_HeadImage ppContactSubType:PPContactSubType_HeadImage_Original]==nil)
            {
                action = WCContactEditViewControllerAction_EditFinishedWithEmptyDataAndImage;
                
                break;
            }
            
            //////////////////////////////////////////////////
            
            if([self.contactEditSectionController legalDataText]==NO)
            {
                action = WCContactEditViewControllerAction_EditFinishedWithIllegalTextData;
                break;
            }
            
            //////////////////////////////////////////////////
            
            // 還要透過 isContactExist，判斷名片是不是在同步中被刪除,（同連絡人新增方式判斷)
            if(self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_Add ||
               self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_Browse ||
               [self isContactExist]==NO)
            {
                //新增模式有資料下即可。
            }
            else
            {
                //文字資料 or 大圖沒異動
                if([self imageShouldWriteForPPContactMainType:PPContactMainType_FrontCardImage]==NO &&
                   [self imageShouldWriteForPPContactMainType:PPContactMainType_BackCardImage]==NO &&
                   [self imageShouldWriteForPPContactMainType:PPContactMainType_HeadImage]==NO &&
                   self.edited==NO)
                {
                    action = WCContactEditViewControllerAction_EditFinishedWithNoChangeData;
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            action = WCContactEditViewControllerAction_EditFinishedSuccessfully;
            
        } while (0);
        
    }
    
    return action;
}


//================================================================================
//
//================================================================================
- (void)insertRowModelInSectionModel:(PPContactSectionModel *)contactSectionModel indexPath:(NSIndexPath *)indexPath
{
    NSIndexPath *insertIndexPath = [self.contactEditSectionController indexPathForinsertingRowModelAtSection:indexPath.section forSearching:NO];
    
    BOOL isArriveMaxLimitRowNumbers = [self.contactEditSectionController checkArchivingUpperLimitAndRemoveRowModelForSection:indexPath.section forSearching:NO];
    
    //////////////////////////////////////////////////
    
    do
    {
        if(insertIndexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        // !!不同section之間的切換，不會造成 keyboardWillHiden 的呼叫，所以也不用設定雙頁模式排版參數
        if(insertIndexPath.row>0 &&
           self.currentSelectIndexPath.section==insertIndexPath.section)
        {
            //鍵盤出現時，才需要將找尋下個focus開啟，否則視成一般流程
            if(self.keyboardShown==YES)
            {
                self.findingNextFocus = YES;
            }
        }
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        
        dispatch_async(dispatch_get_main_queue(), ^{
            if(isArriveMaxLimitRowNumbers==YES)
            {
                // !!這邊不會觸發 keyboardWillHide，所以將左邊圖片排版參數重設
                blockself.findingNextFocus = NO;
                
                [blockself.contactEditView.contactEditTableView reloadRowsAtIndexPaths:[NSArray arrayWithObject:insertIndexPath] withRowAnimation:UITableViewRowAnimationNone];
            }
            else
            {
                [blockself.contactEditView.contactEditTableView reloadSections:[NSIndexSet indexSetWithIndex:indexPath.section] withRowAnimation:UITableViewRowAnimationNone];
            }
            
            //////////////////////////////////////////////////
            
            if([blockself activeFocusTextField:YES atSection:indexPath.section]==YES)
            {
                blockself.currentSelectIndexPath = insertIndexPath;
            }
        });
        
        
        //////////////////////////////////////////////////
        
        //新增日期欄位，因為有預設值，所以要檢查是否觸發done鍵
        if(contactSectionModel.contactMainType==PPContactMainType_BirthDay ||
           contactSectionModel.contactMainType==PPContactMainType_Date)
        {
            self.edited = YES;
            
            [self updateDoneButtonEnable];
        }
        
        
    } while (0);
}

//================================================================================
//
//================================================================================
- (BOOL)allowTextFieldShouldBeginEditing
{
    return self.textFieldShouldBeginEditing;
}


//================================================================================
//
//================================================================================
- (BOOL)allowTextViewShouldBeginEditing
{
    return self.textViewShouldBegingEditing;
}


//================================================================================
//
//================================================================================
- (BOOL)imageShouldWriteForPPContactMainType:(PPContactMainType)ppContactMainType
{
    BOOL result = NO;
    
    do
    {
        if(ppContactMainType!=PPContactMainType_FrontCardImage && ppContactMainType!=PPContactMainType_BackCardImage && ppContactMainType!=PPContactMainType_HeadImage)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        WCContactViewControllerImageState existOriginalImageState = WCContactViewControllerImageState_None;
        
        //////////////////////////////////////////////////
        
        switch (ppContactMainType)
        {
            case PPContactMainType_BackCardImage:
            {
                existOriginalImageState = [self contactViewControllerImageStateForPPContactSubType:PPContactSubType_BackCardImage_Original];
                
                break;
            }
            case PPContactMainType_FrontCardImage:
            {
                existOriginalImageState = [self contactViewControllerImageStateForPPContactSubType:PPContactSubType_FrontCardImage_Original];
                
                break;
            }
            case PPContactMainType_HeadImage:
            {
                existOriginalImageState = [self contactViewControllerImageStateForPPContactSubType:PPContactSubType_HeadImage_Original];
                
                break;
            }
            default:
            {
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        // 編輯模式，還要判斷名片圖是否存在，不然同步被刪除的的情況下，看 Changed 的圖片狀態不準
        if(self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_Edit||
           self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_MyCard)
        {
            //原始圖沒改過
            if(existOriginalImageState!=WCContactViewControllerImageState_Changed)
            {
                break;
            }
        }
        //新增模式下，有存在圖就寫回
        else
        {
            if(existOriginalImageState==WCContactViewControllerImageState_None || existOriginalImageState==WCContactViewControllerImageState_NoneExist)
            {
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        result = YES;
        
    } while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)showWCContactEditFieldViewControllerForSelectingIndexPath:(NSIndexPath *)indexPath title:(NSString *)title
{
    BOOL result = NO;
    
    @autoreleasepool
    {
        do
        {
            if(self.contactEditFieldViewController==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            self.contactEditFieldViewController.currentSelectedTitle = title;
            
            if([title compare:WCCV_MLS_AddField]==NSOrderedSame)
            {
                self.contactEditFieldViewController.contactEditFieldViewControllerMode = WCContactEditFieldViewControllerMode_AddField;
            }
            else
            {
                self.contactEditFieldViewController.contactEditFieldViewControllerMode = WCContactEditFieldViewControllerMode_ChangeTitle;
            }
            //////////////////////////////////////////////////
            
            PPContactMainType contactMainType = [self.contactEditSectionController contactMainTypeInSection:indexPath.section forSearching:NO];
            
            //////////////////////////////////////////////////
            
            //!!使用者自訂
            if(contactMainType==PPContactMainType_UserDefine)
            {
                ContactEditFieldUserDefineDataModel *dataModel = [[[ContactEditFieldUserDefineDataModel alloc] init] autorelease];
                
                if(dataModel==nil)
                {
                    break;
                }
                
                self.contactEditFieldViewController.contactEditFieldSectionController.dataModel = dataModel;
                
                //////////////////////////////////////////////////
                
                self.contactEditFieldViewController.showDoneButton = YES;
                
                //////////////////////////////////////////////////
                
                PPContactSectionModel *sectionModel = [self.contactEditFieldViewController.contactEditFieldSectionController contactSetionModelForPPContactMainType:contactMainType];
                
                //////////////////////////////////////////////////
                
                if(sectionModel!=nil && sectionModel.rowModels.count>0)
                {
                    //!!設定contactEditFieldViewController cell顯示的字串
                    PPRowModel *rowModel = [sectionModel.rowModels objectAtIndex:0];
                    PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
                    
                    if(contactRowObject!=nil)
                    {
                        [contactRowObject.inputValueDictionary setObject:title
                                                                  forKey:[[[contactRowObject inputValueDictionary] allKeys] firstObject]];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    [[self.contactEditFieldViewController.contactEditFieldSectionController  sectionModelsForSearching:NO]addObject:sectionModel];
                }
                
            }
            //!!加入標題Section WCContactEditFieldViewController
            else if(contactMainType==PPContactMainType_AddField)
            {
                NSArray *sectionModels = [self nextEditFieldSectionModelArray];
                
                //////////////////////////////////////////////////
                
                if(sectionModels!=nil &&sectionModels.count>0)
                {
                    for (PPSectionModel *sectionModel in sectionModels)
                    {
                        [[self.contactEditFieldViewController.contactEditFieldSectionController  sectionModelsForSearching:NO] addObject:sectionModel];
                    }
                }
            }
            //!!改變標題的WCContactEditFieldViewController
            else
            {
                NSArray *sectionModels = [self.contactEditSectionController sectionModelsForDefault];
                
                if(sectionModels.count<=indexPath.section)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                ContactEditFieldCellTitleDataModel *dataModel = [[[ContactEditFieldCellTitleDataModel alloc] init] autorelease];
                
                if(dataModel==nil)
                {
                    break;
                }
                
                self.contactEditFieldViewController.contactEditFieldSectionController.dataModel = dataModel;
                
                //////////////////////////////////////////////////
                
                PPContactMainType contactMainType = [self.contactEditSectionController contactMainTypeInSection:indexPath.section forSearching:NO];
                
                //////////////////////////////////////////////////
                
                PPSectionModel *newSectionModel = nil;
                
                if(contactMainType!=PPContactMainType_None)
                {
                    newSectionModel = [self.contactEditFieldViewController.contactEditFieldSectionController contactSetionModelForPPContactMainType:contactMainType];
                }
                
                //////////////////////////////////////////////////
                
                //                // Other 欄位要檢查 統一編號和暱稱是否有滿
                //                if(contactMainType==PPContactMainType_Other)
                //                {
                //                    for(NSInteger rowIndex=0; rowIndex<newSectionModel.rowModels.count; rowIndex++)
                //                    {
                //                        PPRowModel *rowModel = [newSectionModel.rowModels objectAtIndex:rowIndex];
                //
                //                        for(PPRowModel *existRowModel in existSectionModel.rowModels)
                //                        {
                //                            if([rowModel.text compare:existRowModel.text]==NSOrderedSame)
                //                            {
                //                                [newSectionModel.rowModels removeObject:rowModel];
                //
                //                                rowIndex--;
                //
                //                                break;
                //                            }
                //                        }
                //                    }
                //                }
                
                //////////////////////////////////////////////////
                
                if(newSectionModel==nil || newSectionModel.rowModels.count<=0)
                {
                    break;
                }
                
                [[self.contactEditFieldViewController.contactEditFieldSectionController  sectionModelsForSearching:NO] addObject:newSectionModel];
            }
            
            //////////////////////////////////////////////////
            
            if([self.contactEditFieldViewController.contactEditFieldSectionController  sectionModelsForSearching:NO].count<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            self.contactEditFieldViewController.delegate = self;
            
            [self.navigationController pushViewController:self.contactEditFieldViewController animated:YES];
            
            //////////////////////////////////////////////////
            
            result = YES;
            
        } while (0);
    }
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)showCountrySelectViewController
{
    BOOL result = NO;
    
    @autoreleasepool
    {
        do
        {
            if(self.currentSelectIndexPath==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            //!!找含國家的欄位
            PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:self.currentSelectIndexPath forSearching:NO];
            
            if(rowModel==nil || [rowModel ppContactRowObjectOfRowModel]==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            PPContactRowObject *contactRowObject = rowModel.object;
            
            NSString *countryCode  = nil;
            NSNumber *recognitionlanguageCode = nil;
            
            for(NSNumber *key in contactRowObject.inputValueDictionary.allKeys)
            {
                //國家欄位
                if([key unsignedIntegerValue] == PPContactSubType_Address_CountryCode)
                {
                    countryCode = [contactRowObject.inputValueDictionary objectForKey:key];
                }
                //辨識語言欄位
                else if([key unsignedIntegerValue] == PPContactSubType_Address_RecognitionLanguageCode)
                {
                    recognitionlanguageCode = [contactRowObject.inputValueDictionary objectForKey:key];
                }
            }
            
            //!!若資料裡面沒有countryCode，則採用預設
            if(countryCode==nil || countryCode.length<=0)
            {
                countryCode = [PPCountryCodeConvert defaultCountryCode];
            }
            
            //////////////////////////////////////////////////
            
            PPCountrySelectorViewController *countrySelectTableView = [[[PPCountrySelectorViewController alloc] initWithFrame:self.view.bounds delegate:self] autorelease];
            
            if(countrySelectTableView==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            if(recognitionlanguageCode==nil)
            {
                [countrySelectTableView setDisplayLanguageWithLanguageCode:@""];
            }
            else if([recognitionlanguageCode integerValue]==-1)
            {
                [countrySelectTableView setDisplayLanguageWithLanguageCode:[PPCountryCodeConvert languageCodeWithRecogLang:[PPCountryCodeConvert defaultRecogLangWithCountryCode:countryCode]]];
            }
            else
            {
                [countrySelectTableView setDisplayLanguageWithLanguageCode:[PPCountryCodeConvert languageCodeWithRecogLang:[recognitionlanguageCode unsignedIntegerValue]]];
            }
            
            countrySelectTableView.imageEdgeInsets = WCContactViewControllerNavigationBarButtonImageEdgeInsets;
            countrySelectTableView.backButtonHighlightedBackgroundColor = WCAppearanceDefine_ButtonBackgroundColor;
            countrySelectTableView.currentCountryCode = countryCode;
            
            [self.navigationController pushViewController:countrySelectTableView animated:YES];
            
            
            //////////////////////////////////////////////////
            
            result = YES;
            
        } while (0);
        
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)showHeadImageSelectActionSheet
{
    NSMutableArray *itemTitles = [NSMutableArray array];
    
    [itemTitles addObjectsFromArray:@[WCCV_MLS_TakePhoto,
                                      WCCV_MLS_SelectAlbumPhoto]];

    // 有名片圖就要加從名片圖框選
    if([self imageForPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Thumbnail]!=nil ||
       [self imageForPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Original]!=nil)
    {
        [itemTitles addObject:WCCV_MLS_ClipCardImageForHeadImage];
    }

    // 有大頭貼就要加刪除大頭貼
    
    if(self.showDeleteHeadImageItem)
    {
        if([self imageForPPContactMainType:PPContactMainType_HeadImage ppContactSubType:PPContactSubType_HeadImage_Thumbnail]!=nil ||
           [self imageForPPContactMainType:PPContactMainType_HeadImage ppContactSubType:PPContactSubType_HeadImage_Original]!=nil)
        {
            [itemTitles addObject:WCCV_MLS_DeletePhoto];
        }
    }
    
    //////////////////////////////////////////////////
    
    self.selectController = [[[PPSelectController alloc] init] autorelease];
    
    ////////////////////////////////////////////////
    
    if(self.selectController!=nil)
    {
        self.selectController.delegate = self;
        self.selectController.tag = WCContactEditViewController_SelectControllerTag_AddOrDeleteHeadImage;
        self.selectController.tableViewCellSelectionStyle = UITableViewCellSelectionStyleNone;
        
        //////////////////////////////////////////////////
        
        self.selectController.sourceItemStringArray = itemTitles;
        self.selectController.selectedIndex = -1;
        
        [self.selectController showFromViewController:self animated:YES];
    }
    
}


//================================================================================
//
//================================================================================
- (void)mainThreadTerminalSendDataWithError:(NSError *)error
{
    [self showBusyView:NO withSuperView:nil];
    
    //////////////////////////////////////////////////
    
    if(error!=nil && ([error.domain isEqualToString:NSStringFromClass([self class])]==NO || error.code!=NSErrorCustom_Code_OperationCancel))
    {
        __block typeof(self) blockself = self;
        
        UIAlertAction *cancelEditAction = [UIAlertAction actionWithTitle:WCCV_MLS_CancelEdit style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
            [blockself requestSendAction:WCContactEditViewControllerAction_GoBack];
        }];
        
        UIAlertAction *continueEditAction = [UIAlertAction actionWithTitle:WCCV_MLS_ContinueEdit style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            [blockself requestSendAction:WCContactEditViewControllerAction_ContinueEdit];
        }];
        
        
        [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                  title:@""
                                                message:[error alertMessage]
                                       showFromViewController:self
                                               animated:YES
                                            alertAction:cancelEditAction,continueEditAction, nil];
    }
    else
    {
        if([self.delegate respondsToSelector:@selector(contactEditViewController:action:)]==YES)
        {
            [self.delegate contactEditViewController:self
                                              action:WCContactEditViewControllerAction_EditFinishedSuccessfully];
        }
        else
        {
            [self goBackAnimated:YES];
        }
    }
    
}


//================================================================================
//
//================================================================================
- (NSArray *)nextEditFieldSectionModelArray
{
    NSArray *nextEditFieldSectionModelArray = nil;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(ppContactMainTypeArrayFetchingNewSectionFieldDataForWCContactEditViewController:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        ContactEditFieldAddedCellDataModel *dataModel = [[ContactEditFieldAddedCellDataModel alloc] init];
        
        if(dataModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.contactEditFieldViewController.contactEditFieldSectionController.dataModel = dataModel;
        
        //////////////////////////////////////////////////
        
        NSMutableArray *fieldSelectionArray = [self.dataSource ppContactMainTypeArrayFetchingNewSectionFieldDataForWCContactEditViewController:self];
        
        //!!計算目前存在section的contactMainType
        for(PPContactSectionModel *sectionItemModel in [self.contactEditSectionController sectionModelsForSearching:NO])
        {
            for (NSNumber *contactMainType in fieldSelectionArray)
            {
                if([contactMainType unsignedIntegerValue]==sectionItemModel.contactMainType)
                {
                    [fieldSelectionArray removeObject:contactMainType];
                    break;
                }
            }
        }
        
        //////////////////////////////////////////////////
        
        nextEditFieldSectionModelArray = [WCContactEditFieldSectionController sectionModelArrayForDataModel:[dataModel autorelease]
                                                                                     ppContactMainTypeArray:fieldSelectionArray
                                                                                filterPPContactSubTypeArray:self.contactEditSectionController.extraSubTypeArray];
    } while (0);
    
    return nextEditFieldSectionModelArray;
}


//================================================================================
//
//================================================================================
- (void)textFieldDidBeginEditingAtIndexPath:(NSIndexPath *)indexPath
{
    PPRowModel         *rowModel         = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
    PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
    
    do
    {
        //重設範圍
        self.focusImageRect = CGRectZero;
        
        if(contactRowObject==nil || contactRowObject.imageRectDictionary.count<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        id object = [contactRowObject.imageRectDictionary objectForKey:[contactRowObject.imageRectDictionary.allKeys objectAtIndex:0]];
        
        if(object==nil || [object isKindOfClass:[NSString class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.focusImageRect = CGRectFromString(object);
        
    } while (0);
    
    //////////////////////////////////////////////////
    
    self.foucsContactFieldSource = [rowModel ppContactFieldSource];
}


//================================================================================
//
//================================================================================
- (void)textFieldDidChanged:(UITextField *)textField atIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        if(textField==nil ||
           indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
        
        if(contactRowObject==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([textField.text length]>0)
        {
            if(contactRowObject.inputValueDictionary.count>0)
            {
                if(contactRowObject.contactMainType==PPContactMainType_UserDefine)
                {
                    NSArray *contactSubTypes = [[contactRowObject inputValueDictionary] allKeys];
                    
                    for(id contactSubType in contactSubTypes)
                    {
                        if([contactSubType integerValue]!=PPContactSubType_UserDefine_ID &&
                           [contactSubType integerValue]!=PPContactSubType_UserDefine_UserInfo &&
                           [contactSubType integerValue]!=PPContactSubType_UserDefine_ItemMenu)
                        {
                            [contactRowObject.inputValueDictionary setObject:textField.text forKey:contactSubType];
                            
                            break;
                        }
                    }
                }
                else if(contactRowObject.contactMainType==PPContactMainType_Group)
                {
                    [contactRowObject.inputValueDictionary setObject:textField.text forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Group]];
                }
                else if(contactRowObject.contactMainType==PPContactMainType_BirthDay)
                {
                    PPContactSubType contactSubType = [contactRowObject curEditingSubType];
                    
                    //////////////////////////////////////////////////
                    
                    NSArray *rowModelTexts = [textField.text componentsSeparatedByString:@"/"];
                    
                    //不含年份，要給隱藏欄位 1990 至資料模型，存檔時才能維持有 1990的隱藏欄位
                    if(rowModelTexts.count<3)
                    {
                        [contactRowObject.inputValueDictionary setObject:[[NSString stringWithInteger:WC_ValidMinYear] stringByAppendingString:[NSString stringWithFormat:@"/%@",textField.text]]
                                                                  forKey:@(contactSubType)];
                    }
                    else
                    {
                        [contactRowObject.inputValueDictionary setObject:textField.text
                                                                  forKey:@(contactSubType)];
                    }
                }
                else
                {
                    PPContactSubType contactSubType = [contactRowObject curEditingSubType];
                    
                    [contactRowObject.inputValueDictionary setObject:textField.text
                                                              forKey:@(contactSubType)];
                }
            }
            else
            {
#ifdef DEBUG
                NSLog(@"Warnning contactRowObject at indexPath:%@, inputValueDictionary.count is equal to zero",indexPath);
#endif
            }
            
            
        }
        else
        {
            PPContactSubType contactSubType = [contactRowObject curEditingSubType];
            
            //!!文字長度歸零
            [contactRowObject.inputValueDictionary setObject:@""
                                                      forKey:@(contactSubType)];
            
            //////////////////////////////////////////////////

            if(contactRowObject.tableViewCellStyle==PPContactTableViewCellStyle_DataPicker)
            {
                ContactDataPickerTableViewCell *cell = [self.contactEditView.contactEditTableView cellForRowAtIndexPath:indexPath];
                
                [cell selectRow:0 animated:NO];
            }
        }
        
        //////////////////////////////////////////////////
        
        //已手動編輯過
        [rowModel setPPContactFieldSource:PPContactFieldSource_UserCreate];
        
        //////////////////////////////////////////////////
        
        self.edited = YES;
        
        //更新目前完成按鈕狀態
        [self updateDoneButtonEnable];
        
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)textViewDidChangeValue:(UITextView *)textView atIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        if(indexPath==nil ||
           textView==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
        if([rowModel ppContactRowObjectOfRowModel]==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactRowObject *contactRowObject = rowModel.object;
        
        [contactRowObject.inputValueDictionary setObject:textView.text
                                                  forKey:@([contactRowObject curEditingSubType])];
        
        //////////////////////////////////////////////////
        
        //已手動編輯過
        [rowModel setPPContactFieldSource:PPContactFieldSource_UserCreate];
        
        //////////////////////////////////////////////////
        
        self.edited = YES;
        
        //更新目前完成按鈕狀態
        [self updateDoneButtonEnable];
        
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)updateDoneButtonEnable
{
    if(self.contactEditNavigationBarView!=nil)
    {
        self.contactEditNavigationBarView.doneButton.enabled = YES;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private Show note


//==============================================================================
//
//==============================================================================
- (void)showNoteUI
{
    // MARK: 備註欄位
    NoteViewController *noteViewController = [[NoteViewController alloc] init];
    
    if(noteViewController!=nil)
    {
        noteViewController.noteViewControllerDelegate = self;
        noteViewController.noteEditting = YES;
        [noteViewController setTitleText:WCCV_MLS_Note];
        noteViewController.maxLength = [self requestContactEditTableViewCellTextMaxLengthWithContactMainType:PPContactMainType_Note contactSubType:PPContactSubType_None
                                                                                            contactLabelType:PPContactLabelType_None];
        
        //////////////////////////////////////////////////
        
        ContactDataExchangeModel *noteDataExchangeModel = [self.contactEditSectionController.noteFieldArray firstObject];
        
        if(noteDataExchangeModel!=nil)
        {
            noteViewController.noteTextString = [noteDataExchangeModel.propertyDictionary objectForKey:@(PPContactSubType_None)];
        }
        
        //////////////////////////////////////////////////
        
        [self.navigationController pushViewController:noteViewController animated:YES];
    }
    
    [noteViewController release];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Focus Method

//================================================================================
//
//================================================================================
- (BOOL)activeFocusTextField:(BOOL)active atSection:(NSInteger)section row:(NSInteger)row
{
    BOOL result = NO;
    
    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:row inSection:section];
    
    if(active==YES)
    {
        id tableViewCell = [self.contactEditView.contactEditTableView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:indexPath.row inSection:indexPath.section]];
        
        if([tableViewCell isKindOfClass:[PPDateTextFieldTableViewCell class]])
        {
            PPDateTextFieldTableViewCell *dateFieldTableViewCell = (PPDateTextFieldTableViewCell *)tableViewCell;
            
            [dateFieldTableViewCell.textField becomeFirstResponder];
            
            result = YES;
        }
        else if([tableViewCell isKindOfClass:[PPTextFieldTableViewCell class]])
        {
            PPTextFieldTableViewCell *textFieldTableViewCell = (PPTextFieldTableViewCell *)tableViewCell;
            
            [textFieldTableViewCell.textField becomeFirstResponder];
            
            result = YES;
        }
        else if([tableViewCell isKindOfClass:[PPTextViewTableViewCell class]])
        {
            PPTextViewTableViewCell *textViewTableViewCell = (PPTextViewTableViewCell *)tableViewCell;
            
            [textViewTableViewCell.ppTextView becomeFirstResponder];
            
            result = YES;
            
        }
        else if([tableViewCell isKindOfClass:[PPPhoneTextFieldTableViewCell class]])
        {
            PPPhoneTextFieldTableViewCell *phoneTextFieldTableViewCell = (PPPhoneTextFieldTableViewCell *)tableViewCell;
            
            [phoneTextFieldTableViewCell.textField becomeFirstResponder];
            
            result = YES;
        }
        else if([tableViewCell isKindOfClass:[PPMultipleTextFieldButtonTableViewCell class]])
        {
            PPMultipleTextFieldButtonTableViewCell *multipleTextFieldButtonTableViewCell = (PPMultipleTextFieldButtonTableViewCell *)tableViewCell;
            
            if(multipleTextFieldButtonTableViewCell.textFieldButtonViews.count>0)
            {
                UITextField *textField = [[multipleTextFieldButtonTableViewCell.textFieldButtonViews objectAtIndex:0] textField];
                
                [textField becomeFirstResponder];
                
                result = YES;
            }
        }
    }
    else
    {
        NSIndexPath *indexPath = [NSIndexPath indexPathForRow:row inSection:section];
        
        id tableViewCell = [self.contactEditView.contactEditTableView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:indexPath.row inSection:indexPath.section]];
        
        if([tableViewCell isKindOfClass:[PPTextFieldTableViewCell class]])
        {
            PPTextFieldTableViewCell *textFieldTableViewCell = (PPTextFieldTableViewCell *)tableViewCell;
            
            if([textFieldTableViewCell.textField isFirstResponder]==YES)
            {
                [textFieldTableViewCell.textField resignFirstResponder];
                
                result = YES;
            }
        }
        else if([tableViewCell isKindOfClass:[PPTextViewTableViewCell class]])
        {
            PPTextViewTableViewCell *textViewTableViewCell = (PPTextViewTableViewCell *)tableViewCell;
            
            if([textViewTableViewCell.ppTextView isFirstResponder]==YES)
            {
                [textViewTableViewCell.ppTextView resignFirstResponder];
                
                result = YES;
            }
        }
        else if([tableViewCell isKindOfClass:[PPPhoneTextFieldTableViewCell class]])
        {
            
            PPPhoneTextFieldTableViewCell *phoneTextFieldTableViewCell = (PPPhoneTextFieldTableViewCell *)tableViewCell;
            
            if([phoneTextFieldTableViewCell.textField isFirstResponder]==YES)
            {
                [phoneTextFieldTableViewCell.textField resignFirstResponder];
                
                result = YES;
            }
            
        }
        else if([tableViewCell isKindOfClass:[PPMultipleTextFieldButtonTableViewCell class]])
        {
            PPMultipleTextFieldButtonTableViewCell *multipleTextFieldButtonTableViewCell = (PPMultipleTextFieldButtonTableViewCell *)tableViewCell;
            
            //////////////////////////////////////////////////
            
            NSUInteger numberOfTextFields = multipleTextFieldButtonTableViewCell.textFieldButtonViews.count;
            
            BOOL findFoucs = NO;
            
            for(NSUInteger tag=0 ; tag<numberOfTextFields ; tag++)
            {
                UITextField *textField = [multipleTextFieldButtonTableViewCell.textFieldButtonViews objectAtIndex:tag];
                
                if([textField isFirstResponder]==YES)
                {
                    [textField resignFirstResponder];
                    findFoucs = YES;
                }
            }
            
            //////////////////////////////////////////////////
            
            if(findFoucs==YES)
            {
                result = YES;
            }
        }
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)activeFocusTextField:(BOOL)active atSection:(NSInteger)section
{
    // MARK: Focus 產生
    BOOL result = NO;
    
    do
    {
        if(section<0 || [self.contactEditSectionController sectionModelsForSearching:NO].count<=section)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPSectionModel *sectionModel = [[self.contactEditSectionController sectionModelsForSearching:NO] objectAtIndex:section];
        
        NSInteger numberOfRow = sectionModel.rowModels.count;
        
        if(active==YES)
        {
            NSInteger row =  numberOfRow - 1;
            
            //確定最後一筆是否為新增xx，還是可以輸入的欄位
            
            PPRowModel *rowModel = [sectionModel.rowModels lastObject];
            
            if(rowModel!=nil)
            {
                if([rowModel ppContactRowObjectOfRowModel].editingStyle==UITableViewCellEditingStyleInsert)
                {
                    row = row-1;
                }
            }
            
            if(row<0)
            {
                row = 0;
            }
            
            //////////////////////////////////////////////////
            
            result = [self activeFocusTextField:active atSection:section row:row];
        }
        else
        {
            for(NSUInteger row = 0; row<numberOfRow ; row++)
            {
                result = [self activeFocusTextField:active atSection:section row:row];
                
                if(result==YES)
                {
                    break;
                }
            }
        }
        
    } while (0);
    
    //////////////////////////////////////////////////
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)autoFocusEmptyNameField
{
    if([self.contactEditSectionController emptyNameFieldAtFirst]==YES)
    {
        NSInteger section = [self.contactEditSectionController sectionForPPContactMainType:PPContactMainType_Name forSearching:NO];
        
        if(section!=NSNotFound)
        {
            __block typeof(self) blockself = self;
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                if([blockself activeFocusTextField:YES atSection:section]==YES)
                {
                    blockself.currentSelectIndexPath = [NSIndexPath indexPathForRow:0 inSection:section];
                }
            });
        }
    }
}


//================================================================================
//
//================================================================================
- (void)switchKeyboardDisplay
{
    do
    {
        UITextField *inputTextField = [self focusTextField];
        
        if(inputTextField==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        // 目前 InputView 顯示為名片圖，重新 focus
        if(self.contactEditDoubleSideView.superview!=nil ||
           UIInterfaceOrientationIsPortrait(self.toInterfaceOrientation)==YES)
        {
            self.contactEditDoubleSideView.showInKeyboard = NO;
        }
        else
        {
            self.contactEditDoubleSideView.showInKeyboard = YES;
        }
        
        [inputTextField resignFirstResponder];
        [inputTextField becomeFirstResponder];
    }
    while(0);
}


//================================================================================
//
//================================================================================
- (void)refreshKeyboardDisplay
{
    //調整鍵盤顯示
    dispatch_async(dispatch_get_main_queue(), ^{
        do
        {
            UITextField *focusTextField = [self focusTextField];
            
            if(focusTextField==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            if(UIInterfaceOrientationIsPortrait(self.interfaceOrientation)==YES)
            {
                self.contactEditDoubleSideView.showInKeyboard = NO;
            }
            
            //////////////////////////////////////////////////
            
            [focusTextField resignFirstResponder];
            [focusTextField becomeFirstResponder];
        }
        while (0);
    });
}


//================================================================================
//
//================================================================================
- (void)keepKeyboardDisplayStyleWithView:(UIView *)view
{
    do
    {
        if(view==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([view respondsToSelector:@selector(setInputView:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(self.contactEditDoubleSideView.showInKeyboard==YES)
        {
            [view performSelector:@selector(setInputView:) withObject:self.contactEditDoubleSideView];
        }
        else
        {
            [view performSelector:@selector(setInputView:) withObject:nil];
        }
        
        //////////////////////////////////////////////////
        
        //修正鍵盤上方工具列樣式
        
        if([view respondsToSelector:@selector(inputAccessoryView)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        UIView *inputAccessoryView = [view inputAccessoryView];
        
        if(inputAccessoryView==nil ||
           [inputAccessoryView isKindOfClass:[ContactKeyboardToolBarView class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        ContactKeyboardToolBarView *toolBarView = (ContactKeyboardToolBarView *)inputAccessoryView;
        
        if(UIInterfaceOrientationIsPortrait(self.toInterfaceOrientation)==YES ||
           UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
        {
            toolBarView.switchInputButton.hidden = YES;
            
            [toolBarView updatePortraitConstraints];
        }
        else
        {
            toolBarView.switchInputButton.hidden = NO;
            
            [toolBarView updateLandscapeConstraints];
        }
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Guide Related Method

//================================================================================
//
//================================================================================
- (BOOL)addWCGuidesData
{
    BOOL result = NO;
    
    [PPGuideController setDelegate:self];
    
    //////////////////////////////////////////////////
    // prepare guide data
    
    [PPGuideController clearAllGuideScripts];
    
    @autoreleasepool
    {
        NSMutableArray *guideDataModels = [NSMutableArray array];
        
        //////////////////////////////////////////////////
        
        if(guideDataModels!=nil)
        {
            if([self existFrontCardImage]==YES &&
               [self existRearCardImage]==YES &&
               [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideFlipCard]==1)
            {
                [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideFlipCard];
                
                //////////////////////////////////////////////////
                
                [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                           guideIndex:PPHeadImageNameTabelViewCellGuideIndex_Flip
                                                                                title:WCCV_MLS_GuideFlipTitle
                                                                              message:WCCV_MLS_GuideFlipMessage
                                                                      layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
            }
            else if([self existFrontCardImage]==NO &&
                    [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideAddFrontCard]==1)
            {
                [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideAddFrontCard];
                
                //////////////////////////////////////////////////
                
                [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                           guideIndex:PPHeadImageNameTabelViewCellGuideIndex_AddFrontCard
                                                                                title:WCCV_MLS_GuideAddFrontCardTitle
                                                                              message:WCCV_MLS_GuideAddFrontCardMessage
                                                                      layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
            }
            else if([self existFrontCardImage]==YES &&
                    [self existRearCardImage]==NO &&
                    [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideAddRearCard]==1)
            {
                [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideAddRearCard];
                
                //////////////////////////////////////////////////
                
                [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                           guideIndex:PPHeadImageNameTabelViewCellGuideIndex_AddBackCard
                                                                                title:WCCV_MLS_GuideAddBackCardTitle
                                                                              message:WCCV_MLS_GuideAddBackCardMessage
                                                                      layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
            }
            
            //////////////////////////////////////////////////
            
            if([PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideMore]==1)
            {
                [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideMore];
                
                //////////////////////////////////////////////////
                
                [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                           guideIndex:ContactEditNavigationBarViewButtonGuideIndex_More
                                                                                title:WCCV_MLS_GuideMoreTitle
                                                                              message:WCCV_MLS_GuideMoreMessage
                                                                      layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
            }
            
            //////////////////////////////////////////////////
            
            if(guideDataModels.count>0)
            {
                [PPGuideController addGuideScriptWithName:NSStringFromClass([self class]) guideDataModels:guideDataModels];
                
                result = YES;
            }
        }
    }
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Update HeadImage Cell Method

//================================================================================
//
//================================================================================
- (void)updateHeadImageCellHeadImage
{
    do
    {
        NSInteger section = [self.contactEditSectionController sectionForPPContactMainType:PPContactMainType_HeadImage forSearching:NO];
        
        if(section==NSNotFound)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        UITableViewCell *tableViewCell = [self.contactEditView.contactEditTableView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:section]];
        
        if(tableViewCell==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([tableViewCell respondsToSelector:@selector(fetchImageWithObject:)]==YES)
        {
            [tableViewCell performSelector:@selector(fetchImageWithObject:) withObject:self];
            
            // !!只有 PPHeadImageNameTabelViewCell有 |fetchImageWithObject:|, 所以用來判斷是不是PPHeadImageNameTabelViewCell
            if (self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_MyCard)
            {
                // MyCard只有正面，如果已經有，就不用addOrFlipContactCardButton
                PPHeadImageNameTabelViewCell *cell = (PPHeadImageNameTabelViewCell *)tableViewCell;
                cell.addOrFlipContactCardButton.hidden = (self.existFrontCardImage);
            }
            
        }
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private TopActionSheet Buttons

//================================================================================
// MARK: More Buttons
//================================================================================
- (NSMutableArray *)moreButtons
{
    NSMutableArray *moreButtons = nil;
    
    do
    {
        moreButtons = [NSMutableArray array];
        
        if(moreButtons==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPCommentButton *noteButton = [[PPCommentButton alloc] initWithFrame:CGRectZero
                                                             buttonImageName:ImageNameWCContactViewControllerMoreButtonNote
                                                               buttonComment:WCCV_MLS_Note];
        
        if(noteButton==nil)
        {
            break;
        }
        
        noteButton.tag = WCContactEditViewControllerButtonTag_Note;
        
        //////////////////////////////////////////////////
        
        [moreButtons addObject:noteButton];
        
        [noteButton release];
        
        //////////////////////////////////////////////////

        //存在名片圖時，才能做手括辨識
        PPCommentButton *handClipButton = [[PPCommentButton alloc] initWithFrame:CGRectZero
                                                                 buttonImageName:ImageNameContactEditViewControllerMoreButtonClip
                                                                   buttonComment:WCCV_MLS_HandClip];
        
        if(handClipButton==nil)
        {
            break;
        }
        
        handClipButton.tag = WCContactEditViewControllerButtonTag_HandClip;
        
        //////////////////////////////////////////////////
        
        [moreButtons addObject:handClipButton];
        
        [handClipButton release];
     
        //////////////////////////////////////////////////
        
        if(self.hideAddOrFlipContactCardButton==NO)
        {
            PPCommentButton *replaceImageButton = [[PPCommentButton alloc] initWithFrame:CGRectZero
                                                                         buttonImageName:ImageNameContactEditViewControllerMoreButtonChange
                                                                           buttonComment:WCCV_MLS_ReplaceCard];
            
            if(replaceImageButton==nil)
            {
                break;
            }
            
            replaceImageButton.tag = WCContactEditViewControllerButtonTag_ReplaceCard;
            
            //////////////////////////////////////////////////
            
            [moreButtons addObject:replaceImageButton];
            
            [replaceImageButton release];
        }
        
        //////////////////////////////////////////////////
        if(self.contactEditViewControllerLayout!=WCContactEditViewControllerLayout_MyCard)
        {
            PPCommentButton *deleteContactButton = [[PPCommentButton alloc] initWithFrame:CGRectZero
                                                                          buttonImageName:ImageNameWCContactViewControllerMoreButtonDelete
                                                                            buttonComment:WCCV_MLS_DeleteContacter];
            
            if(deleteContactButton==nil)
            {
                break;
            }
            
            deleteContactButton.tag = WCContactEditViewControllerButtonTag_DeleteContact;
            
            //////////////////////////////////////////////////
            
            [moreButtons addObject:deleteContactButton];
            
            [deleteContactButton release];
        }
        //////////////////////////////////////////////////
        
        if(self.contactEditViewControllerLayout!=WCContactEditViewControllerLayout_MyCard)
        {
            PPCommentButton *mergeSystemContactButton = [[PPCommentButton alloc] initWithFrame:CGRectZero
                                                                               buttonImageName:ImageNameWCContactViewControllerMoreButtonMerge
                                                                                 buttonComment:WCCV_MLS_Merge];
            
            if(mergeSystemContactButton==nil)
            {
                break;
            }
            
            mergeSystemContactButton.tag = WCContactEditViewControllerButtonTag_MergeSystemContact;
            
            //////////////////////////////////////////////////
            
            [moreButtons addObject:mergeSystemContactButton];
            
            [mergeSystemContactButton release];
        }
        else
        {
            PPCommentButton *recognizeButton = [[PPCommentButton alloc] initWithFrame:CGRectZero
                                                                      buttonImageName:ImageNameWCContactViewControllerMoreButtonRecog
                                                                        buttonComment:WCCV_MLS_RecognizeButton];
            if (recognizeButton!=nil)
            {
                recognizeButton.tag = WCContactEditViewControllerButtonTag_ReRecognize;
                
                [moreButtons addObject:recognizeButton];
                [recognizeButton release];
            }
        }
        
        //////////////////////////////////////////////////
        
        for(PPCommentButton *button in moreButtons)
        {
            [button.titleLabel setFont:[UIFont systemFontOfSize:PPTopButtonFontSize]];
            
            //////////////////////////////////////////////////
            
            [button setBackgroundImage:[UIImage imageWithColor:PPTopButtonBackgroundColorHighlighted]
                              forState:UIControlStateHighlighted];
            
            [button setCommentTextColorNormal:PPTopButtonFontColorNormal];
            [button setCommentTextColorHighlighted:PPTopButtonFontColorHighlighted];
        }
        
    }
    while (0);
    
    return moreButtons;
}


//================================================================================
//
//================================================================================
- (BOOL)updateMoreButtonsEnableForButtonTag:(WCContactEditViewControllerButtonTag)buttonTag
{
    BOOL result = NO;
    
    do
    {
        if(self.topButtonsActionSheet==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        switch (buttonTag)
        {
            case WCContactEditViewControllerButtonTag_AddField:
            {
                //判斷是否能新增
                
                NSArray *sectionModels = [self nextEditFieldSectionModelArray];
                
                //////////////////////////////////////////////////
                
                if(sectionModels==nil ||
                   sectionModels.count<=0)
                {
                    break;
                }
                
                result = YES;
                
                break;
            }
            case WCContactEditViewControllerButtonTag_HandClip:
            case WCContactEditViewControllerButtonTag_ReplaceCard:
            {
                UIImage *cardImage = nil;
                
                if(self.showFrontCard==YES)
                {
                    cardImage = [self imageForPPContactMainType:PPContactMainType_FrontCardImage
                                               ppContactSubType:PPContactSubType_FrontCardImage_Original];
                }
                else
                {
                    cardImage = [self imageForPPContactMainType:PPContactMainType_BackCardImage
                                               ppContactSubType:PPContactSubType_BackCardImage_Original];
                }
                
                if(cardImage==nil)
                {
                    break;
                }
                
                result = YES;
                
                break;
            }
            case WCContactEditViewControllerButtonTag_DeleteContact:
            {
                if(self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_Add)
                {
                    break;
                }
                
                result = YES;
                break;
            }
            case WCContactEditViewControllerButtonTag_MergeSystemContact:
            case WCContactEditViewControllerButtonTag_Note:
            case WCContactEditViewControllerButtonTag_Reorder:
            default:
            {
                result = YES;
                break;
            }
        }
        
    }
    while (0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Show Rect of CardImage method

//================================================================================
//
//================================================================================
- (void)showCardImageScrollViewForShowingFrontCard:(BOOL)frontCard
{
    // 大圖用 Fill
    
    UIImage *originalImage = nil;
    
    if(frontCard==YES)
    {
        originalImage = [self imageForPPContactMainType:PPContactMainType_FrontCardImage
                                       ppContactSubType:PPContactSubType_FrontCardImage_Original];
        
    }
    else
    {
        originalImage = [self imageForPPContactMainType:PPContactMainType_BackCardImage
                                       ppContactSubType:PPContactSubType_BackCardImage_Original];
    }
    
    //////////////////////////////////////////////////
    
    if(originalImage!=nil)
    {
        [self showPartCardImageScrollViewForImage:originalImage
                                             rect:CGRectMake(0,0,originalImage.size.width,originalImage.size.height)];
    }
}


//================================================================================
//
//================================================================================
- (void)showPartCardImageScrollViewForImage:(UIImage *)image rect:(CGRect)rect
{
    do
    {
        if([self.contactImageProtocol respondsToSelector:@selector(setPPImageScrollViewImageMode:)]==YES &&
           image.size.width==rect.size.width &&
           image.size.height==rect.size.height)
        {
            [self.contactImageProtocol setPPImageScrollViewImageMode:PPImageScrollViewImageMode_ScaleAspectFill];
        }
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            CGImageRef cgImageTmp = NULL;
            
            if(image!=nil)
            {
                cgImageTmp = CGImageCreateWithImageInRect([image CGImage], rect);
            }
            // 當沒有前後名片圖，且顯示的scrollView上已經有預設名片圖，就不用在產生一次
            else
            {
                UIImage *defaultCardImage = [self imageForPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Default];
                
                if(defaultCardImage!=nil)
                {
                    cgImageTmp = CGImageCreateWithImageInRect([defaultCardImage CGImage], CGRectMake(0, 0,defaultCardImage.size.width,defaultCardImage.size.height));
                }
            }
            
            //////////////////////////////////////////////////
            
            __block UIImage *partImage = nil;
            
            if(cgImageTmp!=nil)
            {
                partImage = [UIImage imageWithCGImage:cgImageTmp];
                
                [partImage retain];
            }
            
            CGImageRelease(cgImageTmp);
            
            //////////////////////////////////////////////////
            
            if(partImage!=nil)
            {
                __block typeof(self) blcokSelf = self;
                
                dispatch_sync(dispatch_get_main_queue(), ^{
                    
                    [blcokSelf.contactImageProtocol setContactFrontCardImage:partImage];
                    
                    [partImage release];
                });
            }
        });
        
    } while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Contact Exist Method

//================================================================================
//
//================================================================================
- (BOOL)isContactExist
{
    BOOL isContactExist = YES;
    
    if([self.delegate respondsToSelector:@selector(cardIDExistInWCContactViewEditViewController:)]==YES &&
       [self.userInfoObject isKindOfClass:[NSString class]]==YES)
    {
        isContactExist = [self.delegate cardIDExistInWCContactViewEditViewController:self.userInfoObject];
    }
    
    return isContactExist;
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Update ContactHeaderView Hiden Method

//================================================================================
//
//================================================================================
- (void)updateContactEditHeadViewHidden
{
    BOOL frontCardExist = [self existFrontCardImage];
    
    //////////////////////////////////////////////////
    
    self.contactEditHeaderView.hidden = !(frontCardExist);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private DoubleSide Mode

//================================================================================
//
//================================================================================
- (BOOL)isDoubleSideMode
{
    if(UIInterfaceOrientationIsPortrait(self.interfaceOrientation)==NO)
    {
        return YES;
    }
    else
    {
        return NO;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Query Contact Favorite Method

//================================================================================
//
//================================================================================
- (void)requestContactIsFavoriteAndUpdateApperance
{
    
    do
    {
        if([self.contactDataExchangeProtocol respondsToSelector:@selector(favoriteWithSender:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(self.operationQueue==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        __block NSBlockOperation *blockOperation = [[[NSBlockOperation alloc] init] autorelease];
        
        if(blockOperation==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        
        [blockOperation addExecutionBlock:^{
            
            BOOL result = [blockself.contactDataExchangeProtocol favoriteWithSender:blockself];
            
            //////////////////////////////////////////////////
            
            dispatch_async(dispatch_get_main_queue(), ^(void)
                           {
                               blockself.contactEditNavigationBarView.favoriteButton.selected = result;
                               blockself.favoritedContact = result;
                           });
        }];
        
        //////////////////////////////////////////////////
        
        [self.operationQueue addOperation:blockOperation];
        
        // loop end
    }while (0);
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Get Foucs TextField Method

//================================================================================
//
//================================================================================
- (UITextField *)focusTextField
{
    UITextField *inputTextField = nil;
    
    do
    {
        UITableViewCell *tableViewCell = [self.contactEditView.contactEditTableView cellForRowAtIndexPath:self.currentSelectIndexPath];
        
        if(tableViewCell==nil)
        {
            // 取不到 focusTextField, 捲動至上次編輯位置
            [self.contactEditView.contactEditTableView setContentOffset:self.tableViewContentOffset
                                                               animated:NO];
            
            tableViewCell = [self.contactEditView.contactEditTableView cellForRowAtIndexPath:self.currentSelectIndexPath];
        }
        
        if(tableViewCell==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([tableViewCell respondsToSelector:@selector(currentFocusTextField)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        inputTextField = [tableViewCell performSelector:@selector(currentFocusTextField)];
    }
    while (0);
    
    return inputTextField;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Nofication Method

//================================================================================
//
//================================================================================
- (void)receiveTextFieldArriveMaxLengthNofication:(NSNotification *)notificaiton
{
    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        [WCToastController showMessageToastFromSuperView:blockself.toastSuperView
                                             withMessage:[NSString stringWithFormat:WCCV_MLS_ArriveLengthLimit,  [[notificaiton object] integerValue]]
                                                position:PPToastPositionCenter];
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Send Delegate Method

//================================================================================
//
//================================================================================
- (void)requestSendAction:(WCContactEditViewControllerAction)action
{
    if([self.delegate respondsToSelector:@selector(contactEditViewController:action:)]==YES)
    {
           [self.delegate contactEditViewController:self action:action];
    }
}


//================================================================================
//
//================================================================================
- (BOOL)requestSendDataWithEditFinished
{
    BOOL result = YES;

    if([self.delegate respondsToSelector:@selector(contactEditViewControllerWillSendDataWithEditFinished:)]==YES)
    {
        result = [self.delegate contactEditViewControllerWillSendDataWithEditFinished:self];
    }
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Show AlertController Method

//================================================================================
// MARK: 新增聯絡人,修改後，是否放棄儲存聯絡人
//================================================================================
- (void)presentAskCheckIfDiscardNewContactSaveAlertController
{
    do
    {
        __block typeof(self) blockself = self;
        
        UIAlertAction *giveupAction = [UIAlertAction actionWithTitle:WCCV_MLS_GiveUp style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            [blockself requestSendAction:WCContactEditViewControllerAction_GiveUpSavingContacter];
        }];
        
        if(giveupAction==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        UIAlertAction *saveAction = [UIAlertAction actionWithTitle:WCCV_MLS_Save style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
          
            if([blockself requestSendDataWithEditFinished]==YES)
            {
                [blockself againSendEditDoneAction];
            }
        }];
        
        if(saveAction==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                  title:@""
                                                message:WCCV_MLS_CheckIfSave
                                 showFromViewController:self
                                               animated:YES
                                            alertAction:giveupAction,saveAction,nil];
    }
    while (0);
}


//================================================================================
// MARK: 編輯聯絡人, 修改後, 是否放棄儲存聯絡人
//================================================================================
- (void)presentAskCheckIfDiscardEditContactSaveAlertController
{
    do
    {
        __block typeof(self) blockself = self;
        
        UIAlertAction *backAction = [UIAlertAction actionWithTitle:WCCV_MLS_GiveUp
                                                             style:UIAlertActionStyleDefault
                                                           handler:^(UIAlertAction *action){
                                                               [blockself requestSendAction:WCContactEditViewControllerAction_GoBack];
                                                           }];
        
        if(backAction==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        UIAlertAction *saveAction = [UIAlertAction actionWithTitle:WCCV_MLS_Save
                                                             style:UIAlertActionStyleDefault
                                                           handler:^(UIAlertAction *action){
                                                              
                                                                   if([blockself requestSendDataWithEditFinished]==YES)
                                                                   {
                                                                       [blockself againSendEditDoneAction];
                                                                   }
                                                           }];
        
        //////////////////////////////////////////////////
        
        if(saveAction==nil)
        {
            break;
        }
        
        [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                  title:@""
                                                message:WCCV_MLS_CheckIfSave
                                 showFromViewController:self
                                               animated:YES
                                            alertAction:backAction,saveAction, nil];
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)presentAskCheckIfDeleteContactAlertController
{
    do
    {
        UIAlertAction *backAction = [UIAlertAction actionWithTitle:WCCV_MLS_Cancel
                                                             style:UIAlertActionStyleDefault
                                                           handler:^(UIAlertAction *action){
                                                               
                                                           }];
        
        if(backAction==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        
        UIAlertAction *deleteAction = [UIAlertAction actionWithTitle:WCCV_MLS_Delete
                                                             style:UIAlertActionStyleDefault
                                                           handler:^(UIAlertAction *action){
                                                               [blockself requestSendAction:WCContactEditViewControllerAction_DeleteContacter];
                                                           }];
        
        //////////////////////////////////////////////////
        
        if(deleteAction==nil)
        {
            break;
        }
        
        [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                  title:@""
                                                message:WCCV_MLS_CheckIfDelete
                                 showFromViewController:self
                                               animated:YES
                                            alertAction:backAction,deleteAction, nil];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditTableViewCelltHeight Method

//================================================================================
//  MARK: 欄位高度
//================================================================================
- (CGFloat)contactEditTableViewCellWithDefaultHeight:(CGFloat)rowHeight indexPath:(NSIndexPath *)indexPath
{
    CGFloat returnRowHeight = rowHeight;
    
    do
    {
        PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
        if(rowModel==nil || [rowModel ppContactRowObjectOfRowModel]==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactRowObject *contactRowObject = rowModel.object;
        
        if(contactRowObject.tableViewCellStyle==PPContactTableViewCellStyle_TextView  && contactRowObject.inputValueDictionary.count>0)
        {
            returnRowHeight *=3;
        }
        else if(contactRowObject.tableViewCellStyle==PPContactTableViewCellStyle_HeadImageName)
        {
            returnRowHeight = WCContactEditViewControllerHeadImageCellHeight;
        }
        else if(contactRowObject.tableViewCellStyle==PPContactTableViewCellStyle_Default &&
                rowModel.detailText!=nil)
        {
            UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, rowHeight)];
            
            [label setText:rowModel.detailText];
            label.numberOfLines = 0;
            label.lineBreakMode = NSLineBreakByWordWrapping;
            label.font = [UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize];
            [label sizeToFit];
            
            if(label.bounds.size.height>WCContactContactEditViewController_Cell_DetailTextExtraHeight)
            {
                returnRowHeight+=label.bounds.size.height;
            }
            else
            {
                returnRowHeight+=WCContactContactEditViewController_Cell_DetailTextExtraHeight;
            }
            
            [label release];
        }
        else if(contactRowObject.tableViewCellStyle==PPContactTableViewCellStyle_MultiTextFields ||
                contactRowObject.tableViewCellStyle==PPContactTableViewCellStyle_HeadImageName)
        {
            if(contactRowObject.inputValueDictionary.count>0)
            {
                BOOL phonetic = NO;
                
                if([self.dataSource respondsToSelector:@selector(shouldShowPhoneticOnWCContactEditViewController:contactMainType:)]==YES)
                {
                    phonetic = [self.dataSource shouldShowPhoneticOnWCContactEditViewController:self
                                                                                contactMainType:contactRowObject.contactMainType];
                }
                
                returnRowHeight = returnRowHeight* [contactRowObject validVisbleFieldNumberWithCountPhonetic:phonetic];
            }
        }
        
    } while (0);
    
    return returnRowHeight;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditHeaderViewDelegate Method

//================================================================================
//
//================================================================================
- (void)contactEditHeaderView:(ContactEditHeaderView *)contactEditHeaderView responderView:(UIView *)responderView action:(ContactEditHeaderViewAction)action
{
    switch (action)
    {
        case ContactEditHeaderViewAction_CardImage:
        {
            if(self.showFrontCard==YES)
            {
                [self requestSendAction:WCContactEditViewControllerAction_ClickFrontCardImage];
            }
            else
            {
                [self requestSendAction:WCContactEditViewControllerAction_ClickRearCardImage];
            }
            
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditViewDataSource Method

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInContactEditView:(ContactEditView *)contactEditView
{
    return [self.contactEditSectionController numberOfSectionsForSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSInteger)contactEditView:(ContactEditView *)contactEditView numberOfRowsInSection:(NSInteger)section
{
    return [self.contactEditSectionController numberOfRowsInSection:section
                                                       forSearching:NO];
}


//================================================================================
// MARK: 產生 Cell 欄位
//================================================================================
- (UITableViewCell *)contactEditView:(ContactEditView *)contactEditView
               cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = nil;
    
    PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
    
    do
    {
        if(rowModel==nil || [rowModel ppContactRowObjectOfRowModel]==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
        
        switch (contactRowObject.tableViewCellStyle)
        {
            case PPContactTableViewCellStyle_HeadImageName:
            {
                // MARK: 大頭照欄位
                
                cell = [contactEditView.contactEditTableView dequeueReusableCellWithIdentifier:HeadImageNameCellIdentifier];
                
                //////////////////////////////////////////////////
                
                if(cell==nil)
                {
                    cell = [[[PPHeadImageNameTabelViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                                                reuseIdentifier:HeadImageNameCellIdentifier] autorelease];
                }
                
                //////////////////////////////////////////////////
                
                PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
                
                if(rowModel!=nil)
                {
                    PPHeadImageNameTabelViewCell *headImageNameTabelViewCell = (PPHeadImageNameTabelViewCell *)cell;
                    
                    headImageNameTabelViewCell.delegate = contactEditView;
                    [headImageNameTabelViewCell reuse];
                    
                    headImageNameTabelViewCell.headImageButtonEdgeInsets = WCContactEditViewControllerTableViewHeadImageEdgeInset;
                    headImageNameTabelViewCell.addOrFlipCardButtonEdgeInsets = WCContactEditViewControllerTableViewAddOrFlipCardButtonEdgeInset;
                    
                    //////////////////////////////////////////////////
                    
                    headImageNameTabelViewCell.addOrFlipContactCardButton.hidden = self.hideAddOrFlipContactCardButton;
                    // !! myCard是看有沒有名片圖決定要不要顯示
                    if(self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_MyCard)
                    {
                        headImageNameTabelViewCell.addOrFlipContactCardButton.hidden = [self existFrontCardImage];
                    }
                    //////////////////////////////////////////////////
                    
                    [headImageNameTabelViewCell setDefaulHeadImage:[UIImage imageWithName:ImageNameContactEditViewControllerUndefinedHead]];
                    
                    //////////////////////////////////////////////////
                    
                    if([self existFrontCardImage]==YES &&
                       [self existRearCardImage]==YES)
                    {
                        headImageNameTabelViewCell.addOrFlipContactCardButton.ppGuideIndex = PPHeadImageNameTabelViewCellGuideIndex_Flip;
                    }
                    else if([self existFrontCardImage]==YES)
                    {
                        headImageNameTabelViewCell.addOrFlipContactCardButton.ppGuideIndex = PPHeadImageNameTabelViewCellGuideIndex_AddBackCard;
                    }
                    else
                    {
                        headImageNameTabelViewCell.addOrFlipContactCardButton.ppGuideIndex = PPHeadImageNameTabelViewCellGuideIndex_AddFrontCard;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    [headImageNameTabelViewCell fetchImageWithObject:self];
                }
                
                cell.selectionStyle = UITableViewCellSelectionStyleNone;
                
                break;
            }
            case PPContactTableViewCellStyle_Switch:
            {
                // MARK: 系統連絡人存取欄位
                cell = [contactEditView.contactEditTableView dequeueReusableCellWithIdentifier:SwitchCellIdentifier];
                
                if(cell==nil)
                {
                    cell = [[[PPSwitchTableViewCell alloc] initCustomStyleWithReuseIdentifier:SwitchCellIdentifier] autorelease];
                }
                
                //////////////////////////////////////////////////
                
                PPSwitchTableViewCell *switchCell = (PPSwitchTableViewCell *)cell;
                
                //特殊做法, tableView 是 edit state, 調整 accessoryView
                switchCell.editingAccessoryView = switchCell.switchControl;
                
                switchCell.tag = contactRowObject.contactLabelType;
                
                switchCell.delegate = self;
                
                //////////////////////////////////////////////////
                
                switchCell.textLabel.text = [rowModel.text localizedFromTable:WCCV];
                
                if([[contactRowObject.inputValueDictionary objectForKey:@(PPContactSubType_SaveToSystemGroup)] boolValue]==YES)
                {
                    switchCell.switchControl.on = YES;
                }
                else
                {
                    switchCell.switchControl.on = NO;
                }
                
                [switchCell.textLabel setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                break;
            }
            default:
            {
#if defined(PRODUCTLINE_WCSF)
                
                cell = [self contactEditView:contactEditView
             salesforceCellForRowAtIndexPath:indexPath
                                    rowModel:rowModel];
#elif defined(PRODUCTLINE_WCO365)
                cell = [self contactEditView:contactEditView
              office365CellForRowAtIndexPath:indexPath
                                    rowModel:rowModel];
#else
                cell = [self contactEditView:contactEditView
                     wcCellForRowAtIndexPath:indexPath
                                    rowModel:rowModel];
                
#endif
                break;
            }
        }
        
    }while(0);
    
    return cell;
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView
     commitEditingStyle:(UITableViewCellEditingStyle)editingStyle
      forRowAtIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        //MARK: 點擊新增欄位
        if(editingStyle==UITableViewCellEditingStyleInsert)
        {
            __block PPContactSectionModel *contactSectionModel = nil;
            
            if(indexPath.section<[self.contactEditSectionController sectionModelsForSearching:NO].count)
            {
                contactSectionModel = [[self.contactEditSectionController sectionModelsForSearching:NO] objectAtIndex:indexPath.section];
            }
            
            //////////////////////////////////////////////////
            if(contactSectionModel!=nil)
            {
                //!!點擊新增欄位的欄位
                if(contactSectionModel.contactMainType==PPContactMainType_AddField)
                {
                    //!!紀錄此時點擊cell的indexPath，才能在返回時修改對應的資料。
                    self.currentSelectIndexPath = indexPath;
                    
                    //!!保持 currentSelectIndexPath 在下次進來viewcontroller前，不會被改到
                    self.textFieldShouldBeginEditing = NO;
                    
                    //////////////////////////////////////////////////
                    
                    PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
                    
                    if(rowModel!=nil &&
                       rowModel.text!=nil &&
                       self.topButtonsActionSheet.superview==nil)
                    {
                        [self showWCContactEditFieldViewControllerForSelectingIndexPath:indexPath title:rowModel.text];
                    }
                    
                }
                else
                {
                    [self insertRowModelInSectionModel:contactSectionModel indexPath:indexPath];
                }
            }
        }
        else if (editingStyle==UITableViewCellEditingStyleDelete)
        {
            // MARK: 點擊刪除欄位
            dispatch_async(dispatch_get_main_queue(), ^(void)
                           {
                               
                               self.findingNextFocus = NO;
                               
                               //////////////////////////////////////////////////
                               
                               [self.contactEditView.contactEditTableView beginUpdates];
                               
                               if([self.contactEditSectionController deleteRowModelAtIndexPath:indexPath forSearching:NO]==YES)
                               {
                                   [self.contactEditView.contactEditTableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:[NSIndexPath indexPathForRow:indexPath.row inSection:indexPath.section]]
                                                                                    withRowAnimation:UITableViewRowAnimationNone];
                                   
                                   //////////////////////////////////////////////////
                                   
                                   //刪除文字，代表可以按done
                                   self.edited = YES;
                                   
                                   [self updateDoneButtonEnable];
                               }
                               
                               //////////////////////////////////////////////////
                               
                               PPContactSectionModel *contactSectionModel = nil;
                               
                               if(indexPath.section<[self.contactEditSectionController sectionModelsForSearching:NO].count)
                               {
                                   contactSectionModel = [[self.contactEditSectionController sectionModelsForSearching:NO] objectAtIndex:indexPath.section];
                               }
                               
                               //!!要檢查是否新增"新增xx"的欄位
                               if([self.contactEditSectionController checkIllegalAndSaveRowModelInSection:indexPath.section forSearching:NO]==YES)
                               {
                                   [self.contactEditView.contactEditTableView insertRowsAtIndexPaths:[NSArray arrayWithObject:[NSIndexPath indexPathForRow:contactSectionModel.rowModels.count-1 inSection:indexPath.section]]
                                                                                    withRowAnimation:UITableViewRowAnimationNone];
                               }
                               else if(contactSectionModel.contactMainType==PPContactMainType_Other)
                               {
                                   //先計算數目
                                   NSUInteger totalNickNameCount = 0;
                                   NSUInteger totalUnifiedNumber = 0;
                                   
                                   for(PPRowModel *rowModel in contactSectionModel.rowModels)
                                   {
                                       if([rowModel ppContactRowObjectOfRowModel].contactLabelType==PPContactLabelType_Other_NickName)
                                       {
                                           totalNickNameCount++;
                                       }
                                       else if([rowModel ppContactRowObjectOfRowModel].contactLabelType==PPContactLabelType_Other_UnifiedBusinessNumber)
                                       {
                                           totalUnifiedNumber++;
                                       }
                                   }
                                   
                                   //////////////////////////////////////////////////
                                   
                                   UITableViewCellEditingStyle nickNameRowModelCellEditStyle = UITableViewCellEditingStyleDelete;
                                   
                                   //決定欄位是否能刪除
                                   if(totalNickNameCount<=PPContactMainTypeMaxCount_NickName)
                                   {
                                       nickNameRowModelCellEditStyle = UITableViewCellEditingStyleNone;
                                   }
                                   
                                   //////////////////////////////////////////////////
                                   
                                   UITableViewCellEditingStyle unifiedBusinessNumberRowModelCellEditStyle = UITableViewCellEditingStyleDelete;
                                   
                                   if(totalUnifiedNumber<=PPContactMainTypeMaxCount_UnifiedBusinessNumber)
                                   {
                                       unifiedBusinessNumberRowModelCellEditStyle = UITableViewCellEditingStyleNone;
                                   }
                                   
                                   //////////////////////////////////////////////////
                                   
                                   if(nickNameRowModelCellEditStyle!=UITableViewCellEditingStyleDelete ||
                                      unifiedBusinessNumberRowModelCellEditStyle!=UITableViewCellEditingStyleDelete)
                                   {
                                       for(PPRowModel *rowModel in contactSectionModel.rowModels)
                                       {
                                           if([rowModel ppContactRowObjectOfRowModel].contactLabelType==PPContactLabelType_Other_NickName)
                                           {
                                               [rowModel ppContactRowObjectOfRowModel].editingStyle = nickNameRowModelCellEditStyle;
                                           }
                                           else if([rowModel ppContactRowObjectOfRowModel].contactLabelType==PPContactLabelType_Other_UnifiedBusinessNumber)
                                           {
                                               [rowModel ppContactRowObjectOfRowModel].editingStyle = unifiedBusinessNumberRowModelCellEditStyle;
                                           }
                                       }
                                       
                                       //////////////////////////////////////////////////
                                       
                                       [self.contactEditView.contactEditTableView reloadSections:[NSIndexSet indexSetWithIndex:indexPath.section]
                                                                                withRowAnimation:UITableViewRowAnimationNone];
                                   }
                               }
                               
                               [self.contactEditView.contactEditTableView endUpdates];
                               
                               //////////////////////////////////////////////////
                               
                               
                               __block typeof(self) blockself = self;
                               
                               dispatch_async(dispatch_get_main_queue(), ^{
                                   
                                   if([blockself activeFocusTextField:NO atSection:indexPath.section]==YES)
                                   {
                                       blockself.currentSelectIndexPath = nil;
                                   }
                               });
                               
                           });
        }
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditViewDelegate Method

//================================================================================
//
//================================================================================
- (BOOL)contactEditView:(ContactEditView *)contactEditView ppMultipleTextFieldButtonTableViewCellShouldBeginEditing:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell textFieldTag:(NSUInteger)tag atIndexPath:(NSIndexPath *)indexPath
{
    BOOL result = NO;
    
    do
    {
        if([self allowTextFieldShouldBeginEditing]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(tag>=multipleTextFieldButtonTableViewCell.textFieldButtonViews.count)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
        
        //////////////////////////////////////////////////
        
        self.currentSelectIndexPath = indexPath;
        
        //////////////////////////////////////////////////
        
        NSArray *sortKey = nil;
        
        if([self.dataSource respondsToSelector:@selector(ppContactSubTypeArrayForSortingSectionRowWithPPContactMainType:ppContactEditViewController:)]==YES)
        {
            sortKey = [self.dataSource ppContactSubTypeArrayForSortingSectionRowWithPPContactMainType:contactRowObject.contactMainType ppContactEditViewController:self];
        }
        
        if(sortKey==nil || sortKey.count<=0)
        {
            sortKey = [contactRowObject sortAllKeys];
        }
        
        //////////////////////////////////////////////////
        
        if([[sortKey objectAtIndex:tag] unsignedIntegerValue]==PPContactSubType_Address_Country)
        {
            [self showCountrySelectViewController];
        }
        
        //////////////////////////////////////////////////
        
        UITextField *textField = nil;
        
        for(PPTextFieldButtonView *textFieldButtonView in multipleTextFieldButtonTableViewCell.textFieldButtonViews)
        {
            if(textFieldButtonView.textField.tag==tag)
            {
                textField = textFieldButtonView.textField;
                break;
            }
        }
        
        [self keepKeyboardDisplayStyleWithView:textField];
        
        result = YES;
        
    } while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)contactEditView:(ContactEditView *)contactEditView ppPhoneTextFieldTableViewCellShouldBeginEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    BOOL result = [self allowTextFieldShouldBeginEditing];
    
    if(result==YES)
    {
        self.currentSelectIndexPath = indexPath;
        
        //////////////////////////////////////////////////
        
        [self keepKeyboardDisplayStyleWithView:phoneTextFieldTableViewCell.textField];
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)contactEditView:(ContactEditView *)contactEditView ppTextFieldTableViewCellShouldBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    BOOL result = [self allowTextFieldShouldBeginEditing];
    
    if(result==YES)
    {
        self.currentSelectIndexPath = indexPath;
        
        //////////////////////////////////////////////////
        
        [self keepKeyboardDisplayStyleWithView:textFieldTableViewCell.textField];
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)contactEditView:(ContactEditView *)contactEditView ppTextViewTableViewCellShouldBeginEditing:(PPTextViewTableViewCell *)textViewTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    BOOL result = [self allowTextViewShouldBeginEditing];
    
    if(result==YES)
    {
        self.currentSelectIndexPath = indexPath;
        
        //////////////////////////////////////////////////
        
        [self keepKeyboardDisplayStyleWithView:textViewTableViewCell.ppTextView];
    }
    
    return result;
}


//================================================================================
//
//================================================================================
//- (BOOL)contactEditView:(ContactEditView *)contactEditView ppTextViewTableViewCellShouldBeginEditing:(PPTextViewTableViewCell *)textViewTableViewCell atIndexPath:(NSIndexPath *)indexPath
//{
//    return YES;
//}


//================================================================================
//
//================================================================================
- (BOOL)contactEditView:(ContactEditView *)contactEditView ppHeadImageNameTableViewCellShouldBeginEditing:(PPHeadImageNameTabelViewCell *)headImageNameTabelViewCell textFieldTag:(NSUInteger)tag atIndexPath:(NSIndexPath *)indexPath
{
    BOOL result = [self allowTextViewShouldBeginEditing];
    
    if(result==YES)
    {
        self.currentSelectIndexPath = indexPath;
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (CGFloat)contactEditView:(ContactEditView *)contactEditView estimatedHeightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [self contactEditTableViewCellWithDefaultHeight:contactEditView.contactEditTableView.estimatedRowHeight indexPath:indexPath];
}


//================================================================================
//
//================================================================================
- (CGFloat)contactEditView:(ContactEditView *)contactEditView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    // MARK: Cell 高度
    CGFloat rowHeight = 0;
    
    if([[[UIDevice currentDevice] systemVersion] floatValue]<7.0)
    {
        rowHeight = [self contactEditTableViewCellWithDefaultHeight:contactEditView.contactEditTableView.rowHeight indexPath:indexPath];
    }
    else
    {
        rowHeight = [self contactEditTableViewCellWithDefaultHeight:contactEditView.contactEditTableView.estimatedRowHeight indexPath:indexPath];
        
    }
    
    return rowHeight;
}


//================================================================================
// MARK: 點擊Cell
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView didSelectRowAtIndexPath:(NSIndexPath *)indexPath;
{
    UITableViewCell *cell = [self.contactEditView.contactEditTableView cellForRowAtIndexPath:indexPath];
    
    if(cell.editingStyle==UITableViewCellEditingStyleInsert)
    {
        [contactEditView.contactEditTableView deselectRowAtIndexPath:indexPath animated:NO];
        
        //////////////////////////////////////////////////
        
        [self contactEditView:contactEditView commitEditingStyle:UITableViewCellEditingStyleInsert forRowAtIndexPath:indexPath];
    }
    else if (cell.editingStyle==(UITableViewCellEditingStyleDelete|UITableViewCellEditingStyleInsert))
    {
        // MARK: 點擊勾選
#if defined (PRODUCTLINE_WCSF)
        [self contactEditView:contactEditView wcsfDidSelectRowAtIndexPath:indexPath];
#elif defined (PRODUCTLINE_WCO365)
        [self contactEditView:contactEditView wco365DidSelectRowAtIndexPath:indexPath];
#endif
    }
    else if(cell.editingStyle==UITableViewCellEditingStyleNone)
    {
        [contactEditView.contactEditTableView deselectRowAtIndexPath:indexPath animated:NO];
        
        //////////////////////////////////////////////////
        
        PPContactRowObject *contactRowObject = [[self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO] ppContactRowObjectOfRowModel];
        
        if(contactRowObject.contactMainType==PPContactMainType_Group)
        {
            switch (contactRowObject.contactLabelType)
            {
                case PPContactLabelType_Group_Info:
                {
                    [self requestSendAction:WCContactEditViewControllerAction_ChangeGroup];
                    
                    break;
                }
                default:
                {
                    break;
                }
            }
        }
        else if(contactRowObject.contactMainType==PPContactMainType_SystemGroup)
        {
            switch (contactRowObject.contactLabelType)
            {
                case PPContactLabelType_SystemGroup_Info:
                {
                    [self requestSendAction:WCContactEditViewControllerAction_ChangeSystemGroup];
                    
                    break;
                }
                default:
                {
                    break;
                }
            }
        }
        else if(contactRowObject.contactMainType==PPContactMaintype_VisibleAccount)
        {
            [self requestSendAction:WCContactEditViewControllerAction_ChangeVisibleAccount];
        }
        else if(contactRowObject.contactMainType==PPContactMainType_SalesforceSaveAs)
        {
            [self requestSendAction:WCContactEditViewControllerAction_ChangeSalesforceTarget];
        }
    }
    else
    {
        PPContactMainType ppContactMainType = [self.contactEditSectionController contactMainTypeInSection:indexPath.section forSearching:NO];
        
        do
        {
            //!!不允許變動標題
            if(ppContactMainType==PPContactMainType_None ||
               ppContactMainType==PPContactMainType_Other ||
               ppContactMainType==PPContactMainType_Name ||
               ppContactMainType==PPContactMainType_Note ||
               ppContactMainType==PPContactMainType_PublicNote ||
               ppContactMainType==PPContactMainType_AddField ||
               ppContactMainType==PPContactMainType_UserDefine ||
               ppContactMainType==PPContactMainType_BirthDay ||
               ppContactMainType==PPContactMainType_HeadImage ||
               ppContactMainType==PPContactMainType_Company ||
               ppContactMainType==PPContactMainType_Salutation ||
               ppContactMainType==PPContactMainType_Status)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
            
            if(rowModel==nil || rowModel.object==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            //建立時間無法變動標題
            if(ppContactMainType==PPContactMainType_Other &&
               ([rowModel ppContactRowObjectOfRowModel].contactLabelType==PPContactLabelType_Other_ConstructTime ||
                [rowModel ppContactRowObjectOfRowModel].contactLabelType==PPContactLabelType_Other_ModifyTime))
            {
                break;
            }
            
            self.currentSelectIndexPath = indexPath;
            
            //////////////////////////////////////////////////
            
            if(self.topButtonsActionSheet.superview==nil)
            {
                [self showWCContactEditFieldViewControllerForSelectingIndexPath:indexPath title:rowModel.text];
            }
        }
        while (0);
    }
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView didDeselectRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [self.contactEditView.contactEditTableView cellForRowAtIndexPath:indexPath];

    if (cell.editingStyle==(UITableViewCellEditingStyleDelete|UITableViewCellEditingStyleInsert))
    {
        // MARK: 取消勾選
#if defined (PRODUCTLINE_WCSF)
        [self contactEditView:contactEditView wcsfDidDeselectRowAtIndexPath:indexPath];
#elif defined (PRODUCTLINE_WCO365)
        [self contactEditView:contactEditView wco365DidDeselectRowAtIndexPath:indexPath];
#endif
    }
}


//================================================================================
//
//================================================================================
- (UITableViewCellEditingStyle)contactEditView:(ContactEditView *)contactEditView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCellEditingStyle style = UITableViewCellEditingStyleNone;
    
    do
    {
        if(contactEditView.contactEditTableView.editing==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
        
        if(contactRowObject==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        style = contactRowObject.editingStyle;
        
    } while (0);
    
    return style;
}


//================================================================================
//
//================================================================================
- (BOOL)contactEditView:(ContactEditView *)contactEditView canMoveRowAtIndexPath:(NSIndexPath *)indexPath;
{
    BOOL result = NO;
    
    do
    {
        //預設不能row 順序不能移動
        if(self.enableReorderControl==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(indexPath.section>=[self.contactEditSectionController sectionModelsForSearching:NO].count)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactSectionModel *contactSectionModel = [[self.contactEditSectionController sectionModelsForSearching:NO] objectAtIndex:indexPath.section];
        
        if(indexPath.row>=contactSectionModel.rowModels.count-1)
        {
            break;
        }
        else if(contactSectionModel.contactMainType==PPContactMainType_UserDefine)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        result = YES;
        
    } while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (NSIndexPath *)contactEditView:(ContactEditView *)contactEditView targetIndexPathForMoveFromRowAtIndexPath:(NSIndexPath *)sourceIndexPath toProposedIndexPath:(NSIndexPath *)proposedDestinationIndexPath
{
    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:sourceIndexPath.row inSection:sourceIndexPath.section];
    
    do
    {
        if(sourceIndexPath.section>=[self.contactEditSectionController sectionModelsForSearching:NO].count)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactSectionModel *contactSectionModel = [[self.contactEditSectionController sectionModelsForSearching:NO] objectAtIndex:sourceIndexPath.section];
        
        if(sourceIndexPath.row>=contactSectionModel.rowModels.count-1)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSInteger  row = 0;
        
        if(proposedDestinationIndexPath.section==sourceIndexPath.section)
        {
            if(proposedDestinationIndexPath.row>=contactSectionModel.rowModels.count-1)
            {
                row = contactSectionModel.rowModels.count-2;
            }
            else
            {
                row = proposedDestinationIndexPath.row;
            }
        }
        else if(proposedDestinationIndexPath.section>sourceIndexPath.section)
        {
            row = contactSectionModel.rowModels.count-2;
        }
        else
        {
            row = 0;
        }
        
        if(row<0)
        {
            row = 0;
        }
        
        //////////////////////////////////////////////////
        
        indexPath = [NSIndexPath indexPathForRow:row inSection:sourceIndexPath.section];
        
    } while (0);
    
    return indexPath;
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView moveRowAtIndexPath:(NSIndexPath *)sourceIndexPath toIndexPath:(NSIndexPath *)destinationIndexPath
{
    
    do
    {
        if(destinationIndexPath.section>=[self.contactEditSectionController sectionModelsForSearching:NO].count)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactSectionModel *destinationContactSectionModel = [[self.contactEditSectionController sectionModelsForSearching:NO] objectAtIndex:destinationIndexPath.section];
        
        if(destinationIndexPath.row>=destinationContactSectionModel.rowModels.count-1 ||
           sourceIndexPath.row>=destinationContactSectionModel.rowModels.count-1)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [destinationContactSectionModel.rowModels exchangeObjectAtIndex:sourceIndexPath.row withObjectAtIndex:destinationIndexPath.row];
        
        //////////////////////////////////////////////////
        
        //改變資料順序
        self.edited = YES;
        
    } while (0);
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView ppMultipleTextFieldButtonTableViewCellDidBeginEditing:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell textFieldTag:(NSUInteger)tag atIndexPath:(NSIndexPath *)indexPath
{
    PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
    PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
    
    if(contactRowObject!=nil)
    {
        NSArray *sortKey = nil;
        
        if([self.dataSource respondsToSelector:@selector(ppContactSubTypeArrayForSortingSectionRowWithPPContactMainType:ppContactEditViewController:)]==YES)
        {
            sortKey = [self.dataSource ppContactSubTypeArrayForSortingSectionRowWithPPContactMainType:contactRowObject.contactMainType ppContactEditViewController:self];
        }
        
        if(sortKey==nil || sortKey.count<=0)
        {
            sortKey = [contactRowObject sortAllKeys];
        }
        
        //////////////////////////////////////////////////
        
        // 如果不顯示讀音，要把讀音的key拿掉
        if([self.dataSource respondsToSelector:@selector(shouldShowPhoneticOnWCContactEditViewController:contactMainType:)])
        {
            NSMutableArray *tempKey = [NSMutableArray arrayWithArray:sortKey];
            
            if([self.dataSource shouldShowPhoneticOnWCContactEditViewController:self
                                                                contactMainType:PPContactMainType_Name]==NO)
            {
                [tempKey removeObject:@(PPContactSubType_Name_FirstNamePhonetic)];
                [tempKey removeObject:@(PPContactSubType_Name_LastNamePhonetic)];
            }
            
            //////////////////////////////////////////////////
            
            if([self.dataSource shouldShowPhoneticOnWCContactEditViewController:self
                                                                contactMainType:PPContactMainType_Company]==NO)
            {
                [tempKey removeObject:@(PPContactSubType_Company_NamePhonetic)];
            }
            
            //////////////////////////////////////////////////
            
            sortKey = tempKey;
        }
        
        //////////////////////////////////////////////////
        
        do
        {
            //重設範圍
            self.focusImageRect = CGRectZero;
            
            if(contactRowObject.imageRectDictionary.count<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            id object = [contactRowObject.imageRectDictionary objectForKey:[sortKey objectAtIndex:tag]];
            
            if(object==nil || [object isKindOfClass:[NSString class]]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            self.focusImageRect = CGRectFromString(object);
            
        } while (0);
        
        //////////////////////////////////////////////////
        
        self.foucsContactFieldSource = [rowModel ppContactFieldSource];
    }
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView ppMultipleTextFieldButtonTableViewCellDidChanged:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell textFieldTag:(NSUInteger)tag atIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        if(indexPath!=nil)
        {
            PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
            
            if(rowModel==nil)
            {
                return;
            }
            
            //////////////////////////////////////////////////
            
            PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
            
            if(contactRowObject==nil)
            {
                return;
            }
            
            //////////////////////////////////////////////////
            
            PPContactSectionModel *sectionModel = [[self.contactEditSectionController sectionModelsForSearching:NO]objectAtIndex:indexPath.section];
            
            if(sectionModel==nil)
            {
                return;
            }
            
            //////////////////////////////////////////////////
            
            if(multipleTextFieldButtonTableViewCell.textFieldButtonViews.count>tag)
            {
                UITextField *textField = [[multipleTextFieldButtonTableViewCell.textFieldButtonViews objectAtIndex:tag] textField];
                
                PPContactSubType contactSubType = PPContactSubType_None;
                
#if defined (PRODUCTLINE_WCO365)
                contactSubType = [contactRowObject office365ContactSubTypeWithLocalizedPlaceholder:textField.placeholder];
#else
                contactSubType = [contactRowObject contactSubTypeWithLocalizedPlaceholder:textField.placeholder];
#endif
                if(textField.text!=nil)
                {
                    [contactRowObject.inputValueDictionary setObject:textField.text
                                                              forKey:[NSNumber numberWithUnsignedInteger:contactSubType]];
                }
                else
                {
                    [contactRowObject.inputValueDictionary setObject:@""
                                                              forKey:[NSNumber numberWithUnsignedInteger:contactSubType]];
                }
                
                
            }
            
            //////////////////////////////////////////////////
            
            //已手動編輯過
            [rowModel setPPContactFieldSource:PPContactFieldSource_UserCreate];
            
            //////////////////////////////////////////////////
            
            self.edited = YES;
            
            //更新目前完成按鈕狀態
            [self updateDoneButtonEnable];
        }
        
    } while (0);
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView ppMultipleTextFieldButtonTableViewCellTouchDetail:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell textFieldTag:(NSUInteger)tag atIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(self.dataSource==nil ||
           [self.dataSource respondsToSelector:@selector(phoneticArrayWithWCContactEditViewController:clickedPhonetic:sourceValue:ppContactSubType:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
        
        if(contactRowObject==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactSectionModel *sectionModel = [[self.contactEditSectionController sectionModelsForSearching:NO]objectAtIndex:indexPath.section];
        
        if(sectionModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(multipleTextFieldButtonTableViewCell.textFieldButtonViews.count>tag)
        {
            UITextField *textField = [[multipleTextFieldButtonTableViewCell.textFieldButtonViews objectAtIndex:tag] textField];
            
            PPContactSubType contactSubType = [contactRowObject contactSubTypeWithLocalizedPlaceholder:textField.placeholder];
            
            NSString *sourceValue = nil;
            
            switch (contactSubType)
            {
                case PPContactSubType_Name_FirstNamePhonetic:
                {
                    sourceValue = [contactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_FirstName]];
                    
                    break;
                }
                case PPContactSubType_Name_LastNamePhonetic:
                {
                    sourceValue = [contactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_LastName]];
                    
                    break;
                }
                case PPContactSubType_Company_NamePhonetic:
                {
                    sourceValue = [contactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Company_Name]];
                    
                    break;
                }
                default:
                {
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            NSMutableArray *phoneticArray = [self.dataSource phoneticArrayWithWCContactEditViewController:self
                                                                                          clickedPhonetic:[contactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:contactSubType]]
                                                                                              sourceValue:sourceValue
                                                                                         ppContactSubType:contactSubType];
            
            
            //////////////////////////////////////////////////
            
            if(phoneticArray==nil && phoneticArray.count<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            BOOL illegal = YES;
            
            //檢查內容是不是字串
            for (id object in phoneticArray)
            {
                if([object isKindOfClass:[NSString class]]==NO)
                {
                    illegal = NO;
                    
                    break;
                }
            }
            
            if(illegal==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            self.selectController = [[[PPSelectController alloc] init] autorelease];
            
            ////////////////////////////////////////////////
            
            if(self.selectController!=nil)
            {
                self.selectController.delegate = self;
                self.selectController.tag = WCContactEditViewController_SelectControllerTag_Phonetic;
                self.selectController.tableViewCellSelectionStyle = UITableViewCellSelectionStyleNone;
                
                //////////////////////////////////////////////////
                
                if(self.keyboardShown==YES)
                {
                    [self.view endEditing:YES];
                }
                
                //////////////////////////////////////////////////
                
                self.selectController.sourceItemStringArray = phoneticArray;
                self.selectController.selectedIndex = -1;
                self.selectController.userInfo = @{textField.placeholder:indexPath};
                [self.selectController showFromViewController:self animated:YES];
            }
        }
        
    } while (0);
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView ppPhoneTextFieldTableViewCellDidBeginEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    [self textFieldDidBeginEditingAtIndexPath:indexPath];
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView ppPhoneTextFieldTableViewCellDidChanged:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    if(phoneTextFieldTableViewCell!=nil)
    {
        [self textFieldDidChanged:phoneTextFieldTableViewCell.textField atIndexPath:indexPath];
    }
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView ppTextFieldTableViewCellDidBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    //編輯中，一律回復顏色狀態
    textFieldTableViewCell.textField.textColor = WCContactEditViewCOntrollerTableViewCellTextColor;
    
    //////////////////////////////////////////////////
    
    if([textFieldTableViewCell isKindOfClass:[ContactDatePickerTableViewCell class]]==YES)
    {
        // MARK: 生日欄位 Pre Focus
        //給定預設時間字串
        
        do
        {
            if([textFieldTableViewCell.textField.text length]>0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            textFieldTableViewCell.textField.text = [[NSDate date] stringWithFormat:NSDateFormat_MonthAndDay];
            
            //////////////////////////////////////////////////
            
            PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
            
            if(rowModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
            
            if(contactRowObject==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            [contactRowObject.inputValueDictionary setObject:[[NSString stringWithInteger:WC_ValidMinYear] stringByAppendingString:[NSString stringWithFormat:@"/%@",textFieldTableViewCell.textField.text]]
                                                      forKey:@([contactRowObject curEditingSubType])];
        }
        while (0);
        
        //////////////////////////////////////////////////
        
        if([textFieldTableViewCell respondsToSelector:@selector(updateDefaultDisplayRowContent)]==YES)
        {
            [textFieldTableViewCell performSelector:@selector(updateDefaultDisplayRowContent)];
        };
        
    }
    else if([textFieldTableViewCell isKindOfClass:[ContactDateAndTimeTextFieldTableViewCell class]]==YES)
    {
        // MARK: 其它日期欄位 Pre Focus
        
        ContactDateAndTimeTextFieldTableViewCell *dateAndTimeTextFieldTableViewCell = (ContactDateAndTimeTextFieldTableViewCell *)textFieldTableViewCell;
        
        NSString *dateFormat = NSDateFormat_Day;
        
        //給定預設時間字串
        do
        {
            if([textFieldTableViewCell.textField.text length]>0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            if(dateAndTimeTextFieldTableViewCell.datePicker.datePickerMode==UIDatePickerModeDateAndTime)
            {
                dateFormat = NSDateFormat_Minute;
            }
            
            dateAndTimeTextFieldTableViewCell.textField.text = [[NSDate date] stringWithFormat:dateFormat];
            
            //////////////////////////////////////////////////
            
            PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
            
            if(rowModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
            
            if(contactRowObject==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            [contactRowObject.inputValueDictionary setObject:dateAndTimeTextFieldTableViewCell.textField.text
                                                      forKey:@([contactRowObject curEditingSubType])];
            
            self.edited = YES;
            
        }
        while (0);
        
        //////////////////////////////////////////////////
        
        [dateAndTimeTextFieldTableViewCell setDatePickerDateWithDateString:dateAndTimeTextFieldTableViewCell.textField.text format:dateFormat];
    }
    
    //////////////////////////////////////////////////
    
    [self textFieldDidBeginEditingAtIndexPath:indexPath];
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView ppTextFieldTableViewCellDidChanged:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    if(textFieldTableViewCell!=nil)
    {
        [self textFieldDidChanged:textFieldTableViewCell.textField atIndexPath:indexPath];
    }
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView ppTextFieldTableViewCellDidEndEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactRowObject *rowObject = [rowModel ppContactRowObjectOfRowModel];
        
        if([rowObject checkValueIsLegal]==YES)
        {
            textFieldTableViewCell.textField.textColor = WCContactEditViewCOntrollerTableViewCellTextColor;
        }
        else
        {
            textFieldTableViewCell.textField.textColor = [UIColor redColor];
        }
    }
    while (0);
}





//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView ppTextViewTableViewCellDidBeginEditing:(PPTextViewTableViewCell *)textViewTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    [self textFieldDidBeginEditingAtIndexPath:indexPath];
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView ppTextViewTableViewCellDidChange:(PPTextViewTableViewCell *)ppTextViewTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    [self textViewDidChangeValue:ppTextViewTableViewCell.ppTextView atIndexPath:indexPath];
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView ppHeadImageNameTableViewCell:(PPHeadImageNameTabelViewCell *)headImageNameTabelViewCell
               ppButton:(PPButton *)ppButton
           controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case PPHeadImageNameTabelViewCellButtonTag_ClickHeadImage:
        {
            BOOL showHeadImageSelectActionSheet = YES;
            
            if([self.delegate respondsToSelector:@selector(contactEditViewControllerCouldEditHeadImage:)]==YES)
            {
                showHeadImageSelectActionSheet = [self.delegate contactEditViewControllerCouldEditHeadImage:self];
            }
            
            ///////////////////////////////////////////////////////
            
            if(showHeadImageSelectActionSheet==YES)
            {
                if(self.keyboardShown==YES)
                {
                    [self.view endEditing:YES];
                }
                
                //////////////////////////////////////////////////
                
                [self showHeadImageSelectActionSheet];
            }
            
            break;
        }
        case PPHeadImageNameTabelViewCellButtonTag_Flip:
        {
            // MARK: 切換前後名片圖
            self.showFrontCard = !self.showFrontCard;
            
            //////////////////////////////////////////////////
            
            if(self.showFrontCard==YES)
            {
                [self.contactImageProtocol setContactFrontCardImage:[self imageForPPContactMainType:PPContactMainType_FrontCardImage
                                                                                   ppContactSubType:PPContactSubType_FrontCardImage_Thumbnail]];
            }
            else
            {
                [self.contactImageProtocol setContactRearCardImage:[self imageForPPContactMainType:PPContactMainType_BackCardImage
                                                                                  ppContactSubType:PPContactSubType_BackCardImage_Thumbnail]];
            }
            
            break;
        }
        case PPHeadImageNameTabelViewCellButtonTag_AddFrontCard:
        case PPHeadImageNameTabelViewCellButtonTag_AddBackCard:
        {
            // MARK: 新增前後名片圖
            
            if(self.keyboardShown==YES)
            {
                [self.view endEditing:YES];
            }
            
            //////////////////////////////////////////////////
            
            self.selectController = [[[PPSelectController alloc] init] autorelease];
            ////////////////////////////////////////////////
            
            if(self.selectController!=nil)
            {
                self.selectController.delegate = self;
                
                if(ppButton.tag==PPHeadImageNameTabelViewCellButtonTag_AddBackCard)
                {
                    self.selectController.tag = WCContactEditViewController_SelectControllerTag_SelectRearCard;
                }
                else
                {
                    self.selectController.tag = WCContactEditViewController_SelectControllerTag_SelectFrontCard;
                }
                
                self.selectController.tableViewCellSelectionStyle = UITableViewCellSelectionStyleNone;
                
                //////////////////////////////////////////////////
                
                self.selectController.sourceItemStringArray = @[WCCV_MLS_TakePhoto,WCCV_MLS_SelectAlbumPhoto];
                self.selectController.selectedIndex = -1;
                
                [self.selectController showFromViewController:self animated:YES];
            }
            
            break;
        }
        default:
        {
            
            break;
        }
    }
}


//================================================================================
//
//================================================================================
- (void)contactEditViewDidTouch:(ContactEditView *)contactEditView
{
    if(self.keyboardShown==YES)
    {
        self.keyboardShown = NO;
        
        [self.view endEditing:YES];
        
        //////////////////////////////////////////////////
        
        self.textViewShouldBegingEditing = NO;
        
        // TextView欄位太長，鍵盤縮下去瞬間，視圖跟著往下，此時手指又碰到視圖，造成鍵盤又往上，所以要先封掉textview的編輯，待0.5秒後釋放
        [self performSelector:@selector(setTextViewShouldBegingEditing:) withObject:[NSNumber numberWithBool:YES] afterDelay:0.5];
    }
}


//================================================================================
//
//================================================================================
- (UIView *)contactEditView:(ContactEditView *)contactEditView viewForHeaderInSection:(NSInteger)section
{
    UILabel *label = nil;
    
    do
    {
        NSArray *sectionModels = [self.contactEditSectionController sectionModelsForDefault];
        
        if(sectionModels==nil ||
           sectionModels.count<=section)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactSectionModel *sectionModel = [sectionModels objectAtIndex:section];
        
        if(sectionModel.title.length<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self totalCountDataForPPContactMainType:sectionModel.contactMainType]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        label = [[[UILabel alloc] init] autorelease];
        
        if(label==nil)
        {
            break;
        }
        
        label.textColor       = WCAppearanceDefine_SectionHeaderTitleColor;
        label.backgroundColor = WCAppearanceDefine_SectionHeaderBGColor;
        label.text = [@" " stringByAppendingString:sectionModel.title];
    }
    while (0);
    
    return label;
}


//================================================================================
//
//================================================================================
- (CGFloat)contactEditView:(ContactEditView *)contactEditView heightForHeaderInSection:(NSInteger)section
{
    CGFloat heightForHeaderInSection = 0;
    
    do
    {
        NSArray *sectionModels = [self.contactEditSectionController sectionModelsForDefault];
        
        if(sectionModels==nil ||
           sectionModels.count<=section)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactSectionModel *sectionModel = [sectionModels objectAtIndex:section];
        
        if(sectionModel.title==nil ||
           sectionModel.title.length<=0)
        {
            break;
        }
        
        if([self totalCountDataForPPContactMainType:sectionModel.contactMainType]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        heightForHeaderInSection = WCContactEditViewControllerTableViewSectionHeadViewHeight;
        
    }
    while (0);
    
    return heightForHeaderInSection;
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView willDisplayCell:(UITableViewCell *)cell forRowAtIndexPath:(NSIndexPath *)indexPath
{
    // MARK: 預設勾選的處理
#if defined (PRODUCTLINE_WCSF)
    [self contactEditView:contactEditView wcsfWillDisplayCell:cell forRowAtIndexPath:indexPath];
#elif defined (PRODUCTLINE_WCO365)
    [self contactEditView:contactEditView wco365WillDisplayCell:cell forRowAtIndexPath:indexPath];
#endif
}


//================================================================================
// MARK: 鍵盤上方按鈕被點擊
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView contactEditKeyboardToolBarView:(ContactKeyboardToolBarView *)contactEditKeyboardToolBarView ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case ContactKeyboardToolBarViewButtonTag_HideKeyboard:
        {
            if(self.keyboardShown==YES)
            {
                self.keyboardShown = NO;
                self.findingNextFocus = NO;
                
                //////////////////////////////////////////////////
                
                [self.view endEditing:YES];
            }
            
            break;
        }
        case ContactKeyboardToolBarViewButtonTag_SwitchInput:
        {
            
            typeof(self) blockself = self;
            dispatch_async(dispatch_get_main_queue(), ^{
                [blockself switchKeyboardDisplay];
            });
            
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditNavigationBarViewDelegate Method

//================================================================================
//
//================================================================================
- (void)contactEditNavigationBarView:(ContactEditNavigationBarView *)contactEditNavigationBarView ppButton:(PPButton *)button withControlEvent:(UIControlEvents)event
{
    //force dissmiss keyboard
    [self.view endEditing:YES];
    
    //////////////////////////////////////////////////
    
    switch (button.tag)
    {
        case ContactEditNavigationBarViewButtonTag_Cancel:
        {
            // MARK: 點選退出按鈕
            if (self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_Browse)
            {
                [self requestSendAction:WCContactEditViewControllerAction_ShowBrowse];
            }
            else
            {
                //代表有異動
                if([self actionWithEndEdit]==WCContactEditViewControllerAction_EditFinishedSuccessfully)
                {
                    if(self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_Edit)
                    {
                        [self presentAskCheckIfDiscardEditContactSaveAlertController];
                    }
                    else
                    {
                        [self presentAskCheckIfDiscardNewContactSaveAlertController];
                    }
                }
                // 空資料且編輯模式，按back 問要不要刪除
                else if([self actionWithEndEdit]==WCContactEditViewControllerAction_EditFinishedWithEmptyDataAndImage &&
                        self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_Edit)
                {
                    //刪除連絡人
                    [self presentAskCheckIfDeleteContactAlertController];
                }
                else
                {
                    [self requestSendAction:WCContactEditViewControllerAction_GoBack];
                }
            }
            break;
        }
        case ContactEditNavigationBarViewButtonTag_Done:
        {
            WCContactEditViewControllerAction action = [self actionWithEndEdit];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if(action==WCContactEditViewControllerAction_EditFinishedSuccessfully)
            {
                if([self requestSendDataWithEditFinished]==YES)
                {
                    [self againSendEditDoneAction];
                }
            }
            //編輯模式，且資料為空時，同刪除連絡人
            else if(action==WCContactEditViewControllerAction_EditFinishedWithEmptyDataAndImage  &&
                    self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_Edit)
            {
                [self presentAskCheckIfDeleteContactAlertController];
            }
            else if(action==WCContactEditViewControllerAction_EditFinishedWithIllegalTextData)
            {
                
                PPAlertController *alertController = [PPAlertController alertControllerWithTitle:@"" message:WCCV_MLS_InputFormatErrorAndSaveAfterFixing preferredStyle:UIAlertControllerStyleAlert];
                
                if(alertController!=nil)
                {
                    __block typeof(self) blockself = self;
                    
                    [alertController addAction:[UIAlertAction actionWithTitle:WCCV_MLS_OK style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                        
                        NSIndexPath *indexPath = [self.contactEditSectionController firstIllegalDataForIndexPath];
                        
                        //////////////////////////////////////////////////
                        
                        if(indexPath!=nil)
                        {
                            [blockself.contactEditView.contactEditTableView scrollToRowAtIndexPath:indexPath
                                                                                  atScrollPosition:UITableViewScrollPositionMiddle
                                                                                          animated:NO];
                            
                            //////////////////////////////////////////////////
                            
                            if([blockself activeFocusTextField:YES atSection:indexPath.section row:indexPath.row]==YES)
                            {
                                blockself.currentSelectIndexPath = indexPath;
                            }
                        }
                    }]];
                    
                    //////////////////////////////////////////////////
                    
                    [self presentViewController:alertController animated:YES completion:nil];
                }
            }
            else if(action==WCContactEditViewControllerAction_EditFinishedWithNoChangeData)
            {
#if defined (PRODUCTLINE_WCSF) || defined (PRODUCTLINE_WCO365)
                if([self requestSendDataWithEditFinished]==YES)
                {
                    [self againSendEditDoneAction];
                }
#else
                [self requestSendAction:action];
#endif
            }
            else
            {
                [self requestSendAction:action];
            }
            break;
        }
        case ContactEditNavigationBarViewButtonTag_More:
        {
            // MARK: 點選 more 按鈕
            self.topButtonsActionSheet = [[[PPTopButtonsActionSheet alloc] initWithFrame:self.navigationController.view.bounds] autorelease];
            
            
            if(self.topButtonsActionSheet!=nil)
            {
#if defined (PRODUCTLINE_WCSF)
                self.topButtonsActionSheet.capabilityButtonArray = [self salesforceMoreButtons];
#elif defined (PRODUCTLINE_WCO365)
                self.topButtonsActionSheet.capabilityButtonArray = [self office365MoreButtons];
#else
                self.topButtonsActionSheet.capabilityButtonArray = [self moreButtons];
#endif
                self.topButtonsActionSheet.delegate = self;
                self.topButtonsActionSheet.buttonListViewBackgroundColor = PPTopButtonsActionSheetViewBackgroundColor;
            }
            
            //////////////////////////////////////////////////
            
            [self.topButtonsActionSheet showFromSuperView:self.navigationController.view animated:YES];
            
            break;
        }
        case ContactEditNavigationBarViewButtonTag_Favorite:
        {
            // MARK: 點選我的最愛
            contactEditNavigationBarView.favoriteButton.selected = !contactEditNavigationBarView.favoriteButton.selected;
            
            self.favoritedContact = contactEditNavigationBarView.favoriteButton.selected;
            
            //視成已編輯過
            self.edited = YES;
            
            break;
        }
        case ContactEditNavigationBarViewButtonTag_Next:
        {
            // MARK: 幫同事掃描，save and back
            self.isHelpScanAddNext = YES;
            WCContactEditViewControllerAction action = [self actionWithEndEdit];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if(action==WCContactEditViewControllerAction_EditFinishedSuccessfully)
            {
                if([self requestSendDataWithEditFinished]==YES)
                {
                    [self againSendEditDoneAction];
                }
            }
            //編輯模式，且資料為空時，同刪除連絡人
            else if(action==WCContactEditViewControllerAction_EditFinishedWithEmptyDataAndImage  &&
                    self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_Edit)
            {
                [self presentAskCheckIfDeleteContactAlertController];
            }
            else if(action==WCContactEditViewControllerAction_EditFinishedWithIllegalTextData)
            {
                
                PPAlertController *alertController = [PPAlertController alertControllerWithTitle:@"" message:WCCV_MLS_InputFormatErrorAndSaveAfterFixing preferredStyle:UIAlertControllerStyleAlert];
                
                if(alertController!=nil)
                {
                    __block typeof(self) blockself = self;
                    
                    [alertController addAction:[UIAlertAction actionWithTitle:WCCV_MLS_OK style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                        
                        NSIndexPath *indexPath = [self.contactEditSectionController firstIllegalDataForIndexPath];
                        
                        //////////////////////////////////////////////////
                        
                        if(indexPath!=nil)
                        {
                            [blockself.contactEditView.contactEditTableView scrollToRowAtIndexPath:indexPath
                                                                                  atScrollPosition:UITableViewScrollPositionMiddle
                                                                                          animated:NO];
                            
                            //////////////////////////////////////////////////
                            
                            if([blockself activeFocusTextField:YES atSection:indexPath.section row:indexPath.row]==YES)
                            {
                                blockself.currentSelectIndexPath = indexPath;
                            }
                        }
                    }]];
                    
                    //////////////////////////////////////////////////
                    
                    [self presentViewController:alertController animated:YES completion:nil];
                }
            }
            else if(action==WCContactEditViewControllerAction_EditFinishedWithNoChangeData)
            {
#if defined (PRODUCTLINE_WCSF) || defined (PRODUCTLINE_WCO365)
                if([self requestSendDataWithEditFinished]==YES)
                {
                    [self againSendEditDoneAction];
                }
#else
                [self requestSendAction:action];
#endif
            }
            else
            {
                [self requestSendAction:action];
            }
            break;
        }
        case ContactEditNavigationBarViewButtonTag_Note:
        {
            // MARK: 備註欄位
            [self showNoteUI];
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCContactEditFieldViewControllerDelegate Method

//================================================================================
//
//================================================================================
- (void)contactEditFieldViewController:(WCContactEditFieldViewController *)contactEditFieldViewController
                        didSelectTitle:(NSString *)title
                  forPPContactMainType:(PPContactMainType)contactMainType
{
    do
    {
        if([title length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        //非新增欄位，改變cell標題
        if(contactEditFieldViewController.contactEditFieldViewControllerMode==WCContactEditFieldViewControllerMode_ChangeTitle)
        {
            if([self.contactEditSectionController changeRowModelText:title atIndexPath:self.currentSelectIndexPath]==YES)
            {
                [self.contactEditView.contactEditTableView reloadRowsAtIndexPaths:[NSArray arrayWithObject:self.currentSelectIndexPath]
                                                                 withRowAnimation:UITableViewRowAnimationNone];
                
                //////////////////////////////////////////////////
                
                //變更標題時，也算標題修正過
                self.edited = YES;
                
                [self updateDoneButtonEnable];
                
            }
        }
        //!!新增欄位
        else
        {
            //!!名字欄位增加的是欄位裡面的文字框數量;
            if(contactMainType==PPContactMainType_Name)
            {
                if([self.contactEditSectionController expandRowModelFieldInPPContanctSectionWithTitle:title
                                                                                    ppContactMainType:PPContactMainType_Name
                                                                                         forSearching:NO]==YES)
                {
                    
                    NSInteger section = [self.contactEditSectionController sectionForPPContactMainType:contactMainType forSearching:NO];
                    
                    //////////////////////////////////////////////////
                    
                    BOOL    deleteAddField = NO;
                    
                    NSUInteger lastIndex   = [self.contactEditSectionController sectionModelsForSearching:NO].count-1;
                    
                    NSArray *secitonModels = [self nextEditFieldSectionModelArray];
                    
                    //!!下次選取沒資料, 移除新增 add_field欄位
                    if(secitonModels==nil || secitonModels.count<=0)
                    {
                        deleteAddField = [self.contactEditSectionController deleteSectionModelAtIndex:lastIndex forSearching:NO];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    [self.contactEditView.contactEditTableView beginUpdates];
                    
                    if(section!=NSNotFound)
                    {
                        [self.contactEditView.contactEditTableView reloadSections:[NSIndexSet indexSetWithIndex:section]
                                                                 withRowAnimation:UITableViewRowAnimationNone];
                    }
                    
                    if(deleteAddField==YES)
                    {
                        [self.contactEditView.contactEditTableView deleteSections:[NSIndexSet indexSetWithIndex:lastIndex-1]
                                                                 withRowAnimation:UITableViewRowAnimationNone];
                        
                    }
                    
                    [self.contactEditView.contactEditTableView endUpdates];
                    
                }
            }
            //拼音欄位，增加的是名字與公司欄位的文字框數量
            else if(contactMainType==PPContactMainType_Phonetic)
            {
                NSInteger nameSection = NSNotFound;
                
                if([self.contactEditSectionController expandRowModelFieldInPPContanctSectionWithTitle:title
                                                                                    ppContactMainType:PPContactMainType_Name
                                                                                         forSearching:NO]==YES)
                {
                    nameSection = [self.contactEditSectionController sectionForPPContactMainType:PPContactMainType_Name forSearching:NO];
                    
                }
                
                //////////////////////////////////////////////////
                
                NSInteger companySection = NSNotFound;
                
                if([self.contactEditSectionController expandRowModelFieldInPPContanctSectionWithTitle:title
                                                                                    ppContactMainType:PPContactMainType_Company
                                                                                         forSearching:NO]==YES)
                {
                    companySection = [self.contactEditSectionController sectionForPPContactMainType:PPContactMainType_Company forSearching:NO];
                }
                
                //////////////////////////////////////////////////
                
                BOOL    deleteAddField = NO;
                
                NSUInteger lastIndex   = [self.contactEditSectionController sectionModelsForSearching:NO].count-1;
                
                NSArray *secitonModels = [self nextEditFieldSectionModelArray];
                
                //!!下次選取沒資料, 移除新增 add_field欄位
                if(secitonModels==nil || secitonModels.count<=0)
                {
                    deleteAddField = [self.contactEditSectionController deleteSectionModelAtIndex:lastIndex forSearching:NO];
                }
                
                //////////////////////////////////////////////////
                
                [self.contactEditView.contactEditTableView beginUpdates];
                
                if(nameSection!=NSNotFound)
                {
                    [self.contactEditView.contactEditTableView reloadSections:[NSIndexSet indexSetWithIndex:nameSection] withRowAnimation:UITableViewRowAnimationNone];
                }
                
                
                if(companySection!=NSNotFound)
                {
                    [self.contactEditView.contactEditTableView reloadSections:[NSIndexSet indexSetWithIndex:companySection] withRowAnimation:UITableViewRowAnimationNone];
                }
                
                
                if(deleteAddField==YES)
                {
                    [self.contactEditView.contactEditTableView deleteSections:[NSIndexSet indexSetWithIndex:lastIndex-1]
                                                             withRowAnimation:UITableViewRowAnimationNone];
                }
                
                [self.contactEditView.contactEditTableView endUpdates];
                
            }
            else
            {
                if([self.contactEditSectionController insertNewSectionModelForPPContactMainType:contactMainType
                                                                                   forSearching:NO]==YES)
                {
                    NSInteger section = [self.contactEditSectionController sectionForPPContactMainType:contactMainType forSearching:NO];
                    
                    //////////////////////////////////////////////////
                    
                    if(section!=NSNotFound)
                    {
                        [self.contactEditView.contactEditTableView beginUpdates];
                        
                        [self.contactEditView.contactEditTableView insertSections:[NSIndexSet indexSetWithIndex:section]
                                                                 withRowAnimation:UITableViewRowAnimationNone];
                        
                        [self.contactEditView.contactEditTableView endUpdates];
                    }
                }
            }
        }
    }
    while (0);
    
    //////////////////////////////////////////////////
    
    //!!當沒有資料時會新增失敗，可是畫面還是要切回來
    [self.navigationController popViewControllerAnimated:YES];
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - NoteViewController Delegate

//================================================================================
//
//================================================================================
- (void)noteViewController:(NoteViewController *)noteViewController ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case NoteViewControllerButtonTag_Back:
        {
            [noteViewController goBackAnimated:YES];
            
            break;
        }
        case NoteViewControllerButtonTag_Done:
        {
            ContactDataExchangeModel *noteDataExchangeModel = [[ContactDataExchangeModel alloc] init];
            
            if(noteDataExchangeModel!=nil)
            {
                noteDataExchangeModel.labelText = PPContactLabelText_PublicNote;
                noteDataExchangeModel.labelType = PPContactLabelType_None;
                noteDataExchangeModel.contactFieldSource = PPContactFieldSource_UserCreate;
                
                //////////////////////////////////////////////////
                
                if(noteViewController.noteTextString!=nil)
                {
                    [noteDataExchangeModel.propertyDictionary setObject:noteViewController.noteTextString forKey:@(PPContactSubType_None)];
                }
                else
                {
                    [noteDataExchangeModel.propertyDictionary setObject:@"" forKey:@(PPContactSubType_None)];
                }
                
                //////////////////////////////////////////////////
                
                self.contactEditSectionController.noteFieldArray = @[noteDataExchangeModel];
                
                //////////////////////////////////////////////////
                
                self.edited = YES;
            }
            
            
            [noteDataExchangeModel release];
            
            //////////////////////////////////////////////////
            
            [noteViewController goBackAnimated:YES];
            
            break;
        }
        case NoteViewControllerButtonTag_InsertDate:
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSwitchTableViewCell Deelegate Method

//================================================================================
// MARK: 切換系統類別顯示
//================================================================================
- (void)ppSwitchTableViewCellValueChanged:(PPSwitchTableViewCell *)switchTableViewCell
{
    // MARK: 顯示沒有儲存到系統連絡人權限
    [WCABDataController checkAccessPermissionWithCompletion:^(BOOL authorized){
        
        if(authorized==YES)
        {
            BOOL validGroupCouldSelect = YES;
            
            WCABDataController *abDataController = [[WCABDataController alloc] initWithError:nil];
            
            if(abDataController!=nil)
            {
                // TODO: 要做有效類別的偵測
                if([abDataController defaultSourceIDWithExcludedGmailAccount:self.syncAccountName]==nil)
                {
                    validGroupCouldSelect = NO;
                }
            }
            
            [abDataController release];
            
            //////////////////////////////////////////////////
            
            if(validGroupCouldSelect==YES)
            {
                WCContactEditViewControllerAction action = WCContactEditViewControllerAction_SaveContacterToSystem;
                
                if(switchTableViewCell.switchControl.on==YES)
                {
                    [PPSettingsController setIntegerValue:1 withKey:WCContactViewController_SettingsKey_EnableSystemContactCategory];
                    
                    //////////////////////////////////////////////////
                    
                    NSDictionary *systemCategoryFieldDictionaries = [self.contactDataExchangeProtocol sender:self fieldDictionaryforPPContactMainTypeArray:@[@(PPContactMainType_SystemGroup)]];
                    
                    self.contactEditSectionController.systemCategoryArray = [systemCategoryFieldDictionaries objectForKey:@(PPContactMainType_SystemGroup)];
                    
                    //////////////////////////////////////////////////
                    
                    [self.contactEditSectionController enableSystemCategory:YES
                                                                     orders:self.contactMainTypeOrders];
                }
                else
                {
                    [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_EnableSystemContactCategory];
                    
                    //////////////////////////////////////////////////
                    
                    [self.contactEditSectionController enableSystemCategory:NO
                                                                     orders:self.contactMainTypeOrders];
                    
                    //////////////////////////////////////////////////
                    
                    action = WCContactEditViewControllerAction_NonSaveContacterToSystem;
                }
                
                //////////////////////////////////////////////////
                
                NSInteger section = [self.contactEditSectionController sectionForPPContactMainType:PPContactMainType_SystemGroup
                                                                                      forSearching:NO];
                
                if(section!=NSNotFound)
                {
                    [self.contactEditView.contactEditTableView reloadSections:[NSIndexSet indexSetWithIndex:section]
                                                             withRowAnimation:UITableViewRowAnimationNone];
                }
                
                //////////////////////////////////////////////////
                
                [self requestSendAction:action];
            }
            else
            {
                [switchTableViewCell.switchControl setOn:NO animated:NO];
                
                //////////////////////////////////////////////////
                
                NSString *message = [NSString stringWithFormat:WCCV_MLS_NoUsableSourceAndGroup, self.syncAccountName];
                
                [WCToastController showMessageToastFromSuperView:self.view
                                                     withMessage:message
                                                        position:PPToastPositionCenter];
            }
        }
        else
        {
            [switchTableViewCell.switchControl setOn:NO animated:NO];
            
            //////////////////////////////////////////////////
            
            [WCToastController showMessageToastFromSuperView:self.view
                                                 withMessage:WCCV_MLS_NoAddressBookPermission
                                                    position:PPToastPositionCenter];
            
        }
    }];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPImageTabelViewCellImageSource

//================================================================================
//
//================================================================================
- (UIImage *)headImage
{
    UIImage *headImage = nil;
    
    do
    {
        headImage = [self imageForPPContactMainType:PPContactMainType_HeadImage
                                   ppContactSubType:PPContactSubType_HeadImage_Thumbnail];
        
        if(headImage==nil)
        {
            headImage = [self imageForPPContactMainType:PPContactMainType_HeadImage
                                       ppContactSubType:PPContactSubType_HeadImage_Original];
        }
    }
    while (0);
    
    return headImage;
}


//================================================================================
//
//================================================================================
- (BOOL)existFrontCardImage
{
    BOOL frontCardExist = NO;
    
    if([self imageForPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Thumbnail]!=nil ||
       [self imageForPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Original]!=nil)
    {
        frontCardExist = YES;
    }
    else if([self.dataSource respondsToSelector:@selector(imageExistWithWCContactEditViewController:ppContactMainType:)]==YES)
    {
        frontCardExist = [self.dataSource imageExistWithWCContactEditViewController:self
                                                                  ppContactMainType:PPContactMainType_FrontCardImage];
    }
    
    return frontCardExist;
}


//================================================================================
//
//================================================================================
- (BOOL)existRearCardImage
{
    BOOL rearCardExist = NO;
    
    if([self imageForPPContactMainType:PPContactMainType_BackCardImage ppContactSubType:PPContactSubType_BackCardImage_Thumbnail]!=nil ||
       [self imageForPPContactMainType:PPContactMainType_BackCardImage ppContactSubType:PPContactSubType_BackCardImage_Original]!=nil)
    {
        rearCardExist = YES;
    }
    else if([self.dataSource respondsToSelector:@selector(imageExistWithWCContactEditViewController:ppContactMainType:)]==YES)
    {
        rearCardExist = [self.dataSource imageExistWithWCContactEditViewController:self
                                                                 ppContactMainType:PPContactMainType_BackCardImage];
    }
    
    return rearCardExist;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCountrySelectorTableView Method

//================================================================================
//
//================================================================================
- (void)ppCountrySelectorTableViewDidSelectCountry:(NSString *)countryCode countryName:(NSString *)countryName
{
    PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:self.currentSelectIndexPath forSearching:NO];
    
    
    if(rowModel!=nil && [rowModel ppContactRowObjectOfRowModel]!=nil)
    {
        PPContactRowObject *contactRowObject = rowModel.object;
        
        for(NSNumber *key in contactRowObject.inputValueDictionary.allKeys)
        {
            //國家欄位
            if([key integerValue]==PPContactSubType_Address_CountryCode)
            {
                [contactRowObject.inputValueDictionary setObject:countryCode forKey:key];
                
                //////////////////////////////////////////////////
                
                //已手動編輯過
                [rowModel setPPContactFieldSource:PPContactFieldSource_UserCreate];
                
                //////////////////////////////////////////////////
                
                self.edited = YES;
                
                [self updateDoneButtonEnable];
            }
            else if([key integerValue]==PPContactSubType_Address_Country)
            {
                [contactRowObject.inputValueDictionary setObject:countryName forKey:key];
                
                //////////////////////////////////////////////////
                
                self.edited = YES;
                [self updateDoneButtonEnable];
            }
        }
        
        //////////////////////////////////////////////////
        
        [self.contactEditView.contactEditTableView reloadRowsAtIndexPaths:[NSArray arrayWithObject:self.currentSelectIndexPath] withRowAnimation:UITableViewRowAnimationNone];
        
        //////////////////////////////////////////////////
        
        [self.navigationController popViewControllerAnimated:YES];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGuideControllerDelegate Method

//================================================================================
//
//================================================================================
- (void)guideControllerDidFinishScript:(NSString *)guideScriptName
{
    if(self.checkAutoFocusWhenEmptyNameField==YES)
    {
        self.checkAutoFocusWhenEmptyNameField = NO;
        
        [self autoFocusEmptyNameField];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSelectionControllerDelegate Method

//================================================================================
//
//================================================================================
- (void)ppSelectController:(PPSelectController *)selectController itemSelectedIndex:(NSInteger)itemIndex withString:(NSString *)itemString
{
    
    if(selectController.tag==WCContactEditViewController_SelectControllerTag_Phonetic)
    {
        do
        {
            
            if(selectController.userInfo==nil || [selectController.userInfo isKindOfClass:[NSDictionary class]]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSDictionary *dictionary = selectController.userInfo;
            
            if(dictionary.count<=0)
            {
                break;
            }
            
            /////////////////////////////////////////////////
            
            NSString    *placeholder = [[dictionary allKeys] firstObject];
            NSIndexPath *indexPath   = [dictionary objectForKey:placeholder];
            
            PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
            
            if(rowModel==nil)
            {
                return;
            }
            
            //////////////////////////////////////////////////
            
            PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
            
            if(contactRowObject==nil)
            {
                return;
            }
            
            //////////////////////////////////////////////////
            
            PPContactSectionModel *sectionModel = [[self.contactEditSectionController sectionModelsForSearching:NO] objectAtIndex:indexPath.section];
            
            if(sectionModel==nil)
            {
                return;
            }
            
            //////////////////////////////////////////////////
            
            PPContactSubType contactSubType = [contactRowObject contactSubTypeWithLocalizedPlaceholder:placeholder];
            
            if(placeholder!=nil)
            {
                [contactRowObject.inputValueDictionary setObject:itemString
                                                          forKey:[NSNumber numberWithUnsignedInteger:contactSubType]];
            }
            else
            {
                [contactRowObject.inputValueDictionary setObject:@""
                                                          forKey:[NSNumber numberWithUnsignedInteger:contactSubType]];
            }
            
            //////////////////////////////////////////////////
            
            [indexPath retain];
            
            __block typeof(self) blockSelf = self;
            
            dispatch_async(dispatch_get_main_queue(), ^{
                [blockSelf.contactEditView.contactEditTableView reloadRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationNone];
                
                [indexPath release];
            });
            
            //////////////////////////////////////////////////
            
            //已手動編輯過
            [rowModel setPPContactFieldSource:PPContactFieldSource_UserCreate];
            
            //////////////////////////////////////////////////
            
            self.edited = YES;
            
        } while (0);
    }
    else
    {
        if([itemString isEqualToString:WCCV_MLS_TakePhoto]==YES)
        {
            // MARK: 通知外部拍照新增前名片圖
            
            switch (selectController.tag)
            {
                case WCContactEditViewController_SelectControllerTag_SelectFrontCard:
                {
                    [self requestSendAction:WCContactEditViewControllerAction_CameraForFrontCardImage];
             
                    break;
                }
                case WCContactEditViewController_SelectControllerTag_SelectRearCard:
                {
                    [self requestSendAction:WCContactEditViewControllerAction_CameraForRearCardImage];
                    
                    break;
                }
                case WCContactEditViewController_SelectControllerTag_AddOrDeleteHeadImage:
                default:
                {
                    [self requestSendAction:WCContactEditViewControllerAction_CameraForHeadImage];
            
                    break;
                }
            }
            
        }
        else if([itemString isEqualToString:WCCV_MLS_SelectAlbumPhoto]==YES)
        {
            // MARK: 通知外部相簿新增後名片圖
            
            switch (selectController.tag)
            {
                case WCContactEditViewController_SelectControllerTag_SelectFrontCard:
                {
                    [self requestSendAction:WCContactEditViewControllerAction_AlbumPhotoForFrontCardImage];
                    
                    break;
                }
                case WCContactEditViewController_SelectControllerTag_SelectRearCard:
                {
                    [self requestSendAction:WCContactEditViewControllerAction_AlbumPhotoForRearCardImage];
                    
                    break;
                }
                case WCContactEditViewController_SelectControllerTag_AddOrDeleteHeadImage:
                default:
                {
                    [self requestSendAction:WCContactEditViewControllerAction_AlbumPhotoForHeadImage];
                    
                    break;
                }
            }
        }
        else if([itemString isEqualToString:WCCV_MLS_ClipCardImageForHeadImage]==YES)
        {
            // MARK: 通知外部進行名片圖手括辨識
            [self requestSendAction:WCContactEditViewControllerAction_ClipCardImageForHeadImage];
        }
        else if([itemString isEqualToString:WCCV_MLS_DeletePhoto]==YES)
        {
            // MARK: 通知外部進行名刪除大頭照
            if([self imageForPPContactMainType:PPContactMainType_HeadImage ppContactSubType:PPContactSubType_HeadImage_Thumbnail])
            {
                do
                {
                    [self deleteHeadImage];
                    
                    //////////////////////////////////////////////////
                    
                    NSInteger section = [self.contactEditSectionController sectionForPPContactMainType:PPContactMainType_HeadImage forSearching:NO];
                    
                    if(section==NSNotFound)
                    {
                        break;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    UITableViewCell *tableViewCell = [self.contactEditView.contactEditTableView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:section]];
                    
                    if(tableViewCell!=nil &&
                       [tableViewCell respondsToSelector:@selector(showDefaultHeadImage)]==YES)
                    {
                        [tableViewCell performSelector:@selector(showDefaultHeadImage)];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    [self updateDoneButtonEnable];
                }
                while (0);
            }
        }
    }
}


//================================================================================
//
//================================================================================
- (void)ppSelectControllerDidDismiss:(PPSelectController *)selectController
{
    self.selectController = nil;
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTopButtonsActionSheet Delegate Method

//================================================================================
//
//================================================================================
- (void)ppTopButtonsActionSheet:(PPTopButtonsActionSheet *)ppTopButtonsActionSheet capabilityButtonSelectedTag:(NSInteger)buttonTag
{
    if(self.keyboardShown==YES)
    {
        [self.view endEditing:YES];
    }
    
    //////////////////////////////////////////////////
    
    switch (buttonTag)
    {
        case WCContactEditViewControllerButtonTag_AddField:
        {
            //!!保持 currentSelectIndexPath 在下次進來viewcontroller前，不會被改到
            self.textFieldShouldBeginEditing = NO;
            
            //////////////////////////////////////////////////
            
            @autoreleasepool
            {
                do
                {
                    if(self.contactEditFieldViewController==nil)
                    {
                        break;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    self.contactEditFieldViewController.currentSelectedTitle = WCCV_MLS_AddField;
                    self.contactEditFieldViewController.contactEditFieldViewControllerMode =WCContactEditFieldViewControllerMode_AddField;
                    
                    //////////////////////////////////////////////////
                    
                    NSArray *sectionModels = [self nextEditFieldSectionModelArray];
                    
                    //////////////////////////////////////////////////
                    
                    if(sectionModels!=nil &&sectionModels.count>0)
                    {
                        for (PPSectionModel *sectionModel in sectionModels)
                        {
                            [[self.contactEditFieldViewController.contactEditFieldSectionController  sectionModelsForSearching:NO] addObject:sectionModel];
                        }
                    }
                    
                    //////////////////////////////////////////////////
                    
                    if([self.contactEditFieldViewController.contactEditFieldSectionController  sectionModelsForSearching:NO].count<=0)
                    {
                        break;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    self.contactEditFieldViewController.delegate = self;
                    
                    [self.navigationController pushViewController:self.contactEditFieldViewController animated:YES];
                    
                } while (0);
            }
            
            break;
        }
        case WCContactEditViewControllerButtonTag_HandClip:
        {
            // MARK: 手括辨識
            if([self updateMoreButtonsEnableForButtonTag:buttonTag]==YES)
            {
                if(self.showFrontCard==YES)
                {
                    [self requestSendAction:WCContactEditViewControllerAction_HandClipForFrontCard];
                }
                else
                {
                    [self requestSendAction:WCContactEditViewControllerAction_HandClipForRearCard];
                }
            }
            else
            {
                [WCToastController showMessageToastFromSuperView:self.view
                                                     withMessage:WCCV_MLS_EmptyBusinessCard
                                                        position:PPToastPositionCenter];
            }
            
            break;
        }
        case WCContactEditViewControllerButtonTag_Reorder:
        {
            // MARK: 重排序, 不做
            break;
        }
        case WCContactEditViewControllerButtonTag_Note:
        {
            // MARK: 備註欄位
            [self showNoteUI];
            break;
        }
        case WCContactEditViewControllerButtonTag_DeleteContact:
        {
            // MARK: 刪除連絡人
            
            if([self actionWithEndEdit]==WCContactEditViewControllerAction_EditFinishedWithEmptyDataAndImage)
            {
                if (self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_Add)
                {
                    [self requestSendAction:WCContactEditViewControllerAction_GoBack];
                }
                else
                {
                    [self requestSendAction:WCContactEditViewControllerAction_DeleteContacter];
                }
            }
            else
            {
                [self presentAskCheckIfDeleteContactAlertController];
            }
            
            break;
        }
        case WCContactEditViewControllerButtonTag_MergeSystemContact:
        {
            // MARK: 合併系統聯絡人
            [self requestSendAction:WCContactEditViewControllerAction_MergeiPhoneContact];
   
            break;
        }
        case WCContactEditViewControllerButtonTag_ReplaceCard:
        {
            // MARK: 換名片圖
            if([self updateMoreButtonsEnableForButtonTag:buttonTag]==YES)
            {
                if(self.keyboardShown==YES)
                {
                    [self.view endEditing:YES];
                }
                
                //////////////////////////////////////////////////
                
                self.selectController = [[[PPSelectController alloc] init] autorelease];
                
                ////////////////////////////////////////////////
                
                if(self.selectController!=nil)
                {
                    self.selectController.delegate = self;
                    
                    if(self.showFrontCard==YES)
                    {
                        self.selectController.tag = WCContactEditViewController_SelectControllerTag_SelectFrontCard;
                    }
                    else
                    {
                        self.selectController.tag = WCContactEditViewController_SelectControllerTag_SelectRearCard;
                    }
                    
                    self.selectController.tableViewCellSelectionStyle = UITableViewCellSelectionStyleNone;
                    
                    //////////////////////////////////////////////////
                    
                    self.selectController.sourceItemStringArray = @[WCCV_MLS_TakePhoto,
                                                                    WCCV_MLS_SelectAlbumPhoto];
                    self.selectController.selectedIndex = -1;
                    
                    [self.selectController showFromViewController:self animated:YES];
                }
            }
            else
            {
                [WCToastController showMessageToastFromSuperView:self.view
                                                     withMessage:WCCV_MLS_EmptyBusinessCard
                                                        position:PPToastPositionCenter];
            }
            
            break;
        }
        case WCContactEditViewControllerButtonTag_ReRecognize:
        {
            [self requestSendAction:WCContactEditViewControllerAction_ReRecognize];

            break;
        }
        default:
        {
            
            break;
        }
    }
    
    //////////////////////////////////////////////////
    
    // 回復原始頁面設定，界面看起來才正常
    
    self.navigationController.navigationBar.hidden = NO;
    self.contactEditNavigationBarView.hidden = NO;
}



//================================================================================
//
//================================================================================
- (void)ppTopButtonsActionSheetDidDismiss:(PPTopButtonsActionSheet *)ppTopButtonsActionSheet
{
    self.navigationController.navigationBar.hidden = NO;
    self.contactEditNavigationBarView.hidden = NO;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)fetchContactCardImagesData
{
    // MARK: 更新前後名片圖
    
    do
    {
        if([self.contactDataExchangeProtocol respondsToSelector:@selector(sender:imageForPPContactMainType:ppContactSubType:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(self.operationQueue==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        __block NSBlockOperation *blockOperation = [[[NSBlockOperation alloc] init] autorelease];
        
        if(blockOperation==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        __block UIImage *frontCardImage = nil;
        __block UIImage *backCardImage  = nil;
        __block UIImage *defaulCardImage = nil;
        
        [blockOperation addExecutionBlock:^{
            
            do
            {
                PPContactSubType  frontCardContactSubType = PPContactSubType_FrontCardImage_Original;
                
                NSArray *contactSubTypes = @[@(PPContactSubType_FrontCardImage_Original),@(PPContactSubType_FrontCardImage_Thumbnail)];
                
                //////////////////////////////////////////////////
                
                for (id subType in contactSubTypes)
                {
                    frontCardContactSubType = [subType unsignedIntegerValue];
                    
                    frontCardImage = [[blockself imageForPPContactMainType:PPContactMainType_FrontCardImage
                                                          ppContactSubType:frontCardContactSubType] retain];
                    
                    if(frontCardImage==nil)
                    {
                        frontCardImage = [[blockself.contactDataExchangeProtocol sender:self
                                                              imageForPPContactMainType:PPContactMainType_FrontCardImage
                                                                       ppContactSubType:frontCardContactSubType] retain];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    if(frontCardImage!=nil)
                    {
                        break;
                    }
                }
                
                //////////////////////////////////////////////////
                
                PPContactSubType backCardContactSubType = PPContactSubType_BackCardImage_Original;
                
                contactSubTypes = @[@(PPContactSubType_BackCardImage_Original),@(PPContactSubType_BackCardImage_Thumbnail)];
                
                //////////////////////////////////////////////////
                
                for (id subType in contactSubTypes)
                {
                    backCardContactSubType = [subType unsignedIntegerValue];
                    
                    backCardImage = [[blockself imageForPPContactMainType:PPContactMainType_BackCardImage
                                                         ppContactSubType:backCardContactSubType] retain];
                    
                    if(backCardImage==nil)
                    {
                        backCardImage = [[blockself.contactDataExchangeProtocol sender:self
                                                             imageForPPContactMainType:PPContactMainType_BackCardImage
                                                                      ppContactSubType:backCardContactSubType] retain];
                    }
                    
                    
                    //////////////////////////////////////////////////
                    
                    if(backCardImage!=nil)
                    {
                        break;
                    }
                }
                
                //////////////////////////////////////////////////
                
                defaulCardImage = [[self imageForPPContactMainType:PPContactMainType_FrontCardImage
                                                  ppContactSubType:PPContactSubType_FrontCardImage_Default] retain];
                
                if(defaulCardImage==nil)
                {
                    [[blockself.contactDataExchangeProtocol sender:self
                                         imageForPPContactMainType:PPContactMainType_FrontCardImage
                                                  ppContactSubType:PPContactSubType_FrontCardImage_Default] retain];
                }
                
                //////////////////////////////////////////////////
                
                if(blockOperation.isCancelled==YES)
                {
                    [frontCardImage release];
                    [backCardImage release];
                    [defaulCardImage release];
                    
                    break;
                }
                
                //////////////////////////////////////////////////
                
                dispatch_async(dispatch_get_main_queue(), ^(void)
                               {
                                   [blockself setImage:defaulCardImage
                                  forPPContactMainType:PPContactMainType_FrontCardImage
                                      ppContactSubType:PPContactSubType_FrontCardImage_Default];
                                   
                                   //////////////////////////////////////////////////
                                   
                                   [blockself setImage:backCardImage
                                  forPPContactMainType:PPContactMainType_BackCardImage
                                      ppContactSubType:backCardContactSubType];
                                   
                                   //////////////////////////////////////////////////
                                   
                                   [blockself setImage:frontCardImage
                                  forPPContactMainType:PPContactMainType_FrontCardImage
                                      ppContactSubType:frontCardContactSubType];
                                   
                                   //////////////////////////////////////////////////
                                   
                                   //初始化前名片圖狀態
                                   for(NSUInteger subType=PPContactSubType_FrontCardImage_Default; subType<=PPContactSubType_FrontCardImage_Original; subType++)
                                   {
                                       if([blockself contactViewControllerImageStateForPPContactSubType:subType]==WCContactViewControllerImageState_None)
                                       {
                                           [blockself setContactViewControllerImageState:WCContactViewControllerImageState_NoneExist
                                                                     forPPContactSubType:subType];
                                       }
                                   }
                                   
                                   //////////////////////////////////////////////////
                                   
                                   //初始化後名片圖狀態
                                   for(NSUInteger subType=PPContactSubType_BackCardImage_Thumbnail; subType<=PPContactSubType_BackCardImage_Original; subType++)
                                   {
                                       if([blockself contactViewControllerImageStateForPPContactSubType:subType]==WCContactViewControllerImageState_None)
                                       {
                                           [blockself setContactViewControllerImageState:WCContactViewControllerImageState_NoneExist
                                                                     forPPContactSubType:subType];
                                       }
                                   }
                                   
                                   //////////////////////////////////////////////////
                                   
                                   [frontCardImage release];
                                   [backCardImage release];
                                   [defaulCardImage release];
                                   
                                   //////////////////////////////////////////////////
                                   
                                   [blockself updateHeadImageCellHeadImage];
                                   
                               });                // loop end
            }while (0);
        }];
        
        //////////////////////////////////////////////////
        
        [self.operationQueue addOperation:blockOperation];
        
        // loop end
    }while (0);
}


//================================================================================
//
//================================================================================
- (void)fetchContactHeadImagesData
{
    // MARK: 更新大頭照圖
    do
    {
        if([self.contactDataExchangeProtocol respondsToSelector:@selector(sender:imageForPPContactMainType:ppContactSubType:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(self.operationQueue==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        __block NSBlockOperation *blockOperation = [[[NSBlockOperation alloc] init] autorelease];
        
        if(blockOperation==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        __block UIImage *headImage = nil;
        
        [blockOperation addExecutionBlock:^{
            
            do
            {
                PPContactSubType headImageContactSubType = PPContactSubType_HeadImage_Original;
                
                NSArray *contactSubTypes = @[@(PPContactSubType_HeadImage_Original),@(PPContactSubType_HeadImage_Thumbnail)];
                
                //////////////////////////////////////////////////
                
                for (id subType in contactSubTypes)
                {
                    headImageContactSubType = [subType unsignedIntegerValue];
                    
                    headImage = [[blockself imageForPPContactMainType:PPContactMainType_HeadImage
                                                     ppContactSubType:headImageContactSubType] retain];
                    
                    if(headImage==nil)
                    {
                        headImage = [[blockself.contactDataExchangeProtocol sender:self
                                                         imageForPPContactMainType:PPContactMainType_HeadImage
                                                                  ppContactSubType:headImageContactSubType] retain];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    if(headImage!=nil)
                    {
                        break;
                    }
                }
                
                //////////////////////////////////////////////////
                
                if(blockOperation.isCancelled==YES)
                {
                    [headImage release];
                    break;
                }
                
                //////////////////////////////////////////////////
                
                dispatch_async(dispatch_get_main_queue(), ^(void)
                               {
                                   if([blockself setImage:headImage
                                     forPPContactMainType:PPContactMainType_HeadImage
                                         ppContactSubType:headImageContactSubType]==YES)
                                   {
                                       // notify to refresh head Image
                                       [blockself updateHeadImageCellHeadImage];
                                   }
                                   
                                   [headImage release];
                                   
                                   //////////////////////////////////////////////////
                                   
                                   //初始化大頭圖狀態
                                   for(NSUInteger subType=PPContactSubType_HeadImage_Thumbnail; subType<=PPContactSubType_HeadImage_Original; subType++)
                                   {
                                       if([blockself contactViewControllerImageStateForPPContactSubType:subType]==WCContactViewControllerImageState_None)
                                       {
                                           [blockself setContactViewControllerImageState:WCContactViewControllerImageState_NoneExist
                                                                     forPPContactSubType:subType];
                                       }
                                   }
                                   
                               });
                // loop end
            }while (0);
        }];
        
        //////////////////////////////////////////////////
        
        [self.operationQueue addOperation:blockOperation];
        
        // loop end
    }while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (NSUInteger)totalCountDataForPPContactMainType:(PPContactMainType)ppContactMainType
{
    NSUInteger totalCount = 0;
    
    do
    {
        if(self.contactEditSectionController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSMutableArray *contactSectionModels = [self.contactEditSectionController sectionModelsForSearching:NO];
        
        NSInteger section = [self.contactEditSectionController sectionForPPContactMainType:ppContactMainType forSearching:NO];
        
        if(section==NSNotFound ||
           section>=contactSectionModels.count)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactSectionModel *sectionModel = [contactSectionModels objectAtIndex:section];
        
        totalCount = sectionModel.rowModels.count;
        
    } while (0);
    
    return totalCount;
}


//================================================================================
//
//================================================================================
- (void)addDataFromFieldDictionary:(NSDictionary *)fieldDictionary
{
    if(fieldDictionary!=nil && fieldDictionary.count>0)
    {
        //!! contactEditView 資料的更新
        [self.contactEditSectionController fetchFieldDictionary:fieldDictionary
                                                         orders:self.contactMainTypeOrders
                                    toSectionModelsForSearching:NO];
        
        for(NSUInteger sectionIndex = 0; sectionIndex < self.contactEditSectionController.sectionModelsForDefault.count ; sectionIndex++)
        {
            if([self.contactEditSectionController checkArchivingUpperLimitAndRemoveRowModelForSection:sectionIndex forSearching:NO]==NO)
            {
                self.edited = YES;
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        //更新目前完成按鈕狀態
        [self updateDoneButtonEnable];
    }
}


//================================================================================
//
//================================================================================
- (void)clearAndFetchData
{
    //!! 使用預設資料集
    [self clearAndFetchDefaultData];
    
    //////////////////////////////////////////////////
    
    if([self.dataSource respondsToSelector:@selector(ppContactMainTypeArrayFetchingDataForWCContactEditViewController:)]==YES)
    {
        self.contactMainTypeOrders = [self.dataSource ppContactMainTypeArrayFetchingDataForWCContactEditViewController:self];
        
        //!! contactEditView 資料的更新
        NSDictionary *fieldDictionary = [self.contactDataExchangeProtocol sender:self
                                        fieldDictionaryforPPContactMainTypeArray:self.contactMainTypeOrders];
        
        [self.contactEditSectionController fetchFieldDictionary:fieldDictionary
                                                         orders:self.contactMainTypeOrders
                                    toSectionModelsForSearching:NO];
        
        
        //////////////////////////////////////////////////
        
        if([self isContactExist]==NO)
        {
            self.dataState = WCContactViewControllerDataState_NotExist;
        }
        else
        {
            self.dataState = WCContactViewControllerImageState_Exist;
        }
    }
    
    //////////////////////////////////////////////////
    
    //取得我的最愛
    [self requestContactIsFavoriteAndUpdateApperance];
}


//================================================================================
//
//================================================================================
- (void)clearAndFetchDefaultData
{
    [self.contactEditSectionController.extraSubTypeArray removeAllObjects];
    
    //////////////////////////////////////////////////
    
    if([self.dataSource respondsToSelector:@selector(shouldShowPhoneticOnWCContactEditViewController:contactMainType:)]==YES)
    {
        self.contactEditSectionController.showNamePhonetic = [self.dataSource shouldShowPhoneticOnWCContactEditViewController:self
                                                                                                              contactMainType:PPContactMainType_Name];
        
        //////////////////////////////////////////////////
        
        self.contactEditSectionController.showCompanyPhonetic = [self.dataSource shouldShowPhoneticOnWCContactEditViewController:self
                                                                                                                 contactMainType:PPContactMainType_Company];
    }
    
    //////////////////////////////////////////////////
    
    //新增欄位先不做
    //    [self.contactEditSectionController defaultSectionDatasWithDataModel:self.contactEditSectionController.dataModel
    //                                                 ppContactMainTypeArray:@[@(PPContactMainType_HeadImage),
    //                                                                          @(PPContactMainType_Name),
    //                                                                          @(PPContactMainType_Phone),
    //                                                                          @(PPContactMainType_Email),
    //                                                                          @(PPContactMainType_Company),
    //                                                                          @(PPContactMainType_Address),
    //                                                                          @(PPContactMainType_URL),
    //                                                                          ]
    //                                                           forSearching:NO];
    //
    
    //////////////////////////////////////////////////
    
    if([self.dataSource respondsToSelector:@selector(ppContactMainTypeArrayFetchingDataForWCContactEditViewController:)]==YES)
    {
        self.contactMainTypeOrders = [self.dataSource ppContactMainTypeArrayFetchingDataForWCContactEditViewController:self];
    }
    
    //////////////////////////////////////////////////
    
    //!! 預設欄位的  Note 不秀
    [self.contactMainTypeOrders removeObject:@(PPContactMainType_Note)];
    
    //////////////////////////////////////////////////
    
    [self.contactEditSectionController defaultSectionDatasWithDataModel:self.contactEditSectionController.dataModel
                                                 ppContactMainTypeArray:self.contactMainTypeOrders
                                                           forSearching:NO];
}


//================================================================================
//
//================================================================================
- (void)clearAndFetchDefaultDataFromFieldDictionary:(NSDictionary *)fieldDictionary
{
    //!! 使用預設資料集
    [self clearAndFetchDefaultData];
    
    //////////////////////////////////////////////////
    
    if(fieldDictionary!=nil && fieldDictionary.count>0)
    {
        if([self.dataSource respondsToSelector:@selector(ppContactMainTypeArrayFetchingDataForWCContactEditViewController:)]==YES)
        {
            self.contactMainTypeOrders = [self.dataSource ppContactMainTypeArrayFetchingDataForWCContactEditViewController:self];
        }
        
        
        //////////////////////////////////////////////////
        
        //!! contactEditView 資料的更新
        [self.contactEditSectionController fetchFieldDictionary:fieldDictionary
                                                         orders:self.contactMainTypeOrders
                                    toSectionModelsForSearching:NO];
        
        for(NSUInteger sectionIndex = 0; sectionIndex < self.contactEditSectionController.sectionModelsForDefault.count ; sectionIndex++)
        {
            [self.contactEditSectionController checkArchivingUpperLimitAndRemoveRowModelForSection:sectionIndex forSearching:NO];
        }
    }
    
    //////////////////////////////////////////////////
    
    //更新目前完成按鈕狀態
    [self updateDoneButtonEnable];
    
    //////////////////////////////////////////////////
    
    [self reloadData];
}


//================================================================================
//
//================================================================================
- (void)clearCardImageRectForPPContactFieldSource:(PPContactFieldSource)ppContactFieldSource
{
    [self.contactEditSectionController clearImageRectDataWithContactFieldSource:ppContactFieldSource searching:NO];
}


//================================================================================
//
//================================================================================
- (void)updateDataFromFieldDictionary:(NSDictionary *)fieldDictionary
                 ppContactFieldSource:(PPContactFieldSource)ppContactFieldSource;

{
    [self.contactEditSectionController clearRowModelWithContactFieldSource:ppContactFieldSource searching:NO];
    
    //////////////////////////////////////////////////
    
    [self addDataFromFieldDictionary:fieldDictionary];
    
    //////////////////////////////////////////////////
    
    self.edited = YES;
    
    //////////////////////////////////////////////////
    
    [self reloadData];
}


//================================================================================
//
//================================================================================
- (void)clearAndUpdateGroupDataFromFieldDictioanry:(NSDictionary *)fieldDictionary
{
    for(id key in fieldDictionary.allKeys)
    {
        NSUInteger seciton = [self.contactEditSectionController sectionForPPContactMainType:[key unsignedIntegerValue]
                                                                               forSearching:NO];
        
        if(seciton!=NSNotFound)
        {
            [[self.contactEditSectionController sectionModelsForDefault] removeObjectAtIndex:seciton];
        }
    }
    
    //////////////////////////////////////////////////
    
    [self updateGroupDataFromFieldDictioanry:fieldDictionary];
}


//================================================================================
//
//================================================================================
- (void)updateGroupDataFromFieldDictioanry:(NSDictionary *)fieldDictionary
{
    BOOL validGroup = [self.contactEditSectionController validGroup];
    
    //若已存在有效群組，在變換時，即視為能編輯成功
    if(validGroup==YES)
    {
        self.edited = YES;
    }
    
    //////////////////////////////////////////////////
    
    [self addDataFromFieldDictionary:fieldDictionary];
    
    //////////////////////////////////////////////////
    
    [self.contactEditView.contactEditTableView performSelectorOnMainThread:@selector(reloadData) withObject:nil waitUntilDone:NO];
}


//================================================================================
//
//================================================================================
- (void)removeGroupDataWithPPContactLabelType:(PPContactLabelType)contactLabelType
{
    PPRowModel *targetRowModel = nil;
    
    for(PPContactSectionModel *contactSectionModel in [self.contactEditSectionController sectionModelsForSearching:NO])
    {
        for(PPRowModel *rowModel in contactSectionModel.rowModels)
        {
            if([rowModel ppContactRowObjectOfRowModel].contactLabelType==contactLabelType)
            {
                targetRowModel = rowModel;
                break;
            }
        }
        
        if(targetRowModel!=nil && [contactSectionModel.rowModels indexOfObject:targetRowModel]!=NSNotFound)
        {
            [contactSectionModel.rowModels removeObject:targetRowModel];
            
            break;
        }
    }
    
    //////////////////////////////////////////////////
    
    [self reloadData];
}


//================================================================================
//
//================================================================================
- (void)clearAndUpdateContactMainTypeDataFromFieldDictioanry:(NSDictionary *)fieldDictionary
{
    do
    {
        if(fieldDictionary.count<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(id key in fieldDictionary.allKeys)
        {
            NSUInteger seciton = [self.contactEditSectionController sectionForPPContactMainType:[key unsignedIntegerValue]
                                                                                   forSearching:NO];
            
            if(seciton!=NSNotFound)
            {
                [[self.contactEditSectionController sectionModelsForDefault] removeObjectAtIndex:seciton];
            }
        }
        
        //////////////////////////////////////////////////
        
        if([[fieldDictionary allKeys] indexOfObject:@(PPContactMainType_Other)]!=NSNotFound)
        {
            // Note 特殊欄位，要先給預設欄位，才能讓流程一致
            [self.contactEditSectionController defaultSectionDatasWithDataModel:self.contactEditSectionController.dataModel
                                                         ppContactMainTypeArray:@[@(PPContactMainType_Other)]
                                                                   forSearching:NO];
        }
        
        //////////////////////////////////////////////////
        
        [self addDataFromFieldDictionary:fieldDictionary];
        
        //////////////////////////////////////////////////
        
        [self reloadData];
        
        //////////////////////////////////////////////////
        
        self.edited = YES;
        
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)setWCContactEditViewControllerLayout:(WCContactEditViewControllerLayout)contactEditViewControllerLayout
{
    if(_contactEditViewControllerLayout!=contactEditViewControllerLayout)
    {
        _contactEditViewControllerLayout = contactEditViewControllerLayout;
    }
}


//================================================================================
//
//================================================================================
- (void)againSendEditDoneAction
{
    NSError *error = nil;
    
    do
    {
        if(self.operationQueue==nil)
        {
            error = PPErrorOperationFailed(error);
            break;
        }
        
        //////////////////////////////////////////////////
        BOOL isFavorite = self.contactEditNavigationBarView.favoriteButton.selected;
        
        [self showBusyView:NO withSuperView:nil];
        [self showBusyView:YES withSuperView:nil];
        
        //////////////////////////////////////////////////
        
        __block NSBlockOperation *blockOperation = [[[NSBlockOperation alloc] init] autorelease];
        __block WCContactEditViewController *blockSelf = self;
        
        if(blockOperation==nil)
        {
            error = PPErrorOperationFailed(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        [blockOperation addExecutionBlock:^
         {
             @autoreleasepool
             {
                 //==================================================
                 // 同步過程中，名片被刪除，即新增連絡人，異動所有圖片狀態
                 //==================================================
                 if([blockSelf isContactExist]==NO)
                 {
                     if([blockSelf contactViewControllerImageStateForPPContactSubType:PPContactSubType_HeadImage_Original]==WCContactViewControllerImageState_Exist)
                     {
                         [blockSelf setContactViewControllerImageState:WCContactViewControllerImageState_Changed
                                                   forPPContactSubType:PPContactSubType_HeadImage_Original];
                     }
                     
                     //////////////////////////////////////////////////
                     
                     if([blockSelf contactViewControllerImageStateForPPContactSubType:PPContactSubType_FrontCardImage_Original]==WCContactViewControllerImageState_Exist)
                     {
                         [blockSelf setContactViewControllerImageState:WCContactViewControllerImageState_Changed
                                                   forPPContactSubType:PPContactSubType_FrontCardImage_Original];
                     }
                     
                     //////////////////////////////////////////////////
                     
                     if([blockSelf contactViewControllerImageStateForPPContactSubType:PPContactSubType_BackCardImage_Original]==WCContactViewControllerImageState_Exist)
                     {
                         [blockSelf setContactViewControllerImageState:WCContactViewControllerImageState_Changed
                                                   forPPContactSubType:PPContactSubType_BackCardImage_Original];
                     }
                 }
                 
                 //////////////////////////////////////////////////
                 
                 BOOL writeResult = YES;
                 NSError *returnError = nil;
                 
                 do
                 {
                     //==================================================
                     // 寫回我的最愛資訊
                     //==================================================
                     
                     if([blockSelf.contactDataExchangeProtocol respondsToSelector:@selector(sender:setFavorite:error:)]==YES)
                     {
                         writeResult = [blockSelf.contactDataExchangeProtocol sender:self
                                                                         setFavorite:isFavorite
                                                                               error:&returnError];
                     }
                     
                     if(writeResult==NO)
                     {
                         break;
                     }
                     
                     //////////////////////////////////////////////////

                     //==================================================
                     // 寫回文字資訊
                     //==================================================
                     
                     if([blockSelf.contactDataExchangeProtocol respondsToSelector:@selector(sender:setFieldsDictionary:error:)]==YES)
                     {
                         writeResult = [blockSelf.contactDataExchangeProtocol
                                        sender:blockSelf
                                        setFieldsDictionary:[blockSelf curTextFieldDictionary] error:&returnError];
                     }
                     
                     if(writeResult==NO)
                     {
                         break;
                     }
                     
                     //////////////////////////////////////////////////
                     
                     //==================================================
                     // 寫回圖片資訊
                     //==================================================
                     
                     if([blockSelf.contactDataExchangeProtocol respondsToSelector:@selector(sender:setImage:forPPContactMainType:error:)]==YES)
                     {
                         //!!加入大頭照資訊
                         if([blockSelf imageShouldWriteForPPContactMainType:PPContactMainType_HeadImage]==YES)
                         {
                             writeResult = [blockSelf.contactDataExchangeProtocol sender:blockSelf
                                                                                setImage:[blockSelf imageForPPContactMainType:PPContactMainType_HeadImage ppContactSubType:PPContactSubType_HeadImage_Original]
                                                                    forPPContactMainType:PPContactMainType_HeadImage
                                                                                   error:&returnError];
                         }
                         
                         if(writeResult==NO)
                         {
                             break;
                         }
                         
                         //////////////////////////////////////////////////
                         
                         //!!加入名片圖資訊
                         if([blockSelf imageShouldWriteForPPContactMainType:PPContactMainType_FrontCardImage]==YES)
                         {
                             writeResult = [blockSelf.contactDataExchangeProtocol sender:blockSelf
                                                                                setImage:[blockSelf imageForPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Original]
                                                                    forPPContactMainType:PPContactMainType_FrontCardImage
                                                                                   error:&returnError];
                         }
                         
                         if(writeResult==NO)
                         {
                             break;
                         }
                         
                         //////////////////////////////////////////////////

                         if([blockSelf imageShouldWriteForPPContactMainType:PPContactMainType_BackCardImage]==YES)
                         {
                             writeResult = [blockSelf.contactDataExchangeProtocol sender:blockSelf
                                                                                setImage:[blockSelf imageForPPContactMainType:PPContactMainType_BackCardImage ppContactSubType:PPContactSubType_BackCardImage_Original]
                                                                    forPPContactMainType:PPContactMainType_BackCardImage
                                                                                   error:&returnError];
                         }
                         
                     }
                 }
                 while (0);
                 
                 //////////////////////////////////////////////////
                 
                 [blockSelf performSelectorOnMainThread:@selector(mainThreadTerminalSendDataWithError:)
                                             withObject:returnError
                                          waitUntilDone:NO];
                
                 // autorelease end
             }
         }];
        
        //////////////////////////////////////////////////
        
        @synchronized(self.operationQueue)
        {
            if([self.operationQueue operationCount]>0)
            {
                [self.operationQueue cancelAllOperations];
            }
            
            [self.operationQueue addOperation:blockOperation];
        }
        
        //////////////////////////////////////////////////
        
    }while (0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil)
    {
        [self mainThreadTerminalSendDataWithError:error];
    }
}


//================================================================================
//
//================================================================================
- (void)reloadData
{
    if(self.contactEditView!=nil)
    {
        [self.contactEditView.sectionHeaders removeAllObjects];
        
        [self.contactEditView.contactEditTableView reloadData];
    }
}


//================================================================================
//
//================================================================================
- (BOOL)emptyTextData
{
    BOOL validText = YES;
    
    //檢查有效欄位值。
    NSUInteger totalSection = [self.contactEditSectionController sectionModelsForSearching:NO].count;
    
    for(NSUInteger sectionIndex=0 ; sectionIndex<totalSection ; sectionIndex++)
    {
        PPContactSectionModel *contactSectionModel = [[self.contactEditSectionController sectionModelsForSearching:NO] objectAtIndex:sectionIndex];
        
        for(PPRowModel *rowModel in contactSectionModel.rowModels)
        {
            PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
            
            //群組，可檢視用戶欄位，不能當作有效的欄位值判斷
            if(contactRowObject.contactMainType==PPContactMainType_Group ||
               contactRowObject.contactMainType==PPContactMainType_SystemGroup ||
               contactRowObject.contactMainType==PPContactMaintype_VisibleAccount)
            {
                continue;
            }
            
            //////////////////////////////////////////////////
            
            if([contactRowObject checkInputValueDictionaryKeyHasValidValue]==YES)
            {
                validText = NO;
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        if(validText==NO)
        {
            break;
        }
    }
    
    //////////////////////////////////////////////////
    
    // Note 欄位
    if(validText==YES)
    {
        ContactDataExchangeModel *contactDataExchangeModel = [self.contactEditSectionController.noteFieldArray firstObject];
        
        for(id key in contactDataExchangeModel.propertyDictionary.allKeys)
        {
            NSString *text = [contactDataExchangeModel.propertyDictionary objectForKey:key];
            
            if(text!=nil &&
               text.length>0)
            {
                validText = NO;
                
                break;
            }
        }
    }
    
    return validText;
}


//================================================================================
//
//================================================================================
- (BOOL)arriveMaximumCoutForContactMainType:(PPContactMainType)contactMainType contactSubType:(PPContactSubType)contactSubType
{
    BOOL result = NO;
    
    NSUInteger section = [self.contactEditSectionController sectionForPPContactMainType:contactMainType forSearching:NO];
    
    if(section!=NSNotFound)
    {
        NSUInteger rowModelCount = 0;
        
        PPSectionModel *sectionModel = [[self.contactEditSectionController sectionModelsForDefault] objectAtIndex:section];
        
        //檢查有效欄位
        for(PPRowModel *rowModel in sectionModel.rowModels)
        {
            if([rowModel ppContactRowObjectOfRowModel].editingStyle==UITableViewCellEditingStyleInsert)
            {
                continue;
                
            }
            
            //////////////////////////////////////////////////
            
            PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
            
            // 目前手括只有公司欄位要判斷到 subType
            if(contactMainType==PPContactMainType_Company)
            {
                NSString *stringValue = [[contactRowObject inputValueDictionary] objectForKey:@(contactSubType)];
                
                if([stringValue length]>0)
                {
                    rowModelCount++;
                }
            }
            else if([contactRowObject checkInputValueDictionaryKeyHasValidValue]==YES)
            {
                rowModelCount++;
            }
        }
        
        //////////////////////////////////////////////////
        
        if(rowModelCount>=[[self.contactEditSectionController.dataModel class] maxNumberOfRowForPPContactMainType:contactMainType])
        {
            result = YES;
        }
    }
    
    return result;
}


//================================================================================
// MARK: 詢問欄位長度
//================================================================================
- (NSUInteger)requestContactEditTableViewCellTextMaxLengthWithContactMainType:(PPContactMainType)contactMainType
                                                               contactSubType:(PPContactSubType)contactSubType
                                                             contactLabelType:(PPContactLabelType)contactLabelType
{
    NSUInteger maxLength = 0;
    
    if([self.dataSource respondsToSelector:@selector(contactEditTableViewCellTextMaxLengthInWCContactEditViewController:ppContactMainType:contactSubType:contactLabelType:)]==YES)
    {
        maxLength = [self.dataSource contactEditTableViewCellTextMaxLengthInWCContactEditViewController:self
                                                                                      ppContactMainType:contactMainType
                                                                                         contactSubType:contactSubType
                                                                                       contactLabelType:contactLabelType];
    }
    
    return maxLength;
}


//================================================================================
//
//================================================================================
- (NSMutableDictionary <NSString *,ContactDataExchangeModel *> *)curTextFieldDictionary
{
    NSMutableDictionary *fieldsDictionary = [self.contactEditSectionController fieldDictionaryFromSectionModelForSearching:NO];
    
    //////////////////////////////////////////////////
    
    // Note 資訊
    if(self.contactEditSectionController.noteFieldArray!=nil)
    {
        [fieldsDictionary setObject:self.contactEditSectionController.noteFieldArray
                             forKey:@(PPContactMainType_Note)];
    }
    
    return fieldsDictionary;
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Status Bar Height Method

//================================================================================
//
//================================================================================
- (CGFloat)statusBarHeight
{
    //有時候若 present 的ViewController 隱藏工具列，在 ViewController Dissmiss 回來時，
    //因為時機點的問題，造成此 status bar hide狀態，造成取值問題
    return ([UIApplication sharedApplication].statusBarFrame.size.height>0)?[UIApplication sharedApplication].statusBarFrame.size.height:20;
}


@end

