//
//  WCContactEditViewController.h
//
//  Created by Howard.Lin on 13/9/26.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactEditView.h"

// Define
#import "WCContactEditViewController+PublicParameterDefine.h"
#import "WCContactEditViewControllerDataSource.h"
#import "WCContactEditViewControllerDelegate.h"

// Controller
#import "PPCountrySelectorViewController.h"
#import "PPGuideController.h"
#import "WCContactViewController.h"
#import "WCContactEditSectionController.h"

// View
#import "ContactEditHeaderView.h"
#import "WCContactEditDoubleSideView.h"

// Category
#import "PPSectionController+Contact.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCContactEditViewController : WCContactViewController
<
PPGuideControllerDelegate
>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)           id<WCContactEditViewControllerDataSource> dataSource;
@property (nonatomic,assign)           id<WCContactEditViewControllerDelegate>   delegate;
@property (nonatomic,assign, readonly) WCContactEditViewControllerLayout  contactEditViewControllerLayout;
@property (nonatomic,assign)           BOOL                                      enableReorderControl;
@property (nonatomic,assign)           BOOL                                      hideAddOrFlipContactCardButton; //defefault NO
@property (nonatomic,readonly)         WCContactEditSectionController            *contactEditSectionController;
@property (nonatomic,readonly)         ContactEditView                           *contactEditView;
@property (nonatomic,readonly)         ContactEditHeaderView                     *contactEditHeaderView;
@property (nonatomic,readonly)         WCContactEditDoubleSideView               *contactEditDoubleSideView;
@property (nonatomic,copy)             NSString                                  *syncAccountName; //用來判斷系統群組連絡人的帳號下類別是否能匯入。
@property (nonatomic,assign)           BOOL                               edited;

/// 結束後是否拍下一張，contactEditViewControllerLayout==WCContactEditViewControllerLayout_HelpScan才有效
@property (nonatomic,assign)           BOOL                               isHelpScanAddNext;

/// 是否顯示刪除大頭貼，default YES, 目前office 365的介面不用顯示
@property (nonatomic,assign)           BOOL                               showDeleteHeadImageItem;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 * To return totalCount of data for ppContactMainType
 * @param ppContactMainType PPContactMainType
 * @return : The totalCount of data for ppContactMainType
 */
- (NSUInteger)totalCountDataForPPContactMainType:(PPContactMainType)ppContactMainType;


/**
 * To add data from fieldDictionary
 * @param fieldDictionary The fieldDictionary is to update
 */
- (void)addDataFromFieldDictionary:(NSDictionary *)fieldDictionary;


/**
 * To clear exist data and fetch new data from contactDataExchangeProtocol
 */
- (void)clearAndFetchData;


/**
 * To clear exist data and fetch default data
 */
- (void)clearAndFetchDefaultData;


/**
 * To clear exist data and use fieldDictionary as a default data
 * @param fieldDictionary The initial data
 */
- (void)clearAndFetchDefaultDataFromFieldDictionary:(NSDictionary *)fieldDictionary;


/**
 * To clear exist ImageRect data for ppContactFieldSource
 * @param ppContactFieldSource The source of data.
 */
- (void)clearCardImageRectForPPContactFieldSource:(PPContactFieldSource)ppContactFieldSource;


/**
 * To update data from fieldDictionary
 * @param fieldDictionary The fieldDictionary is to update
 * @param ppContactFieldSource The source of data.
 */
- (void)updateDataFromFieldDictionary:(NSDictionary *)fieldDictionary
                 ppContactFieldSource:(PPContactFieldSource)ppContactFieldSource;


/**
 * clear and update group data from fieldDictioary
 * @param fieldDictionary The fieldDictionary is to update
 */
- (void)clearAndUpdateGroupDataFromFieldDictioanry:(NSDictionary *)fieldDictionary;


/**
 * To update group data from fieldDictioary
 * @param fieldDictionary The fieldDictionary is to update
 */
- (void)updateGroupDataFromFieldDictioanry:(NSDictionary *)fieldDictionary;


/**
 *  移除相對應的群組資料
 *
 *  @param contactLabelType 群組LabelType
 */
- (void)removeGroupDataWithPPContactLabelType:(PPContactLabelType)contactLabelType;


/**
 *  移除對應的 Contact MainType 資料，然後在更新
 *
 *  @param fieldDictionary 來源資料
 */
- (void)clearAndUpdateContactMainTypeDataFromFieldDictioanry:(NSDictionary *)fieldDictionary;


/**
 * To set layout of CotactEditViewController
 * @param layout to see WCContactEditViewControllerLayout defines
 */
- (void)setWCContactEditViewControllerLayout:(WCContactEditViewControllerLayout)layout;


/**
 * To send edit done action
 */
- (void)againSendEditDoneAction;

- (void)reloadData;

- (BOOL)emptyTextData;


/**
 *  是否達到欄位上限
 *
 *  @param contactMainType 欄位類型
 *
 *  @return YES 達到
 */
- (BOOL)arriveMaximumCoutForContactMainType:(PPContactMainType)contactMainType contactSubType:(PPContactSubType)contactSubType;



/**
 詢問欄位長度

 @param contactMainType contactMainType 欄位類型
 @param contactSubType contactSubType 欄位子類型
 @param contactLabelType contactLabelType 欄位子類型
 @return 長度
 */
- (NSUInteger)requestContactEditTableViewCellTextMaxLengthWithContactMainType:(PPContactMainType)contactMainType
                                                               contactSubType:(PPContactSubType)contactSubType
                                                             contactLabelType:(PPContactLabelType)contactLabelType;



/**
 取得目前文字資料

 @return 目前文字資料
 */
- (NSMutableDictionary <NSString *,ContactDataExchangeModel *> *)curTextFieldDictionary;





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - image check for overriding
- (BOOL)existFrontCardImage;
- (BOOL)existRearCardImage;





////////////////////////////////////////////////////////////////////////////////////////////////*////

#pragma mark - Instance Status Bar Height Method

- (CGFloat)statusBarHeight;

@end
