//
//  WCContactEditDoubleSideView.m
//  
//
//  Created by Howard on 2015/12/3.
//
//

#import "WCContactEditDoubleSideView.h"

// Define
#import "WCAppearanceDefine.h"
#import "WCContactViewController+ResourceDefine.h"

// View
#import "PPImageScrollView.h"
@interface WCContactEditDoubleSideView()

@property (nonatomic,retain) PPImageScrollView *frontImageScrollView;
@property (nonatomic,retain) PPImageScrollView *rearImageScrollView;
@property (nonatomic,retain) NSMutableArray *layoutConstraints;
@property (nonatomic,retain) UIImage *tempFrontCardImage; // 有可能在指定圖片時， scrollView frame 錯誤，此時要重新指定圖片
@property (nonatomic,retain) UIImage *tempRearCardImage; // 有可能在指定圖片時， scrollView frame 錯誤，此時要重新指定圖片
@end


@implementation WCContactEditDoubleSideView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Cretaing, Copying, and Dellocation object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        self.backgroundColor = WCAppearanceDefine_SectionHeaderBGColor;
        
        //////////////////////////////////////////////////

        if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
        {
           _imageScrollViewEdgeInsets = WCCEV_PartialImageScrollViewEdgeInsets;
        }
        
        //////////////////////////////////////////////////
        
        _frontImageScrollView = [[PPImageScrollView alloc] init];
        
        if(_frontImageScrollView!=nil)
        {
            [_frontImageScrollView setBackgroundColor:[UIColor clearColor]];
            
            [self addSubview:_frontImageScrollView];
        }
        
        //////////////////////////////////////////////////
        
        _rearImageScrollView = [[PPImageScrollView alloc] init];
        
        if(_rearImageScrollView!=nil)
        {
            [_rearImageScrollView setBackgroundColor:[UIColor clearColor]];

            _rearImageScrollView.hidden = YES;
            
            [self addSubview:_rearImageScrollView];
        }
    }
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_frontImageScrollView release];
    _frontImageScrollView = nil;
    
    [_rearImageScrollView release];
    _rearImageScrollView = nil;
    
    [_tempFrontCardImage release];
    _tempFrontCardImage = nil;
    
    [_tempRearCardImage release];
    _tempRearCardImage = nil;
    
    [_layoutConstraints release];
    _layoutConstraints = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout of subview

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];

    //////////////////////////////////////////////////

    CGFloat height = 0;
    
    if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
    {
        height = self.bounds.size.height-self.keyboardHeight;
    }
    else
    {
        height = self.bounds.size.height-self.imageScrollViewEdgeInsets.bottom-self.imageScrollViewEdgeInsets.top;
    }
    
    //////////////////////////////////////////////////

    if(self.showRearCardSide==YES)
    {
        self.frontImageScrollView.frame = CGRectMake(self.imageScrollViewEdgeInsets.left,
                                                     self.imageScrollViewEdgeInsets.top,
                                                     self.bounds.size.width-self.imageScrollViewEdgeInsets.left-self.imageScrollViewEdgeInsets.right,
                                                     height);
        
        self.rearImageScrollView.frame = CGRectMake(self.imageScrollViewEdgeInsets.left,
                                                    self.frontImageScrollView.frame.origin.y+self.frontImageScrollView.frame.size.height+self.imageScrollViewEdgeInsets.bottom,
                                                    self.bounds.size.width-self.imageScrollViewEdgeInsets.left-self.imageScrollViewEdgeInsets.right,
                                                    height);
    }
    else
    {
        if(self.focusMode==YES)
        {
            self.frontImageScrollView.frame = CGRectMake(0,
                                                         0,
                                                         self.bounds.size.width-self.imageScrollViewEdgeInsets.left-self.imageScrollViewEdgeInsets.right,
                                                         height);
            
            //////////////////////////////////////////////////

            self.frontImageScrollView.center = CGPointMake(self.bounds.size.width/2, self.frontImageScrollView.frame.size.height/2);
        }
        else
        {
            self.frontImageScrollView.frame = CGRectMake(0,
                                                         0,
                                                         self.bounds.size.width-self.imageScrollViewEdgeInsets.left-self.imageScrollViewEdgeInsets.right,
                                                         height);
            
            
            //////////////////////////////////////////////////
            
            self.frontImageScrollView.center = CGPointMake(self.bounds.size.width/2, self.bounds.size.height/2);
        }
    }
    
    //////////////////////////////////////////////////

    if(self.tempFrontCardImage!=nil)
    {
        [self setContactFrontCardImage:self.tempFrontCardImage];
        
        self.tempFrontCardImage = nil;
    }
    
    if(self.tempRearCardImage!=nil)
    {
        [self setContactRearCardImage:self.tempRearCardImage];
        
        self.tempRearCardImage = nil;
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Method

//================================================================================
//
//================================================================================
- (void)setShowRearCardSide:(BOOL)showRearCardSide
{
    self.rearImageScrollView.hidden = !showRearCardSide;
    
    //////////////////////////////////////////////////

    _showRearCardSide = showRearCardSide;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactImage Protocol Method

//================================================================================
//
//================================================================================
- (void)setContactFrontCardImage:(UIImage *)contactFrontCardImage
{
    if(self.frontImageScrollView.bounds.size.width==0 ||
       self.frontImageScrollView.bounds.size.height==0)
    {
        self.tempFrontCardImage = contactFrontCardImage;
    }
    else
    {
        self.frontImageScrollView.image = contactFrontCardImage;
    }
}


//================================================================================
//
//================================================================================
- (void)setContactRearCardImage:(UIImage *)contactRearCardImage
{
    if(self.showRearCardSide==YES)
    {
        if(self.rearImageScrollView.bounds.size.width==0 ||
           self.rearImageScrollView.bounds.size.height==0)
        {
            self.tempRearCardImage = contactRearCardImage;
        }
        else
        {
            self.rearImageScrollView.image = contactRearCardImage;
        }
        
    }
    else
    {
        [self setContactFrontCardImage:contactRearCardImage];
    }
}


//================================================================================
//
//================================================================================
- (void)setContactHeadImage:(UIImage *)contactHeadImage
{
    // do nothing
}


//================================================================================
//
//================================================================================
- (void)setPPImageScrollViewImageMode:(PPImageScrollViewImageMode)imageScrollViewImageMode
{
    self.frontImageScrollView.imageMode = imageScrollViewImageMode;
}
@end
