//
//  PPHeadImageNameTabelViewCell.m
//  Pods
//
//  Created by Howard on 2015/6/30.
//
//

#import "PPHeadImageNameTabelViewCell.h"

// Define
#import "WCContactEditViewController+ResouceDefine.h"

// View
#import "PPTextFieldButtonView.h"
#import "PPTableViewCellLineView.h"

// Category
#import "UIView+PPGuideController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPHeadImageNameTabelViewCell() <PPButtonDelegate,PPTextFieldButtonViewDelegate>

@property (nonatomic,retain) PPButton                *headImageButton;
@property (nonatomic,retain,readwrite) PPButton      *addOrFlipContactCardButton;
@property (nonatomic,retain) UIActivityIndicatorView *headImageBusyView;
@property (nonatomic,retain) NSMutableArray          *reuseableTextfieldButtons;
@property (nonatomic,retain) NSMutableDictionary     *textFieldButtonDictionary;
@property (nonatomic,retain) NSMutableArray          *layoutConstraints;
@property (nonatomic,retain) NSOperationQueue        *fetchImageOperationQueue;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPHeadImageNameTabelViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if(self=[super initWithStyle:style reuseIdentifier:reuseIdentifier])
    {
        _headImageButton = [[PPButton alloc] init];
        
        if(_headImageButton!=nil)
        {
            [_headImageButton setTag:PPHeadImageNameTabelViewCellButtonTag_ClickHeadImage];
            [_headImageButton addControlEvents:UIControlEventTouchUpInside];
            [_headImageButton setDelegate:self];
            _headImageButton.imageView.contentMode = UIViewContentModeScaleAspectFit;
            
            //////////////////////////////////////////////////

            [self addSubview:_headImageButton];
            
            //////////////////////////////////////////////////
            
            _headImageBusyView = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleGray];
            
            if(_headImageBusyView!=nil)
            {
                [_headImageBusyView setUserInteractionEnabled:NO];
                [_headImageBusyView setHidden:YES];
                [_headImageButton addSubview:_headImageBusyView];
            }
        }
 
        //////////////////////////////////////////////////

        _addOrFlipContactCardButton = [[PPButton alloc] init];
        
        if(_addOrFlipContactCardButton!=nil)
        {
            [_addOrFlipContactCardButton addControlEvents:UIControlEventTouchUpInside];
            [_addOrFlipContactCardButton setDelegate:self];

            //////////////////////////////////////////////////
            
            [self addSubview:_addOrFlipContactCardButton];
        }
        
        //////////////////////////////////////////////////

        _reuseableTextfieldButtons = [[NSMutableArray alloc] init];
        
        //////////////////////////////////////////////////

        _textFieldButtonDictionary = [[NSMutableDictionary alloc] init];
        
        //////////////////////////////////////////////////

        _headImageButtonEdgeInsets = UIEdgeInsetsZero;
        
        //////////////////////////////////////////////////

        _addOrFlipCardButtonEdgeInsets = UIEdgeInsetsZero;
        
        //////////////////////////////////////////////////

        _fetchImageOperationQueue = [[NSOperationQueue alloc] init];
        
        if(_fetchImageOperationQueue!=nil)
        {
            [_fetchImageOperationQueue setMaxConcurrentOperationCount:1];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_defaulHeadImage release];
    _defaulHeadImage = nil;
    
    //////////////////////////////////////////////////

    [_headImageButton setDelegate:nil];
    [_headImageButton removeFromSuperview];
    [_headImageButton release];
    _headImageButton = nil;
    
    //////////////////////////////////////////////////

    [_headImageBusyView removeFromSuperview];
    [_headImageBusyView release];
    _headImageBusyView = nil;
    
    //////////////////////////////////////////////////

    [_reuseableTextfieldButtons removeAllObjects];
    [_reuseableTextfieldButtons release];
    _reuseableTextfieldButtons = nil;
    
    //////////////////////////////////////////////////
    
    for(id key in _textFieldButtonDictionary)
    {
        id object = [_textFieldButtonDictionary objectForKey:key];
        
        if([object respondsToSelector:@selector(removeFromSuperview)]==YES)
        {
            [object removeFromSuperview];
        }
    }
    
    //////////////////////////////////////////////////

    [_textFieldButtonDictionary removeAllObjects];
    [_textFieldButtonDictionary release];
    _textFieldButtonDictionary = nil;
    
    //////////////////////////////////////////////////

    [_layoutConstraints removeAllObjects];
    [_layoutConstraints release];
    _layoutConstraints = nil;
    
    //////////////////////////////////////////////////

    [_fetchImageOperationQueue cancelAllOperations];
    [_fetchImageOperationQueue release];
    _fetchImageOperationQueue = nil;
    
    //////////////////////////////////////////////////

    [_addOrFlipContactCardButton removeFromSuperview];
    [_addOrFlipContactCardButton release];
    _addOrFlipContactCardButton = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (NSMutableDictionary *)viewDictionary
{
    NSMutableDictionary *viewDictionary = nil;

    do
    {
        viewDictionary = [NSMutableDictionary dictionary];
        
        if(viewDictionary==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        [viewDictionary setObject:self.headImageButton forKey:@"HeadImageButton"];
        
        //////////////////////////////////////////////////

        for(id key in self.textFieldButtonDictionary)
        {
            [viewDictionary setObject:[self.textFieldButtonDictionary objectForKey:key] forKey:key];
        }
        
    }
    while (0);
    
    return viewDictionary;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - layout of subview

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    [self sendSubviewToBack:self.contentView];
    //////////////////////////////////////////////////

    self.headImageButton.frame = CGRectMake(self.headImageButtonEdgeInsets.left,
                                            self.headImageButtonEdgeInsets.top,
                                            MIN(self.bounds.size.width, self.bounds.size.height)-self.headImageButtonEdgeInsets.left-self.headImageButtonEdgeInsets.right,
                                            MIN(self.bounds.size.width, self.bounds.size.height)-self.headImageButtonEdgeInsets.top-self.headImageButtonEdgeInsets.bottom);
    
    //////////////////////////////////////////////////
    
    self.addOrFlipContactCardButton.frame = CGRectMake(0,
                                                       0,
                                                       44,
                                                       44);
    
    self.addOrFlipContactCardButton.center = CGPointMake(self.bounds.size.width-self.addOrFlipContactCardButton.frame.size.width/2-self.addOrFlipCardButtonEdgeInsets.right, self.headImageButton.center.y);

    //////////////////////////////////////////////////
    
    self.headImageBusyView.frame = self.headImageButton.bounds;
    
    //////////////////////////////////////////////////
    // !! 如果沒有mask或mask與目前button的大小不同，要重新產生
    if(self.headImageButton.bounds.size.width>0 &&
       self.headImageButton.bounds.size.height>0)
    {
        if (self.headImageButton.layer.mask!=nil &&
            CGRectEqualToRect(self.headImageButton.bounds, self.headImageButton.layer.mask.bounds)==YES)
        {
            return;
        }
        UIBezierPath *bezierPath = [UIBezierPath bezierPath];
        
        if(bezierPath!=nil)
        {
            [bezierPath addArcWithCenter:CGPointMake(self.headImageButton.bounds.size.width/2, self.headImageButton.bounds.size.height/2)
                                  radius:MIN(self.headImageButton.bounds.size.width/2,self.headImageButton.bounds.size.height/2)
                              startAngle:0
                                endAngle:2*M_PI
                               clockwise:YES];
            
            //////////////////////////////////////////////////
            
            CAShapeLayer *shapeLayer = [CAShapeLayer layer];
            
            if(shapeLayer!=nil)
            {
                [shapeLayer setFrame:self.headImageButton.bounds];
                [shapeLayer setPath:bezierPath.CGPath];
                
                self.headImageButton.layer.mask = shapeLayer;
            }
        }
    }
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Method

//================================================================================
//
//================================================================================
- (void)setDefaulHeadImage:(UIImage *)defaulHeadImage
{
    if(_defaulHeadImage!=defaulHeadImage)
    {
        [defaulHeadImage retain];
        
        [_defaulHeadImage release];
        
        _defaulHeadImage = defaulHeadImage;
        
        //////////////////////////////////////////////////

        [self showDefaultHeadImage];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    do
    {
        if([self.delegate respondsToSelector:@selector(ppHeadImageNameTableViewCell:ppButton:controlEvent:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        [self.delegate ppHeadImageNameTableViewCell:self
                                           ppButton:ppButton
                                       controlEvent:controlEvent];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)startBusyView
{
    if([self.headImageBusyView isAnimating]==NO)
    {
        self.headImageBusyView.hidden = NO;
        
        [self.headImageBusyView startAnimating];
    }
}


//================================================================================
//
//================================================================================
- (void)endBusyView
{
    self.headImageBusyView.hidden = YES;
    
    [self.headImageBusyView stopAnimating];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)fetchImageWithObject:(id<PPImageTabelViewCellImageSource>)object
{
    do
    {
        if(object==nil ||
           [object respondsToSelector:@selector(headImage)]==NO ||
           [object respondsToSelector:@selector(existFrontCardImage)]==NO ||
           [object respondsToSelector:@selector(existRearCardImage)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSBlockOperation *blockOperation = [[NSBlockOperation alloc] init];
        
        if(blockOperation==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        [self startBusyView];
        
        //////////////////////////////////////////////////

        __block typeof(self) blockSelf = self;
        
        [blockOperation addExecutionBlock:^{
            
            __block UIImage *headImage = [[object headImage] retain];
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                if(headImage!=nil)
                {
                    CGFloat scale = 0.0;
                    UIImage *temp = nil;
                    if (headImage.size.width>=headImage.size.height)
                    {
                        scale = blockSelf.headImageButton.bounds.size.height/headImage.size.height;
                        temp = [headImage imageScalingMaxLength:headImage.size.width*scale];
                    }
                    else
                    {
                        scale = blockSelf.headImageButton.bounds.size.width/headImage.size.width;
                        temp = [headImage imageScalingMaxLength:headImage.size.height*scale];
                    }
                    
                    [blockSelf.headImageButton setImage:temp];
                    
                    [headImage release];
                    
                    //////////////////////////////////////////////////
                }
                [blockSelf endBusyView];
                
                //////////////////////////////////////////////////
                
                BOOL existFrontCard = [object existFrontCardImage];
                
                BOOL existRearCard = [object existRearCardImage];
                
                if(existRearCard==YES)
                {
                    [blockSelf.addOrFlipContactCardButton setImageWithName:ImageNameContactEditViewControllerButtonFlip];
                    blockSelf.addOrFlipContactCardButton.tag = PPHeadImageNameTabelViewCellButtonTag_Flip;
                    blockSelf.addOrFlipContactCardButton.ppGuideIndex = PPHeadImageNameTabelViewCellGuideIndex_Flip;
                    
                }
                else if(existFrontCard==YES)
                {
                    [blockSelf.addOrFlipContactCardButton setImageWithName:ImageNameContactEditViewControllerButtonAddRearCard];
                    blockSelf.addOrFlipContactCardButton.tag = PPHeadImageNameTabelViewCellButtonTag_AddBackCard;
                    blockSelf.addOrFlipContactCardButton.ppGuideIndex = PPHeadImageNameTabelViewCellGuideIndex_AddBackCard;
                }
                else
                {
                    [blockSelf.addOrFlipContactCardButton setImageWithName:ImageNameContactEditViewControllerButtonAddFrontCard];
                    blockSelf.addOrFlipContactCardButton.tag = PPHeadImageNameTabelViewCellButtonTag_AddFrontCard;
                    blockSelf.addOrFlipContactCardButton.ppGuideIndex = PPHeadImageNameTabelViewCellGuideIndex_AddFrontCard;
                }
            });
        }];
        
        //////////////////////////////////////////////////
        
        if(blockOperation!=nil)
        {
            @synchronized(self.fetchImageOperationQueue)
            {
                [self.fetchImageOperationQueue cancelAllOperations];
                [self.fetchImageOperationQueue addOperation:blockOperation];
                [blockOperation release];
            }
        }
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)reuse
{
    //輸入區
    for(id key in self.textFieldButtonDictionary)
    {
        id object = [self.textFieldButtonDictionary objectForKey:key];
        
        if([object respondsToSelector:@selector(removeFromSuperview)]==YES)
        {
            [object removeFromSuperview];
        }
        
        //////////////////////////////////////////////////
        
        //放到回收容器
        [self.reuseableTextfieldButtons addObject:object];
    }
    
    [self.reuseableTextfieldButtons removeAllObjects];
}


//================================================================================
//
//================================================================================
- (UITextField *)textFieldForTag:(NSUInteger)tag
{
    UITextField *textField = nil;
    
    //////////////////////////////////////////////////

    for(id key in self.textFieldButtonDictionary)
    {
        PPTextFieldButtonView *textFieldButtonView = [self.textFieldButtonDictionary objectForKey:key];
        
        if(textFieldButtonView.textField.tag==tag)
        {
            textField = textFieldButtonView.textField;
            break;
        }
    }

    return textField;
}


//================================================================================
//
//================================================================================
- (void)showDefaultHeadImage
{
    [self.headImageButton setImage:self.defaulHeadImage];
}

@end
