//
//  ContactEditNavigationBarView.m
//
//  Created by Howard.Lin on 13/12/24.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactEditNavigationBarView.h"

// Define
#import "WCAppearanceDefine.h"
#import "WCContactViewController+ResourceDefine.h"


// Category
#import "NSString+Additions.h"
#import "PPButton+Factory.h"
#import "UIView+PPGuideController.h"

@implementation ContactEditNavigationBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (instancetype)initWithFrame:(CGRect)frame layout:(WCContactEditViewControllerLayout)layout
{
    self = [super initWithFrame:frame];

    self.style = PPBarViewStyle_CenteredAbsolute;
    
    _layoutMode = layout;
    //////////////////////////////////////////////////
    
    self.backgroundColor = [UIColor clearColor];
    
    //////////////////////////////////////////////////

    self.backgroundImageView.image = nil;
    self.titleLabel.hidden         = YES;
    
    //////////////////////////////////////////////////
    
    _cancelButton = [[PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                     tag:ContactEditNavigationBarViewButtonTag_Cancel
                                                delegate:self
                                   normalBackgroundColor:nil
                              highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                         imageEdgeInsets:WCContactViewControllerNavigationBarButtonImageEdgeInsets] retain];
    
    if(_cancelButton!=nil)
    {
        [_cancelButton addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////
        
        PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_cancelButton];
        
        if(itemModel!=nil)
        {
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
        }
    }
    
    if(self.layoutMode==WCContactEditViewControllerLayout_MyCard)
    {
        // !!my card 只要save，more
 
        //////////////////////////////////////////////////
        
        _doneButton = [[PPButton ppButtonWithIconImageName:ImageNameWCContactViewControllerNavigationBarButtonSave
                                                       tag:ContactEditNavigationBarViewButtonTag_Done
                                                  delegate:self
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                           imageEdgeInsets:WCContactViewControllerNavigationBarButtonImageEdgeInsets] retain];
        
        if(_doneButton!=nil)
        {
            _doneButton.ppGuideIndex = ContactEditNavigationBarViewButtonGuideIndex_Done;
            [_doneButton addControlEvents:UIControlEventTouchUpInside];
        }
        
        //////////////////////////////////////////////////
        
        _moreButton = [[PPButton ppButtonWithIconImageName:ImageNameWCContactViewControllerNavigationBarButtonMore
                                                       tag:ContactEditNavigationBarViewButtonTag_More
                                                  delegate:self
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                           imageEdgeInsets:WCContactViewControllerNavigationBarButtonImageEdgeInsets] retain];
        
        if(_moreButton!=nil)
        {
            _moreButton.ppGuideIndex = ContactEditNavigationBarViewButtonGuideIndex_More;
            [_moreButton addControlEvents:UIControlEventTouchUpInside];
        }
        
        //////////////////////////////////////////////////
        
        if(_doneButton!=nil &&
           _moreButton!=nil)
        {
            PPBarViewItemModel *favoriteButtonItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_favoriteButton];
            
            if(favoriteButtonItemModel!=nil)
            {
                favoriteButtonItemModel.edgeInsetsForMiniBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *doneButtonItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_doneButton];
            
            if(doneButtonItemModel!=nil)
            {
                doneButtonItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *moreButtonItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_moreButton];
            
            if(moreButtonItemModel!=nil)
            {
                moreButtonItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////
            
            if(doneButtonItemModel!=nil &&
               moreButtonItemModel!=nil)
            {
                [self setItemModels:@[doneButtonItemModel,moreButtonItemModel] forBlockType:PPBarViewBlockType_Right];
            }
        }
    }
    else if(self.layoutMode==WCContactEditViewControllerLayout_HelpScan)
    {
        //////////////////////////////////////////////////
        
        _nextButton = [[PPButton ppButtonWithIconImageName:ImageNameWCContactViewControllerNavigationBarButtonNext
                                                       tag:ContactEditNavigationBarViewButtonTag_Next
                                                  delegate:self
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                           imageEdgeInsets:WCContactViewControllerNavigationBarButtonImageEdgeInsets] retain];
        
        if(_nextButton!=nil)
        {
            _nextButton.ppGuideIndex = ContactEditNavigationBarViewButtonGuideIndex_Next;
            [_nextButton addControlEvents:UIControlEventTouchUpInside];
        }
        //////////////////////////////////////////////////
        
        _noteButton = [[PPButton ppButtonWithIconImageName:ImageNameWCContactViewControllerNavigationBarButtonNote
                                                       tag:ContactEditNavigationBarViewButtonTag_Note
                                                  delegate:self
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                           imageEdgeInsets:WCContactViewControllerNavigationBarButtonImageEdgeInsets] retain];
        
        if(_noteButton!=nil)
        {
            [_noteButton addControlEvents:UIControlEventTouchUpInside];
        }
        //////////////////////////////////////////////////
        
        _doneButton = [[PPButton ppButtonWithIconImageName:ImageNameWCContactViewControllerNavigationBarButtonSave
                                                       tag:ContactEditNavigationBarViewButtonTag_Done
                                                  delegate:self
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                           imageEdgeInsets:WCContactViewControllerNavigationBarButtonImageEdgeInsets] retain];
        
        if(_doneButton!=nil)
        {
            _doneButton.ppGuideIndex = ContactEditNavigationBarViewButtonGuideIndex_Done;
            [_doneButton addControlEvents:UIControlEventTouchUpInside];
        }
        
        //////////////////////////////////////////////////
        
        if(_nextButton!=nil &&
           _noteButton!=nil &&
           _doneButton!=nil)
        {
            PPBarViewItemModel *nextButtonItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_nextButton];
            
            if(nextButtonItemModel!=nil)
            {
                nextButtonItemModel.edgeInsetsForMiniBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////

            PPBarViewItemModel *noteButtonItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_noteButton];
            
            if(noteButtonItemModel!=nil)
            {
                noteButtonItemModel.edgeInsetsForMiniBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////

            PPBarViewItemModel *doneButtonItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_doneButton];
            
            if(doneButtonItemModel!=nil)
            {
                doneButtonItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////
            
            if(nextButtonItemModel!=nil &&
               doneButtonItemModel!=nil &&
               noteButtonItemModel!=nil)
            {
                [self setItemModels:@[nextButtonItemModel,noteButtonItemModel,doneButtonItemModel] forBlockType:PPBarViewBlockType_Right];
            }
        }
    }
    else
    {
        //////////////////////////////////////////////////
        
        _favoriteButton = [[PPButton ppButtonWithIconImageName:ImageNameWCContactViewControllerNavigationBarButtonFavorite
                                                           tag:ContactEditNavigationBarViewButtonTag_Favorite
                                                      delegate:self
                                         normalBackgroundColor:nil
                                    highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                               imageEdgeInsets:WCContactViewControllerNavigationBarButtonImageEdgeInsets] retain];
        
        if(_favoriteButton!=nil)
        {
            [_favoriteButton addControlEvents:UIControlEventTouchUpInside];
        }
        
        
#if defined (PRODUCTLINE_WCSF) || defined (PRODUCTLINE_WCO365)
        _favoriteButton.hidden = YES;
#endif
        
        //////////////////////////////////////////////////
        
        _doneButton = [[PPButton ppButtonWithIconImageName:ImageNameWCContactViewControllerNavigationBarButtonSave
                                                       tag:ContactEditNavigationBarViewButtonTag_Done
                                                  delegate:self
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                           imageEdgeInsets:WCContactViewControllerNavigationBarButtonImageEdgeInsets] retain];
        
        if(_doneButton!=nil)
        {
            _doneButton.ppGuideIndex = ContactEditNavigationBarViewButtonGuideIndex_Done;
            [_doneButton addControlEvents:UIControlEventTouchUpInside];
        }
        
        //////////////////////////////////////////////////
        
        _moreButton = [[PPButton ppButtonWithIconImageName:ImageNameWCContactViewControllerNavigationBarButtonMore
                                                       tag:ContactEditNavigationBarViewButtonTag_More
                                                  delegate:self
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                           imageEdgeInsets:WCContactViewControllerNavigationBarButtonImageEdgeInsets] retain];
        
        if(_moreButton!=nil)
        {
            _moreButton.ppGuideIndex = ContactEditNavigationBarViewButtonGuideIndex_More;
            [_moreButton addControlEvents:UIControlEventTouchUpInside];
        }
        
        //////////////////////////////////////////////////
        
        if(_favoriteButton!=nil &&
           _doneButton!=nil &&
           _moreButton!=nil)
        {
            PPBarViewItemModel *favoriteButtonItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_favoriteButton];
            
            if(favoriteButtonItemModel!=nil)
            {
                favoriteButtonItemModel.edgeInsetsForMiniBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *doneButtonItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_doneButton];
            
            if(doneButtonItemModel!=nil)
            {
                doneButtonItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *moreButtonItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_moreButton];
            
            if(moreButtonItemModel!=nil)
            {
                moreButtonItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////
            
            if(favoriteButtonItemModel!=nil &&
               doneButtonItemModel!=nil &&
               moreButtonItemModel!=nil)
            {
                [self setItemModels:@[favoriteButtonItemModel,doneButtonItemModel,moreButtonItemModel] forBlockType:PPBarViewBlockType_Right];
            }
        }
    }
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_favoriteButton removeFromSuperview];
    [_favoriteButton release];
    _favoriteButton = nil;
    
    [_cancelButton removeFromSuperview];
    [_cancelButton release];
    _cancelButton = nil;
    
    [_doneButton removeFromSuperview];
    [_doneButton release];
    _doneButton = nil;
    
    [_moreButton removeFromSuperview];
    [_moreButton release];
    _moreButton = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if([self.delegate respondsToSelector:@selector(contactEditNavigationBarView:ppButton:withControlEvent:)]==YES)
    {
        [self.delegate contactEditNavigationBarView:self ppButton:ppButton withControlEvent:controlEvent];
    }
}

@end
