//
//  ContactEditHeaderView.m
//
//
//  Created by Howard on 2015/6/29.
//
//

#import "ContactEditHeaderView.h"

// Define
#import "WCContactViewController+ResourceDefine.h"
#import "WCContactEditViewController+ResouceDefine.h"
#import "ContactApperanceDefine.h"

// View
#import "PPTableView.h"

// Controller
#import "PPLogController.h"
#import "PPMakeVirtualCardController.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

#define ContactEditHeaderView_SwitchButtonRect   CGRectMake(0,0,30,30)
#define ContactEditHeaderView_SwitchButtonMargin UIEdgeInsetsMake(0, 0, 10, 10)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditHeaderView Extension

@interface ContactEditHeaderView ()

@property (nonatomic,assign) BOOL                    canUpdateConstraint;
@property (nonatomic,retain) UIActivityIndicatorView *cardImageIndicatorView;
@property (nonatomic,retain) UIActivityIndicatorView *headImageIndicatorView;
@property (nonatomic,retain) UITapGestureRecognizer  *singleTapGestureRecognier;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactEditHeaderView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame])
    {
        self.backgroundColor     = WCContactEditHeaderViewBackgroundColor;
        self.canUpdateConstraint = NO;
        
        //////////////////////////////////////////////////
        
        _contactCardMaskView = [[UIView alloc] initWithFrame:CGRectZero];
        if (self.contactCardMaskView!=nil)
        {
            self.contactCardMaskView.alpha                  = 0;
            self.contactCardMaskView.backgroundColor        = [UIColor lightGrayColor];
            self.contactCardMaskView.userInteractionEnabled = NO;
            [self addSubview:self.contactCardMaskView];
        }
        
        //////////////////////////////////////////////////
        
        _contactCardScrollView = [[PPImageScrollView alloc] initWithFrame:CGRectZero];
        
        if (self.contactCardScrollView!=nil)
        {
            self.contactCardScrollView.backgroundColor = [UIColor clearColor];
            
            //雙指單擊放大
            self.contactCardScrollView.doubleTapGestureRecognizer.numberOfTouchesRequired = 2;
            self.contactCardScrollView.doubleTapGestureRecognizer.numberOfTapsRequired = 1;

            //////////////////////////////////////////////////

            [self addSubview:self.contactCardScrollView];
        }
        
        //////////////////////////////////////////////////

        _singleTapGestureRecognier = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(singleTapNotifyWithGesture:)];
        
        if(self.singleTapGestureRecognier!=nil)
        {
            [self.contactCardScrollView addGestureRecognizer:_singleTapGestureRecognier];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_singleTapGestureRecognier removeTarget:self action:@selector(singleTapNotifyWithGesture:)];
    [_singleTapGestureRecognier release];
    _singleTapGestureRecognier = nil;
    
    [self.contactCardScrollView removeFromSuperview];
    self.contactCardScrollView.delegate = nil;
    self.contactCardScrollView = nil;

    [self.contactCardMaskView removeFromSuperview];
    self.contactCardMaskView = nil;

    self.delegate = nil;
    
    [self.cardImageIndicatorView removeFromSuperview];
    self.cardImageIndicatorView = nil;
    
    [self.headImageIndicatorView removeFromSuperview];
    self.headImageIndicatorView = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
// 因為需進行比例的切割，需要得到界面高度
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    self.contactCardScrollView.frame = self.bounds;
    [self.contactCardScrollView layoutImageView];
    
    //////////////////////////////////////////////////

    self.contactCardMaskView.frame = self.bounds;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)cardImageIndicatorViewVisible:(BOOL)visible
{
    if (visible==YES)
    {
        if (self.cardImageIndicatorView==nil)
        {
            _cardImageIndicatorView = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(0, 0, self.contactCardScrollView.bounds.size.width, self.contactCardScrollView.bounds.size.height)];
        }
        
        if (self.cardImageIndicatorView!=nil)
        {
            self.cardImageIndicatorView.activityIndicatorViewStyle = UIActivityIndicatorViewStyleWhiteLarge;
            
            [self.cardImageIndicatorView startAnimating];
            [self.contactCardScrollView addSubview:self.cardImageIndicatorView];
        }
    }
    else
    {
        [self.cardImageIndicatorView stopAnimating];
        [self.cardImageIndicatorView removeFromSuperview];
        self.cardImageIndicatorView = nil;
    }
}


//================================================================================
//
//================================================================================
- (void)setContactFrontCardImage:(UIImage *)contactFrontCardImage
{
    if(contactFrontCardImage!=nil)
    {
        [self.contactCardScrollView setImage:contactFrontCardImage];
    }
}


//================================================================================
//
//================================================================================
- (void)setContactRearCardImage:(UIImage *)contactRearCardImage
{
    if(contactRearCardImage!=nil)
    {
        [self.contactCardScrollView setImage:contactRearCardImage];
    }
}


//================================================================================
//
//================================================================================
- (void)setContactHeadImage:(UIImage *)contactHeadImage
{
    // do nothing
}


//================================================================================
//
//================================================================================
- (void)setPPImageScrollViewImageMode:(PPImageScrollViewImageMode)imageScrollViewImageMode
{
    self.contactCardScrollView.imageMode = imageScrollViewImageMode;
}


//================================================================================
//
//================================================================================
- (void)setContactCardMaskAlpha:(CGFloat)colorAlpha
{
    self.contactCardMaskView.alpha = colorAlpha;
    
    if (colorAlpha==0)
    {
        self.contactCardScrollView.userInteractionEnabled = YES;
    }
    else
    {
        self.contactCardScrollView.userInteractionEnabled = NO;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Gesture Method

//================================================================================
//
//================================================================================
- (void)singleTapNotifyWithGesture:(id)gesture
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(contactEditHeaderView:responderView:action:)]==YES)
    {
        [self.delegate contactEditHeaderView:self responderView:self.contactCardScrollView action:ContactEditHeaderViewAction_CardImage];
    }
}

@end
