//
//  ContactDateAndTimeTextFieldTableViewCell.m
//
//  Created by Howard.Lin on 13/10/22.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactDateAndTimeTextFieldTableViewCell.h"

// Define
#import "ContactApperanceDefine.h"
#import "WCAppearanceDefine.h"
#import "WCContactViewController+ResourceDefine.h"

// Category
#import "UIColor+Contact.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactDateAndTimeTextFieldTableViewCell()

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactDateAndTimeTextFieldTableViewCell


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    
    if(self!=nil)
    {
        [self.textField setTextColor:[UIColor contactEditViewInputFieldTextColor]];
        self.textField.clearButtonMode = UITextFieldViewModeNever;
      
        //////////////////////////////////////////////////
        
        [self.textLabel setAdjustsFontSizeToFitWidth:YES];
        
        //////////////////////////////////////////////////
        
        _contactTableViewCellLineView = [[PPTableViewCellLineView alloc] init];
        
        if(_contactTableViewCellLineView!=nil)
        {
            _contactTableViewCellLineView.lineColor = WCAppearanceDefine_SeparatorColor;
            
            [self.contentView addSubview:_contactTableViewCellLineView];
            [self.contentView sendSubviewToBack:_contactTableViewCellLineView];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _contactKeyboardToolBarViewDelegate = nil;
    
    //////////////////////////////////////////////////

    [_contactTableViewCellLineView removeFromSuperview];
    [_contactTableViewCellLineView release];
    _contactTableViewCellLineView = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout Of View

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    CGRect textLabelFrame = self.textLabel.frame;
    
    textLabelFrame.size.width = ContactTableViewCellLabelWidth;
    
    self.textLabel.frame = textLabelFrame;

    //////////////////////////////////////////////////
    
    self.contactTableViewCellLineView.frame = self.contentView.bounds;
    self.contactTableViewCellLineView.leftMargin = textLabelFrame.origin.x + textLabelFrame.size.width +ContactTableViewCellContentEdgeInset.left;
    [self.contactTableViewCellLineView performSelectorOnMainThread:@selector(setNeedsDisplay) withObject:nil waitUntilDone:NO];
    
    //////////////////////////////////////////////////
    
    CGRect textFieldFrame = self.textField.frame;
    textFieldFrame.origin.x   = self.contactTableViewCellLineView.leftMargin + ContactTableViewCellContentEdgeInset.left;
    textFieldFrame.size.width = self.contentView.bounds.size.width - ContactTableViewCellContentEdgeInset.right - textFieldFrame.origin.x;
    self.textField.frame = textFieldFrame;
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Method

//================================================================================
//
//================================================================================
- (void)setContactKeyboardToolBarViewDelegate:(id<ContactKeyboardToolBarViewDelegate>)contactKeyboardToolBarViewDelegate
{
    if(_contactKeyboardToolBarViewDelegate==nil)
    {
        _contactKeyboardToolBarViewDelegate = contactKeyboardToolBarViewDelegate;
        
        //////////////////////////////////////////////////
        
        ContactKeyboardToolBarView *toolBarView = [[ContactKeyboardToolBarView alloc] init];
        
        if(toolBarView!=nil)
        {
            self.textField.inputAccessoryView = toolBarView;
            toolBarView.contactKeyboardToolBarViewDelegate = self.contactKeyboardToolBarViewDelegate;
        }
        
        [toolBarView release];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CurrentInputViewProtocol Method

//================================================================================
//
//================================================================================
- (UITextField *)currentFocusTextField
{
    return self.textField;
}


//================================================================================
//
//================================================================================
- (void)setTextFieldViewMode:(UITextFieldViewMode)textFieldViewMode
{
    self.textField.clearButtonMode = textFieldViewMode;
}

@end
