//
//  ContactDataPickerTableViewCell.m
//  
//
//  Created by Howard on 2016/8/15.
//
//

#import "ContactDataPickerTableViewCell.h"

// Define
#import "ContactApperanceDefine.h"
#import "WCAppearanceDefine.h"
#import "WCContactViewController+PublicParameterDefine.h"
#import "WCContactViewController+ResourceDefine.h"


// View
#import "PPTableViewCellLineView.h"

// Category
#import "UIColor+Contact.h"

@interface ContactDataPickerTableViewCell ()
<
CustomRectTextFieldDataSource,
UIPickerViewDataSource,
UIPickerViewDelegate
>

@property (nonatomic,retain) PPTableViewCellLineView *contactTableViewCellLineView;
@end



@implementation ContactDataPickerTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    
    if(self!=nil)
    {
        self.pickerView.dataSource = self;
        self.pickerView.delegate = self;
        
        //////////////////////////////////////////////////

        [self.textLabel setAdjustsFontSizeToFitWidth:YES];
        
        //////////////////////////////////////////////////

        [self.textField setTextColor:[UIColor contactEditViewInputFieldTextColor]];
       
        self.textField.dataSource = self;
        
        //////////////////////////////////////////////////
        
        _contactTableViewCellLineView = [[PPTableViewCellLineView alloc] init];
        
        if(_contactTableViewCellLineView!=nil)
        {
            _contactTableViewCellLineView.lineColor = WCAppearanceDefine_SeparatorColor;
            
            [self.contentView addSubview:_contactTableViewCellLineView];
            [self.contentView sendSubviewToBack:_contactTableViewCellLineView];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _contactKeyboardToolBarViewDelegate = nil;
    
    //////////////////////////////////////////////////
    
    [_contactTableViewCellLineView removeFromSuperview];
    [_contactTableViewCellLineView release];
    _contactTableViewCellLineView = nil;
    
    //////////////////////////////////////////////////
    
    [_itemsMenu release];
    _itemsMenu = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout Of View

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    CGRect textLabelFrame = self.textLabel.frame;
    
    textLabelFrame.size.width = ContactTableViewCellLabelWidth;
    
    self.textLabel.frame = textLabelFrame;
    
    //////////////////////////////////////////////////
    
    self.contactTableViewCellLineView.frame = self.contentView.bounds;
    self.contactTableViewCellLineView.leftMargin = textLabelFrame.origin.x + textLabelFrame.size.width +ContactTableViewCellContentEdgeInset.left;
    [self.contactTableViewCellLineView performSelectorOnMainThread:@selector(setNeedsDisplay) withObject:nil waitUntilDone:NO];
    
    //////////////////////////////////////////////////
    
    CGRect textFieldFrame = self.textField.frame;
    textFieldFrame.origin.x   = self.contactTableViewCellLineView.leftMargin;
    textFieldFrame.size.width = self.contentView.bounds.size.width-self.contactTableViewCellLineView.leftMargin;
    self.textField.frame = textFieldFrame;
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Method

//================================================================================
//
//================================================================================
- (void)setContactKeyboardToolBarViewDelegate:(id<ContactKeyboardToolBarViewDelegate>)contactKeyboardToolBarViewDelegate
{
    if(_contactKeyboardToolBarViewDelegate==nil)
    {
        _contactKeyboardToolBarViewDelegate = contactKeyboardToolBarViewDelegate;
        
        //////////////////////////////////////////////////
        
        ContactKeyboardToolBarView *toolBarView = [[ContactKeyboardToolBarView alloc] init];
        
        if(toolBarView!=nil)
        {
            self.textField.inputAccessoryView = toolBarView;
            toolBarView.contactKeyboardToolBarViewDelegate = self.contactKeyboardToolBarViewDelegate;
        }
        
        [toolBarView release];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Text Rect Method

//================================================================================
//
//================================================================================
- (CGRect)textRectForBounds:(CGRect)bounds
{
    CGRect textBounds = bounds;
    
    textBounds.origin.x += ContactTableViewCellContentEdgeInset.left;
    
    return textBounds;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CurrentInputViewProtocol Method

//================================================================================
//
//================================================================================
- (UITextField *)currentFocusTextField
{
    return self.textField;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CustomRectTextFieldDataSource

//================================================================================
//
//================================================================================
- (CGRect)textRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField
{
    return [self textRectForBounds:bounds];
}


//================================================================================
//
//================================================================================
- (CGRect)editingRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField
{
    return [self textRectForBounds:bounds];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIPickerViewDataSource Method

//================================================================================
//
//================================================================================
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView
{
    return 1;
}


//================================================================================
//
//================================================================================
- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component
{
    return [self.itemsMenu count];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIPickerDelegate Method

//================================================================================
//
//================================================================================
- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component
{
    NSString *itemTitle = @"";
    
    do
    {
        NSArray *itemTitles = [self itemsMenu];
        
        if([itemTitles count]<=row)
        {
            break;
        }
        
        itemTitle = [itemTitles objectAtIndex:row];
        
        //////////////////////////////////////////////////

        if([itemTitle isEqualToString:WCVC_EditViewControllerSelectEmptyValue]==YES)
        {
            itemTitle = WCCV_MLS_PleaseSelectItem;
        }
    }
    while (0);
    
    return itemTitle;
}


//================================================================================
//
//================================================================================
- (void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component
{
    if([self.itemsMenu count]>row)
    {
        NSString *text = [self.itemsMenu objectAtIndex:row];
        
        //////////////////////////////////////////////////
        
        if([text isEqualToString:WCVC_EditViewControllerSelectEmptyValue]==YES)
        {
            self.textField.text = @"";
        }
        else if([text isEqualToString:WCVC_EditViewControllerSelectDisableValue]==YES)
        {
            self.textField.text = WCCV_MLS_EditListDisable;
        }
        else
        {
            self.textField.text = text;
        }
        
        //////////////////////////////////////////////////
        
        [self textFieldDidChange];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)selectRow:(NSInteger)row animated:(BOOL)animated
{
    if(row<self.itemsMenu.count)
    {
        [self.pickerView selectRow:row inComponent:0 animated:animated];
    }
}

@end
