//
//  ContactEditFieldUserDefineDataModel.m
//
//  Created by Howard.Lin on 13/11/8.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactEditFieldUserDefineDataModel.h"
#import "ContactApperanceDefine.h"
#import "NSString+Additions.h"
#import "PPContactRowObject.h"

@implementation ContactEditFieldUserDefineDataModel

//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForPPContactMainType:(PPContactMainType)contactMainType ppContactSubType:(PPContactSubType)contactSubType
{
    PPContactSectionModel *sectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
    
    //////////////////////////////////////////////////
    
    do
    {
        if(sectionModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        @autoreleasepool
        {
            PPContactTableViewCellStyle tableViewCellStyle = PPContactTableViewCellStyle_TextField;
            
            switch (contactSubType)
            {
                case PPContactSubType_UserDefine_Integer:
                case PPContactSubType_UserDefine_Float:
                {
                    tableViewCellStyle = PPContactTableViewCellStyle_TextField;
                    break;
                }
                case PPContactSubType_UserDefine_Text:
                {
                    tableViewCellStyle = PPContactTableViewCellStyle_TextField;
                    break;
                }
                case PPContactSubType_UserDefine_URL:
                {
                    tableViewCellStyle = PPContactTableViewCellStyle_TextField;
                    break;
                }
                case PPContactSubType_UserDefine_ListValue:
                {
                    tableViewCellStyle = PPContactTableViewCellStyle_Label;
                    break;
                }
                case PPContactSubType_UserDefine_Email:
                {
                    tableViewCellStyle = PPContactTableViewCellStyle_TextField;
                    break;
                }
                case PPContactSubType_UserDefine_Date:
                {
                    tableViewCellStyle = PPContactTableViewCellStyle_DateAndTimeTextField;
                    break;
                }
                case PPContactSubType_UserDefine_DateAndTime:
                {
                    tableViewCellStyle = PPContactTableViewCellStyle_DateAndTimeTextField;
                    break;
                }
                default:
                {
                    tableViewCellStyle = PPContactTableViewCellStyle_TextField;
                    break;
                }
            }
            
            //////////////////////////////////////////////////

            
            PPContactRowObject *contactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                            ppContactLabelType:PPContactLabelType_None
                                                                                     tableViewCellEditingStyle:UITableViewCellEditingStyleNone
                                                                                   ppContactTableViewCellStyle:tableViewCellStyle
                                                    selected:NO];
            
            //////////////////////////////////////////////////
            
            [contactRowObject.inputValueDictionary setObject:@"" forKey:@(contactSubType)];
            
            //////////////////////////////////////////////////
            
            PPRowModel *rowModel = [PPRowModel rowModelWithRow:sectionModel.rowModels.count
                                                          text:nil
                                                    detailText:nil
                                                        object:contactRowObject];
            
            
            if(rowModel!=nil)
            {
                [sectionModel.rowModels addObject:rowModel];
            }
        }
        
        
    } while (0);
    
    return sectionModel;
}


@end
