//
//  ContactEditDataModel.m
//
//  Created by Howard.Lin on 13/10/3.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactEditDataModel.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactEditDataModel()


+ (PPContactSectionModel *)ppContactSectionModelForPPContactMainType:(PPContactMainType)contactMainType
                                                       itemTextArray:(NSArray *)itemTextArray
                                           tableViewCellEditingStyle:(UITableViewCellEditingStyle)editingStyle
                                                ppContactFieldSource:(PPContactFieldSource)contactFieldSource;


@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactEditDataModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
+ (NSMutableArray *)defaultPlaceholderArrayForPPContactMainType:(PPContactMainType)contactMainType
{
    NSMutableArray *workArray   = [NSMutableArray array];
    
    do
    {
        if(workArray==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        switch (contactMainType)
        {
            case PPContactMainType_Address:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Address_Street,WCCV_MLS_Address_City,WCCV_MLS_Address_State,WCCV_MLS_Address_ZIP,WCCV_MLS_Address_Country]];
                
                break;
            }
            case PPContactMainType_Company:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Company,WCCV_MLS_Company_Department,WCCV_MLS_Company_JobTitle]];
                
                break;
            }
            case PPContactMainType_BirthDay:
            case PPContactMainType_Date:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Date]];
                
                break;
            }
            case PPContactMainType_Name:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Name_First,WCCV_MLS_Name_Last]];
                
                break;
            }
            case PPContactMainType_InstantMessage:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_InstantMessage]];
                
                break;
            }
            case PPContactMainType_Email:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Mail]];
                
                break;
            }
            case PPContactMainType_Other:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Nickname,WCCV_MLS_UnifiledBusinessNo]];
                
                break;
            }
            case PPContactMainType_Note:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Note]];
                
                break;
            }
            case PPContactMainType_PublicNote:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_PublicNote]];
                
                break;
            }
            case PPContactMainType_Phone:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Phone]];
                
                break;
            }
            case PPContactMainType_URL:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_URL]];
                
                break;
            }
            case PPContactMainType_UserDefine:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_UserDefine]];
                
                break;
            }
            default:
            {
                break;
            }
        }
        
    } while (0);
    
    return workArray;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForPPContactMainType:(PPContactMainType)contactMainType
                                                       itemTextArray:(NSArray *)itemTextArray
                                           tableViewCellEditingStyle:(UITableViewCellEditingStyle)editingStyle
                                                ppContactFieldSource:(PPContactFieldSource)contactFieldSource
{
    
    PPContactSectionModel *contactSectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
    
    do
    {
        PPContactTableViewCellStyle cellKind = PPContactTableViewCellStyle_Default;
        
        @autoreleasepool
        {
            //新增欄位只要取一個就行了
            if(editingStyle==UITableViewCellEditingStyleInsert)
            {
                itemTextArray = @[[itemTextArray firstObject]];
            }
            
            //////////////////////////////////////////////////
            
            for(NSString *text in itemTextArray)
            {
                PPContactLabelType contactLabelType = [PPContactRowObject ppContactLabelTypeForPPContactMainType:contactMainType labelText:text];
                
                if(contactMainType==PPContactMainType_Other)
                {
                    cellKind = PPContactTableViewCellStyle_TextField;
                }
                else if(contactMainType==PPContactMainType_HeadImage)
                {
                    cellKind = PPContactTableViewCellStyle_HeadImageName;
                }
                
                //////////////////////////////////////////////////
                
                PPContactRowObject *contactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                                ppContactLabelType:contactLabelType
                                                                                         tableViewCellEditingStyle:editingStyle
                                                                                       ppContactTableViewCellStyle:cellKind
                                                        selected:NO];
                
                if(contactRowObject==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                contactRowObject.tableViewCellStyle = cellKind;
                
                if(contactMainType==PPContactMainType_Other)
                {
                    [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_None)];
                }
                else if(contactMainType==PPContactMainType_HeadImage)
                {
                    [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_None)];
                }
                
                //////////////////////////////////////////////////
                
                PPRowModel *rowModel = [PPRowModel rowModelWithRow:contactSectionModel.rowModels.count text:text detailText:nil object:contactRowObject];
                
                [rowModel setPPContactFieldSource:contactFieldSource];
                
                if(rowModel!=nil)
                {
                    [contactSectionModel.rowModels addObject:rowModel];
                }
            }
        }
        
    } while (0);
    
    return contactSectionModel;
}


//================================================================================
//
//================================================================================
+ (NSMutableArray *)customSectionPlaceholderArrayForPPContactMainType:(PPContactMainType)contactMainType
                                                ppContactSubTypeArray:(NSArray *)contactSubTypeArray
{
    NSMutableArray *workArray   = [NSMutableArray array];
    
    do
    {
        if(workArray==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(contactMainType!=PPContactMainType_Name && contactMainType!=PPContactMainType_Company)
        {
            workArray = [self defaultPlaceholderArrayForPPContactMainType:contactMainType];
            break;
        }
        
        //////////////////////////////////////////////////
        
        // 姓名欄位
        if(contactMainType==PPContactMainType_Name)
        {
            for (NSNumber *subType in contactSubTypeArray)
            {
                switch ([subType unsignedIntegerValue])
                {
                    case PPContactSubType_Name_FirstName:
                    {
                        [workArray addObject:WCCV_MLS_Name_First];
                        break;
                    }
                    case PPContactSubType_Name_FirstNamePhonetic:
                    {
                        [workArray addObject:WCCV_MLS_Name_FirstPhonetic];
                        break;
                    }
                    case PPContactSubType_Name_LastName:
                    {
                        [workArray addObject:WCCV_MLS_Name_Last];
                        break;
                    }
                    case PPContactSubType_Name_LastNamePhonetic:
                    {
                        [workArray addObject:WCCV_MLS_Name_LastPhonetic];
                        break;
                    }
                    case PPContactSubType_Name_Prefix:
                    {
                        [workArray addObject:WCCV_MLS_Name_Prefix];
                        break;
                    }
                    case PPContactSubType_Name_MiddleName:
                    {
                        [workArray addObject:WCCV_MLS_Name_Middle];
                        break;
                    }
                    case PPContactSubType_Name_Surffix:
                    {
                        [workArray addObject:WCCV_MLS_Name_Suffix];
                        break;
                    }
                    default:
                    {
                        break;
                    }
                }
            }
        }
        else if(contactMainType==PPContactMainType_Company)
        {
            for (NSNumber *subType in contactSubTypeArray)
            {
                switch ([subType unsignedIntegerValue])
                {
                    case PPContactSubType_Company_Name:
                    {
                        [workArray addObject:WCCV_MLS_Company];
                        break;
                    }
                    case PPContactSubType_Company_NamePhonetic:
                    {
                        [workArray addObject:WCCV_MLS_Company_Phonetic];
                        break;
                    }
                    case PPContactSubType_Company_Department:
                    {
                        [workArray addObject:WCCV_MLS_Company_Department];
                        break;
                    }
                    case PPContactSubType_Company_JobTitle:
                    {
                        [workArray addObject:WCCV_MLS_Company_JobTitle];
                        break;
                    }
                    default:
                    {
                        break;
                    }
                }
            }
        }
    } while (0);
    
    return workArray;
}


//================================================================================
//
//================================================================================
+ (NSMutableArray *)defaultTitleArrayForPPContactMainType:(PPContactMainType)contactMainType
{
    NSMutableArray *workArray = [NSMutableArray array];
    
    do
    {
        if(workArray==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        switch (contactMainType)
        {
            case PPContactMainType_AddField:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_AddField]];
                
                break;
            }
            case PPContactMainType_Address:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_AddAddress,WCCV_MLS_Address_Work]];
                
                break;
            }
            case PPContactMainType_Company:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_AddCompanyInfomation,WCCV_MLS_Company]];
                
                break;
            }
            case PPContactMainType_BirthDay:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_AddBirthday,WCCV_MLS_Date_Birthday]];
                
                break;
            }
            case PPContactMainType_Date:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_AddDate,WCCV_MLS_Date_Anniversary]];
                
                break;
            }
            case PPContactMainType_InstantMessage:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_AddInstanceMessenger,WCCV_MLS_IM_MSN]];
                
                break;
            }
            case PPContactMainType_Email:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_AddMail,WCCV_MLS_Email_Work]];
                
                break;
            }
            case PPContactMainType_Name:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_AddName,WCCV_MLS_Name]];
                
                break;
            }
            case PPContactMainType_Note:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_AddNote,WCCV_MLS_Note]];
                
                break;
            }
            case PPContactMainType_PublicNote:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_AddPublicNote,WCCV_MLS_PublicNote]];
                
                break;
            }
            case PPContactMainType_Other:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_UnifiledBusinessNo,WCCV_MLS_Nickname]];
                
                break;
            }
            case PPContactMainType_Phone:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_AddPhone,WCCV_MLS_Phone_Mobile]];
                
                break;
            }
            case PPContactMainType_URL:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_AddWebSite,WCCV_MLS_URL_HomePage]];
                
                break;
            }
            case PPContactMainType_UserDefine:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_AddUserDefine,WCCV_MLS_UserDefine]];
                
                break;
            }
            case PPContactMainType_HeadImage:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Photo]];
                break;
            }
            case PPContactMainType_SocialNetwork:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_AddSocialNetwork,WCCV_MLS_SocialNetwork]];
                break;
            }
            default:
            {
                break;
            }
        }

    } while (0);
    
    return workArray;
    
}


//================================================================================
//
//================================================================================
+ (NSArray *)addressPlaceholderArrayWithCountryCode:(NSString *)countryCode
{
    if([countryCode compare:@"TW" options:NSCaseInsensitiveSearch]==NSOrderedSame)
    {
        return @[WCCV_MLS_Address_Street,WCCV_MLS_Address_TW_City,WCCV_MLS_Address_TW_State,WCCV_MLS_Address_TW_Zip,WCCV_MLS_Address_Country];
    }
    else if([countryCode compare:@"JP" options:NSCaseInsensitiveSearch]==NSOrderedSame)
    {
        return @[WCCV_MLS_Address_Street,WCCV_MLS_Address_JP_City,WCCV_MLS_Address_JP_State,WCCV_MLS_Address_JP_Zip,WCCV_MLS_Address_Country];
    }
    else
    {
        return @[WCCV_MLS_Address_Street,WCCV_MLS_Address_City,WCCV_MLS_Address_State,WCCV_MLS_Address_ZIP,WCCV_MLS_Address_Country];
    }
}


//================================================================================
//
//================================================================================
+ (NSMutableArray *)totalTitleArrayForPPContactMainType:(PPContactMainType)contactMainType
{
    NSMutableArray *workArray = [NSMutableArray array];
    
    do
    {
        if(workArray==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(PPContactMainType_Address==contactMainType)
        {
            [workArray addObjectsFromArray:@[WCCV_MLS_Address_Work,WCCV_MLS_Address_Home,WCCV_MLS_Address_Other]];
        }
        
        else if(PPContactMainType_Email==contactMainType)
        {
            [workArray addObjectsFromArray:@[WCCV_MLS_Email_Work,WCCV_MLS_Email_Home,WCCV_MLS_Email_Other]];
        }
        
        else if(PPContactMainType_Phone==contactMainType)
        {
            [workArray addObjectsFromArray:@[WCCV_MLS_Phone_Work,WCCV_MLS_Phone_Home,WCCV_MLS_Phone_Mobile,WCCV_MLS_Phone_Main,WCCV_MLS_Phone_WorkFax,WCCV_MLS_Phone_HomeFax,WCCV_MLS_Phone_Pager,WCCV_MLS_Phone_GoogleVoice,WCCV_MLS_Phone_iPhone,WCCV_MLS_Phone_Other]];
        }
        
        else if(PPContactMainType_URL==contactMainType)
        {
            [workArray addObjectsFromArray:@[WCCV_MLS_URL_HomePage,WCCV_MLS_URL_Home,WCCV_MLS_URL_Work,WCCV_MLS_URL_Profile,WCCV_MLS_URL_Blog,WCCV_MLS_URL_Other]];
        }
        
        else if(PPContactMainType_BirthDay==contactMainType)
        {
            [workArray addObjectsFromArray:@[WCCV_MLS_Date_Birthday,WCCV_MLS_Date_Other]];
        }
        
        else if(PPContactMainType_Date==contactMainType)
        {
            [workArray addObjectsFromArray:@[WCCV_MLS_Date_Anniversary,WCCV_MLS_Date_Other]];
        }
        
        else if(PPContactMainType_InstantMessage==contactMainType)
        {
            [workArray addObjectsFromArray:@[WCCV_MLS_IM_MSN,WCCV_MLS_IM_Skype,WCCV_MLS_IM_QQ,WCCV_MLS_IM_Yahoo,WCCV_MLS_IM_ICQ,WCCV_MLS_IM_GoogleTalk,WCCV_MLS_IM_Jabber,WCCV_MLS_IM_AIM,WCCV_MLS_IM_Other,WCCV_MLS_IM_GaduGadu]];
        }
        
        else if(PPContactMainType_Other==contactMainType)
        {
            [workArray addObjectsFromArray:@[WCCV_MLS_Other]];
        }
        
        else if(PPContactMainType_Note==contactMainType)
        {
            [workArray addObjectsFromArray:@[WCCV_MLS_Note]];
        }
        
        else if(PPContactMainType_PublicNote==contactMainType)
        {
            [workArray addObjectsFromArray:@[WCCV_MLS_PublicNote]];
        }

        else if(PPContactMainType_SocialNetwork==contactMainType)
        {
            [workArray addObjectsFromArray:@[PPContactLabelText_SN_Twitter,
                                             PPContactLabelText_SN_Facebook,
                                             PPContactLabelText_SN_Flicker,
                                             PPContactLabelText_SN_LinkedIn,
                                             PPContactLabelText_SN_MySpace,
                                             PPContactLabelText_SN_SinaWebo,
                                             PPContactLabelText_SN_Other]];
                                            
        }
        
    } while (0);
    
    return workArray;
}


//================================================================================
//
//================================================================================
+ (NSUInteger)maxNumberOfRowForPPContactMainType:(PPContactMainType)contactMainType
{
    NSUInteger maxNumber = 0;
    
    do
    {
        if(contactMainType == PPContactMainType_None)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        switch (contactMainType)
        {
            case PPContactMainType_HeadImage:
            {
                maxNumber = PPContactMainTypeMaxCount_HeadImage;
                break;
            }
            case PPContactMainType_Name:
            {
                maxNumber = PPContactMainTypeMaxCount_Name;
                break;
            }
            case PPContactMainType_Other:
            {
                maxNumber = PPContactMainTypeMaxCount_Other;
                break;
            }
            case PPContactMainType_Date:
            {
                maxNumber = PPContactMainTypeMaxCount_Date;
                break;
            }
            case PPContactMainType_Address:
            {
                maxNumber = PPContactMainTypeMaxCount_Address;
                break;
            }
            case PPContactMainType_Company:
            {
                maxNumber = PPContactMainTypeMaxCount_Company;
                break;
            }
            case PPContactMainType_Email:
            {
                maxNumber = PPContactMainTypeMaxCount_Email;
                break;
            }
            case PPContactMainType_URL:
            {
                maxNumber = PPContactMainTypeMaxCount_URL;
                break;
            }
            case PPContactMainType_BirthDay:
            {
                maxNumber = PPContactMainTypeMaxCount_BirthDay;
                break;
            }
            case PPContactMainType_Phone:
            {
                maxNumber = PPContactMainTypeMaxCount_Phone;
                break;
            }
            case PPContactMainType_UserDefine:
            {
                maxNumber = PPContactMainTypeMaxCount_UserDefine - 1;
                break;
            }
            case PPContactMainType_InstantMessage:
            {
                maxNumber = PPContactMainTypeMaxCount_InstantMessage;
                break;
            }
            case PPContactMainType_Note:
            {
                maxNumber = PPContactMainTypeMaxCount_Note;
                break;
            }
            case PPContactMainType_PublicNote:
            {
                maxNumber = PPContactMainTypeMaxCount_PublicNote;
                break;
            }
            case PPContactMainType_SocialNetwork:
            {
                maxNumber = PPContactMainTypeMaxCount_SocialNetwork;
                break;
            }
            case PPContactMainType_Salutation:
            {
                maxNumber = PPContactMainTypeMaxCount_Salutation;
                break;
            }
            default:
            {
                //!!防止在加入 新增xx欄位時，數量overflow
                maxNumber = NSUIntegerMax-1;
                break;
            }
        }
        
        
    } while (0);
    
    return maxNumber;
}


//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForParsingFields:(NSArray *)fields
                                               ppContactMainType:(PPContactMainType)contactMainType
                                                    showPhonetic:(BOOL)showPhonetic
{
    PPContactSectionModel *sectionModel = nil;
    
    do
    {
        if(fields==nil || fields.count<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        sectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
    
        if(sectionModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        UITableViewCellEditingStyle style = UITableViewCellEditingStyleNone;
        PPContactTableViewCellStyle tableViewCellStyle = PPContactTableViewCellStyle_TextField;
        
        //////////////////////////////////////////////////
        
        for(ContactDataExchangeModel *contactDataExchangeModel in fields)
        {
            switch (contactMainType)
            {
                case PPContactMainType_AddField:
                case PPContactMainType_Address:
                case PPContactMainType_Company:
                case PPContactMainType_Name:
                {
                    if([contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddAddress] | [contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddCompanyInfomation] | [contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddName])
                    {
                        style = UITableViewCellEditingStyleInsert;
                        tableViewCellStyle = PPContactTableViewCellStyle_Default;
                    }
                    else
                    {
                        style = UITableViewCellEditingStyleDelete;
                        tableViewCellStyle = PPContactTableViewCellStyle_MultiTextFields;
                    }
                    
                    break;
                }
                case PPContactMainType_BirthDay:
                {
                    if([contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddBirthday])
                    {
                        style = UITableViewCellEditingStyleInsert;
                        tableViewCellStyle = PPContactTableViewCellStyle_Default;
                    }
                    else
                    {
                        style = UITableViewCellEditingStyleDelete;
                        tableViewCellStyle = PPContactTableViewCellStyle_DatePicker;
                    }
                    break;
                }
                    
                case PPContactMainType_Date:
                {
                    if([contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddDate])
                    {
                        style = UITableViewCellEditingStyleInsert;
                        tableViewCellStyle = PPContactTableViewCellStyle_Default;
                    }
                    else
                    {
                        style = UITableViewCellEditingStyleDelete;
                        tableViewCellStyle = PPContactTableViewCellStyle_DateAndTimeTextField;
                    }
                    break;
                }
                case PPContactMainType_Phone:
                {
                    if([contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddPhone])
                    {
                        style = UITableViewCellEditingStyleInsert;
                        tableViewCellStyle = PPContactTableViewCellStyle_Default;
                    }
                    else
                    {
                        style = UITableViewCellEditingStyleDelete;
                        tableViewCellStyle = PPContactTableViewCellStyle_PhoneTextField;
                    }
                    break;
                }
                case PPContactMainType_Note:
                {
                    if([contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddNote])
                    {
                        style = UITableViewCellEditingStyleInsert;
                        tableViewCellStyle = PPContactTableViewCellStyle_Default;
                    }
                    else
                    {
                        style = UITableViewCellEditingStyleDelete;
                        tableViewCellStyle = PPContactTableViewCellStyle_TextView;
                    }
                    break;
                }
                case PPContactMainType_PublicNote:
                {
                    if([contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddPublicNote])
                    {
                        style = UITableViewCellEditingStyleInsert;
                        tableViewCellStyle = PPContactTableViewCellStyle_Default;
                    }
                    else
                    {
                        style = UITableViewCellEditingStyleDelete;
                        tableViewCellStyle = PPContactTableViewCellStyle_TextView;
                    }
                    break;
                }
                case PPContactMainType_InstantMessage:
                case PPContactMainType_Email:
                case PPContactMainType_URL:
                case PPContactMainType_SocialNetwork:
                {
                    if([contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddInstanceMessenger]==YES ||
                       [contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddMail]==YES ||
                       [contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddNickName]==YES ||
                       [contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddUnifiedNumber]==YES ||
                       [contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddWebSite]==YES ||
                       [contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddSocialNetwork]==YES)
                    {
                        style = UITableViewCellEditingStyleInsert;
                        tableViewCellStyle = PPContactTableViewCellStyle_Default;
                    }
                    else
                    {
                        style = UITableViewCellEditingStyleDelete;
                        tableViewCellStyle = PPContactTableViewCellStyle_TextField;
                    }
                    break;
                    
                }
                case PPContactMainType_Other:
                {
                    if(contactDataExchangeModel.labelType==PPContactLabelType_Other_ConstructTime ||
                       contactDataExchangeModel.labelType==PPContactLabelType_Other_ModifyTime)
                    {
                        style = UITableViewCellEditingStyleNone;
                    }
                    else
                    {
                        style = UITableViewCellEditingStyleDelete;
                    }

                    tableViewCellStyle = PPContactTableViewCellStyle_TextField;
                    break;
                }
                case PPContactMainType_UserDefine:
                {
                    if([contactDataExchangeModel.labelText isEqualToString:WCCV_MLS_AddUserDefine])
                    {
                        style = UITableViewCellEditingStyleDelete;
                    }
                    else
                    {
                        style = UITableViewCellEditingStyleNone;
                    }
                    
                    //////////////////////////////////////////////////

                    // MARK: 同個 sectionModel, 使用者自訂欄位的 tableViewCell，要用 ContactMainType + ContactSubType 決定
                    for(id contactSubTypeKey in [contactDataExchangeModel.propertyDictionary allKeys])
                    {
                        switch ([contactSubTypeKey integerValue])
                        {
                            case PPContactSubType_UserDefine_Integer:
                            case PPContactSubType_UserDefine_Float:
                            {
                                tableViewCellStyle = PPContactTableViewCellStyle_TextField;
                                break;
                            }
                            case PPContactSubType_UserDefine_Text:
                            {
                                tableViewCellStyle = PPContactTableViewCellStyle_TextField;
                                break;
                            }
                            case PPContactSubType_UserDefine_URL:
                            {
                                tableViewCellStyle = PPContactTableViewCellStyle_TextField;
                                break;
                            }
                            case PPContactSubType_UserDefine_ListValue:
                            {
                                tableViewCellStyle = PPContactTableViewCellStyle_DataPicker;
                                break;
                            }
                            case PPContactSubType_UserDefine_Email:
                            {
                                tableViewCellStyle = PPContactTableViewCellStyle_TextField;
                                break;
                            }
                            case PPContactSubType_UserDefine_Date:
                            {
                                tableViewCellStyle = PPContactTableViewCellStyle_DateAndTimeTextField;
                                break;
                            }
                            case PPContactSubType_UserDefine_DateAndTime:
                            {
                                tableViewCellStyle = PPContactTableViewCellStyle_DateAndTimeTextField;
                                break;
                            }
                            default:
                            {
                                
                                break;
                            }
                        }
                    }
                   
                    break;
                }
                case PPContactMainType_Group:
                case PPContactMaintype_VisibleAccount:
                {
                    style = UITableViewCellEditingStyleNone;
                    
                    tableViewCellStyle = PPContactTableViewCellStyle_Default;
                    
                    break;
                }
                case PPContactMainType_SystemGroup:
                {
                    style = UITableViewCellEditingStyleNone;
                    
                    if(contactDataExchangeModel.labelType==PPContactLabelType_SystemGroup_Save)
                    {
                        tableViewCellStyle = PPContactTableViewCellStyle_Switch;
                    }
                    else
                    {
                        tableViewCellStyle = PPContactTableViewCellStyle_Default;
                    }

                    
                    break;
                }
                default:
                {
                    break;
                }
            }
    
            //////////////////////////////////////////////////
            
            PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                               ppContactLabelType:contactDataExchangeModel.labelType
                                                                                        tableViewCellEditingStyle:style
                                                                                      ppContactTableViewCellStyle:tableViewCellStyle
                                                       selected:contactDataExchangeModel.valid];
            
            
            if(newContactRowObject==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for (id key in contactDataExchangeModel.propertyDictionary.allKeys)
            {
                [newContactRowObject.inputValueDictionary setObject:[contactDataExchangeModel.propertyDictionary objectForKey:key] forKey:key];
            }
            
            //////////////////////////////////////////////////
            
            NSString *detailText = nil;
            
            //////////////////////////////////////////////////

            if(newContactRowObject.contactMainType==PPContactMainType_Name)
            {
                NSString *firstName = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_FirstName]];
                
                if(firstName==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_FirstName]];
                }
                
                //////////////////////////////////////////////////
                
                if(showPhonetic==YES)
                {
                    NSString *firstNamePhoneticName = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_FirstNamePhonetic]];
                    
                    if(firstNamePhoneticName==nil)
                    {
                        [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_FirstNamePhonetic]];
                    }
                }
                
                //////////////////////////////////////////////////
                
                NSString *middleName = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_MiddleName]];
                
                if(middleName==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_MiddleName]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *lastName = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_LastName]];
                
                if(lastName==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_LastName]];
                }

                //////////////////////////////////////////////////
                
                if(showPhonetic==YES)
                {
                    NSString *lastNamePhoneticName = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_LastNamePhonetic]];
                    
                    if(lastNamePhoneticName==nil)
                    {
                        [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_LastNamePhonetic]];
                    }
                }
    
                //////////////////////////////////////////////////
                
                NSString *prefix = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_Prefix]];
                
                if(prefix==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_Prefix]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *surffix = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_Surffix]];
                
                if(surffix==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_Surffix]];
                }
            }
            else if(newContactRowObject.contactMainType==PPContactMainType_Company)
            {
                NSString *companyName = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Company_Name]];
                
                if(companyName==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Company_Name]];
                }
                
                //////////////////////////////////////////////////
                
                if(showPhonetic==YES)
                {
                    NSString *companyPhoneticName = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Company_NamePhonetic]];
                    
                    if(companyPhoneticName==nil)
                    {
                        [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Company_NamePhonetic]];
                    }
                }
                
                //////////////////////////////////////////////////
                
                NSString *jobTitle = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Company_JobTitle]];
                
                if(jobTitle==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Company_JobTitle]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *departmennt = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Company_Department]];
                
                if(departmennt==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Company_Department]];
                }
            }
            //!!若是地址欄位要補齊顯示欄位格數，顯示才不會出錯
            else if(newContactRowObject.contactMainType==PPContactMainType_Address)
            {
                NSString *city = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_City]];
                
                if(city==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_City]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *street = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Street]];
                
                if(street==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Street]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *zip = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Zip]];
                
                if(zip==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Zip]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *state = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_State]];
                
                if(state==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_State]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *country = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Country]];
                
                if(country==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Country]];
                }
            }
            //!!使用者自訂欄位
            else if(contactMainType==PPContactMainType_UserDefine)
            {
                NSString *userDefine;
                
                for(id key in [newContactRowObject.inputValueDictionary allKeys])
                {
                    userDefine = [newContactRowObject.inputValueDictionary objectForKey:key];
                    
                    //////////////////////////////////////////////////

                    if(userDefine==nil)
                    {
                        [newContactRowObject.inputValueDictionary setObject:@"" forKey:key];
                    }
                }      
            
            }
            //群組欄位
            else if(contactMainType==PPContactMainType_Group)
            {
                NSString *group = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Group]];
                
                if(group==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Group]];
                }
                else
                {
                    detailText = group;
                }
            }
            //系統群組欄位
            else if(contactMainType==PPContactMainType_SystemGroup)
            {
                NSString *group = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_SystemGroup]];
                
                if(group==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_SystemGroup]];
                }
                else
                {
                    detailText = group;
                }
            }
            // 可檢視用戶
            else if(contactMainType==PPContactMaintype_VisibleAccount)
            {
                NSString *visibleAccount = [newContactRowObject.inputValueDictionary objectForKey:@(PPContactSubType_VisibleAccount)];
                
                if(visibleAccount==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_VisibleAccount)];
                }
                else
                {
                    detailText = visibleAccount;
                }
            }
            //////////////////////////////////////////////////
            
            for (id key in contactDataExchangeModel.imageRectDictionary.allKeys)
            {
                [newContactRowObject.imageRectDictionary setObject:[contactDataExchangeModel.imageRectDictionary objectForKey:key] forKey:key];
            }
            
            //////////////////////////////////////////////////
            
            NSString *labelText = contactDataExchangeModel.labelText;
            
            if(labelText==nil && labelText.length<=0)
            {
                labelText = [PPContactRowObject labelTextFromPPContactLabelType:contactDataExchangeModel.labelType ppContactMainType:contactMainType];
            }
            
            //////////////////////////////////////////////////
            
            PPRowModel *newRowModel = [PPRowModel rowModelWithRow:sectionModel.rowModels.count
                                                             text:labelText
                                                       detailText:detailText
                                                           object:newContactRowObject];
            
            [newRowModel setPPContactFieldSource:contactDataExchangeModel.contactFieldSource];
            
            if(newRowModel!=nil)
            {
                [sectionModel.rowModels addObject:newRowModel];
            }
        }
        
    } while (0);

    return sectionModel;
}


//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForPPContactMainType:(PPContactMainType)contactMainType
{
    PPContactSectionModel *contactSectionModel = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        //!!使用者欄位無法自已新增，只能從外部給予
        if(contactMainType==PPContactMainType_UserDefine)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSArray *itemTextLabelArray   = [self defaultTitleArrayForPPContactMainType:contactMainType];
        
        if(itemTextLabelArray==nil || itemTextLabelArray.count<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        UITableViewCellEditingStyle tableViewCellEditingStyle = UITableViewCellEditingStyleInsert;
        
        if(contactMainType==PPContactMainType_HeadImage)
        {
            tableViewCellEditingStyle = UITableViewCellEditingStyleNone;
        }
        else if(contactMainType==PPContactMainType_Other)
        {
            tableViewCellEditingStyle = UITableViewCellEditingStyleNone;
        }
        
        
        //////////////////////////////////////////////////

        contactSectionModel = [self ppContactSectionModelForPPContactMainType:contactMainType
                                                                itemTextArray:itemTextLabelArray
                                                    tableViewCellEditingStyle:tableViewCellEditingStyle
                                                         ppContactFieldSource:PPContactFieldSource_None];
        
    } while (0);
    
    return contactSectionModel;
    
}


//================================================================================
//
//================================================================================
+ (PPContactTableViewCellStyle)contactTableViewCellStyleForContactMainType:(PPContactMainType)contactMainType
{
    PPContactTableViewCellStyle style = PPContactTableViewCellStyle_Default;
    
    switch (contactMainType)
    {
        case PPContactMainType_InstantMessage:
        case PPContactMainType_Email:
        case PPContactMainType_Other:
        case PPContactMainType_UserDefine:
        case PPContactMainType_URL:
        case PPContactMainType_SocialNetwork:
        {
            style = PPContactTableViewCellStyle_TextField;
            break;
        }
        case PPContactMainType_BirthDay:
        {
            style = PPContactTableViewCellStyle_DatePicker;
            break;
        }
        case PPContactMainType_Date:
        {
            style = PPContactTableViewCellStyle_DateAndTimeTextField;
            break;
        }
        case PPContactMainType_Note:
        case PPContactMainType_PublicNote:
        {
            style = PPContactTableViewCellStyle_TextView;
            break;
        }
        case PPContactMainType_Name:
        case PPContactMainType_Address:
        case PPContactMainType_Company:
        {
            style = PPContactTableViewCellStyle_MultiTextFields;
            break;
        }
        case PPContactMainType_Phone:
        {
            style = PPContactTableViewCellStyle_PhoneTextField;
            break;
        }
        case PPContactMainType_HeadImage:
        {
            style = PPContactTableViewCellStyle_HeadImageName;
            break;
        }
        default:
        {
            style = PPContactTableViewCellStyle_Default;
            break;
        }
    }
    
    return style;
}

@end
