//
//  WCContactEditViewController+ContactEditViewDelegate.m
//  AVCaptureDevice+RequestAuthorization
//
//  Created by Howard on 2019/2/18.
//

#import "WCContactEditViewController+ContactEditViewDelegate.h"

// Define
#import "PPDateSectionController+ParameterDefine.h"
#import "WCContactViewController+PublicParameterDefine.h"
#import "WCContactViewController+ResourceDefine.h"
#import "WCContactEditViewController+ResouceDefine.h"
#import "WCFieldDefine.h"

// Category
#import "NSDate+Format.h"
#import "PPRowModel+Contact.h"
#import "UIView+PPGuideController.h"

// View
#import "ContactDataPickerTableViewCell.h"
#import "ContactDatePickerTableViewCell.h"
#import "ContactDateAndTimeTextFieldTableViewCell.h"
#import "ContactPhoneTextFieldTableViewCell.h"
#import "ContactMultipleTextFieldButtonTableViewCell.h"
#import "ContactTextFieldTableViewCell.h"
#import "ContactTextViewTableViewCell.h"
#import "PPSwitchTableViewCell.h"
#import "PPTableViewCell.h"

#if defined (PRODUCTLINE_WCO365)
#import "PPContactRowObject+Office365.h"
#endif

@implementation WCContactEditViewController (ContactEditViewDelegate)

//================================================================================
//
//================================================================================
- (UITableViewCell *)contactEditView:(ContactEditView *)contactEditView
             wcCellForRowAtIndexPath:(NSIndexPath *)indexPath
                            rowModel:(PPRowModel *)rowModel
{
    UITableViewCell *cell = nil;
    
    do
    {
        if(rowModel==nil || [rowModel ppContactRowObjectOfRowModel]==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactRowObject *contactRowObject = rowModel.object;
        
        //////////////////////////////////////////////////
        
        switch (contactRowObject.tableViewCellStyle)
        {
            case PPContactTableViewCellStyle_DataPicker:
            {
                // MARK: 資料選擇欄位
                
                cell = [contactEditView.contactEditTableView dequeueReusableCellWithIdentifier:DataPickerCellIdentifier];
                
                //////////////////////////////////////////////////
                
                if(cell==nil)
                {
                    cell = [[[ContactDataPickerTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:DataPickerCellIdentifier] autorelease];
                }
                else if([cell respondsToSelector:@selector(reuse)]==YES)
                {
                    [cell performSelector:@selector(reuse)];
                }
                
                //////////////////////////////////////////////////
                
                ContactDataPickerTableViewCell *dataPickerFieldCell = (ContactDataPickerTableViewCell *)cell;
                
                //!!讓游標顏色消失
                if([[[UIDevice currentDevice]systemVersion]floatValue]>=7.0)
                {
                    dataPickerFieldCell.textField.tintColor = [UIColor clearColor];
                }
                else
                {
                    [[dataPickerFieldCell.textField valueForKey:@"textInputTraits"] setValue:[UIColor clearColor]
                                                                                      forKey:@"insertionPointColor"];
                }
                
                dataPickerFieldCell.delegate = contactEditView;
                dataPickerFieldCell.contactKeyboardToolBarViewDelegate = contactEditView;
                
                //////////////////////////////////////////////////
                
                dataPickerFieldCell.textField.inputAccessoryView.frame = CGRectMake(0, 0, contactEditView.bounds.size.width,ContactKeyboardToolBarViewButtonHeight);
                
                //////////////////////////////////////////////////
                
                dataPickerFieldCell.ignoreCustomLabelFrame = YES;
                
                //////////////////////////////////////////////////
                
                dataPickerFieldCell.textLabel.text = rowModel.text;
                [dataPickerFieldCell.textLabel setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                //////////////////////////////////////////////////
                
                if(contactRowObject.inputValueDictionary.count>0)
                {
                    NSString *text = [contactRowObject visibleTextFromSubType];
                    
                    if([text isEqualToString:WCVC_EditViewControllerSelectEmptyValue]==YES)
                    {
                        dataPickerFieldCell.textField.text = @"";
                    }
                    else if([text isEqualToString:WCVC_EditViewControllerSelectDisableValue]==YES)
                    {
                        dataPickerFieldCell.textField.text = WCCV_MLS_EditListDisable;
                    }
                    else
                    {
                        dataPickerFieldCell.textField.text = text;
                    }
                }
                else
                {
                    dataPickerFieldCell.textField.text = @"";
                }
                
                //////////////////////////////////////////////////
                
                dataPickerFieldCell.textField.placeholder = [contactRowObject localizedPlaceholder];
                [dataPickerFieldCell.textField setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                //////////////////////////////////////////////////
                
                if([[contactRowObject.inputValueDictionary allKeys] indexOfObject:@(PPContactSubType_UserDefine_ItemMenu)]!=NSNotFound)
                {
                    dataPickerFieldCell.itemsMenu = [contactRowObject.inputValueDictionary objectForKey:@(PPContactSubType_UserDefine_ItemMenu)];
                    
                    //////////////////////////////////////////////////
                    
                    [dataPickerFieldCell selectRow:[dataPickerFieldCell.itemsMenu indexOfObject:dataPickerFieldCell.textField.text]
                                          animated:NO];
                }
                
                break;
            }
            case PPContactTableViewCellStyle_DatePicker:
            {
                // MARK: 生日欄位
                cell = [contactEditView.contactEditTableView dequeueReusableCellWithIdentifier:DatePickerCellIdentifier];
                
                //////////////////////////////////////////////////
                
                if(cell==nil)
                {
                    cell = [[[ContactDatePickerTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:DatePickerCellIdentifier] autorelease];
                }
                else if([cell respondsToSelector:@selector(reuse)]==YES)
                {
                    [cell performSelector:@selector(reuse)];
                }
                
                //////////////////////////////////////////////////
                
                ContactDatePickerTableViewCell *datePickerFieldCell = (ContactDatePickerTableViewCell *)cell;
                
                //!!讓游標顏色消失
                if([[[UIDevice currentDevice]systemVersion]floatValue]>=7.0)
                {
                    datePickerFieldCell.textField.tintColor = [UIColor clearColor];
                }
                else
                {
                    [[datePickerFieldCell.textField valueForKey:@"textInputTraits"] setValue:[UIColor clearColor]
                                                                                      forKey:@"insertionPointColor"];
                }
                
                datePickerFieldCell.delegate = contactEditView;
                datePickerFieldCell.contactKeyboardToolBarViewDelegate = contactEditView;
                
                //////////////////////////////////////////////////
                
                datePickerFieldCell.textField.inputAccessoryView.frame = CGRectMake(0, 0, contactEditView.bounds.size.width,ContactKeyboardToolBarViewButtonHeight);
                
                //////////////////////////////////////////////////
                
                datePickerFieldCell.ignoreCustomLabelFrame = YES;
                
                //////////////////////////////////////////////////
                
                datePickerFieldCell.textLabel.text = rowModel.text;
                [datePickerFieldCell.textLabel setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                //////////////////////////////////////////////////
                
                if(contactRowObject.inputValueDictionary.count>0)
                {
                    NSString *rowModelText = [contactRowObject visibleTextFromSubType];
                    
                    NSArray *rowModelTexts = [rowModelText componentsSeparatedByString:@"/"];
                    
                    //含年份, 小於1901年份為隱藏欄位
                    if(rowModelTexts.count>=3 &&
                       [[rowModelTexts firstObject] integerValue]<=WC_ValidMinYear)
                    {
                        datePickerFieldCell.textField.text = [[rowModelTexts objectAtIndex:1] stringByAppendingString:[NSString stringWithFormat:@"/%@",[rowModelTexts lastObject]]];
                    }
                    else
                    {
                        datePickerFieldCell.textField.text = rowModelText;
                    }
                }
                else
                {
                    datePickerFieldCell.textField.text = @"";
                }
                
                //////////////////////////////////////////////////
                
                datePickerFieldCell.textField.placeholder = [contactRowObject localizedPlaceholder];
                [datePickerFieldCell.textField setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                //////////////////////////////////////////////////
                
                [datePickerFieldCell refreshDisplayWithDateComponents:@[@(PPDateSectionControllerComponent_Year),
                                                                        @(PPDateSectionControllerComponent_Month),
                                                                        @(PPDateSectionControllerComponent_Day)]];
                
                break;
            }
            case PPContactTableViewCellStyle_DateAndTimeTextField:
            {
                // MARK: 時間欄位
                cell = [contactEditView.contactEditTableView dequeueReusableCellWithIdentifier:DateAndTimeTextFieldCellIdentifier];
                
                //////////////////////////////////////////////////
                
                if(cell==nil)
                {
                    cell = [[[ContactDateAndTimeTextFieldTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:DateAndTimeTextFieldCellIdentifier] autorelease];
                }
                else if([cell respondsToSelector:@selector(reuse)]==YES)
                {
                    [cell performSelector:@selector(reuse)];
                }
                
                //////////////////////////////////////////////////
                
                ContactDateAndTimeTextFieldTableViewCell *dateTextFieldCell = (ContactDateAndTimeTextFieldTableViewCell *)cell;
                
                //!!讓游標顏色消失
                if([[[UIDevice currentDevice] systemVersion] floatValue]>=7.0)
                {
                    dateTextFieldCell.textField.tintColor = [UIColor clearColor];
                }
                else
                {
                    [[dateTextFieldCell.textField valueForKey:@"textInputTraits"] setValue:[UIColor clearColor]
                                                                                    forKey:@"insertionPointColor"];
                }
                
                dateTextFieldCell.delegate = contactEditView;
                dateTextFieldCell.contactKeyboardToolBarViewDelegate = contactEditView;
                
                //////////////////////////////////////////////////
                
                dateTextFieldCell.textField.inputAccessoryView.frame = CGRectMake(0, 0, contactEditView.bounds.size.width,ContactKeyboardToolBarViewButtonHeight);
                
                //////////////////////////////////////////////////
                
                dateTextFieldCell.ignoreCustomLabelFrame = YES;
                
                //////////////////////////////////////////////////
                
                dateTextFieldCell.maxLength = [self requestContactEditTableViewCellTextMaxLengthWithContactMainType:contactRowObject.contactMainType
                                                                                                     contactSubType:[contactRowObject curEditingSubType]
                                                                                                   contactLabelType:contactRowObject.contactLabelType];
                
                if(dateTextFieldCell.maxLength<=0)
                {
                    dateTextFieldCell.maxLength = NSUIntegerMax;
                }
                
                //////////////////////////////////////////////////
                
                dateTextFieldCell.textLabel.text = rowModel.text;
                [dateTextFieldCell.textLabel setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                //////////////////////////////////////////////////
                
                [dateTextFieldCell.datePicker setMinimumDate:[NSDate dateFromString:PDSC_MinimumDate format:NSDateFormat_Day]];
                [dateTextFieldCell.datePicker setMaximumDate:[NSDate dateFromString:PDSC_MaximumDate format:NSDateFormat_Day]];
                
                //////////////////////////////////////////////////
                
                if(contactRowObject.curEditingSubType==PPContactSubType_UserDefine_DateAndTime)
                {
                    dateTextFieldCell.datePicker.datePickerMode = UIDatePickerModeDateAndTime;
                }
                else
                {
                    dateTextFieldCell.datePicker.datePickerMode = UIDatePickerModeDate;
                }
                
                
                //////////////////////////////////////////////////
                
                NSString *dateString = nil;
                
                if(contactRowObject.inputValueDictionary.count>0)
                {
                    dateString = [contactRowObject.inputValueDictionary objectForKey:@([contactRowObject curEditingSubType])];
                }
                
                //////////////////////////////////////////////////
                
                [dateTextFieldCell setTextFieldViewMode:UITextFieldViewModeWhileEditing];
                
                //////////////////////////////////////////////////
                
                dateTextFieldCell.textField.text = [dateString length]>0 ? dateString : @"";
                
                dateTextFieldCell.textField.placeholder = [contactRowObject localizedPlaceholder];
                [dateTextFieldCell.textField setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                break;
            }
            case PPContactTableViewCellStyle_MultiTextFields:
            {
                // MARK: 姓名，公司，地址欄位
                NSString *identifier = [MultiTextFieldCellIdentifier stringByAppendingString:[NSString stringWithFormat:@"%td",indexPath.section]];
                
                cell = [contactEditView.contactEditTableView dequeueReusableCellWithIdentifier:identifier];
                
                //////////////////////////////////////////////////
                
                if(cell==nil)
                {
                    cell = [[[ContactMultipleTextFieldButtonTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:identifier] autorelease];
                }
                
                //////////////////////////////////////////////////
                
                ContactMultipleTextFieldButtonTableViewCell *multipleTextFieldButtonTableViewCell = (ContactMultipleTextFieldButtonTableViewCell *)cell;
                
                multipleTextFieldButtonTableViewCell.contactKeyboardToolBarViewDelegate = contactEditView;
                multipleTextFieldButtonTableViewCell.delegate = contactEditView;
                
                //////////////////////////////////////////////////
                
                if(contactRowObject.contactMainType==PPContactMainType_Address)
                {
                    multipleTextFieldButtonTableViewCell.textLabel.text = rowModel.text;
                }
                else
                {
                    multipleTextFieldButtonTableViewCell.textLabel.text = nil;
                }
                
                //////////////////////////////////////////////////
                
                [multipleTextFieldButtonTableViewCell.textLabel setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                //////////////////////////////////////////////////
                
                NSMutableArray *placeholders = [NSMutableArray array];
                
                //////////////////////////////////////////////////
                
                NSMutableArray *sortKey = nil;
                
                if([self.dataSource respondsToSelector:@selector(ppContactSubTypeArrayForSortingSectionRowWithPPContactMainType:ppContactEditViewController:)]==YES)
                {
                    sortKey = [self.dataSource ppContactSubTypeArrayForSortingSectionRowWithPPContactMainType:contactRowObject.contactMainType ppContactEditViewController:self];
                }
                
                if(sortKey==nil || sortKey.count<=0)
                {
                    sortKey = [NSMutableArray arrayWithArray:[contactRowObject sortAllKeys]];
                }
                
                //////////////////////////////////////////////////
                
                if(sortKey!=nil)
                {
                    if ([self.dataSource respondsToSelector:@selector(shouldShowPhoneticOnWCContactEditViewController:contactMainType:)])
                    {
                        if([self.dataSource shouldShowPhoneticOnWCContactEditViewController:self
                                                                            contactMainType:PPContactMainType_Name]==NO)
                        {
                            [sortKey removeObject:@(PPContactSubType_Name_FirstNamePhonetic)];
                            [sortKey removeObject:@(PPContactSubType_Name_LastNamePhonetic)];
                        }
                        
                        //////////////////////////////////////////////////
                        
                        if([self.dataSource shouldShowPhoneticOnWCContactEditViewController:self
                                                                            contactMainType:PPContactMainType_Company]==NO)
                        {
                            [sortKey removeObject:@(PPContactSubType_Company_NamePhonetic)];
                        }
                    }
                }
                
                //////////////////////////////////////////////////
                
                NSString *coutryCode = [contactRowObject.inputValueDictionary objectForKey:@(PPContactSubType_Address_CountryCode)];
                
                if(coutryCode==nil || coutryCode.length<=0)
                {
                    coutryCode = [PPCountryCodeConvert defaultCountryCode];
                }
                
                //////////////////////////////////////////////////
                
                for(NSNumber *key in sortKey)
                {
                    NSString *placeholder = nil;
#if defined (PRODUCTLINE_WCO365)
                    placeholder = [contactRowObject office365PlaceholderForPPContactSubType:[key unsignedIntegerValue]
                                                                       countryCode:coutryCode];
#else
                    placeholder = [contactRowObject placeholderForPPContactSubType:[key unsignedIntegerValue]
                                                                                 countryCode:coutryCode];
#endif
                    if(placeholder!=nil)
                    {
                        [placeholders addObject:placeholder];
                    }
                }
                
                [multipleTextFieldButtonTableViewCell customTextFieldsWithPlacehoders:placeholders];
                
                //////////////////////////////////////////////////
                
                // 設定 InputAccessoryViewFrame
                
                for (PPTextFieldButtonView *textFieldButtonView in multipleTextFieldButtonTableViewCell.textFieldButtonViews)
                {
                    textFieldButtonView.textField.inputAccessoryView.frame = CGRectMake(0, 0, contactEditView.bounds.size.width,ContactKeyboardToolBarViewButtonHeight);
                }
                
                //////////////////////////////////////////////////
                
                if(contactRowObject.contactMainType==PPContactMainType_Address)
                {
                    for (NSInteger keyIndex=0 ; keyIndex<sortKey.count ; keyIndex++)
                    {
                        PPTextFieldButtonView *textFieldButtonView = nil;
                        
                        if(keyIndex>multipleTextFieldButtonTableViewCell.textFieldButtonViews.count)
                        {
                            break;
                        }
                        else if(keyIndex==multipleTextFieldButtonTableViewCell.textFieldButtonViews.count)
                        {
                            //!!此時拿出PPContactSubType_Address_CountryCode的欄位，會對應至multipleTextFieldButtonTableViewCell.textield最後一個textfield(顯示國家欄位)
                            textFieldButtonView = [multipleTextFieldButtonTableViewCell.textFieldButtonViews objectAtIndex:keyIndex-1];
                        }
                        else
                        {
                            textFieldButtonView = [multipleTextFieldButtonTableViewCell.textFieldButtonViews objectAtIndex:keyIndex];
                        }
                        
                        //////////////////////////////////////////////////
                        
                        //隱藏textfield 按鈕
                        textFieldButtonView.ppButtonDetail.hidden = YES;
                        
                        UITextField *field = textFieldButtonView.textField;
                        
                        //////////////////////////////////////////////////
                        
                        [field setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                        
                        //////////////////////////////////////////////////
                        
                        NSNumber *key = [sortKey objectAtIndex:keyIndex];
                        
                        switch ([key unsignedIntegerValue])
                        {
                            case PPContactSubType_Address_City:
                            case PPContactSubType_Address_State:
                            case PPContactSubType_Address_Street:
                            case PPContactSubType_Address_Country:
                            case PPContactSubType_Address_Zip:
                            {
                                field.text = [contactRowObject.inputValueDictionary objectForKey:key];
                                
                                //////////////////////////////////////////////////
                                
                                textFieldButtonView.maxLength = [self requestContactEditTableViewCellTextMaxLengthWithContactMainType:contactRowObject.contactMainType
                                                                                                                       contactSubType:[key unsignedIntegerValue]
                                                                                                                     contactLabelType:contactRowObject.contactLabelType];
                                
                                if(multipleTextFieldButtonTableViewCell.maxLength<=0)
                                {
                                    multipleTextFieldButtonTableViewCell.maxLength = NSUIntegerMax;
                                }
                                
                                break;
                            }
                            case PPContactSubType_Address_CountryCode:
                            {
                                NSString *countryCode = [contactRowObject.inputValueDictionary objectForKey:key];
                                
                                if(countryCode==nil && countryCode.length>0)
                                {
                                    countryCode = [PPCountryCodeConvert defaultCountryCode];
                                }
                                
                                //MARK 這邊取的是對照namecard.h的定義
                                NSNumber *languageCode = [contactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_RecognitionLanguageCode]];
                                
                                if(languageCode==nil)
                                {
                                    field.text = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode];
                                }
                                //取預設語系
                                else if([languageCode integerValue]==-1)
                                {
                                    field.text = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode
                                                                                    withLanguageCode:[PPCountryCodeConvert languageCodeWithRecogLang:[PPCountryCodeConvert defaultRecogLangWithCountryCode:countryCode]]];
                                }
                                else
                                {
                                    field.text = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode
                                                                                    withLanguageCode:[PPCountryCodeConvert languageCodeWithRecogLang:[languageCode unsignedIntegerValue]]];
                                }
                                
                                break;
                            }
                            default:
                            {
                                break;
                            }
                        }
                    }
                }
                else
                {
                    for (NSInteger fieldIndex=0 ; fieldIndex<multipleTextFieldButtonTableViewCell.textFieldButtonViews.count; fieldIndex++)
                    {
                        
                        PPTextFieldButtonView *textFieldButtonView = [multipleTextFieldButtonTableViewCell.textFieldButtonViews objectAtIndex:fieldIndex];
                        
                        //////////////////////////////////////////////////
                        
                        BOOL showPhoneticButton = NO;
                        
                        if([self.dataSource respondsToSelector:@selector(shouldShowSelectPhoneticMenuOnWCContactEditViewController:)]==YES)
                        {
                            showPhoneticButton = [self.dataSource shouldShowSelectPhoneticMenuOnWCContactEditViewController:self];
                        }
                        
                        //////////////////////////////////////////////////
                        
                        NSNumber *key = [sortKey objectAtIndex:fieldIndex];
                        
                        switch ([key unsignedIntegerValue])
                        {
                            case PPContactSubType_Name_FirstNamePhonetic:
                            case PPContactSubType_Name_LastNamePhonetic:
                            case PPContactSubType_Company_NamePhonetic:
                            {
                                textFieldButtonView.ppButtonDetail.hidden = (!showPhoneticButton);
                                break;
                            }
                            default:
                            {
                                textFieldButtonView.ppButtonDetail.hidden = YES;
                                break;
                            }
                        }
                        
                        //////////////////////////////////////////////////
                        
                        textFieldButtonView.maxLength = [self requestContactEditTableViewCellTextMaxLengthWithContactMainType:contactRowObject.contactMainType
                                                                                                               contactSubType:[key unsignedIntegerValue]
                                                                                                             contactLabelType:contactRowObject.contactLabelType];
                        
                        if(multipleTextFieldButtonTableViewCell.maxLength<=0)
                        {
                            multipleTextFieldButtonTableViewCell.maxLength = NSUIntegerMax;
                        }
                        
                        //////////////////////////////////////////////////
                        
                        textFieldButtonView.textField.keyboardType = UIKeyboardTypeDefault;
                        
                        textFieldButtonView.textField.text = [contactRowObject.inputValueDictionary objectForKey:key];
                        
                        [textFieldButtonView.textField setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                    }
                }
                
                break;
            }
            case PPContactTableViewCellStyle_PhoneTextField:
            {
                // MARK: 電話欄位
                cell = [contactEditView.contactEditTableView dequeueReusableCellWithIdentifier:PhoneTextFieldIdentifier];
                
                //////////////////////////////////////////////////
                
                if(cell==nil)
                {
                    cell = [[[ContactPhoneTextFieldTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:PhoneTextFieldIdentifier] autorelease];
                }
                
                //////////////////////////////////////////////////
                
                ContactPhoneTextFieldTableViewCell *textFieldCell = (ContactPhoneTextFieldTableViewCell *)cell;
                
                textFieldCell.delegate = contactEditView;
                textFieldCell.contactKeyboardToolBarViewDelegate = contactEditView;
                
                //////////////////////////////////////////////////
                
                textFieldCell.ignoreCustomLabelFrame = YES;
                
                //////////////////////////////////////////////////
                
                textFieldCell.autoFormat = self.phoneAutoFormat;
                
                //////////////////////////////////////////////////
                
                textFieldCell.maxLength = [self requestContactEditTableViewCellTextMaxLengthWithContactMainType:contactRowObject.contactMainType
                                                                                                 contactSubType:[contactRowObject curEditingSubType]
                                                                                               contactLabelType:contactRowObject.contactLabelType];
                
                
                if(textFieldCell.maxLength<=0)
                {
                    textFieldCell.maxLength = NSUIntegerMax;
                }
                
                //////////////////////////////////////////////////
                
                textFieldCell.textLabel.text = rowModel.text;
                [textFieldCell.textLabel setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                //////////////////////////////////////////////////
                
                textFieldCell.textField.inputAccessoryView.frame = CGRectMake(0, 0, contactEditView.bounds.size.width,ContactKeyboardToolBarViewButtonHeight);
                
                //////////////////////////////////////////////////
                
                [textFieldCell.textField setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                textFieldCell.textField.placeholder = [contactRowObject localizedPlaceholder];
                
                //////////////////////////////////////////////////
                
                textFieldCell.textField.keyboardType = UIKeyboardTypePhonePad;
                
                //////////////////////////////////////////////////
                
                if(contactRowObject.inputValueDictionary.count>0)
                {
                    textFieldCell.textField.text = [contactRowObject visibleTextFromSubType];
                    
                }
                else
                {
                    textFieldCell.textField.text = @"";
                }
                
                //////////////////////////////////////////////////
                
                [textFieldCell.textField setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                break;
            }
            case PPContactTableViewCellStyle_TextView:
            {
                // MARK:TextView欄位
                cell = [contactEditView.contactEditTableView dequeueReusableCellWithIdentifier:TextViewCellIdenttifier];
                
                //////////////////////////////////////////////////
                
                if(cell==nil)
                {
                    cell = [[[ContactTextViewTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:TextViewCellIdenttifier] autorelease];
                }
                
                //////////////////////////////////////////////////
                
                ContactTextViewTableViewCell *textViewTableViewCell = (ContactTextViewTableViewCell *)cell;
                
                textViewTableViewCell.delegate = contactEditView;
                textViewTableViewCell.contactKeyboardToolBarViewDelegate = contactEditView;
                
                [textViewTableViewCell.ppTextView setAutocapitalizationType:UITextAutocapitalizationTypeSentences];
                
                //////////////////////////////////////////////////
                
                textViewTableViewCell.maxLength = [self requestContactEditTableViewCellTextMaxLengthWithContactMainType:contactRowObject.contactMainType
                                                                                                         contactSubType:[contactRowObject curEditingSubType]
                                                                                                       contactLabelType:contactRowObject.contactLabelType];
                
                if(textViewTableViewCell.maxLength<=0)
                {
                    textViewTableViewCell.maxLength = NSUIntegerMax;
                }
                
                //////////////////////////////////////////////////
                
                textViewTableViewCell.textLabel.text = rowModel.text;
                
                [textViewTableViewCell.textLabel setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                //////////////////////////////////////////////////
                
                if(contactRowObject.inputValueDictionary.count>0)
                {
                    textViewTableViewCell.ppTextView.text = [contactRowObject.inputValueDictionary objectForKey:@([contactRowObject curEditingSubType])];
                }
                else
                {
                    textViewTableViewCell.ppTextView.text = @"";
                }
                
                //////////////////////////////////////////////////
                
                [textViewTableViewCell.ppTextView scrollRangeToVisible:NSMakeRange(0,0)];
                
                //////////////////////////////////////////////////
                
                [textViewTableViewCell.ppTextView setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                [textViewTableViewCell.ppTextView setPlaceholder:[contactRowObject localizedPlaceholder]];
                
                break;
            }
            case PPContactTableViewCellStyle_TextField:
            {
                // MARK:TextField欄位
                PPContactMainType currentMainType = [self.contactEditSectionController contactMainTypeInSection:indexPath.section forSearching:NO];
                
                NSString *indentifiler = [NSString stringWithFormat:@"%td",currentMainType];
                
                cell = [contactEditView.contactEditTableView dequeueReusableCellWithIdentifier:[TextFieldTableViewCell stringByAppendingString:indentifiler]];
                
                //////////////////////////////////////////////////
                
                if(cell==nil)
                {
                    cell = [[[ContactTextFieldTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:[TextFieldTableViewCell stringByAppendingString:indentifiler]] autorelease];
                }
                
                //////////////////////////////////////////////////
                
                ContactTextFieldTableViewCell *textFieldCell = (ContactTextFieldTableViewCell *)cell;
                
                textFieldCell.delegate  = contactEditView;
                textFieldCell.contactKeyboardToolBarViewDelegate = contactEditView;
                
                //////////////////////////////////////////////////
                
                textFieldCell.ignoreCustomLabelFrame = YES;
                
                //////////////////////////////////////////////////
                
                textFieldCell.maxLength = [self requestContactEditTableViewCellTextMaxLengthWithContactMainType:contactRowObject.contactMainType
                                                                                                 contactSubType:[contactRowObject curEditingSubType]
                                                                                               contactLabelType:contactRowObject.contactLabelType];
                
                
                if(textFieldCell.maxLength<=0)
                {
                    textFieldCell.maxLength = NSUIntegerMax;
                }
                
                //////////////////////////////////////////////////
                
                textFieldCell.textLabel.text = rowModel.text;
                
                //此字串表無定義此字串
                if([textFieldCell.textLabel.text compare:rowModel.text]==NSOrderedSame)
                {
                    textFieldCell.textLabel.text = [rowModel.text localizedFromTable:WCCV];
                }
                
                //////////////////////////////////////////////////
                
                [textFieldCell.textLabel setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                //////////////////////////////////////////////////
                
                textFieldCell.textField.placeholder = [contactRowObject localizedPlaceholder];
                
                //////////////////////////////////////////////////
                
                textFieldCell.textField.inputAccessoryView.frame = CGRectMake(0, 0, contactEditView.bounds.size.width,ContactKeyboardToolBarViewButtonHeight);
                
                //////////////////////////////////////////////////
                
                textFieldCell.textField.enabled = YES;
                
                //////////////////////////////////////////////////
                // MARK: textfield keyboardType
                if(currentMainType==PPContactMainType_Email ||
                   (currentMainType==PPContactMainType_UserDefine &&
                    [contactRowObject curEditingSubType]==PPContactSubType_UserDefine_Email))
                {
                    textFieldCell.textField.keyboardType = UIKeyboardTypeEmailAddress;
                }
                else if(currentMainType==PPContactMainType_UserDefine &&
                        ([contactRowObject curEditingSubType]==PPContactSubType_UserDefine_Float ||
                         [contactRowObject curEditingSubType]==PPContactSubType_UserDefine_Integer))
                {
                    textFieldCell.textField.keyboardType = UIKeyboardTypeNumbersAndPunctuation;
                }
                else if(currentMainType==PPContactMainType_Other)
                {
                    if(contactRowObject.contactLabelType==PPContactLabelType_Other_UnifiedBusinessNumber)
                    {
                        textFieldCell.textField.keyboardType = UIKeyboardTypePhonePad;
                    }
                    else if(contactRowObject.contactLabelType==PPContactLabelType_Other_URL_Work)
                    {
                        textFieldCell.textField.keyboardType = UIKeyboardTypeURL;
                    }
                    else if(contactRowObject.contactLabelType==PPContactLabelType_Other_ConstructTime ||
                            contactRowObject.contactLabelType==PPContactLabelType_Other_ModifyTime)
                    {
                        textFieldCell.textField.enabled = NO;
                    }
                    else
                    {
                        textFieldCell.textField.keyboardType = UIKeyboardTypeDefault;
                    }
                }
                else
                {
                    textFieldCell.textField.keyboardType = UIKeyboardTypeDefault;
                }
                
                //////////////////////////////////////////////////
                
                // MARK: 處理 TextField輸入的第一個文字大小寫
                
                if (contactRowObject.contactMainType==PPContactMainType_Email ||
                    contactRowObject.contactMainType==PPContactMainType_InstantMessage ||
                    contactRowObject.contactMainType==PPContactMainType_URL ||
                    contactRowObject.contactMainType==PPContactMainType_SocialNetwork ||
                    contactRowObject.contactLabelType==PPContactLabelType_Other_URL_Work)
                {
                    textFieldCell.textField.autocapitalizationType = UITextAutocapitalizationTypeNone;
                }
                else
                {
                    textFieldCell.textField.autocapitalizationType = UITextAutocapitalizationTypeWords;
                }
                
                //////////////////////////////////////////////////
                
                textFieldCell.textField.text = [contactRowObject visibleTextFromSubType];
                
                //////////////////////////////////////////////////
                
                [textFieldCell.textField setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                //////////////////////////////////////////////////
                
                if([[rowModel ppContactRowObjectOfRowModel] checkValueIsLegal]==YES)
                {
                    textFieldCell.textField.textColor = WCContactEditViewCOntrollerTableViewCellTextColor;
                }
                else
                {
                    textFieldCell.textField.textColor = [UIColor redColor];
                }
                
                break;
            }
            case PPContactTableViewCellStyle_Default:
            default:
            {
                // MARK: 其它欄位
                
                if(rowModel.detailText!=nil && rowModel.detailText.length>0)
                {
                    //配合spec 調整類別，可檢視用戶顯示欄位
                    if(contactRowObject.contactMainType==PPContactMainType_Group ||
                       contactRowObject.contactMainType==PPContactMainType_SystemGroup ||
                       contactRowObject.contactMainType==PPContactMaintype_VisibleAccount)
                    {
                        cell = [contactEditView.contactEditTableView dequeueReusableCellWithIdentifier:[NSString stringWithFormat:@"%td",PPContactMainType_SalesforceSaveAs]];
                        
                        //////////////////////////////////////////////////
                        
                        if(cell==nil)
                        {
                            cell = [[[PPTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                                           reuseIdentifier:[NSString stringWithFormat:@"%td",PPContactMainType_SalesforceSaveAs]] autorelease];
                        }
                        
                        if([rowModel.detailText isEqualToString:WCVC_GroupNameNotSyncedSymbol]==YES)
                        {
                            cell.imageView.image = [UIImage imageWithName:ImageNameWCContactViewControllerButtonCategoryNotSynced];
                        }
                        else
                        {
                            cell.textLabel.text = rowModel.detailText;
                        }
                        
                        //////////////////////////////////////////////////
                        
                        cell.textLabel.numberOfLines = 0;
                        cell.textLabel.lineBreakMode = NSLineBreakByWordWrapping;
                    }
                    else
                    {
                        cell = [contactEditView.contactEditTableView dequeueReusableCellWithIdentifier:[NSString stringWithFormat:@"%td-%td",indexPath.section,indexPath.row]];
                        
                        //////////////////////////////////////////////////
                        
                        if(cell==nil)
                        {
                            cell = [[[PPTableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle
                                                           reuseIdentifier:[NSString stringWithFormat:@"%td-%td",indexPath.section,indexPath.row]] autorelease];
                        }
                        
                        cell.detailTextLabel.text = rowModel.detailText;
                        
                    }
                    
                    //這邊tableview 是編輯狀態，導致箭號消失
                    cell.editingAccessoryType  = UITableViewCellAccessoryDisclosureIndicator;
                }
                else
                {
                    cell = [contactEditView.contactEditTableView dequeueReusableCellWithIdentifier:DefaultCellIdentifier];
                    
                    //////////////////////////////////////////////////
                    
                    if(cell==nil)
                    {
                        cell = [[[PPTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:DefaultCellIdentifier] autorelease];
                    }
                    
                    cell.textLabel.text = [rowModel.text localizedFromTable:WCCV];
                    cell.editingAccessoryType  = UITableViewCellAccessoryNone;
                }
                
                //////////////////////////////////////////////////
                
                cell.tag = contactRowObject.contactLabelType;
                
                [cell.textLabel setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                [cell.textLabel setAdjustsFontSizeToFitWidth:YES];
                
                break;
            }
        }
    }while (0);
    
    //////////////////////////////////////////////////
    
    return cell;
}
@end
