//
//  PPDateSectionController.m
//  
//
//  Created by Howard on 2017/2/9.
//
//

#import "PPDateSectionController.h"

// Define
#import "WCFieldDefine.h"

// Category
#import "NSError+Custom.h"

@implementation PPDateSectionController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)generateDataForComponents:(NSArray <NSNumber *> *)components
{
    [[self sectionModelsForDefault] removeAllObjects];
    
    //////////////////////////////////////////////////

    PPSectionModel *sectionModel = nil;

    //////////////////////////////////////////////////

    for(NSNumber *component in components)
    {
        NSInteger componentValue = [component integerValue];
        
        if(componentValue!=PPDateSectionControllerComponent_Day &&
           componentValue!=PPDateSectionControllerComponent_Month &&
           componentValue!=PPDateSectionControllerComponent_Year)
        {
            continue;
        }
        
        //////////////////////////////////////////////////

        sectionModel = [[PPSectionModel alloc] init];
        
        if(sectionModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        sectionModel.title = [NSString stringWithFormat: @"%td", componentValue];
        
        [[self sectionModelsForDefault] addObject:sectionModel];
        
        //////////////////////////////////////////////////

        NSUInteger rowModelCount = 0;
        NSUInteger beginRowModelValue = 1;
        
        switch (componentValue)
        {
            case PPDateSectionControllerComponent_Day:
            {
                rowModelCount = PDSC_LargeMonthDayCount;
                break;
            }
            case PPDateSectionControllerComponent_Month:
            {
                rowModelCount = PDSC_MonthCount;
                break;
            }
            case PPDateSectionControllerComponent_Year:
            {
                NSDateComponents *components = [[NSCalendar currentCalendar] components:NSCalendarUnitDay | NSCalendarUnitMonth | NSCalendarUnitYear fromDate:[NSDate date]];
                      
                rowModelCount = [components year]-WC_ValidMinYear+1; // ---- 多1個這組
                
                //////////////////////////////////////////////////

                beginRowModelValue = WC_ValidMinYear+1;
                break;
            }
            default:
            {
                break;
            }
        }
        
        //////////////////////////////////////////////////

        PPRowModel *rowModel = nil;

        for(NSUInteger index=0; index<rowModelCount; index++)
        {
            rowModel = [[PPRowModel alloc] init];
            
            if(rowModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            if(index==rowModelCount-1 &&
               componentValue==PPDateSectionControllerComponent_Year)
            {
                rowModel.text = PDSC_YearCustomToken;
            }
            else
            {
                rowModel.text = [NSString stringWithFormat:@"%02td",beginRowModelValue+index];
            }
            
            
            rowModel.object = @(beginRowModelValue+index);
            
            [sectionModel.rowModels addObject:rowModel];
            
            [rowModel release];
        }
        
        [sectionModel release];
    }
}


//================================================================================
//
//================================================================================
- (BOOL)validDayWithYearIndexPath:(NSIndexPath *)yearIndexPath
                   monthIndexPath:(NSIndexPath *)monthIndexPath
                     dayIndexPath:(NSIndexPath *)dayIndexPath
                            error:(NSError **)error
{
    NSError *returnError = nil;
    
    BOOL result = YES;
    
    do
    {
        if(yearIndexPath==nil ||
           monthIndexPath==nil ||
           dayIndexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        PPRowModel *yearRowModel = [self rowModelAtIndexPath:yearIndexPath
                                                forSearching:NO];
        
        if(yearRowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        PPRowModel *monthRowModel = [self rowModelAtIndexPath:monthIndexPath
                                                 forSearching:NO];
        
        if(monthRowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        PPRowModel *dayRowModel = [self rowModelAtIndexPath:dayIndexPath
                                               forSearching:NO];
        
        if(dayRowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSInteger selectedYear = [yearRowModel.text integerValue];
        NSInteger selectedMonth = [monthRowModel.text integerValue];
        NSInteger selectedDay = [dayRowModel.text integerValue];

      
        //閏月
        if (selectedMonth == 2 &&
            (selectedYear % 4 == 0) &&
            (selectedYear % 100 != 0))
        {
            if(selectedDay>PDSC_LeapMonthDayCount)
            {
                returnError = PPErrorMake(PPDateSectionControllerErrorCode_Over_LeapMonthDayCount, @"PPDateSectionControllerErrorCode_Over_LeapMonthDayCount", nil);
                
                result = NO;
            }
        }
        else if (selectedMonth == 2)
        {
            if(selectedDay>PDSC_FebruaryDayCount)
            {
                returnError = PPErrorMake(PPDateSectionControllerErrorCode_Over_FebruaryDayCount, @"PPDateSectionControllerErrorCode_Over_FebruaryDayCount", nil);
                
                result = NO;
            }
        }
        else if (selectedMonth == 4 ||
                 selectedMonth == 6 ||
                 selectedMonth == 9 ||
                 selectedMonth == 11)
        {
            if(selectedDay>PDSC_SmallMonthDayCount)
            {
                returnError = PPErrorMake(PPDateSectionControllerErrorCode_Over_SmallMonthDayCount, @"PPDateSectionControllerErrorCode_Over_SmallMonthDayCount", nil);
                
                
                result = NO;
            }
        }
    }
    while (0);
    
    //////////////////////////////////////////////////

    if(error!=nil)
    {
        *error = returnError;
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (NSIndexPath *)approachValidDayIndexPathWithYearIndexPath:(NSIndexPath *)yearIndexPath
                                             monthIndexPath:(NSIndexPath *)monthIndexPath
                                               dayIndexPath:(NSIndexPath *)dayIndexPath
{
    NSError *returnError = nil;
    
    NSIndexPath *thisDayIndexPath = dayIndexPath;
    
    if([self validDayWithYearIndexPath:yearIndexPath
                        monthIndexPath:monthIndexPath
                          dayIndexPath:dayIndexPath
                                 error:&returnError]==NO)
    {
        switch (returnError.code)
        {
                
            case PPDateSectionControllerErrorCode_Over_FebruaryDayCount:
            {
                //尋找 28天
                
                thisDayIndexPath = [NSIndexPath indexPathForRow:27 inSection:dayIndexPath.section];
                
                break;
            }
            case PPDateSectionControllerErrorCode_Over_LeapMonthDayCount:
            {
                //尋找 29天
        
                thisDayIndexPath = [NSIndexPath indexPathForRow:28 inSection:dayIndexPath.section];
                
                break;
            }
            case PPDateSectionControllerErrorCode_Over_SmallMonthDayCount:
            {
                //尋找 30天
                
                thisDayIndexPath = [NSIndexPath indexPathForRow:29 inSection:dayIndexPath.section];
                
                
                break;
            }
            default:
            {
                
                break;
            }
        }
    }
    
    return thisDayIndexPath;
}


//================================================================================
//
//================================================================================
- (NSInteger)rowForRowModelText:(NSString *)text atSection:(NSUInteger)section
{
    NSInteger row = NSNotFound;
    
    do
    {
        if(text==nil ||
           [text length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if([self.sectionModelsForDefault count]<=section)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        PPSectionModel *sectionModel = [self.sectionModelsForDefault objectAtIndex:section];
        
        for(NSUInteger rowIndex=0; rowIndex<sectionModel.rowModels.count; rowIndex++)
        {
            PPRowModel *rowModel = [sectionModel.rowModels objectAtIndex:rowIndex];
            
            if([rowModel.text isEqualToString:text]==YES)
            {
                row = rowIndex;
                
                break;
            }
        }
    }
    while (0);
    
    return row;
}
@end
