//
//  ContactEditFieldNavigationBarView.m
//
//
//  Created by Howard.Lin on 2014/3/4.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "ContactEditFieldNavigationBarView.h"

// Define
#import "WCAppearanceDefine.h"
#import "WCContactViewController+ResourceDefine.h"

// Category
#import "NSString+Additions.h"
#import "PPButton+Factory.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactEditFieldNavigationBarView()

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactEditFieldNavigationBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if(self = [super initWithFrame:frame])
    {
        self.style = PPBarViewStyle_CenteredAbsolute;
        
        //////////////////////////////////////////////////
        
        _backButton = [[PPButton ppButtonWithSystemBackImitation] retain];

        if(_backButton!=nil)
        {
            _backButton.delegate = self;
            _backButton.tag      = ContactEditFieldNavigationBarViewButtonTag_Back;
            
            [_backButton addControlEvents:UIControlEventTouchUpInside];
            [_backButton setImageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
            [_backButton setBackgroundImage:[UIImage imageWithColor:WCAppearanceDefine_ButtonBackgroundColor] forState:UIControlStateHighlighted];
            [self setViews:[NSArray arrayWithObjects:_backButton,nil] forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        
        _doneButton = [[PPButton ppButtonWithIconImageName:ImageNameWCContactViewControllerButtonDone
                                                       tag:ContactEditFieldNavigationBarViewButtonTag_Done
                                                  delegate:self
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                           imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset] retain];
        if(_doneButton!=nil)
        {
            [_doneButton addControlEvents:UIControlEventTouchUpInside];

            [self setViews:[NSArray arrayWithObjects:_doneButton,nil] forBlockType:PPBarViewBlockType_Right];
        }

    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_backButton removeControlEvents:UIControlEventTouchUpInside];
    [_backButton removeFromSuperview];
    [_backButton release];
    _backButton = nil;
    
    [_doneButton removeControlEvents:UIControlEventTouchUpInside];
    [_doneButton removeFromSuperview];
    [_doneButton release];
    _doneButton = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if([self.delegate respondsToSelector:@selector(contactEditFieldSelectionNavigationBarView:responderView:controlEvent:)]==YES)
    {
        [self.delegate contactEditFieldSelectionNavigationBarView:self
                                                    responderView:ppButton
                                                     controlEvent:controlEvent];
    }
}
@end
