//
//  ContactEditFieldCellTitleDataModel.m
//
//  Created by Howard.Lin on 13/10/2.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactEditFieldCellTitleDataModel.h"
#import "NSString+Additions.h"
#import "ContactApperanceDefine.h"
#import "PPContactRowObject.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactEditFieldCellTitleDataModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (NSMutableArray *)defaultTitleArrayForPPContactMainType:(PPContactMainType)contactMainType
{
    NSMutableArray *workArray = [NSMutableArray array];
    
    do
    {
        if(workArray==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        switch (contactMainType)
        {
            case PPContactMainType_Address:
            {
                [workArray addObjectsFromArray:[NSArray arrayWithObjects:WCCV_MLS_Address_Work,WCCV_MLS_Address_Home,WCCV_MLS_Address_Other, nil]];
                
                break;
            }
            case PPContactMainType_Email:
            {
                [workArray addObjectsFromArray:[NSArray arrayWithObjects:WCCV_MLS_Email_Work,WCCV_MLS_Email_Home,WCCV_MLS_Email_Other, nil]];
                
                break;
            }
            case PPContactMainType_Phone:
            {
                [workArray addObjectsFromArray:[NSArray arrayWithObjects:WCCV_MLS_Phone_Work,WCCV_MLS_Phone_Home,WCCV_MLS_Phone_Mobile,WCCV_MLS_Phone_Main,WCCV_MLS_Phone_WorkFax,WCCV_MLS_Phone_HomeFax,WCCV_MLS_Phone_Pager,WCCV_MLS_Phone_GoogleVoice,WCCV_MLS_Phone_iPhone,WCCV_MLS_Phone_Other, nil]];
                
                break;
            }
            case PPContactMainType_URL:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_URL_HomePage,WCCV_MLS_URL_Home,WCCV_MLS_URL_Work,WCCV_MLS_URL_Profile,WCCV_MLS_URL_Blog,WCCV_MLS_URL_Other]];
                
                break;
            }
            case PPContactMainType_Date:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Date_Anniversary,WCCV_MLS_Date_Other]];

                break;
            }
            case PPContactMainType_InstantMessage:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_IM_MSN,
                                                 WCCV_MLS_IM_Skype,
                                                 WCCV_MLS_IM_QQ,WCCV_MLS_IM_Yahoo,
                                                 WCCV_MLS_IM_ICQ,
                                                 WCCV_MLS_IM_GoogleTalk,
                                                 WCCV_MLS_IM_Jabber,
                                                 WCCV_MLS_IM_AIM,
                                                 WCCV_MLS_IM_Other,
                                                 WCCV_MLS_IM_GaduGadu]];

                break;
            }
            case PPContactMainType_Other:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Nickname,WCCV_MLS_UnifiledBusinessNo]];
                
                break;
            }
            case PPContactMainType_SocialNetwork:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_SN_Twitter,
                                                 WCCV_MLS_SN_Facebook,
                                                 WCCV_MLS_SN_Flicker,
                                                 WCCV_MLS_SN_LinkedIn,
                                                 WCCV_MLS_SN_MySpace,
                                                 WCCV_MLS_SN_SinaWebo,
                                                 WCCV_MLS_SN_Other]];
                break;
            }
            default:
            {
                break;
            }
        }
        
    } while (0);
    
    return workArray;
}


//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForPPContactMainType:(PPContactMainType)contactMainType
{
    PPContactSectionModel *sectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
    
    //////////////////////////////////////////////////
    
    do
    {
        if(sectionModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        
        @autoreleasepool
        {
            NSArray *itemTextLabelArray = [ContactEditFieldCellTitleDataModel defaultTitleArrayForPPContactMainType:contactMainType];
            
            if(itemTextLabelArray==nil || itemTextLabelArray.count<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            for(NSInteger rowModelIndex = 0 ; rowModelIndex <itemTextLabelArray.count ; rowModelIndex++)
            {
                PPContactRowObject *contactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                                ppContactLabelType:PPContactLabelType_None
                                                                                         tableViewCellEditingStyle:UITableViewCellEditingStyleNone
                                                                                       ppContactTableViewCellStyle:PPContactTableViewCellStyle_Default
                                                        selected:NO];
                
                PPRowModel *rowModel = [PPRowModel rowModelWithRow:sectionModel.rowModels.count
                                                              text:[itemTextLabelArray objectAtIndex:rowModelIndex]
                                                        detailText:nil
                                                            object:contactRowObject];
                
                
                if(rowModel!=nil)
                {
                    [sectionModel.rowModels addObject:rowModel];
                }
                
            }
        }
    
        
    } while (0);
    
    return sectionModel;
}

@end
