//
//  ContactEditFieldAddedCellDataModel.m
//
//  Created by Howard.Lin on 13/10/2.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactEditFieldAddedCellDataModel.h"
#import "ContactApperanceDefine.h"
#import "NSString+Additions.h"
#import "PPContactRowObject.h"
#import "PPCountryCodeConvert.h"
#import "PPRowModel+Contact.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactEditFieldAddedCellDataModel()

+ (BOOL)isChineseCountryWithCountryCode:(NSString *)countryCode;
+ (BOOL)isJapanCountryWithCountryCode:(NSString *)countryCode;
+ (BOOL)isKorecaCountryWithCountryCode:(NSString *)countryCode;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactEditFieldAddedCellDataModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
+ (BOOL)isChineseCountryWithCountryCode:(NSString *)countryCode;
{
    //!!預設為否，因為default是英文
    BOOL result = NO;

    do
    {
        if(countryCode==nil || countryCode.length<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([[countryCode lowercaseString] isEqualToString:@"tw"])
        {
            result = YES;
        }

    } while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
+ (BOOL)isJapanCountryWithCountryCode:(NSString *)countryCode;
{
    //!!預設為否，因為default是英文
    BOOL result = NO;
    
    do
    {
        if(countryCode==nil || countryCode.length<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([[countryCode lowercaseString] isEqualToString:@"jp"])
        {
            result = YES;
        }
        
    } while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
+ (BOOL)isKorecaCountryWithCountryCode:(NSString *)countryCode;
{
    //!!預設為否，因為default是英文
    BOOL result = NO;
    
    do
    {
        if(countryCode==nil || countryCode.length<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([[countryCode lowercaseString] isEqualToString:@"kr"])
        {
            result = YES;
        }
        
    } while (0);
    
    return result;
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (NSMutableArray *)customTitleArrayForPPContactMainType:(PPContactMainType)contactMainType
                              ppContactModelSubTypeArray:(NSArray *)contactModelSubTypeArray
{
    NSMutableArray *resultArray = nil;

    do
    {
        if(contactMainType==PPContactMainType_None)
        {
            break;
        }
        
        //////////////////////////////////////////////////
    
        
        // 姓名欄位
        if(contactMainType==PPContactMainType_Name)
        {
            resultArray = [NSMutableArray array];

            for (NSNumber *subType in contactModelSubTypeArray)
            {
                
                switch ([subType unsignedIntegerValue])
                {
                    case PPContactSubType_Name_Prefix:
                    {
                        [resultArray addObject:WCCV_MLS_Name_Prefix];
                        break;
                    }
                    case PPContactSubType_Name_MiddleName:
                    {
                        [resultArray addObject:WCCV_MLS_Name_Middle];
                        break;
                    }
                    case PPContactSubType_Name_Surffix:
                    {
                        [resultArray addObject:WCCV_MLS_Name_Suffix];
                        break;
                    }
                    default:
                    {
                        break;
                    }
                }
            }
        }
        else if(contactMainType==PPContactMainType_Phonetic)
        {
            resultArray = [NSMutableArray array];
            
            for (NSNumber *subType in contactModelSubTypeArray)
            {
                switch ([subType unsignedIntegerValue])
                {
                    case PPContactSubType_Name_FirstNamePhonetic:
                    case PPContactSubType_Name_LastNamePhonetic:
                    case PPContactSubType_Company_NamePhonetic:
                    {
                        [resultArray addObject:WCCV_MLS_Phonetic];
                        break;
                    }
                    default:
                    {
                        break;
                    }
                }
                
                //////////////////////////////////////////////////
                
                if(resultArray.count>0)
                {
                    break;
                }
            }

        }
        else
        {
            resultArray = [self defaultTitleArrayForPPContactMainType:contactMainType];
        }

  
    }while (0);
    
    return resultArray;
}


//================================================================================
//
//================================================================================
+ (NSMutableArray *)defaultTitleArrayForPPContactMainType:(PPContactMainType)contactMainType
{
    NSMutableArray *workArray = [NSMutableArray array];
    
    do
    {
        if(workArray==nil)
        {
            break;
        }
        
        NSString *countryCode = [PPCountryCodeConvert defaultCountryCode];
        
        //////////////////////////////////////////////////
        
        switch (contactMainType)
        {
            case PPContactMainType_Name:
            {
                 //////////////////////////////////////////////////
                 
                 if([self isChineseCountryWithCountryCode:countryCode]==NO && [self isJapanCountryWithCountryCode:countryCode]==NO && [self isKorecaCountryWithCountryCode:countryCode]==NO)
                 {
                     [workArray addObjectsFromArray:@[WCCV_MLS_Name_Prefix,WCCV_MLS_Name_Middle,WCCV_MLS_Name_Suffix]];
                 }
                else
                {
                     [workArray addObjectsFromArray:@[WCCV_MLS_Name_Prefix,WCCV_MLS_Name_Suffix]];
                }

                
                break;
            }
            case PPContactMainType_InstantMessage:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_InstantMessage]];

                break;
            }
            case PPContactMainType_PublicNote:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_PublicNote]];
                
                break;
            }
            case PPContactMainType_Note:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Note]];

                break;
            }
            case PPContactMainType_BirthDay:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Date_Birthday]];
                
                break;
            }
            case PPContactMainType_Date:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Date]];

                break;
            }
            case PPContactMainType_Phonetic:
            {
               if([self isJapanCountryWithCountryCode:countryCode]==YES || [self isKorecaCountryWithCountryCode:countryCode]==YES)
               {
                    [workArray addObjectsFromArray:@[WCCV_MLS_Phonetic]];
               }
                
                break;
            }
            case PPContactMainType_UserDefine:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_UserDefine]];
                break;
            }
            default:
            {
                break;
            }
        }

    } while (0);
    
    return workArray;
}


//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForPPContactMainType:(PPContactMainType)contactMainType
{
    PPContactSectionModel *sectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
    
    //////////////////////////////////////////////////
    
    do
    {
        if(sectionModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        
        @autoreleasepool
        {
            NSArray *itemTextLabelArray = [ContactEditFieldAddedCellDataModel defaultTitleArrayForPPContactMainType:contactMainType];
            
            if(itemTextLabelArray==nil || itemTextLabelArray.count<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
        
            for(NSInteger rowModelIndex = 0 ; rowModelIndex <itemTextLabelArray.count ; rowModelIndex++)
            {
                PPContactRowObject *contactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                                ppContactLabelType:PPContactLabelType_None
                                                                                         tableViewCellEditingStyle:UITableViewCellEditingStyleNone
                                                                                       ppContactTableViewCellStyle:PPContactTableViewCellStyle_Default
                                                        selected:NO];
                
                PPRowModel *rowModel = [PPRowModel rowModelWithRow:sectionModel.rowModels.count
                                                              text:[itemTextLabelArray objectAtIndex:rowModelIndex]
                                                        detailText:nil
                                                            object:contactRowObject];
                
                if(rowModel!=nil)
                {
                    [rowModel setPPContactFieldSource:PPContactFieldSource_UserCreate];
                    
                    [sectionModel.rowModels addObject:rowModel];
                }
                
            }
        }
        
        
    } while (0);
    
    return sectionModel;

}

@end
