//
//  WCContactEditFieldSectionController.m
//
//  Created by Howard.Lin on 13/10/1.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "WCContactEditFieldSectionController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCContactEditFieldSectionController()
{
    @private
     ContactEditFieldDataModel *dataModel_;
}

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCContactEditFieldSectionController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
 dataModel   = dataModel_;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [dataModel_ release];
    dataModel_ = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (NSIndexPath *)indexPathForTitle:(NSString *)title forSearching:(BOOL)searching;
{
    NSIndexPath *indexPath = nil;
    
    do
    {
        if(title==nil || title.length<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSMutableArray *sectionModels = [self sectionModelsForSearching:searching];
        
        if(sectionModels==nil || sectionModels.count<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(NSUInteger sectionIndex = 0 ; sectionIndex < sectionModels.count ; sectionIndex++)
        {
            PPSectionModel *sectionModel = [sectionModels objectAtIndex:sectionIndex];
            
            //////////////////////////////////////////////////
            
            if(sectionModel==nil || sectionModel.rowModels==nil || sectionModel.rowModels.count<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(NSUInteger rowIndex = 0 ; rowIndex < sectionModel.rowModels.count ; rowIndex++)
            {
                PPRowModel *rowModel = [sectionModel.rowModels objectAtIndex:rowIndex];
                
                if(rowModel!=nil && [rowModel.text isEqualToString:title]==YES)
                {
                    indexPath = [NSIndexPath indexPathForRow:rowIndex inSection:sectionIndex];
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            if(indexPath!=nil)
            {
                break;
            }
        }
        
    } while (0);
    
    return indexPath;
}


//================================================================================
//
//================================================================================
- (PPContactSectionModel *)contactSetionModelForPPContactMainType:(PPContactMainType)contactMainType
{
    PPContactSectionModel *sectionModel = nil;
    
    //////////////////////////////////////////////////

    do
    {
        if(self.dataModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        sectionModel = [[self.dataModel class] ppContactSectionModelForPPContactMainType:contactMainType];
        
    } while (0);
    
    return sectionModel;
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (NSMutableArray *)sectionModelArrayForDataModel:(ContactEditFieldDataModel *)dataModel
                           ppContactMainTypeArray:(NSArray *)contactMainTypeArray
                      filterPPContactSubTypeArray:(NSArray *)filterContactSubTypeArray
{
    NSMutableArray *sectionModelArray = nil;
    
    do
    {
        if(dataModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        sectionModelArray = [NSMutableArray array];
        
        if(sectionModelArray==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(NSNumber *contactMainType in contactMainTypeArray)
        {
            //!!取得 PPContactMainType_Name 對應的欄位
            NSMutableArray *titleArray = [[dataModel class] defaultTitleArrayForPPContactMainType:[contactMainType unsignedIntegerValue]];
            
            
            if(titleArray==nil || titleArray.count<=0)
            {
                continue;
            }
            
            //////////////////////////////////////////////////
            
            if([contactMainType unsignedIntegerValue]==PPContactMainType_Name || [contactMainType unsignedIntegerValue]==PPContactMainType_Phonetic)
            {
                NSArray *filterTextArray = [[dataModel class]customTitleArrayForPPContactMainType:[contactMainType unsignedIntegerValue]
                                                                       ppContactModelSubTypeArray:filterContactSubTypeArray];
                
                
                if(filterTextArray!=nil && filterTextArray.count>0)
                {
                    //!!移除重覆的title
                    for (NSUInteger titleArrayIndex = 0 ; titleArrayIndex < titleArray.count ; titleArrayIndex++)
                    {
                        for(NSString *compareString in filterTextArray)
                        {
                            NSString *candidateString = [titleArray objectAtIndex:titleArrayIndex];
                            
                            if([candidateString isEqualToString:compareString]==YES)
                            {
                                [titleArray removeObject:candidateString];
                                titleArrayIndex--;
                                break;
                            }
                        }
                    }
                    
                }
            }
            
            //////////////////////////////////////////////////
            
            PPContactSectionModel *sectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:[contactMainType unsignedIntegerValue]];
            
            if(sectionModel!=nil)
            {
                for (NSString *candidateString in titleArray)
                {
                    PPRowModel *rowModel = [[PPRowModel rowModelWithRow:sectionModel.rowModels.count
                                                                   text:candidateString
                                                             detailText:nil
                                                                 object:nil] retain];
                    
                    if(rowModel!=nil)
                    {
                        [sectionModel.rowModels addObject:rowModel];
                    }
                    
                    [rowModel release];
                }
                
                if(sectionModel.rowModels.count>0)
                {
                    sectionModel.section = sectionModelArray.count;
                    
                    [sectionModelArray addObject:sectionModel];
                }
                
            }
            
        }

    } while (0);
    
    return sectionModelArray;

}


@end
