//
//  WCSocialSearchFlowController.m
//  Pods
//
//  Created by sanhue on 2015/8/24.
//
//


#import "WCSocialSearchFlowController.h"

#import "WCContactAccessFlowResourceDefine.h"
#import "NSString+Additions.h"

#import "PPSelectController.h"
#import "WCToastController.h"
#import "PPURLController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
static WCSocialSearchFlowController *staticSocialSearchFlowController;

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, WCSocialSearchStep)
{
    WCSocialSearchStep_SearchType = 0,
    /// 目前都是選第一筆，所以還不用第二層選項
    WCSocialSearchStep_Content,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCSocialSearchFlowController() <PPSelectControllerDelegate>
@property (nonatomic, retain) UIViewController *superViewController;
@property (nonatomic, retain) PPSelectController *ppSelectController;
@property (nonatomic, copy) WCSocialSearchCompletion completion;

@property (nonatomic, assign) WCSocialSearchType searchType;
@property (nonatomic, retain) WCCardModel *currentCardModel;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCSocialSearchFlowController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.ppSelectController = [[[PPSelectController alloc] init] autorelease];
        self.ppSelectController.delegate = self;
        
        //////////////////////////////////////////////////
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.ppSelectController.delegate = nil;
    self.ppSelectController = nil;
    self.superViewController = nil;
    
    self.currentCardModel = nil;
    self.completion = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) prepare data


//==============================================================================
//
//==============================================================================
- (NSArray *)socialSearchArray
{
    return @[WCSocialSearchFlowControllerString_Facebook,
             WCSocialSearchFlowControllerString_LinkedIn,
             WCSocialSearchFlowControllerString_Twitter,
             WCSocialSearchFlowControllerString_SinaWebo];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) entry point


//==============================================================================
//
//==============================================================================
- (void)startFromViewController:(UIViewController *)viewController
{
    self.superViewController = viewController;
    self.ppSelectController.sourceItemStringArray = [self socialSearchArray];
    self.ppSelectController.tag = WCSocialSearchStep_SearchType;
    [self.ppSelectController showFromViewController:viewController animated:YES];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPSelectControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)ppSelectController:(PPSelectController *)selectController itemSelectedIndex:(NSInteger)itemIndex withString:(NSString *)itemString
{
    if (selectController.tag == WCSocialSearchStep_SearchType)
    {
        self.searchType = itemIndex;
        NSString *contentData = nil;
        if ([itemString isEqualToString:WCSocialSearchFlowControllerString_Facebook])
        {
            self.searchType = WCSocialSearchType_Facebook;
            
            //////////////////////////////////////////////////
            NSMutableString *data = [NSMutableString string];
            
            NSString* displayName = [self.currentCardModel displayName];
            if(displayName == nil)
            {
                // 如果沒有姓名，用email
                NSArray* emailItems = [self.currentCardModel fieldArrayWithType:WC_FT_Email];
                if([emailItems count]>0)
                {
                    WCFieldModel *fieldModel=[emailItems objectAtIndex:0];
                    [data appendString:fieldModel.value];
                }
            }
            else
            {
                [data appendString:displayName];
            }
                             
            contentData = [NSString stringWithString:data];
            
            //////////////////////////////////////////////////
            // 沒資料要顯示toast
            if ([contentData length]==0)
            {
                __block typeof(self) blockSelf = self;
                
                dispatch_async(dispatch_get_main_queue(), ^{
                    [WCToastController showMessageToastFromSuperView:blockSelf.superViewController.view
                                                         withMessage:WCSocialSearchFlowControllerString_NoFacebookData
                                                            position:PPToastPositionCenter];
                });
            }
        }
        else if ([itemString isEqualToString:WCSocialSearchFlowControllerString_LinkedIn])
        {
            self.searchType = WCSocialSearchType_LinkedIn;
            
            //////////////////////////////////////////////////
            
            WCFieldModel *fieldModel = nil;
            NSArray* nameItems = nil;
            nameItems = [self.currentCardModel fieldArrayWithType:WC_FT_Name];
            
            if ([nameItems count]>=1)
            {
                fieldModel = [nameItems objectAtIndex:0];
                NSString* firstName = [fieldModel valueWithSubType2:WC_FST2_Name_First];
                NSString* lastName = [fieldModel valueWithSubType2:WC_FST2_Name_Last];
                
                contentData =  [PPURLController parameterForLinkedInWithFirstName:firstName lastName:lastName];
            }
            
            //////////////////////////////////////////////////
            // 沒資料要顯示toast
            if ([contentData length]==0)
            {
                __block typeof(self) blockSelf = self;
                
                dispatch_async(dispatch_get_main_queue(), ^{
                    [WCToastController showMessageToastFromSuperView:blockSelf.superViewController.view
                                                         withMessage:WCSocialSearchFlowControllerString_NoLinkinData
                                                            position:PPToastPositionCenter];
                });
            }
        }
        else if ([itemString isEqualToString:WCSocialSearchFlowControllerString_SinaWebo])
        {
            self.searchType = WCSocialSearchType_SinaWebo;
            
            //////////////////////////////////////////////////
            
            contentData = [self.currentCardModel displayName];
            
            //////////////////////////////////////////////////
            // 沒資料要顯示toast
            if ([contentData length]==0)
            {
                __block typeof(self) blockSelf = self;
                
                dispatch_async(dispatch_get_main_queue(), ^{
                    [WCToastController showMessageToastFromSuperView:blockSelf.superViewController.view
                                                         withMessage:WCSocialSearchFlowControllerString_NoSinaWeboData
                                                            position:PPToastPositionCenter];
                });
            }
        }
        else
        {
            self.searchType = WCSocialSearchType_Twitter;
            
            //////////////////////////////////////////////////
            NSMutableString *data = [NSMutableString string];
            
            NSString* displayName = [self.currentCardModel displayName];
            if(displayName == nil)
            {
                // 如果沒有姓名，用email
                NSArray* emailItems = [self.currentCardModel fieldArrayWithType:WC_FT_Email];
                if([emailItems count]>0)
                {
                    WCFieldModel *fieldModel=[emailItems objectAtIndex:0];
                    [data appendString:fieldModel.value];
                }
            }
            else
            {
                [data appendString:displayName];
            }
            
            contentData = [NSString stringWithString:data];
            //////////////////////////////////////////////////
            // 沒資料要顯示toast
            if ([contentData length]==0)
            {
                __block typeof(self) blockSelf = self;
                
                dispatch_async(dispatch_get_main_queue(), ^{
                    [WCToastController showMessageToastFromSuperView:blockSelf.superViewController.view
                                                         withMessage:WCSocialSearchFlowControllerString_NoTwitterData
                                                            position:PPToastPositionCenter];
                });
            }
        }
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_main_queue(), ^{
            if (self.completion && [contentData length]>0)
            {
                self.completion (self.searchType, contentData);
            }
        });
        
//        //////////////////////////////////////////////////
//        dispatch_async(dispatch_get_main_queue(), ^{
//            [staticSocialSearchFlowController release];
//            staticSocialSearchFlowController = nil;
//        });
    }
    else
    {
        
    }

}


//================================================================================
//
//================================================================================
- (void)ppSelectControllerDidDismiss:(PPSelectController *)selectController
{
    self.ppSelectController = nil;
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public methods


//==============================================================================
//
//==============================================================================
+ (void)startFromViewController:(UIViewController *)viewController
                      cardModel:(WCCardModel *)cardModel
                     completion:(WCSocialSearchCompletion)completion;
{
    [staticSocialSearchFlowController release];
    staticSocialSearchFlowController = [[WCSocialSearchFlowController alloc] init];
    
    staticSocialSearchFlowController.completion = completion;
    staticSocialSearchFlowController.currentCardModel = cardModel;
    [staticSocialSearchFlowController startFromViewController:viewController];
    
    
}


//==============================================================================
//
//==============================================================================
+ (void)endOfSocialSearchFlowController
{
    [staticSocialSearchFlowController release];
    staticSocialSearchFlowController = nil;
}



@end
