//
//  WCReRecognitionSelectViewController.m
//  Pods
//
//  Created by sanhue on 2015/9/6.
//
//

#import "WCReRecognitionSelectViewController.h"

// define
#import "WCContactAccessFlowResourceDefine.h"

// categories
#import "UIView+Appearance.h"

#import "WCKernelRecogLangModel.h"

// views
#import "PPTableView.h"
#import "PPButton+Factory.h"
#import "PPBarView.h"
#import "PPBusyView.h"

// controller
#import "PPSelectController.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, WCReRecognitionSelectViewControllerButtonTag)
{
    WCReRecognitionSelectViewControllerButtonTag_Cancel=0,
    WCReRecognitionSelectViewControllerButtonTag_Recog,
};

typedef NS_ENUM(NSInteger, WCReRecognitionSelectViewControllerRowID)
{
    WCReRecognitionSelectViewControllerRowID_Front=0,
    WCReRecognitionSelectViewControllerRowID_Back,
    WCReRecognitionSelectViewControllerRowID_Count
};


static NSInteger const LabelHeight = 30;
static NSInteger const ButtonHeight = 44;
static NSInteger const CellHeight = 60;
////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCReRecognitionSelectViewController () <UITableViewDataSource, UITableViewDelegate, PPButtonDelegate, PPSelectControllerDelegate>

#pragma mark views
@property (nonatomic, retain) PPBusyView *ppBusyView;
@property (nonatomic, retain) UIView *backgroundView;

@property (nonatomic, retain) UIView *topSeparatorView;
@property (nonatomic, retain) UIView *bottomSeparatorView;
@property (nonatomic, retain) UIView *centerSeparatorView;

@property (nonatomic, retain) UILabel *alertLabel;
@property (nonatomic, retain) UILabel *messageLabel;

@property (nonatomic, retain) PPTableView *ppLanguageSelectView;
@property (nonatomic, retain) PPButton *cancelButton;
@property (nonatomic, retain) PPButton *recogButton;

#pragma mark controller
@property (nonatomic, retain) PPSelectController *ppSelectController;

#pragma mark data
@property (nonatomic, retain) NSArray *backgroungViewLayoutConstraints;
@property (nonatomic, retain) NSArray *layoutConstraints;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCReRecognitionSelectViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        [self.view setBackgroundColor:[UIColor colorWithRed:0.6 green:0.6 blue:0.6 alpha:0.6]];
        
        //////////////////////////////////////////////////
        self.alertTitle = WCReRecognitionFlowControllerString_Title;
        self.message = WCReRecognitionFlowControllerString_Message;
        
        //////////////////////////////////////////////////
        
        self.showRecogSideInCell = YES;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    [self.ppBusyView removeFromSuperview];
    self.ppBusyView = nil;

    [self removeMainUI];
    
    self.frontRecogLanguages = nil;
    self.backRecogLanguages = nil;
    
    self.frontCardImage = nil;
    self.backCardImage = nil;
    
    self.ppSelectController = nil;
    
    self.alertTitle = nil;
    self.message = nil;
    
    self.delegate = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}








////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [self prepareMainUI];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    self.backgroundView = [[[UIView alloc] init] autorelease];
    
    if (self.backgroundView)
    {
        [self.backgroundView setTranslatesAutoresizingMaskIntoConstraints:NO];
        [self.backgroundView setBackgroundColor:[UIColor whiteColor]];
        [self.backgroundView setCornerRadius:10];
        
        [self.view addSubview:self.backgroundView];
    }
    
    //////////////////////////////////////////////////

    self.alertLabel = [[[UILabel alloc] init] autorelease];
    
    if (self.alertLabel)
    {
        [self.alertLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
        //////////////////////////////////////////////////
        
        [self.alertLabel setTextAlignment:NSTextAlignmentCenter];
        [self.alertLabel setFont:[UIFont boldSystemFontOfSize:20]];
        [self.alertLabel setLineBreakMode:NSLineBreakByTruncatingTail];

        [self.alertLabel setText:self.alertTitle];
        //////////////////////////////////////////////////
        [self.backgroundView addSubview:self.alertLabel];
    }
    
    //////////////////////////////////////////////////
    
    self.messageLabel = [[[UILabel alloc] init] autorelease];
    
    if (self.messageLabel)
    {
        [self.messageLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
        //////////////////////////////////////////////////
        
        [self.messageLabel setTextAlignment:NSTextAlignmentCenter];
        [self.messageLabel setFont:[UIFont systemFontOfSize:16]];
        [self.messageLabel setLineBreakMode:NSLineBreakByWordWrapping];
        [self.messageLabel setNumberOfLines:0];
        [self.messageLabel setText:self.message];
//        [self.messageLabel sizeToFit];
        
        //////////////////////////////////////////////////
        [self.backgroundView addSubview:self.messageLabel];
    }

    //////////////////////////////////////////////////
    
    self.topSeparatorView = [[[UIView alloc] init] autorelease];
    
    if (self.topSeparatorView)
    {
        [self.topSeparatorView setTranslatesAutoresizingMaskIntoConstraints:NO];
        [self.topSeparatorView setBackgroundColor:WCCAFC_SeparatorColor];
        
        [self.backgroundView addSubview:self.topSeparatorView];
    }

    //////////////////////////////////////////////////
    
    self.bottomSeparatorView = [[[UIView alloc] init] autorelease];
    
    if (self.bottomSeparatorView)
    {
        [self.bottomSeparatorView setTranslatesAutoresizingMaskIntoConstraints:NO];
        [self.bottomSeparatorView setBackgroundColor:WCCAFC_SeparatorColor];

        [self.backgroundView addSubview:self.bottomSeparatorView];
    }

    //////////////////////////////////////////////////
    
    self.centerSeparatorView = [[[UIView alloc] init] autorelease];
    
    if (self.centerSeparatorView)
    {
        [self.centerSeparatorView setTranslatesAutoresizingMaskIntoConstraints:NO];
        [self.centerSeparatorView setBackgroundColor:WCCAFC_SeparatorColor];
        
        [self.backgroundView addSubview:self.centerSeparatorView];
    }

    //////////////////////////////////////////////////
    
    self.ppLanguageSelectView = [[[PPTableView alloc] init] autorelease];
    
    if (self.ppLanguageSelectView)
    {
        [self.ppLanguageSelectView setTranslatesAutoresizingMaskIntoConstraints:NO];
        //////////////////////////////////////////////////
        [self.ppLanguageSelectView setDataSource:self];
        [self.ppLanguageSelectView setDelegate:self];
        
        [self.ppLanguageSelectView setScrollEnabled:NO];
        
        //////////////////////////////////////////////////
        [self.backgroundView addSubview:self.ppLanguageSelectView];
    }
    
    //////////////////////////////////////////////////
    
    self.cancelButton = [[[PPButton alloc] init] autorelease];
    
    if (self.cancelButton)
    {
        [self.cancelButton setTranslatesAutoresizingMaskIntoConstraints:NO];
        //////////////////////////////////////////////////
        [self.cancelButton setDelegate:self];
        [self.cancelButton addControlEvents:UIControlEventTouchUpInside];
        [self.cancelButton setTag:WCReRecognitionSelectViewControllerButtonTag_Cancel];

        [self.cancelButton setTitleColor:WCCAFC_ToolBarColor forState:UIControlStateNormal];
        [self.cancelButton setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
        
        [self.cancelButton setTitle:WCReRecognitionFlowControllerString_Cancel maxWidth:0];
        
        //////////////////////////////////////////////////
        [self.backgroundView addSubview:self.cancelButton];
    }
    //////////////////////////////////////////////////
    
    self.recogButton = [[[PPButton alloc] init] autorelease];
    
    if (self.recogButton)
    {
        [self.recogButton setTranslatesAutoresizingMaskIntoConstraints:NO];
        //////////////////////////////////////////////////
        [self.recogButton setDelegate:self];
        [self.recogButton addControlEvents:UIControlEventTouchUpInside];
        [self.recogButton setTag:WCReRecognitionSelectViewControllerButtonTag_Recog];
        
        [self.recogButton setTitleColor:WCCAFC_ToolBarColor forState:UIControlStateNormal];
        [self.recogButton setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
        
        [self.recogButton setTitle:WCReRecognitionFlowControllerString_Recognize maxWidth:0];
        
        //////////////////////////////////////////////////
        [self.backgroundView addSubview:self.recogButton];
    }

    
    //////////////////////////////////////////////////
    [self resetBGViewLayoutConstraints];
    [self resetLayoutConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    [self removeLayoutConstraints];
    [self removeBGViewLayoutConstraints];
    //////////////////////////////////////////////////
    [self.centerSeparatorView removeFromSuperview];
    self.centerSeparatorView = nil;
    
    [self.topSeparatorView removeFromSuperview];
    self.topSeparatorView = nil;
    
    [self.bottomSeparatorView removeFromSuperview];
    self.bottomSeparatorView = nil;
    
    [self.alertLabel removeFromSuperview];
    self.alertLabel = nil;
    
    [self.messageLabel removeFromSuperview];
    self.messageLabel = nil;
    
    [self.ppLanguageSelectView removeFromSuperview];
    self.ppLanguageSelectView = nil;
    
    [self.cancelButton removeFromSuperview];
    self.cancelButton = nil;
    
    [self.recogButton removeFromSuperview];
    self.recogButton = nil;
    
    //////////////////////////////////////////////////
    [self.backgroundView removeFromSuperview];
    self.backgroundView = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetBGViewLayoutConstraints
{
    //////////////////////////////////////////////////
    CGFloat viewHeight = [self viewHeight];
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    CGFloat widthRatio = 0.8;
    if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
    {
        widthRatio = 0.6;
    }
    // 設定backgroundView
    [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.backgroundView
                                                              attribute:NSLayoutAttributeCenterX
                                                              relatedBy:NSLayoutRelationEqual
                                                                 toItem:self.view
                                                              attribute:NSLayoutAttributeCenterX
                                                             multiplier:1.0
                                                               constant:0.0]];
    
    [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.backgroundView
                                                              attribute:NSLayoutAttributeCenterY
                                                              relatedBy:NSLayoutRelationEqual
                                                                 toItem:self.view
                                                              attribute:NSLayoutAttributeCenterY
                                                             multiplier:1.0
                                                               constant:0.0]];
    
    [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.backgroundView
                                                              attribute:NSLayoutAttributeWidth
                                                              relatedBy:NSLayoutRelationEqual
                                                                 toItem:self.view
                                                              attribute:NSLayoutAttributeWidth
                                                             multiplier:widthRatio
                                                               constant:0.0]];
    
    [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.backgroundView
                                                              attribute:NSLayoutAttributeHeight
                                                              relatedBy:NSLayoutRelationEqual
                                                                 toItem:nil
                                                              attribute:NSLayoutAttributeNotAnAttribute
                                                             multiplier:1.0
                                                               constant:viewHeight]];
    
    if ([layoutConstraints count])
    {
        self.backgroungViewLayoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.backgroungViewLayoutConstraints];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeBGViewLayoutConstraints
{
    if (self.backgroungViewLayoutConstraints)
    {
        [self.view removeConstraints:self.backgroungViewLayoutConstraints];
        self.backgroungViewLayoutConstraints = nil;
    }
}


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    if(self.alertLabel==nil||
       self.messageLabel==nil||
       self.ppLanguageSelectView==nil||
       self.cancelButton==nil||
       self.recogButton==nil||
       self.topSeparatorView==nil||
       self.bottomSeparatorView==nil||
       self.centerSeparatorView==nil)
    {
        return ;
    }
    
    [self removeLayoutConstraints];
    
    NSDictionary *views = @{@"alertLabel":self.alertLabel,
                            @"messageLabel":self.messageLabel,
                            @"ppLanguageSelectView":self.ppLanguageSelectView,
                            @"cancelButton":self.cancelButton,
                            @"recogButton":self.recogButton,
                            @"topSeparatorView":self.topSeparatorView,
                            @"bottomSeparatorView":self.bottomSeparatorView,
                            @"centerSeparatorView":self.centerSeparatorView};
    
    NSInteger messgageHeight = LabelHeight*3;
    NSInteger tableHeight = CellHeight*[self tableRowCount];
    NSDictionary *metrics = @{@"normalHeight":@(LabelHeight),
                              @"buttonHeight":@(ButtonHeight),
                              @"messageLabelHeight":@(messgageHeight),
                              @"tableHeight":@(tableHeight)};

    //////////////////////////////////////////////////
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"|-[alertLabel]-|"
                                                                                  options:NSLayoutFormatDirectionLeftToRight
                                                                                  metrics:metrics
                                                                                     views:views]];

    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"|-[messageLabel]-|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];

    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"|[topSeparatorView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];

    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"|[ppLanguageSelectView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];

    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"|[bottomSeparatorView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];

    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"|[cancelButton][centerSeparatorView(1)][recogButton(==cancelButton)]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];

    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[alertLabel(normalHeight)][messageLabel(messageLabelHeight)][topSeparatorView(1)][ppLanguageSelectView(tableHeight)][bottomSeparatorView(1)][cancelButton(buttonHeight)]"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];

    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[alertLabel(normalHeight)][messageLabel(messageLabelHeight)][topSeparatorView(1)][ppLanguageSelectView(tableHeight)][bottomSeparatorView(1)][recogButton(buttonHeight)]"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];

    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[alertLabel(normalHeight)][messageLabel(messageLabelHeight)][topSeparatorView(1)][ppLanguageSelectView(tableHeight)][bottomSeparatorView(1)][centerSeparatorView(buttonHeight)]"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (private)


//==============================================================================
//
//==============================================================================
- (NSInteger)tableRowCount
{
    NSInteger rowCount = 0;
    if (self.frontCardImage)
    {
        rowCount ++;
    }
    
    if (self.backCardImage)
    {
        rowCount ++;
    }
    return rowCount;
}


//==============================================================================
//
//==============================================================================
- (NSInteger)viewHeight
{
    NSInteger viewHeight = 0;
    viewHeight += LabelHeight;
    viewHeight += LabelHeight*3;//self.messageLabel.bounds.size.height;

    viewHeight += CellHeight*[self tableRowCount];
    viewHeight += ButtonHeight;

    return viewHeight;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) busy


//==============================================================================
//
//==============================================================================
- (void)setBusy:(NSNumber *)busy
{
    if ([busy boolValue])
    {
        self.ppBusyView = [[[PPBusyView alloc] initWithSuperView:nil] autorelease];
        [self.ppBusyView setStyle:PPBusyViewStyle_Border];
    }
    else
    {
        [self.ppBusyView removeFromSuperview];
        self.ppBusyView = nil;
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) select controller


//==============================================================================
//
//==============================================================================
- (NSArray *)selectItemsFromRecogLanguages:(NSArray *)recogLanguages
{
    NSMutableArray *selectItems = [NSMutableArray array];
    for (WCKernelRecogLangModel *langModel in recogLanguages)
    {
        [selectItems addObject:langModel.localizedString];
    }
    
    return [NSArray arrayWithArray:selectItems];
}



//==============================================================================
//
//==============================================================================
- (void)showSelectControllerWithTag:(NSInteger)tag items:(NSArray *)items
{
    self.ppSelectController = [[[PPSelectController alloc] init] autorelease];
    
    if (self.ppSelectController)
    {
        self.ppSelectController.tag = tag;
        self.ppSelectController.delegate = self;
        self.ppSelectController.sourceItemStringArray = items;
        
        [self.ppSelectController showFromViewController:self animated:YES];
    }
}


//==============================================================================
//
//==============================================================================
- (NSInteger)frontRecogIDWithLocalizedString:(NSString *)localizedString
{
    for (WCKernelRecogLangModel *langModel in self.frontRecogLanguages)
    {
        if ([langModel.localizedString isEqualToString:localizedString])
        {
            return langModel.langCode;
        }
    }
    
    return -1;
}


//==============================================================================
//
//==============================================================================
- (NSInteger)backRecogIDWithLocalizedString:(NSString *)localizedString
{
    for (WCKernelRecogLangModel *langModel in self.backRecogLanguages)
    {
        if ([langModel.localizedString isEqualToString:localizedString])
        {
            return langModel.langCode;
        }
    }
    
    return -1;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) button action



//==============================================================================
//
//==============================================================================
- (void)onClickRecog
{
    if ([self.delegate respondsToSelector:@selector(requestRecognizeWithFrontSourceModel:backSourceModel:)]==NO)
    {
        // 要實作|requestRecognizeWithFrontSourceModel:backSourceModel:|
        return ;
    }
    
    // 進入辨識流程
    [self setBusy:@(YES)];
    
    __block typeof(self) blockSelf = self;
    
    NSInteger frontRecogLangID = 0;
    NSInteger backRecogLangID = 0;
    
    UITableViewCell *frontCell = [self.ppLanguageSelectView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:WCReRecognitionSelectViewControllerRowID_Front inSection:0]];
    
    if(self.showRecogSideInCell)
    {
        frontRecogLangID = [self frontRecogIDWithLocalizedString:frontCell.detailTextLabel.text];
    }
    else
    {
        frontRecogLangID = [self frontRecogIDWithLocalizedString:frontCell.textLabel.text];
    }

    UITableViewCell *backCell = [self.ppLanguageSelectView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:WCReRecognitionSelectViewControllerRowID_Back inSection:0]];
    backRecogLangID = [self frontRecogIDWithLocalizedString:backCell.detailTextLabel.text];
    if(self.showRecogSideInCell)
    {
        backRecogLangID = [self frontRecogIDWithLocalizedString:backCell.detailTextLabel.text];
    }
    else
    {
        backRecogLangID = [self frontRecogIDWithLocalizedString:backCell.textLabel.text];
    }
    
    //////////////////////////////////////////////////
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                
        // 建立正面辨識資料
        WCRecogSourceModel *frontSourceModel = nil;
        
        if (self.frontCardImage)
        {
            frontSourceModel =  [[WCRecogSourceModel alloc] init];
            if (frontSourceModel)
            {
                frontSourceModel.cardID = @"";
                frontSourceModel.imageType = WC_IT_FrontSide;
                frontSourceModel.imageSource = self.frontCardImage;
                frontSourceModel.recogLang = frontRecogLangID;
                frontSourceModel.hasRecogRect = YES;
                frontSourceModel.dockMode = NO;
            }
        }
        
        //////////////////////////////////////////////////
        // 建立反面辨識資料
        
        WCRecogSourceModel *backSourceModel = nil;
        
        if (self.backCardImage)
        {
            backSourceModel =  [[WCRecogSourceModel alloc] init];
            if (backSourceModel)
            {
                backSourceModel.cardID = @"";
                backSourceModel.imageType = WC_IT_BackSide;
                backSourceModel.imageSource = self.backCardImage;
                backSourceModel.recogLang = backRecogLangID;
                backSourceModel.hasRecogRect = YES;
                backSourceModel.dockMode = NO;
                
            }
        }
        
        
        [self.delegate requestRecognizeWithFrontSourceModel:frontSourceModel backSourceModel:backSourceModel];
        
        [backSourceModel release];
        [frontSourceModel release];
        
        
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            [blockSelf setBusy:@(NO)];
            [blockSelf onClickCancel];
            if ([blockSelf.delegate respondsToSelector:@selector(didFinishWithViewController:)])
            {
                [blockSelf.delegate didFinishWithViewController:self];
            }
        });
    });
}


//==============================================================================
//
//==============================================================================
- (void)onClickCancel
{
    [self.view removeFromSuperview];
}








////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        switch (ppButton.tag)
        {
            case WCReRecognitionSelectViewControllerButtonTag_Recog:
            {
                [blockSelf onClickRecog];
                break;
            }
            case WCReRecognitionSelectViewControllerButtonTag_Cancel:
            default:
            {
                [blockSelf onClickCancel];
                if ([blockSelf.delegate respondsToSelector:@selector(didCancelWithViewController:)])
                {
                    [blockSelf.delegate didCancelWithViewController:self];
                }
                break;
            }
        }
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPSelectControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)ppSelectController:(PPSelectController *)selectController itemSelectedIndex:(NSInteger)itemIndex withString:(NSString *)itemString
{
    // 切換設定
    UITableViewCell *cell = [self.ppLanguageSelectView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:selectController.tag inSection:0]];
    
    if(self.showRecogSideInCell)
    {
        [cell.detailTextLabel setText:itemString];
    }
    else
    {
        [cell.textLabel setText:itemString];
    }
}


//================================================================================
//
//================================================================================
- (void)ppSelectControllerDidDismiss:(PPSelectController *)selectController
{
    self.ppSelectController = nil;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDataSource


//==============================================================================
//
//==============================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [self tableRowCount];
}


//==============================================================================
//
//==============================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"Cell"];
    if (cell==nil)
    {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:@"Cell"] autorelease];
    }
    

    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    [cell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];
    [cell.detailTextLabel setTextColor:WCAppearanceDefine_CellTitleColor];
    
    switch (indexPath.row)
    {
        case WCReRecognitionSelectViewControllerRowID_Front:
        {
            if(self.showRecogSideInCell)
            {
                [cell.textLabel setText:WCReRecognitionFlowControllerString_FrontRecogLanguage];
                WCKernelRecogLangModel *langModel = [self.frontRecogLanguages firstObject];
                if  (langModel)
                {
                    [cell.detailTextLabel setText:langModel.localizedString];
                }
            }
            else
            {
                WCKernelRecogLangModel *langModel = [self.frontRecogLanguages firstObject];
                if  (langModel)
                {
                    [cell.textLabel setText:langModel.localizedString];
                }
            }
            break;
        }
        case WCReRecognitionSelectViewControllerRowID_Back:
        {
            if(self.showRecogSideInCell)
            {
                [cell.textLabel setText:WCReRecognitionFlowControllerString_BackRecogLanguage];
                WCKernelRecogLangModel *langModel = [self.backRecogLanguages firstObject];
                if  (langModel)
                {
                    [cell.detailTextLabel setText:langModel.localizedString];
                }
            }
            else
            {
                WCKernelRecogLangModel *langModel = [self.backRecogLanguages firstObject];
                if  (langModel)
                {
                    [cell.textLabel setText:langModel.localizedString];
                }
            }
            break;
        }
        default:
            break;
    }
    
    return cell;
}



//==============================================================================
//
//==============================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return CellHeight;
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDelegate


//==============================================================================
//
//==============================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        switch (indexPath.row)
        {
            case WCReRecognitionSelectViewControllerRowID_Front:
            {
                [blockSelf showSelectControllerWithTag:indexPath.row items:[blockSelf selectItemsFromRecogLanguages:blockSelf.frontRecogLanguages]];
                break;
            }
            case WCReRecognitionSelectViewControllerRowID_Back:
            {
                [blockSelf showSelectControllerWithTag:indexPath.row items:[blockSelf selectItemsFromRecogLanguages:blockSelf.backRecogLanguages]];

                break;
            }
            default:
                break;
        }
    });
}





@end
