//
//  WCCardImageController.h
//  WorldCard series
//
//  Created by  Eddie on 2012/3/22.
//  Copyright 2011 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "WCImageDefine.h"
#import "CrossPlatformDefine.h"


@interface WCCardImageController : NSObject 
{
	NSString		*baseDir_;
	NSFileManager	*fileManager_;
}

// WCCardImageController initialize
- (id)initWithDirPath:(NSString *)dirPath;

// get image path
- (NSString *)imagePathWithCardID:(NSString *)cardID type:(WC_ImageType)type subtype:(WC_ImageSubType)subtype;

// check if image exist
- (BOOL)hasImageWithCardID:(NSString *)cardID type:(WC_ImageType)type;

// get image
- (CPImage *)copyImageWithCardID:(NSString *)cardID type:(WC_ImageType)type subtype:(WC_ImageSubType)subtype;

// get image data
- (NSData *)copyImageDataWithCardID:(NSString *)cardID type:(WC_ImageType)type subtype:(WC_ImageSubType)subtype;

//========================
//wcm 6.0.0 新增儲存重新辨識用的名片圖 get rerecogn image
//========================
- (CPImage *)copyRerecognImageWithCardID:(NSString *)cardID type:(WC_ImageType)type;

//========================
//wcm 6.0.0 新增儲存重新辨識用的名片圖  get rerecogn image data
//========================
- (NSData *)copyRerecognImageDataWithCardID:(NSString *)cardID type:(WC_ImageType)type;

// set image
- (BOOL)setImage:(CPImage *)image withCardID:(NSString *)cardID type:(WC_ImageType)type error:(NSError **)error;

// set image data
- (BOOL)setImageData:(NSData *)imageData withCardID:(NSString *)cardID type:(WC_ImageType)type error:(NSError **)error;

//========================
//wcm 6.0.0 新增儲存重新辨識用的名片圖 set rerecogn image
//========================
- (BOOL)setRerecognImage:(CPImage *)image withCardID:(NSString *)cardID type:(WC_ImageType)type error:(NSError **)error;

//========================
//wcm 6.0.0 新增儲存重新辨識用的名片圖  set rerecogn image data
//========================
- (BOOL)setRerecognImageData:(NSData *)imageData withCardID:(NSString *)cardID type:(WC_ImageType)type error:(NSError **)error;

// delete image
- (BOOL)removeImageWithCardID:(NSString *)cardID type:(WC_ImageType)type;

//========================
//wcm 6.0.0 新增儲存重新辨識用的名片圖  delete image
//========================
- (BOOL)removeRerecognImageWithCardID:(NSString *)cardID;

// change cardID
- (BOOL)moveImageFromCardID:(NSString *)srcCardID toCardID:(NSString *)dstCardID withImageType:(WC_ImageType)type;

// get image size
- (CGSize)imageSizeWithCardID:(NSString *)cardID type:(WC_ImageType)type subtype:(WC_ImageSubType)subtype;

// reset small image (browse/thumbnail)
- (BOOL)resetSmallImageWithCardID:(NSString *)cardID type:(WC_ImageType)type subtype:(WC_ImageSubType)subtype error:(NSError **)error;

// rotate and resize image
- (CPImage *)rotateAndResizeImage:(CPImage *)srcImage rotateDegree:(NSInteger)rotateDegree maxSize:(NSInteger)maxSize;


@end
