//
//  WCCaptureFlowControllerDelegate.h
//  
//
//  Created by Howard on 2016/1/12.
//
//

#import <Foundation/Foundation.h>
#import "WCCaptureViewController+TypeDefine.h"

@class WCCaptureViewController;
@class WCCaptureFlowController;

@protocol WCCaptureFlowControllerDelegate <NSObject>

@optional

/**
 *  QR Code 辨識結果
 *
 *  @param captureFlowController 委託者
 *  @param string                結果
 */
- (void)captureFlowController:(WCCaptureFlowController *)captureFlowController
     didRecongizeQRCodeString:(NSString *)string;


/**
 *  新增名片，基座拍照
 *
 *  @param captureFlowController 委託者
 *  @param image                 圖檔
 *  @param recogLanguage         辨識語系
 *  @param captureSide           正反面
 *  @param isDoubleSideMode      單雙張模式
 */
- (void)captureFlowController:(WCCaptureFlowController *)captureFlowController
      dockModeDidCaptureImage:(UIImage *)image
                recogLanguage:(NSString *)recogLanguage
                  captureSide:(WCCaptureViewController_CaptureSide)captureSide
             isDoubleSideMode:(BOOL)isDoubleSideMode;

/**
 *  新增名片，手動拍照
 *
 *  @param captureFlowController 委託者
 *  @param image                 圖檔
 *  @param recogSourceModel      辨識模型
 *  @param isFinal               最後一張
 *
 *  處理方式:存圖，更新辨識模型
 */
- (void)captureFlowController:(WCCaptureFlowController *)captureFlowController
     fromCaptureViewControler:(WCCaptureViewController *)captureViewController
     manualModeDidSelectImage:(UIImage *)image
             recogSourceModel:(WCRecogSourceModel *)recogSourceModel
                      isFinal:(BOOL)isFinal;


/**
 *  單張手動模式，選擇圖片
 *
 *  @param captureFlowController 委託者
 *  @param image                 圖檔
 */
- (void)captureFlowController:(WCCaptureFlowController *)captureFlowController
      singleManualSelectImage:(UIImage *)image;


/**
 *  退出相機視圖,新增圖片(基座,手動,QRCode only)
 *
 *  @param captureFlowController 委託者
 *  @param captureViewController 目前視圖
 */
- (void)captureFlowControllerDidClickCancel:(WCCaptureFlowController *)captureFlowController
                  fromCaptureViewController:(WCCaptureViewController *)captureViewController;


/**
 *  相機按ok 新增圖片(基座,手動,QRCode only)
 *
 *  @param captureFlowController 委託者
 *  @param captureViewController 目前視圖
 */
- (void)captureFlowControllerDidClickDone:(WCCaptureFlowController *)captureFlowController
                fromCaptureViewController:(WCCaptureViewController *)captureViewController;

/**
 *  到達上限，流程結束，選擇馬上訂閱
 *
 *  @param captureFlowController 委託者
 *  處理方式:釋放元件，並開啟訂閱介面
 */
- (void)captureFlowControllerDidFinishWithSubscribe:(WCCaptureFlowController *)captureFlowController;


/**
 *  流程結束
 *
 *  @param captureFlowController 委託者
 *  處理方式:釋放元件
 */
- (void)captureFlowControllerDidFinish:(WCCaptureFlowController *)captureFlowController;



/**
 *  詢問上層是否顯示此訊息
 *
 *  @param error 錯誤
 *
 *  @return YES, Show
 */
- (BOOL)captureFlowRequestShowError:(NSError *)error;


/**
 *  詢問上層有無錯誤標題
 *
 *  @param error 錯誤
 *
 *  @return 標題
 */
- (NSString *)captureFlowRequestTitleWithError:(NSError *)error;


/**
 *  詢問上層有無錯誤的解釋
 *
 *  @param error 錯誤
 *
 *  @return 解釋
 */
- (NSString *)captureFlowRequestMessageWithError:(NSError *)error;


/**
 *  基座模式，相機顯示Promotion
 *
 *  @param captureFlowController 委託者
 *  @param captureViewController 相機實體
 */
- (void)captureFlowControllerShowDockPromotion:(WCCaptureFlowController *)captureFlowController
                     fromCaptureViewController:(WCCaptureViewController *)captureViewController;
@end
