//
//  WCCaptureFlowControllerDatasource.h
//  
//
//  Created by Howard on 2016/1/12.
//
//

#import <Foundation/Foundation.h>

// Define
#import "WCCaptureViewController+TypeDefine.h"

// Model
#import "WCRecogSourceModel.h"


@protocol WCCaptureFlowControllerDatasource <NSObject>

@optional

/**
 *  正反面辨識語系
 *
 *  @param captureSide 正反面
 *
 *  @return 辨識語系
 */
- (NSArray *)recogLanguagesWithCaptureSide:(WCCaptureViewController_CaptureSide)captureSide;


/**
 *  目前圖片張數
 *
 *  @return 圖片張數
 */
- (NSInteger)numberOfCard;


/**
 *  辨識名稱對應辨識語系
 *
 *  @param recogTitle 辨識名稱
 *
 *  @return 辨識語系
 */
- (NSUInteger)recogLangCodeWithRecogTitle:(NSString *)recogTitle;


/**
 *  辨識語系模型
 *
 *  @param imageType     正反面
 *  @param recogLanguage 語系字串
 *
 *  @return 辨識語系模型
 */
- (WCRecogSourceModel *)recogSourceModelForImageType:(WC_ImageType)imageType
                                       recogLanguage:(NSString *)recogLanguage
                                   activeCaptureMode:(WCCaptureViewController_CaptureMode)acitveCaptureMode;


@end
