//
//  WCImageBrowseTopBarView.m
//
//  Created by Howard.Lin on 13/11/21.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "WCImageBrowseTopBarView.h"

// Define
#import "WCImageBrowseViewController+ResourceDefine.h"
#import "WCAppearanceDefine.h"

// Category
#import "NSString+Additions.h"
#import "PPButton+Factory.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCImageBrowseTopBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creaing, Copying, and Dellocating Object

//===============================================================================
//
//===============================================================================
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    
    if (self)
    {
        // Initialization code
        self.style = PPBarViewStyle_Average;

        //////////////////////////////////////////////////

        self.backgroundColor = PBIV_TopBarView_DarkBlueColor;

        self.titleLabel.enabled = NO;
        
        //////////////////////////////////////////////////
        
        [self customApperance];
    }
    return self;
}


//===============================================================================
//
//===============================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_turnLeftButton removeFromSuperview];
    [_turnLeftButton release];
    _turnLeftButton = nil;
    
    [_turnRightButton removeFromSuperview];
    [_turnRightButton release];
    _turnRightButton = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//===============================================================================
//
//===============================================================================
- (void)customApperance
{
    //!!返回鍵
    if(self.turnLeftButton==nil)
    {
        _turnLeftButton = [[PPButton ppButtonWithIconImageName:ImageNameForWCImageBrowseTopBarViewButtonTurnLeft
                                                           tag:WCImageBrowseTopBarViewButtonTag_TurnLeft
                                                      delegate:self
                                         normalBackgroundColor:nil
                                    highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                               imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset] retain];
    }
    
    if(self.turnLeftButton!=nil)
    {
        [self.turnLeftButton addControlEvents:UIControlEventTouchUpInside];
    }
    
    //////////////////////////////////////////////////
    
    if(self.turnRightButton==nil)
    {
        _turnRightButton = [[PPButton ppButtonWithIconImageName:ImageNameForWCImageBrowseTopBarViewButtonTurnRight
                                                           tag:WCImageBrowseTopBarViewButtonTag_TurnRight
                                                      delegate:self
                                         normalBackgroundColor:nil
                                    highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                               imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset] retain];
    }
    
    if(self.turnRightButton!=nil)
    {
        [self.turnRightButton addControlEvents:UIControlEventTouchUpInside];
    }
    
    //////////////////////////////////////////////////

    if(self.turnLeftButton!=nil &&
       self.turnRightButton!=nil)
    {
        PPBarViewItemModel *turnLeftItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.turnLeftButton];
        
        turnLeftItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
        
        //////////////////////////////////////////////////

        PPBarViewItemModel *turnRightItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.turnRightButton];
        
        turnRightItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
        
        if(turnLeftItemModel!=nil &&
           turnRightItemModel!=nil)
        {
            [self setItemModels:@[turnLeftItemModel,turnRightItemModel] forBlockType:PPBarViewBlockType_Center];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//===============================================================================
//
//===============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if([self.delegate respondsToSelector:@selector(ppBrowseImageTopBarView:ppButton:controlEvent:)]==YES)
    {
        [self.delegate ppBrowseImageTopBarView:self
                                      ppButton:ppButton
                                  controlEvent:controlEvent];
    }
}


@end
