//
//  WCImageBrowseBottomBarView.m
//
//  Created by Howard.Lin on 13/11/21.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "WCImageBrowseBottomBarView.h"

// Define
#import "WCImageBrowseViewController+ResourceDefine.h"
#import "WCAppearanceDefine.h"

// Category
#import "PPAutoResizedLabel+Factory.h"
#import "NSString+Additions.h"
#import "PPButton+Factory.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCImageBrowseBottomBarView()

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,retain) PPAutoResizedLabel *countLabel;
@property (nonatomic,retain) NSMutableArray *layoutConstraints;
@property (nonatomic,retain) NSMutableArray *countConstraints;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCImageBrowseBottomBarView


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//===============================================================================
//
//===============================================================================
- (id)initWithFrame:(CGRect)frame
{
    if (self=[super initWithFrame:frame])
    {
        self.style = PPBarViewStyle_Average;
        [self customApperance];
    }
    return self;
}


//===============================================================================
//
//===============================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_backButton removeFromSuperview];
    [_backButton release];
    _backButton = nil;
    
    [_captureBackCardButton removeFromSuperview];
    [_captureBackCardButton release];
    _captureBackCardButton = nil;
    
    [_doneButton removeFromSuperview];
    [_doneButton release];
    _doneButton = nil;
    
    [_countLabel removeFromSuperview];
    [_countLabel release];
    _countLabel = nil;
    
    [_nextCardButton removeFromSuperview];
    [_nextCardButton release];
    _nextCardButton = nil;

    [_layoutConstraints release];
    _layoutConstraints = nil;
    
    [_countConstraints release];
    _countConstraints = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//===============================================================================
//
//===============================================================================
- (void)customApperance
{
    //!!返回鍵
    if(self.backButton==nil)
    {
        _backButton = [[PPButton ppButtonWithIconImageName:ImageNameForWCImageBrowseBottomViewButtonBackCapture
                                                       tag:WCImageBrowseBottomBarViewButtonTag_Back
                                                  delegate:self
                                     normalBackgroundColor:PBIV_BottomBarView_DarkBlueColor
                                highlightedBackgroundColor:PBIV_BottomBarView_LightBlueColor
                                           imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset] retain];
    }
    
    if(self.backButton!=nil)
    {
        [self.backButton addControlEvents:UIControlEventTouchUpInside];
    }

    //////////////////////////////////////////////////
    
    if(self.captureBackCardButton==nil)
    {
        _captureBackCardButton = [[PPButton ppButtonWithIconImageName:ImageNameForWCImageBrowseBottomViewButtonRearCapture
                                                                  tag:WCImageBrowseBottomBarViewButtonTag_CaptureBackCard
                                                             delegate:self
                                                normalBackgroundColor:PBIV_BottomBarView_DarkBlueColor
                                           highlightedBackgroundColor:PBIV_BottomBarView_LightBlueColor
                                                      imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset] retain];
    }
    
    if(self.captureBackCardButton!=nil)
    {
        [self.captureBackCardButton addControlEvents:UIControlEventTouchUpInside];
    }
    
    //////////////////////////////////////////////////
    
    if(self.nextCardButton==nil)
    {
        _nextCardButton =  [[PPButton ppButtonWithIconImageName:ImageNameForWCImageBrowseBottomViewButtonNextCapture
                                                            tag:WCImageBrowseBottomBarViewButtonTag_NextCard
                                                       delegate:self
                                          normalBackgroundColor:PBIV_BottomBarView_DarkBlueColor
                                     highlightedBackgroundColor:PBIV_BottomBarView_LightBlueColor
                                                imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset] retain];
    }
    
    if(self.nextCardButton!=nil)
    {
        [self.nextCardButton addControlEvents:UIControlEventTouchUpInside];
    }
    
    //////////////////////////////////////////////////
    
    if(self.doneButton==nil)
    {
        _doneButton = [[PPButton ppButtonWithIconImageName:ImageNameForWCImageBrowseBottomViewButtonDone
                                                       tag:WCImageBrowseBottomBarViewButtonTag_Done
                                                  delegate:self
                                     normalBackgroundColor:PBIV_BottomBarView_DarkBlueColor
                                highlightedBackgroundColor:PBIV_BottomBarView_LightBlueColor
                                           imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset] retain];
    }
    
    if(self.doneButton!=nil)
    {
        self.doneButton.imageView.clipsToBounds = NO;
        
        [self.doneButton addControlEvents:UIControlEventTouchUpInside];
    }

    //////////////////////////////////////////////////
    
    _countLabel = [[PPAutoResizedLabel counterStyleLableWithFont:PBIV_BottomBarView_CountLabelFont
                                                      textColor:PBIV_BottomBarView_CountLabelTextColor
                                                 backgroundColor:PBIV_BottomBarView_CCountLabelBGColor] retain];
    
    if (self.countLabel != nil)
    {
        self.countLabel.contentInsets = UIEdgeInsetsMake(0, 4, 0, 4);
        self.countLabel.widthMustLargerThenHeight = YES;
        self.countLabel.textAlignment = NSTextAlignmentCenter;
        self.countLabel.translatesAutoresizingMaskIntoConstraints = NO;
        self.countLabel.layer.masksToBounds = YES;
        self.countLabel.hidden = YES;
    }
}


//================================================================================
//
//================================================================================
- (void)myLayoutConstraints
{
    do
    {
        self.layoutConstraints = [NSMutableArray array];
        
        if(self.layoutConstraints==nil)
        {
            break;
        }

        //////////////////////////////////////////////////

        NSDictionary *viewDictionary = @{@"DoneButton":self.doneButton,
                                         @"BackButton":self.backButton,
                                         @"CaptureBackCardButton":self.captureBackCardButton,
                                         @"NextCardButton":self.nextCardButton};
        
        
        [self.layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"|[NextCardButton][BackButton(==NextCardButton)][CaptureBackCardButton(==NextCardButton)][DoneButton(==NextCardButton)]|"
                                                                                           options:NSLayoutFormatAlignAllBaseline
                                                                                           metrics:nil
                                                                                             views:viewDictionary]];
        
        //////////////////////////////////////////////////

        [self.layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.nextCardButton
                                                                       attribute:NSLayoutAttributeHeight
                                                                       relatedBy:NSLayoutRelationEqual
                                                                          toItem:self
                                                                       attribute:NSLayoutAttributeHeight
                                                                      multiplier:1
                                                                        constant:0]];

        [self.layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.nextCardButton
                                                                       attribute:NSLayoutAttributeBottom
                                                                       relatedBy:NSLayoutRelationEqual
                                                                          toItem:self
                                                                       attribute:NSLayoutAttributeBottom
                                                                      multiplier:1
                                                                        constant:0]];
        
        //////////////////////////////////////////////////

        [self.layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.doneButton
                                                                       attribute:NSLayoutAttributeHeight
                                                                       relatedBy:NSLayoutRelationEqual
                                                                          toItem:self
                                                                       attribute:NSLayoutAttributeHeight
                                                                      multiplier:1
                                                                        constant:0]];
        
        [self.layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.doneButton
                                                                       attribute:NSLayoutAttributeBottom
                                                                       relatedBy:NSLayoutRelationEqual
                                                                          toItem:self
                                                                       attribute:NSLayoutAttributeBottom
                                                                      multiplier:1
                                                                        constant:0]];
    
        //////////////////////////////////////////////////

        [self.layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.captureBackCardButton
                                                                       attribute:NSLayoutAttributeHeight
                                                                       relatedBy:NSLayoutRelationEqual
                                                                          toItem:self
                                                                       attribute:NSLayoutAttributeHeight
                                                                      multiplier:1
                                                                        constant:0]];
        
        [self.layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.captureBackCardButton
                                                                       attribute:NSLayoutAttributeBottom
                                                                       relatedBy:NSLayoutRelationEqual
                                                                          toItem:self
                                                                       attribute:NSLayoutAttributeBottom
                                                                      multiplier:1
                                                                        constant:0]];
        
        //////////////////////////////////////////////////

        [self.layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.backButton
                                                                       attribute:NSLayoutAttributeHeight
                                                                       relatedBy:NSLayoutRelationEqual
                                                                          toItem:self
                                                                       attribute:NSLayoutAttributeHeight
                                                                      multiplier:1
                                                                        constant:0]];
        
        [self.layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.backButton
                                                                       attribute:NSLayoutAttributeBottom
                                                                       relatedBy:NSLayoutRelationEqual
                                                                          toItem:self
                                                                       attribute:NSLayoutAttributeBottom
                                                                      multiplier:1
                                                                        constant:0]];
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)addCountLabelConstraintWithSuperView:(UIView *)superView
{
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    if(layoutConstraints!=nil)
    {
        [layoutConstraints addObject: [NSLayoutConstraint constraintWithItem:self.countLabel
                                                                   attribute:NSLayoutAttributeCenterX
                                                                   relatedBy:NSLayoutRelationEqual
                                                                      toItem:superView
                                                                   attribute:NSLayoutAttributeCenterX
                                                                  multiplier:1.0
                                                                    constant:PBIV_CountButtonGap*2]];
        
        
        //////////////////////////////////////////////////

        [layoutConstraints addObject: [NSLayoutConstraint constraintWithItem:self.countLabel
                                                                   attribute:NSLayoutAttributeCenterY
                                                                   relatedBy:NSLayoutRelationEqual
                                                                      toItem:superView
                                                                   attribute:NSLayoutAttributeCenterY
                                                                  multiplier:1.0
                                                                    constant:-PBIV_CountButtonGap]];
        
        //////////////////////////////////////////////////

        self.countConstraints = layoutConstraints;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - layout of subview

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    [self setNeedsUpdateConstraints];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Core Layout Methods

//================================================================================
//
//================================================================================
- (void)updateConstraints
{
    [super updateConstraints];
    
    //////////////////////////////////////////////////

    [self addCountLabelConstraintWithSuperView:self.doneButton];
    
    //////////////////////////////////////////////////

    for(NSLayoutConstraint *layoutConstraint in self.layoutConstraints)
    {
        if([self.constraints indexOfObject:layoutConstraint]==NSNotFound)
        {
            [self addConstraint:layoutConstraint];
        }
    }
    
    //////////////////////////////////////////////////

    if(self.countLabel.superview==nil)
    {
        [self.doneButton.imageView addSubview:self.countLabel];
    }
    
    //////////////////////////////////////////////////

    for(NSLayoutConstraint *layoutConstraint in self.countConstraints)
    {
        if([self.doneButton.constraints indexOfObject:layoutConstraint]==NSNotFound)
        {
            [self.doneButton addConstraint:layoutConstraint];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//===============================================================================
//
//===============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if([self.delegate respondsToSelector:@selector(ppBrowseImageBottomBarView:ppButton:controlEvent:)]==YES)
    {
        [self.delegate ppBrowseImageBottomBarView:self
                                         ppButton:ppButton
                                     controlEvent:controlEvent];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method


//================================================================================
//
//================================================================================
- (void)updateCaptureCountLabelWithNumber:(NSInteger)count
{
    self.countLabel.hidden = (count <= 0);
    self.countLabel.text = [NSString stringWithInteger:count];
    [self.countLabel sizeToFit];
    self.countLabel.layer.cornerRadius = self.countLabel.bounds.size.height/2;
}
@end
