//
//  WCAlbumFlowController.m
//  
//
//  Created by Howard on 2016/1/21.
//
//

#import "WCAlbumFlowController.h"

// Define
#import "WCAlbumFlowController+ParameterDefine.h"
#import "WCAlbumFlowController+ResourceDefine.h"
#import "PPAlbumContentViewController+ResourceDefine.h"
#import "WCAppearanceDefine.h"

// Controller
#import "PPAlbumViewController.h"
#import "WCAlbumContentViewController.h"
#import "WCToastController.h"
#import "PPSettingsController.h"

// View
#import "PPAlertView.h"

// Category
#import "NSError+Custom.h"
#import "PHAsset+Image.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Define Function Pointer

typedef void (^AlertCallBack)(BOOL didSubscribeNow);

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface WCAlbumFlowController

@interface WCAlbumFlowController ()<UIAlertViewDelegate,WCAlbumContentViewControllerDataSource,PPAlbumContentViewControllerDelegate,PPAlbumViewControllerDelegate>

@property (nonatomic,assign) id<WCAlbumFlowControllerDatasource> albumFlowControllerDatasource;
@property (nonatomic,assign) id<WCAlbumFlowControllerDelegate> albumFlowControllerDelegate;
@property (nonatomic,assign) WCAlbumFlowControllerMode albumFlowControllerMode;
@property (nonatomic,assign) BOOL multiSelection;
@property (nonatomic,copy)   AlertCallBack alertComplete;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation WCAlbumFlowController

@implementation WCAlbumFlowController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        _maxAddedCardCount = WCAlbumFlowController_MaximumAddedCard;
        
        //////////////////////////////////////////////////

        [[PPAlbumViewController appearance] setNavigationBarViewButtonImageEdgeInset:WCAppearanceDefine_ButtonImageEdgeInset];
    }

    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_alertComplete release];
    _alertComplete = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAlbumViewControllerDelegate Method

//================================================================================
//
//================================================================================
- (void)ppAlbumViewController:(PPAlbumViewController *)ppAlbumViewController didSelectImageFileDocumentPath:(NSString *)imageFileDocumentPath
{
    
}


//================================================================================
//
//================================================================================
- (void)ppAlbumViewController:(PPAlbumViewController *)ppAlbumViewController
  didSelectedAssetsCollection:(PHAssetCollection *)assetsCollection
                    groupName:(NSString *)groupName;
{
    [self showAlbumContentViewControllerFromGroup:assetsCollection
                                        groupName:groupName
                          fromSuperViewController:ppAlbumViewController];
}


//================================================================================
//
//================================================================================
- (void)ppAlbumViewControllerDidCancel:(PPAlbumViewController *)ppAlbumViewController
{
    __block typeof(self) blockself = self;
    
    [ppAlbumViewController dismissAnimated:YES completion:^{
        [blockself requestFlowControllerDidFinish];
    }];
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCAlbumContentViewController Datasource Method

//================================================================================
//
//================================================================================
- (NSArray *)recognitionLanguageTitleArrayInAlbumContentViewController:(WCAlbumContentViewController *)albumContentViewController
{
    NSArray *languages = nil;
    
    do
    {
        if([self.albumFlowControllerDatasource respondsToSelector:@selector(recognitionLanguageTitleArrayWithCurRecognitionLanguageTitle:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        languages = [self.albumFlowControllerDatasource recognitionLanguageTitleArrayWithCurRecognitionLanguageTitle:albumContentViewController.recognitionTitle];
    }
    while (0);
    
    return languages;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAlertView Delegate

//================================================================================
//
//================================================================================
- (void)alertView:(UIAlertView *)alertView didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    NSString *buttonTitle = [alertView buttonTitleAtIndex:buttonIndex];
    
    self.alertComplete([buttonTitle isEqualToString:WCAFC_MLS_SubscribeNow]);
    self.alertComplete = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAlbumContentViewController Delegate

//================================================================================
//
//================================================================================
- (void)albumContentViewController:(PPAlbumContentViewController *)contentViewController
     didFinishAssetImageDictionary:(NSMutableDictionary *)assetImageDictionary
{
    if(assetImageDictionary.count<=0)
    {
        do
        {
            NSError *error = [NSError errorWithDomain:PAVC
                                                 code:WCAlbumFlowControllerErrorCode_NonImageSelect
                                           lineNumber:(__LINE__)
                               localizedFailureReason:@"No Image Select"
                                               object:nil];
            
            if(error==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            BOOL showAlert = YES;
            
            if([self.albumFlowControllerDelegate respondsToSelector:@selector(albumFlowRequestShowError:)]==YES)
            {
                showAlert = [self.albumFlowControllerDelegate albumFlowRequestShowError:error];
            }
            
            if(showAlert==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSString *errorMessage = [error alertMessage];
            
            if([self.albumFlowControllerDelegate respondsToSelector:@selector(albumFlowRequestMessageWithError:)]==YES)
            {
                errorMessage = [self.albumFlowControllerDelegate albumFlowRequestMessageWithError:error];
            }
            
            //////////////////////////////////////////////////

            [WCToastController showMessageToastFromSuperView:contentViewController.view withMessage:errorMessage position:PPToastPositionCenter];
            
            //////////////////////////////////////////////////

            contentViewController.avoidAgainSendResult = NO;
        }
        while (0);
    }
    else
    {
        NSString *recogLanguageTitle = @"";
        
        if([contentViewController respondsToSelector:@selector(recognitionTitle)]==YES)
        {
            recogLanguageTitle = [NSString stringWithString:[contentViewController performSelector:@selector(recognitionTitle)]];
        }
        
        //////////////////////////////////////////////////
        
        NSMutableDictionary *assetImageDictionarys = [NSMutableDictionary dictionaryWithDictionary:assetImageDictionary];
        
        if(self.albumFlowControllerMode==WCAlbumFlowControllerMode_AddImage)
        {
            if([self.albumFlowControllerDelegate respondsToSelector:@selector(albumFlowController:didFinishAssetImageDictionary:recogLanguageTitle:fromViewContrller:)]==YES)
            {
                [self.albumFlowControllerDelegate albumFlowController:self
                                        didFinishAssetImageDictionary:assetImageDictionarys
                                                   recogLanguageTitle:recogLanguageTitle
                                                    fromViewContrller:contentViewController];
                
                //////////////////////////////////////////////////
                
                [self requestFlowControllerDidFinish];
            }
        }
        else
        {
            __block typeof(self) blockself = self;

            PHAsset *asset = [assetImageDictionarys objectForKey:[[assetImageDictionarys allKeys] firstObject]];
            [asset fetchImageWithTargetSize:CGSizeMake(asset.pixelWidth, asset.pixelHeight) completeHandler:^(UIImage *result) {

                if([blockself.albumFlowControllerDelegate respondsToSelector:@selector(albumFlowController:didFinishSelectImage:)]==YES)
                {
                    [blockself.albumFlowControllerDelegate albumFlowController:blockself
                                                          didFinishSelectImage:result];
                }
                
                
                //////////////////////////////////////////////////
                
                [contentViewController dismissAnimated:YES
                                            completion:^{
                    [blockself requestFlowControllerDidFinish];
                }];

            }];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)albumContentViewControllerDidCancel:(PPAlbumContentViewController *)contentViewController
{
    [contentViewController goBackAnimated:YES];
}


//================================================================================
//
//================================================================================
- (BOOL)albumContentViewControllerShouldShowAlertViewForError:(NSError *)error;
{
    BOOL result = YES;
    
    do
    {
        if([self.albumFlowControllerDelegate respondsToSelector:@selector(albumFlowRequestShowError:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        result = [self.albumFlowControllerDelegate albumFlowRequestShowError:error];;
    }
    while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (NSString *)albumContentViewController:(PPAlbumContentViewController *)albumContentViewController
                           titleForError:(NSError *)error
{
    NSString *title = @"";
    
    do
    {
        if([self.albumFlowControllerDelegate respondsToSelector:@selector(albumFlowRequestTitleWithError:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        title = [self.albumFlowControllerDelegate albumFlowRequestTitleWithError:error];
    }
    while (0);
    
    return title;
}


//================================================================================
//
//================================================================================
- (NSString *)albumContentViewController:(PPAlbumContentViewController *)albumContentViewController
                         messageForError:(NSError *)error
{
    NSString *message = error.localizedFailureReason;
    do
    {
        if([self.albumFlowControllerDelegate respondsToSelector:@selector(albumFlowRequestMessageWithError:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        message = [self.albumFlowControllerDelegate albumFlowRequestMessageWithError:error];
    }
    while (0);
    
    return message;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)showAlbumContentViewControllerFromGroup:(PHAssetCollection *)assetCollection
                                      groupName:(NSString *)groupName
                        fromSuperViewController:(UIViewController *)superViewController
{
    do
    {
        if(assetCollection==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPAlbumContentViewController *albumContentViewController = nil;
        
        if(self.albumFlowControllerMode==WCAlbumFlowControllerMode_AddImage)
        {
            albumContentViewController = [[WCAlbumContentViewController alloc] init];
        }
        else
        {
            albumContentViewController = [[PPAlbumContentViewController alloc] init];
        }
        
        //////////////////////////////////////////////////

        if(albumContentViewController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([albumContentViewController respondsToSelector:@selector(setDatasource:)]==YES)
        {
            [albumContentViewController performSelector:@selector(setDatasource:) withObject:self];
        }

        //////////////////////////////////////////////////

        albumContentViewController.delegate = self;
        
        if(self.albumFlowControllerMode==WCAlbumFlowControllerMode_AddImage)
        {
            if(self.maxAddedCardCount==-1)
            {
                albumContentViewController.selectedMaximumCount = NSUIntegerMax;
            }
            else
            {
                albumContentViewController.selectedMaximumCount = self.maxAddedCardCount-self.curAddedCardCount;
            }
        }
        
        //////////////////////////////////////////////////
        
        //單多選
        albumContentViewController.multiSelection = self.multiSelection;
        
        //////////////////////////////////////////////////
        
        if([albumContentViewController respondsToSelector:@selector(setRecognitionTitle:)]==YES &&
           [self.albumFlowControllerDatasource respondsToSelector:@selector(frontCardRecognitionTitle)]==YES)
        {
            [albumContentViewController performSelector:@selector(setRecognitionTitle:)
                                             withObject:[self.albumFlowControllerDatasource frontCardRecognitionTitle]];
        }
        
        albumContentViewController.navigationBarViewButtonImageEdgeInset = WCAppearanceDefine_ButtonImageEdgeInset;
        
        albumContentViewController.view.backgroundColor = [UIColor whiteColor];
        
        //////////////////////////////////////////////////
        albumContentViewController.titleString = groupName;
        
        //////////////////////////////////////////////////
        

        NSRange range = [groupName rangeOfString:PAVC_MLS_Moments];
        
        if(range.length>0)
        {
            [albumContentViewController assignSytemAlbumToContentProviderWithAssertCollection:assetCollection enableMultiSection:YES];
        }
        else
        {
            [albumContentViewController assignSytemAlbumToContentProviderWithAssertCollection:assetCollection enableMultiSection:NO];
        }

        //////////////////////////////////////////////////
        
        [superViewController.navigationController pushViewController:albumContentViewController animated:NO];
        
        [albumContentViewController release];
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)requestFlowControllerDidFinish
{
    if([self.albumFlowControllerDelegate respondsToSelector:@selector(albumFlowControllerDidFinish:)]==YES)
    {
        [self.albumFlowControllerDelegate albumFlowControllerDidFinish:self];
    }
}


//================================================================================
//
//================================================================================
- (void)requestFlowControllerDidFinishWithSubscribeNow
{
    if([self.albumFlowControllerDelegate respondsToSelector:@selector(albumFlowControllerDidFinishWithSubscribeNow:)]==YES)
    {
        [self.albumFlowControllerDelegate albumFlowControllerDidFinishWithSubscribeNow:self];
    }
}

//================================================================================
// 檢查是否可以新增
//================================================================================
- (BOOL)canAddNewCardWithError:(NSError **)error
{
    BOOL result = YES;
    
    do
    {
        //數量檢查
        if(self.maxAddedCardCount<0 ||
           self.maxAddedCardCount>self.curAddedCardCount)
        {
            break;
        }


        //////////////////////////////////////////////////

        // !! 不要用PPErrorMake來產生，因為domian需要統一 !!
        if (error)
        {
            (*error) = [NSError errorWithDomain:WCAFC
                                           code:WCAlbumFlowControllerErrorCode_ReachMaximumCount
                                     lineNumber:(__LINE__)
                         localizedFailureReason:@"MLS_ReachMaxNewCardCount"
                                         object:nil];
        }
        
        result = NO;
    }
    while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)showAlertWithError:(NSError *)error completion:(AlertCallBack)completion
{
    do
    {
        if(error==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        BOOL showAlert = YES;
        
        if([self.albumFlowControllerDelegate respondsToSelector:@selector(albumFlowRequestShowError:)]==YES)
        {
            showAlert = [self.albumFlowControllerDelegate albumFlowRequestShowError:error];
        }
        
        if(showAlert==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.alertComplete = completion;
        
        //////////////////////////////////////////////////
        
        NSString *title = @"";
        
        if([self.albumFlowControllerDelegate respondsToSelector:@selector(albumFlowRequestTitleWithError:)])
        {
            title = [self.albumFlowControllerDelegate albumFlowRequestTitleWithError:error];
        }
        
        //////////////////////////////////////////////////
        
        NSString *message = nil;
        
        // 先跟外部詢問有沒有特別的解釋
        if([self.albumFlowControllerDelegate respondsToSelector:@selector(albumFlowRequestMessageWithError:)])
        {
            message = [self.albumFlowControllerDelegate albumFlowRequestMessageWithError:error];
        }
        
        // 沒有的話就直接使用error code敘述
        if([message length] == 0)
        {
            message = [error alertMessage];
        }
        
        //////////////////////////////////////////////////
        
        // show alert
        if(self.showSubscribeWhenReachMaxCount)
        {
            [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                 title:title
                               message:message
                              delegate:self
                     cancelButtonTitle:WCAFC_MLS_OK
                     otherButtonTitles:WCAFC_MLS_SubscribeNow, nil];

        }
        else
        {
            [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                 title:title
                               message:message
                              delegate:self
                     cancelButtonTitle:WCAFC_MLS_OK
                     otherButtonTitles:nil];
        }
    }
    while (0);
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)presentSelectImageViewControllerFromSuperViewController:(UIViewController *)superViewController
                                    albumFlowControllerDelegate:(id<WCAlbumFlowControllerDelegate>)albumFlowControllerDelegate
{
    self.albumFlowControllerMode = WCAlbumFlowControllerMode_SelectImage;
    self.multiSelection = NO;
    self.albumFlowControllerDelegate = albumFlowControllerDelegate;
    
    //////////////////////////////////////////////////

    //呼叫相簿視圖
    [PPAlbumViewController presentFromSuperViewController:superViewController
                                                 delegate:self
                                     mountSanboxDirectory:nil];
    
}


//================================================================================
//
//================================================================================
- (void)presentNewImageViewControllerFromSuperViewController:(UIViewController *)superViewController
                               albumFlowControllerDatasource:(id<WCAlbumFlowControllerDatasource>)albumFlowControllerDatasource
                                 albumFlowControllerDelegate:(id<WCAlbumFlowControllerDelegate>)albumFlowControllerDelegate
{
    self.albumFlowControllerMode = WCAlbumFlowControllerMode_AddImage;
    self.multiSelection = YES;
    self.albumFlowControllerDatasource = albumFlowControllerDatasource;
    self.albumFlowControllerDelegate = albumFlowControllerDelegate;
    
    //////////////////////////////////////////////////
    
    NSError *error = nil;
    
    if([self canAddNewCardWithError:&error] == NO)
    {
        __block typeof(self) blockSelf = self;
        
        [self showAlertWithError:error completion:^(BOOL didSubscribeNow) {
            
            if(didSubscribeNow)
            {
                [blockSelf requestFlowControllerDidFinishWithSubscribeNow];
            }
            else
            {
                [blockSelf requestFlowControllerDidFinish];
            }
            
        }];
    }
    else
    {
        //呼叫相簿視圖
        [PPAlbumViewController presentFromSuperViewController:superViewController
                                                     delegate:self
                                         mountSanboxDirectory:nil];
    }

    while (0);
}


//================================================================================
//
//================================================================================
- (void)presentMyCardSelectImageViewControllerFromSuperViewController:(UIViewController *)superViewController
                                        albumFlowControllerDatasource:(id<WCAlbumFlowControllerDatasource>)albumFlowControllerDatasource
                                          albumFlowControllerDelegate:(id<WCAlbumFlowControllerDelegate>)albumFlowControllerDelegate
{
    self.albumFlowControllerMode = WCAlbumFlowControllerMode_AddImage;
    self.multiSelection = NO;
    self.albumFlowControllerDatasource = albumFlowControllerDatasource;
    self.albumFlowControllerDelegate = albumFlowControllerDelegate;
    
    //////////////////////////////////////////////////
    
    NSError *error = nil;
    
    if([self canAddNewCardWithError:&error] == NO)
    {
        __block typeof(self) blockSelf = self;
        
        [self showAlertWithError:error completion:^(BOOL didSubscribeNow) {
            
            if(didSubscribeNow)
            {
                [blockSelf requestFlowControllerDidFinishWithSubscribeNow];
            }
            else
            {
                [blockSelf requestFlowControllerDidFinish];
            }
            
        }];
    }
    else
    {
        //呼叫相簿視圖
        [PPAlbumViewController presentFromSuperViewController:superViewController
                                                     delegate:self
                                         mountSanboxDirectory:nil];
    }
    
    while (0);
}
@end
