//
//  WCAlbumContentViewController.m
//  
//
//  Created by Howard on 2015/8/20.
//
//

#import "WCAlbumContentViewController.h"

// Define
#import "WCAlbumContentViewController+ResourceDefine.h"
#import "WCAppearanceDefine.h"

// View
#import "UIButton+Additions.h"

// Controller
#import "PPSelectController.h"

// Category
#import "NSString+Additions.h"
#import "UIColor+HexString.h"
#import "PPButton+Factory.h"
#import "UIViewController+ShareApplication.h"
////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCAlbumContentViewController ()<PPButtonDelegate,PPSelectControllerDelegate>

@property (nonatomic,retain) PPButton *recogLanguageButton;
@property (nonatomic,retain) PPButton *changeRecogLanguageButton;

@property (nonatomic,retain) PPSelectController *languagesSelectController;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCAlbumContentViewController

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        self.view.backgroundColor = [UIColor whiteColor];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_changeRecogLanguageButton setDelegate:nil];
    [_changeRecogLanguageButton release];
    _changeRecogLanguageButton = nil;
    
    [_recogLanguageButton setDelegate:nil];
    [_recogLanguageButton release];
    _recogLanguageButton = nil;

    _languagesSelectController.delegate = nil;
    [_languagesSelectController release];
    _languagesSelectController = nil;
    
    [_recognitionTitle release];
    _recognitionTitle = nil;
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Respondint to View's event

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////

    do
    {
        self.changeRecogLanguageButton =  [PPButton ppButtonWithIconImageName:ImageNameWCAlbumViewControllerButtonDownPull
                                                                          tag:WCAlbumContentViewControllerButtonTag_RecogLanguage
                                                                     delegate:self
                                                        normalBackgroundColor:nil
                                                   highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                              imageEdgeInsets:UIEdgeInsetsMake(WCAppearanceDefine_ButtonImageEdgeInset.top+5, WCAppearanceDefine_ButtonImageEdgeInset.left, WCAppearanceDefine_ButtonImageEdgeInset.bottom, WCAppearanceDefine_ButtonImageEdgeInset.right)];
        
        if(self.changeRecogLanguageButton==nil)
        {
            break;
        }
        
        [self.changeRecogLanguageButton setTitle:[self.recognitionTitle localized] maxWidth:0.0];
        self.changeRecogLanguageButton.minimumImageHeight = 0;
        
        //////////////////////////////////////////////////
        
        [self.changeRecogLanguageButton sizeToFit];
        
        //////////////////////////////////////////////////

        PPBarViewItemModel *changeRecogLanguageButtonItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.changeRecogLanguageButton];
        
        if(changeRecogLanguageButtonItemModel==nil)
        {
            break;
        }
        
        changeRecogLanguageButtonItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
        
        //////////////////////////////////////////////////

        self.albumContentNavigationBarView.style = PPBarViewStyle_CenteredRelative;
        self.albumContentNavigationBarView.titleLabel.enabled = NO;
        self.albumContentNavigationBarView.clipsToBounds = YES;
        
        //////////////////////////////////////////////////

        [self.albumContentNavigationBarView setItemModels:@[changeRecogLanguageButtonItemModel] forBlockType:PPBarViewBlockType_Center];
        
        //////////////////////////////////////////////////
        // 設定另外兩個按鈕的style
        [self.albumContentNavigationBarView.backButton setBackgroundImage:[UIImage imageWithColor:WCAppearanceDefine_ButtonBackgroundColor] forState:UIControlStateHighlighted];
        [self.albumContentNavigationBarView.doneButton setBackgroundImage:[UIImage imageWithColor:WCAppearanceDefine_ButtonBackgroundColor] forState:UIControlStateHighlighted];

    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    
    //////////////////////////////////////////////////
    
    [self.recogLanguageButton removeFromSuperview];
    self.recogLanguageButton = nil;
    
    [self.changeRecogLanguageButton removeFromSuperview];
    self.changeRecogLanguageButton = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - layout of subview

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    self.albumContentView.frame = [self layoutFrame];
    
    //////////////////////////////////////////////////
    
    [self.changeRecogLanguageButton sizeToFit];
    
    //////////////////////////////////////////////////

    self.changeRecogLanguageButton.titleEdgeInsets = UIEdgeInsetsMake(0, -self.changeRecogLanguageButton.imageView.frame.size.width, 0, self.changeRecogLanguageButton.imageView.frame.size.width);
    self.changeRecogLanguageButton.imageEdgeInsets = UIEdgeInsetsMake(self.changeRecogLanguageButton.imageEdgeInsets.top, self.changeRecogLanguageButton.titleLabel.frame.size.width, self.changeRecogLanguageButton.imageEdgeInsets.bottom, -self.changeRecogLanguageButton.titleLabel.frame.size.width);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButton Delegate 

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCAlbumContentViewControllerButtonTag_RecogLanguage:
        {
            do
            {
                if([self.datasource respondsToSelector:@selector(recognitionLanguageTitleArrayInAlbumContentViewController:)]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                // 辨識語系選擇
                NSArray *recognitionLanguageTitles = [self.datasource recognitionLanguageTitleArrayInAlbumContentViewController:self];
                
                if(recognitionLanguageTitles==nil ||
                   recognitionLanguageTitles.count<=0)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                PPSelectController *selectionController = [[PPSelectController alloc] init];
                
                if(selectionController==nil)
                {
                    break;
                }
                
                selectionController.delegate = self;
                
                selectionController.sourceItemStringArray = recognitionLanguageTitles;
                [selectionController showFromViewController:self animated:YES];
                
                self.languagesSelectController = selectionController;
                
                [selectionController release];
            }
            while (0);

            break;
        }
        default:
        {
         
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSelectControllerDelegate

//================================================================================
//
//================================================================================
- (void)ppSelectController:(PPSelectController *)selectController itemSelectedIndex:(NSInteger)itemIndex withString:(NSString *)itemString
{
    self.recognitionTitle = itemString;
    
    [self.changeRecogLanguageButton setTitleText:[itemString localized]];
    [self.changeRecogLanguageButton sizeToFit];
    
    //////////////////////////////////////////////////
    
    self.changeRecogLanguageButton.titleEdgeInsets = UIEdgeInsetsMake(0, -self.changeRecogLanguageButton.imageView.frame.size.width, 0, self.changeRecogLanguageButton.imageView.frame.size.width);
    
    self.changeRecogLanguageButton.imageEdgeInsets = UIEdgeInsetsMake(self.changeRecogLanguageButton.imageEdgeInsets.top, self.changeRecogLanguageButton.titleLabel.frame.size.width, self.changeRecogLanguageButton.imageEdgeInsets.bottom, -self.changeRecogLanguageButton.titleLabel.frame.size.width);
    
    //////////////////////////////////////////////////

    [self.albumContentNavigationBarView layoutSubviews];
}


//================================================================================
//
//================================================================================
- (void)ppSelectControllerDidDismiss:(PPSelectController *)selectController
{
    self.languagesSelectController = nil;
}


@end
