//
//  SearchPicklistChoiceTableViewCell.m
//  Extension
//
//  Created by AndrewLai on 2018/4/19.
//

#import "SearchPicklistChoiceTableViewCell.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, SearchPicklistChoiceTableViewCellButtonTag)
{
    SearchPicklistChoiceTableViewCellButtonTag_Operator = 1,
    SearchPicklistChoiceTableViewCellButtonTag_Choice
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface SearchPicklistChoiceTableViewCell () <PPButtonDelegate>

@property (nonatomic, retain) UIImageView *choiceDirectionImageView;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation SearchPicklistChoiceTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self!=nil)
    {
        _searchOperatorButton = [[PPButton alloc] init];
        if (self.searchOperatorButton!=nil)
        {
            [self.searchOperatorButton setTitleColor:[UIColor grayColor]];
            [self.searchOperatorButton setContentHorizontalAlignment:UIControlContentHorizontalAlignmentLeft];
            [self.searchOperatorButton addControlEvents:UIControlEventTouchUpInside];
            [self.searchOperatorButton setTag:SearchPicklistChoiceTableViewCellButtonTag_Operator];
            [self.searchOperatorButton setDelegate:self];
            
            [self.contentView addSubview:self.searchOperatorButton];
        }
        
        _searchChoiceButton = [[PPButton alloc] init];
        if (self.searchChoiceButton!=nil)
        {
            [self.searchChoiceButton setTitleColor:[UIColor blackColor]];
            [self.searchChoiceButton setContentHorizontalAlignment:UIControlContentHorizontalAlignmentLeft];
            [self.searchChoiceButton addControlEvents:UIControlEventTouchUpInside];
            [self.searchChoiceButton setTag:SearchPicklistChoiceTableViewCellButtonTag_Choice];
            [self.searchChoiceButton setDelegate:self];
            
            [self.contentView addSubview:self.searchChoiceButton];
        }
        
        _directionImageView = [[UIImageView alloc] init];
        if (self.directionImageView!=nil)
        {
            self.directionImageView.image = [UIImage imageWithName:@"WCContactInfoViewControllerButtonMoreLanguage-Highlighted"];
            self.directionImageView.contentMode = UIViewContentModeScaleAspectFit;
            
            [self.contentView addSubview:self.directionImageView];
        }
        
        _choiceDirectionImageView = [[UIImageView alloc] init];
        if (self.choiceDirectionImageView!=nil)
        {
            self.choiceDirectionImageView.image = [UIImage imageWithName:@"WCContactInfoViewControllerButtonMoreLanguage-Highlighted"];
            self.choiceDirectionImageView.contentMode = UIViewContentModeScaleAspectFit;
            
            [self.contentView addSubview:self.choiceDirectionImageView];
        }
        
        self.contactTableViewCellLineView.drawHorizontalLine = YES;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_directionImageView removeFromSuperview];
    [_directionImageView release];
    _directionImageView = nil;
    
    [_searchOperatorButton removeFromSuperview];
    [_searchOperatorButton release];
    _searchOperatorButton = nil;
    
    [_choiceDirectionImageView removeFromSuperview];
    [_choiceDirectionImageView release];
    _choiceDirectionImageView = nil;
    
    [_searchChoiceButton removeFromSuperview];
    [_searchChoiceButton release];
    _searchChoiceButton = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout Of View

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    CGRect searchButtonFrame = self.textField.frame;
    searchButtonFrame.size.height = searchButtonFrame.size.height/2;;
    self.searchOperatorButton.frame = searchButtonFrame;
    
    CGRect imageViewFrame = CGRectMake(0, 0, 20, 20);
    imageViewFrame.origin.x = CGRectGetMaxX(searchButtonFrame)-imageViewFrame.size.width-5;
    imageViewFrame.origin.y = CGRectGetMidY(searchButtonFrame)-imageViewFrame.size.height/2;
    self.directionImageView.frame = imageViewFrame;
    
    CGRect searchChoiceButtonFrame = searchButtonFrame;
    searchChoiceButtonFrame.origin.y = CGRectGetMaxY(searchButtonFrame)+PPTableViewCellLineView_LineWidth;
    self.searchChoiceButton.frame = searchChoiceButtonFrame;
    
    CGRect choiceImageViewFrame = CGRectMake(0, 0, 20, 20);
    choiceImageViewFrame.origin.x = CGRectGetMaxX(searchChoiceButtonFrame)-choiceImageViewFrame.size.width-5;
    choiceImageViewFrame.origin.y = CGRectGetMidY(searchChoiceButtonFrame)-choiceImageViewFrame.size.height/2;
    self.choiceDirectionImageView.frame = choiceImageViewFrame;
    
    self.textField.frame = CGRectZero;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case SearchPicklistChoiceTableViewCellButtonTag_Operator:
        {
            if (self.operatorDelegate!=nil && [self.operatorDelegate respondsToSelector:@selector(searchPicklistChoiceTableViewCellDidClickOperatorButton:)]==YES)
            {
                [self.operatorDelegate searchPicklistChoiceTableViewCellDidClickOperatorButton:self];
            }
            
            break;
        }
        case SearchPicklistChoiceTableViewCellButtonTag_Choice:
        default:
        {
            if (self.operatorDelegate!=nil && [self.operatorDelegate respondsToSelector:@selector(searchPicklistChoiceTableViewCellDidClickChoiceButton:)]==YES)
            {
                [self.operatorDelegate searchPicklistChoiceTableViewCellDidClickChoiceButton:self];
            }
            
            break;
        }
    }
}

@end
