//
//  SearchNumberTextFieldTableViewCell.m
//  Extension
//
//  Created by AndrewLai on 2018/4/19.
//

#import "SearchNumberTextFieldTableViewCell.h"
#import "WCAdvancedSearchViewController+ResourceDefine.h"

#import "UIColor+Contact.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface SearchNumberTextFieldTableViewCell () <PPButtonDelegate>

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation SearchNumberTextFieldTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier])
    {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //////////////////////////////////////////////////
        //預設輸入上限最高
        maxLength_ = NSUIntegerMax;
        
        //////////////////////////////////////////////////
        _searchOperatorButton = [[PPButton alloc] init];
        if (self.searchOperatorButton!=nil)
        {
            [self.searchOperatorButton setTitleColor:[UIColor grayColor]];
            [self.searchOperatorButton setContentHorizontalAlignment:UIControlContentHorizontalAlignmentLeft];
            [self.searchOperatorButton addControlEvents:UIControlEventTouchUpInside];
            [self.searchOperatorButton setDelegate:self];
            
            [self.contentView addSubview:self.searchOperatorButton];
        }
        
        //////////////////////////////////////////////////
        self.textField.placeholder = WCASVC_MLS_PlacceholderFromNumber;
        
        _subTextField = [[CustomRectTextField alloc] init];
        if(self.subTextField!=nil)
        {
            self.subTextField.autocapitalizationType   = UITextAutocapitalizationTypeWords;
            self.subTextField.autocorrectionType       = UITextAutocorrectionTypeNo;
            self.subTextField.backgroundColor          = [UIColor clearColor];
            self.subTextField.borderStyle              = UITextBorderStyleNone;
            self.subTextField.clearButtonMode          = UITextFieldViewModeWhileEditing;
            self.subTextField.contentVerticalAlignment = UIControlContentVerticalAlignmentCenter;
            self.subTextField.delegate                 = self;
            self.subTextField.returnKeyType            = UIReturnKeyDone;
            self.subTextField.placeholder = WCASVC_MLS_PlacceholderToNumber;
            
            [self.contentView addSubview:self.subTextField];
            
            //////////////////////////////////////////////////
            [self.subTextField setTextColor:[UIColor contactEditViewInputFieldTextColor]];
        }
        
        //////////////////////////////////////////////////
        _directionImageView = [[UIImageView alloc] init];
        if (self.directionImageView!=nil)
        {
            self.directionImageView.image = [UIImage imageWithName:@"WCContactInfoViewControllerButtonMoreLanguage-Highlighted"];
            self.directionImageView.contentMode = UIViewContentModeScaleAspectFit;
            
            [self.contentView addSubview:self.directionImageView];
        }
        
        //////////////////////////////////////////////////
        self.contactTableViewCellLineView.drawHorizontalLine = YES;
        
        //////////////////////////////////////////////////
        [self layoutSubviews];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_directionImageView removeFromSuperview];
    [_directionImageView release];
    _directionImageView = nil;
    
    [_searchOperatorButton removeFromSuperview];
    [_searchOperatorButton release];
    _searchOperatorButton = nil;
    
    [_subTextField removeFromSuperview];
    [_subTextField release];
    _subTextField = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    CGRect searchButtonFrame = self.textField.frame;
    searchButtonFrame.size.height = searchButtonFrame.size.height/3;
    self.searchOperatorButton.frame = searchButtonFrame;
    
    CGRect imageViewFrame = CGRectMake(0, 0, 20, 20);
    imageViewFrame.origin.x = CGRectGetMaxX(searchButtonFrame)-imageViewFrame.size.width-5;
    imageViewFrame.origin.y = CGRectGetMidY(searchButtonFrame)-imageViewFrame.size.height/2;
    self.directionImageView.frame = imageViewFrame;
    
    CGRect fromTextFieldFrame = searchButtonFrame;
    fromTextFieldFrame.origin.y = CGRectGetMaxY(searchButtonFrame)+PPTableViewCellLineView_LineWidth;
    self.textField.frame = fromTextFieldFrame;
    
    CGRect toTextFieldFrame = fromTextFieldFrame;
    toTextFieldFrame.origin.y = CGRectGetMaxY(fromTextFieldFrame)+PPTableViewCellLineView_LineWidth;
    self.subTextField.frame = toTextFieldFrame;
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if (self.operatorDelegate!=nil && [self.delegate respondsToSelector:@selector(searchNumberTextFieldTableViewCellDidClickOperatorButton:)]==YES)
    {
        [self.operatorDelegate searchNumberTextFieldTableViewCellDidClickOperatorButton:self];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)setContactKeyboardToolBarViewDelegate:(id<ContactKeyboardToolBarViewDelegate>)contactKeyboardToolBarViewDelegate
{
    [super setContactKeyboardToolBarViewDelegate:contactKeyboardToolBarViewDelegate];
    
    //////////////////////////////////////////////////
    if(self.contactKeyboardToolBarViewDelegate!=nil)
    {
        ContactKeyboardToolBarView *toolBarView = [[ContactKeyboardToolBarView alloc] init];
        if(toolBarView!=nil)
        {
            self.subTextField.inputAccessoryView = toolBarView;
            toolBarView.contactKeyboardToolBarViewDelegate = self.contactKeyboardToolBarViewDelegate;
        }
        
        [toolBarView release];
    }
}

@end
