//
//  SearchCheckBoxAccountTableViewCell.m
//  Extension
//
//  Created by AndrewLai on 2018/4/16.
//

#import "SearchCheckBoxAccountTableViewCell.h"

#import "PPCheckBoxView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface SearchCheckBoxAccountTableViewCell ()
@property (nonatomic, retain) PPCheckBoxView *checkBoxView;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation SearchCheckBoxAccountTableViewCell





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if ((self=[super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        do
        {
            _checkBoxView = [[PPCheckBoxView alloc] initWithFrame:CGRectZero];
            if (self.checkBoxView==nil)
            {
                self = nil;
                break;
            }
            
            self.checkBoxView.status = PPCheckBoxViewStatus_Unselect;
            self.checkBoxView.checkBoxImageSelected = [UIImage imageWithName:@"ic_check-box_select_h"];
            self.checkBoxView.checkBoxImageUnSelected = [UIImage imageWithName:@"ic_check-box_unselect_h"];
            
            [self.contentView addSubview:self.checkBoxView];
        } while (0);
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_checkBoxView removeFromSuperview];
    [_checkBoxView release];
    _checkBoxView = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    self.checkBoxView.frame = CGRectMake(10, 2, 28, 28);
    
    CGFloat labelX = self.checkBoxView.frame.origin.x+self.checkBoxView.frame.size.width+15;
    
    
    self.textLabel.frame = CGRectMake(labelX,
                                      self.textLabel.frame.origin.y,
                                      self.contentView.frame.size.width-labelX-15,
                                      self.textLabel.frame.size.height);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)setCheckBoxViewStatus:(BOOL)isSelected
{
    if (isSelected==YES)
    {
        self.checkBoxView.status = PPCheckBoxViewStatus_Select;
    }
    else
    {
        self.checkBoxView.status = PPCheckBoxViewStatus_Unselect;
    }
}

@end
