//
//  AdvanceSearchView.m
//  Extension
//
//  Created by AndrewLai on 2018/3/2.
//

#import "AdvanceSearchView.h"

//Define
#import "WCAdvancedSearchViewController+ParameterDefine.h"
#import "WCAppearanceDefine.h"

//View
#import "SearchTableSectionHeaderView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface AdvanceSearchView ()

@property (nonatomic,readwrite,retain) PPTableView *advanceSearchTableView;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AdvanceSearchView Implementation

@implementation AdvanceSearchView





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame])
    {
        _advanceSearchTableView = [[PPTableView alloc] initWithFrame:frame style:UITableViewStylePlain];
        if(self.advanceSearchTableView!=nil)
        {
            self.advanceSearchTableView.allowsSelectionDuringEditing = YES;
            
            self.advanceSearchTableView.editing    = YES;
            self.advanceSearchTableView.dataSource = self;
            self.advanceSearchTableView.delegate   = self;
            self.advanceSearchTableView.separatorColor = WCAppearanceDefine_SeparatorColor;
            self.advanceSearchTableView.tableFooterView = [[UIView new] autorelease];
            
            if([self.advanceSearchTableView respondsToSelector:@selector(setEstimatedRowHeight:)]==YES)
            {
                self.advanceSearchTableView.rowHeight = UITableViewAutomaticDimension;
                [self.advanceSearchTableView setEstimatedRowHeight:PPTableViewDefaultRowHeight];
            }
            
            [self addSubview:self.advanceSearchTableView];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.dataSource = nil;
    self.delegate = nil;
    
    self.advanceSearchTableView.dataSource = nil;
    self.advanceSearchTableView.delegate   = nil;
    [self.advanceSearchTableView removeFromSuperview];
    self.advanceSearchTableView = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    self.advanceSearchTableView.frame = self.bounds;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Hit Testing in a View

//================================================================================
//
//================================================================================
- (UIView *)hitTest:(CGPoint)point withEvent:(UIEvent *)event
{
    UIView *hitView= [super hitTest:point withEvent:event];
    
    do
    {
//        if([self.delegate respondsToSelector:@selector(advanceSearchViewDidTouch:)]==NO)
//        {
//            break;
//        }
        
        // MARK: Howard  ios 8.0，有機會點鍵盤時，事件會傳給鍵盤下面的view，造成打字時鍵盤退開的問題。
//        else if([[[UIDevice currentDevice] systemVersion] floatValue]<8.0)
//        {
//            if([hitView isKindOfClass:[UITextField class]]==YES ||
//               [hitView isKindOfClass:[UITextView class]]==YES ||
//               [hitView isKindOfClass:[UIButton class]]==YES ||
//               [NSStringFromClass(hitView.class) isEqualToString:@"UITableViewCellEditControl"]==YES ||
//               [NSStringFromClass(hitView.class) isEqualToString:@"UITableViewCellReorderControl"]==YES)
//            {
//                break;
//            }
//
//            [self.delegate advanceSearchViewDidTouch:self];
//        }
        
    } while (0);
    
    return hitView;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactKeyboardToolBarViewDelegate

//================================================================================
//
//================================================================================
- (void)contactEditKeyboardToolBarView:(ContactKeyboardToolBarView *)contactEditKeyboardToolBarView
                              ppButton:(PPButton *)ppButton
                          controlEvent:(UIControlEvents)controlEvent
{
    do
    {
        if(self.delegate==nil ||
           [self.delegate respondsToSelector:@selector(advanceSearchView:contactEditKeyboardToolBarView:ppButton:controlEvent:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.delegate advanceSearchView:self
          contactEditKeyboardToolBarView:contactEditKeyboardToolBarView
                                ppButton:ppButton
                            controlEvent:controlEvent];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSource Method

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    NSInteger number = 0;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(numberOfSectionsInAdvanceSearchView:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        number = [self.dataSource numberOfSectionsInAdvanceSearchView:self];
        
    } while (0);
    
    return number;
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger number = 0;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(advanceSearchView:numberOfRowsInSection:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        number = [self.dataSource advanceSearchView:self numberOfRowsInSection:section];
        
    } while (0);
    
    
    return number;
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = nil;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(advanceSearchView:cellForRowAtIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        cell = [self.dataSource advanceSearchView:self cellForRowAtIndexPath:indexPath];
        
        //////////////////////////////////////////////////
        
    } while (0);
    
    //////////////////////////////////////////////////
    
    if(cell==nil)
    {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([UITableViewCell class])] autorelease];
    }
    
    return cell;
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath
{
    if([self.dataSource respondsToSelector:@selector(advanceSearchView:commitEditingStyle:forRowAtIndexPath:)]==YES)
    {
        [self.dataSource advanceSearchView:self
                        commitEditingStyle:editingStyle
                         forRowAtIndexPath:indexPath];
    }
}


////================================================================================
////
////================================================================================
//- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
//{
//    NSString *sectionTitle = nil;
//
//    if ([self.dataSource respondsToSelector:@selector(advanceSearchView:titleForHeaderInSection:)]==YES)
//    {
//        sectionTitle = [self.dataSource advanceSearchView:self titleForHeaderInSection:section];
//    }
//
//    return sectionTitle;
//}


//================================================================================
//
//================================================================================
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    SearchTableSectionHeaderView *sectionHeaderView = [[[SearchTableSectionHeaderView alloc] initWithFrame:CGRectZero] autorelease];
    if (sectionHeaderView!=nil)
    {
        sectionHeaderView.backgroundColor = WCAppearanceDefine_SectionHeaderBGColor;
        [sectionHeaderView.sectionLabel setTextColor:WCAppearanceDefine_SectionHeaderTitleColor];
        [sectionHeaderView.sectionLabel setFont:[UIFont systemFontOfSize:WCAppearanceDefine_SectionHeaderFontSize]];

        if ([self.dataSource respondsToSelector:@selector(advanceSearchView:titleForHeaderInSection:)]==YES)
        {
            sectionHeaderView.sectionLabel.text = [self.dataSource advanceSearchView:self titleForHeaderInSection:section];
        }
    }
    
    return sectionHeaderView;
}


//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return WCAppearanceDefine_SectionHeaderHeight;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDelegate

//================================================================================
//
//================================================================================
- (UITableViewCellEditingStyle)tableView:(UITableView *)tableView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCellEditingStyle style = UITableViewCellEditingStyleNone;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(advanceSearchView:editingStyleForRowAtIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        style = [self.delegate advanceSearchView:self editingStyleForRowAtIndexPath:indexPath];
        
    } while (0);
    
    return style;
}


//===============================================================================
//
//===============================================================================
- (CGFloat)tableView:(UITableView *)tableView estimatedHeightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat rowHeight = UITableViewAutomaticDimension;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(advanceSearchView:estimatedHeightForRowAtIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        rowHeight = [self.delegate advanceSearchView:self estimatedHeightForRowAtIndexPath:indexPath];
        
    } while (0);
    
    return rowHeight;
}


//===============================================================================
//
//===============================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat rowHeight = tableView.rowHeight;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(advanceSearchView:heightForRowAtIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        rowHeight = [self.delegate advanceSearchView:self heightForRowAtIndexPath:indexPath];
        
    } while (0);
    
    return rowHeight;
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if([self.delegate respondsToSelector:@selector(advanceSearchView:didSelectRowAtIndexPath:)]==YES)
    {
        [self.delegate advanceSearchView:self
                 didSelectRowAtIndexPath:indexPath];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - SearchPhoneTextFieldTableViewCellDelegate

//================================================================================
//
//================================================================================
- (void)searchPhoneTextFieldTableViewCellDidClickOperatorButton:(SearchPhoneTextFieldTableViewCell *)searchPhoneTextFieldTableViewCell
{
    do
    {
        if([self.delegate respondsToSelector:@selector(advanceSearchView:searchTableViewCellDidClickOperatorButton:)]==NO)
        {
            break;
        }

        //////////////////////////////////////////////////
        [self.delegate advanceSearchView:self searchTableViewCellDidClickOperatorButton:searchPhoneTextFieldTableViewCell];

    } while (0);
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - SearchTextFieldTableViewCellDelegate

//================================================================================
//
//================================================================================
- (void)searchTextFieldTableViewCellDidClickOperatorButton:(SearchTextFieldTableViewCell *)searchTextFieldTableViewCell
{
    do
    {
        if([self.delegate respondsToSelector:@selector(advanceSearchView:searchTableViewCellDidClickOperatorButton:)]==NO)
        {
            break;
        }

        //////////////////////////////////////////////////
        [self.delegate advanceSearchView:self searchTableViewCellDidClickOperatorButton:searchTextFieldTableViewCell];

    } while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - SearchNumberTextFieldTableViewCellDelegate

//================================================================================
//
//================================================================================
- (void)searchNumberTextFieldTableViewCellDidClickOperatorButton:(SearchNumberTextFieldTableViewCell *)searchNumberTextFieldTableViewCell
{
    do
    {
        if([self.delegate respondsToSelector:@selector(advanceSearchView:searchTableViewCellDidClickOperatorButton:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        [self.delegate advanceSearchView:self searchTableViewCellDidClickOperatorButton:searchNumberTextFieldTableViewCell];
        
    } while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - SearchPicklistChoiceTableViewCellDelegate

//================================================================================
//
//================================================================================
- (void)searchPicklistChoiceTableViewCellDidClickOperatorButton:(SearchPicklistChoiceTableViewCell *)searchPicklistChoiceTableViewCell
{
    do
    {
        if([self.delegate respondsToSelector:@selector(advanceSearchView:searchTableViewCellDidClickOperatorButton:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        [self.delegate advanceSearchView:self searchTableViewCellDidClickOperatorButton:searchPicklistChoiceTableViewCell];
        
    } while (0);
}


//================================================================================
//
//================================================================================
- (void)searchPicklistChoiceTableViewCellDidClickChoiceButton:(SearchPicklistChoiceTableViewCell *)searchPicklistChoiceTableViewCell
{
    do
    {
        if([self.delegate respondsToSelector:@selector(advanceSearchView:searchTableViewCellDidClickChoiceButton:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        [self.delegate advanceSearchView:self searchTableViewCellDidClickChoiceButton:searchPicklistChoiceTableViewCell];
        
    } while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTextFieldTableViewCellDelegate

//================================================================================
//
//================================================================================
- (void)ppTextFieldTableViewCellDidBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
    if([self.delegate respondsToSelector:@selector(advanceSearchView:ppTextFieldTableViewCellDidBeginEditing:atIndexPath:)]==YES)
    {
        NSIndexPath *currentIndexPath = [self.advanceSearchTableView indexPathForCell:textFieldTableViewCell];
        [self.delegate advanceSearchView:self ppTextFieldTableViewCellDidBeginEditing:textFieldTableViewCell atIndexPath:currentIndexPath];
    }
}


//================================================================================
//
//================================================================================
- (void)ppTextFieldTableViewCellDidEndEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
    do
    {
        if([self.delegate respondsToSelector:@selector(advanceSearchView:ppTextFieldTableViewCellDidEndEditing:atIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        NSIndexPath *indexPath = [NSIndexPath indexPathForRow:[self.advanceSearchTableView indexPathForCell:textFieldTableViewCell].row
                                                    inSection:[self.advanceSearchTableView  indexPathForCell:textFieldTableViewCell].section];
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        [self.delegate advanceSearchView:self
   ppTextFieldTableViewCellDidEndEditing:textFieldTableViewCell
                             atIndexPath:indexPath];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPPhoneTextFieldTableViewCellDelegate

//================================================================================
//
//================================================================================
- (void)ppPhoneTextFieldTableViewCellDidEndEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell
{
    do
    {
        if([self.delegate respondsToSelector:@selector(advanceSearchView:ppPhoneTextFieldTableViewCellDidEndEditing:atIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        NSIndexPath *indexPath = [NSIndexPath indexPathForRow:[self.advanceSearchTableView indexPathForCell:phoneTextFieldTableViewCell].row
                                                    inSection:[self.advanceSearchTableView  indexPathForCell:phoneTextFieldTableViewCell].section];
        
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        [self.delegate advanceSearchView:self ppPhoneTextFieldTableViewCellDidEndEditing:phoneTextFieldTableViewCell atIndexPath:indexPath];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - SearchDateAndTimeTextFieldTableViewCellDelegate

//================================================================================
//
//================================================================================
- (void)searchDateAndTimeTextFieldTableViewCellDidClickOperatorButton:(SearchDateAndTimeTextFieldTableViewCell *)searchDateAndTimeTextFieldTableViewCell
{
    do
    {
        if([self.delegate respondsToSelector:@selector(advanceSearchView:searchTableViewCellDidClickOperatorButton:)]==NO)
        {
            break;
        }

        //////////////////////////////////////////////////
        [self.delegate advanceSearchView:self searchTableViewCellDidClickOperatorButton:searchDateAndTimeTextFieldTableViewCell];

    } while (0);
}

@end
