//
//  WCABPeoplePickerViewController.m
//
//
//  Created by Howard.Lin on 2014/3/26.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "WCABPeoplePickerViewController.h"
#import "UIViewController+ShareApplication.h"

// Define
#import "WCABPeoplePickerViewController+ResourceDefine.h"
#import "WCABItemSelectFlowController+ResourceDefine.h"
#import "WCAppearanceDefine.h"

// Model
#import "PPProgressModel.h"

// View
#import "WCABPeoplePickerNavigationBarView.h"
#import "WCABPeoplePickerTableViewCell.h"
#import "PPBusyView.h"
#import "PPTableView.h"

// Controller
#import "WCABDataController.h"
#import "WCABPeoplePickerSectionController.h"
#import "WCToastController.h"

#import <AddressBook/AddressBook.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCABPeoplePickerViewController ()<PPButtonDelegate,PPSectionIndexViewDelegate,UITableViewDataSource,UITableViewDelegate>

@property (nonatomic,retain) WCABPeoplePickerSectionController *ppABPeoplePickerSectionController;
@property (nonatomic,retain) WCABPeoplePickerNavigationBarView *ppABPeoplePickerNavigationBarView;
@property (nonatomic,retain) PPSectionIndexView                *ppABPeoplePickerSectionIndexView;
@property (nonatomic,retain) PPBusyView                        *ppBusyView;
@property (nonatomic,retain) PPTableView                       *ppABPeoplePickerTableView;
@property (nonatomic,retain) NSMutableArray                    *selectedPeopleIndexPaths;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCABPeoplePickerViewController


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self = [super init])
    {
        [[WCABPeoplePickerViewController appearance] applyInvocationTo:self];
        
        //////////////////////////////////////////////////

        _multiSelect = YES;
        
        //////////////////////////////////////////////////
        
        self.selectedStringFormat = WCABPPV_MLS_MultiSelectCount;
        
        _ppABPeoplePickerSectionController = [[WCABPeoplePickerSectionController alloc] init];
        
        _selectedPeopleIndexPaths          = [[NSMutableArray alloc] init];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_ppABPeoplePickerSectionController release];
    _ppABPeoplePickerSectionController = nil;
    
    [_ppABPeoplePickerNavigationBarView removeFromSuperview];
    [_ppABPeoplePickerNavigationBarView release];
    _ppABPeoplePickerNavigationBarView = nil;
    
    _ppABPeoplePickerSectionIndexView.delegate = nil;
    [_ppABPeoplePickerSectionIndexView removeFromSuperview];
    [_ppABPeoplePickerSectionIndexView release];
    _ppABPeoplePickerSectionIndexView = nil;
    
    [_ppBusyView removeFromSuperview];
    [_ppBusyView release];
    _ppBusyView = nil;
    
    _ppABPeoplePickerTableView.dataSource = nil;
    _ppABPeoplePickerTableView.delegate   = nil;
    [_ppABPeoplePickerTableView removeFromSuperview];
    _ppABPeoplePickerTableView = nil;
    
    [_selectedPeopleIndexPaths removeAllObjects];
    [_selectedPeopleIndexPaths release];
    _selectedPeopleIndexPaths = nil;
    
    [_navigationViewButtonHighlightedBackgroundColor release];
    _navigationViewButtonHighlightedBackgroundColor = nil;
    
    [_navigationViewButtonHighlightedTitleColor release];
    _navigationViewButtonHighlightedTitleColor = nil;
    
    [_navigationViewButtonNormalTitleColor release];
    _navigationViewButtonNormalTitleColor = nil;
    
    [_controllerTitle release];
    _controllerTitle = nil;
    
    [_tableViewSeparatorColor release];
    _tableViewSeparatorColor = nil;
    
    [_groupID release];
    _groupID = nil;
    
    [_sourceID release];
    _sourceID = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];

    //////////////////////////////////////////////////

    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(recvFetchCardModelsProgressNotification:)
                                                 name:WCABDC_FetchCardModelsProgress
                                               object:nil];
    
    //////////////////////////////////////////////////
    
    if(self.ppABPeoplePickerSectionController!=nil)
    {
        self.ppABPeoplePickerSectionController.westDisplayNameOrder = self.westDisplayNameOrder;
        self.ppABPeoplePickerSectionController.eastDisplayNameOrder = self.eastDisplayNameOrder;
        
        //////////////////////////////////////////////////

        self.ppABPeoplePickerSectionController.style = self.ppIndexSectionControllerStyle;
    }
    
    //////////////////////////////////////////////////
    
    if(self.ppABPeoplePickerTableView==nil)
    {
        _ppABPeoplePickerTableView = [[PPTableView alloc] init];
    }
    
    if(self.ppABPeoplePickerTableView!=nil)
    {
        self.ppABPeoplePickerTableView.dataSource = self;
        self.ppABPeoplePickerTableView.delegate   = self;
        
        if(self.tableViewSeparatorColor!=nil)
        {
            self.ppABPeoplePickerTableView.separatorColor = self.tableViewSeparatorColor;
        }
        
        [self.view addSubview:self.ppABPeoplePickerTableView];
        
        //////////////////////////////////////////////////
        
        if(self.ppABPeoplePickerSectionIndexView==nil)
        {
            _ppABPeoplePickerSectionIndexView = [[PPSectionIndexView alloc] init];
        }
        
        if(self.ppABPeoplePickerSectionIndexView!=nil)
        {
            self.ppABPeoplePickerSectionIndexView.delegate = self;
            
            [self.ppABPeoplePickerSectionIndexView setIndexTitles:[self.ppABPeoplePickerSectionController sectionIndexTitles]
                                                   withExtraTitle:PPSectionIndexViewExtraTitleNone];
            
            [self.view addSubview:self.ppABPeoplePickerSectionIndexView];
        }
    }
    
    //////////////////////////////////////////////////
    
    if(self.ppABPeoplePickerNavigationBarView==nil)
    {
        _ppABPeoplePickerNavigationBarView = [[WCABPeoplePickerNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    }
    
    if(self.ppABPeoplePickerNavigationBarView!=nil)
    {
        self.ppABPeoplePickerNavigationBarView.titleLabel.text = self.controllerTitle;
        
        if([self.selectedStringFormat length]>0)
        {
            self.ppABPeoplePickerNavigationBarView.titleLabel.text = [NSString stringWithFormat:self.selectedStringFormat, 0];
        }
        
        //////////////////////////////////////////////////

        self.ppABPeoplePickerNavigationBarView.allSelectButton.delegate = self;
        [self.ppABPeoplePickerNavigationBarView.allSelectButton addControlEvents:UIControlEventTouchUpInside];
        
        self.ppABPeoplePickerNavigationBarView.backButton.delegate = self;
        [self.ppABPeoplePickerNavigationBarView.backButton addControlEvents:UIControlEventTouchUpInside];
        
        self.ppABPeoplePickerNavigationBarView.doneButton.delegate = self;
        [self.ppABPeoplePickerNavigationBarView.doneButton addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////

        if(self.navigationViewButtonNormalTitleColor!=nil)
        {
            [self.ppABPeoplePickerNavigationBarView.doneButton setTitleColor:self.navigationViewButtonNormalTitleColor forState:UIControlStateNormal];
        }
        
        //////////////////////////////////////////////////
        
        if(self.navigationViewButtonHighlightedTitleColor!=nil)
        {
            [self.ppABPeoplePickerNavigationBarView.doneButton setTitleColor:self.navigationViewButtonHighlightedTitleColor forState:UIControlStateHighlighted];
        }
        
        //////////////////////////////////////////////////
        
        if(self.navigationViewButtonHighlightedBackgroundColor!=nil)
        {
            [self.ppABPeoplePickerNavigationBarView.backButton setBackgroundImage:[UIImage imageWithColor:self.navigationViewButtonHighlightedBackgroundColor] forState:UIControlStateHighlighted];
            
            [self.ppABPeoplePickerNavigationBarView.doneButton setBackgroundImage:[UIImage imageWithColor:self.navigationViewButtonHighlightedBackgroundColor] forState:UIControlStateHighlighted];
            
            [self.ppABPeoplePickerNavigationBarView.allSelectButton setBackgroundImage:[UIImage imageWithColor:self.navigationViewButtonHighlightedBackgroundColor] forState:UIControlStateHighlighted];
        }
        
        //////////////////////////////////////////////////
        
        [self.ppABPeoplePickerNavigationBarView.backButton setImageWithName:ImageNamePPButtonIconForSystemBackImitation];
        [self.ppABPeoplePickerNavigationBarView.backButton setImageEdgeInsets:self.navigationViewButtonImageEdgeInsets];
        
        //////////////////////////////////////////////////

        [self.ppABPeoplePickerNavigationBarView.allSelectButton setImageEdgeInsets:self.navigationViewButtonImageEdgeInsets];

        //////////////////////////////////////////////////
        
        if(self.ppABPeoplePickerNavigationBarView.backButton.imageView.image==nil)
        {
            [self.ppABPeoplePickerNavigationBarView.backButton setTitle:[@"MLS_Back" localizedFromTable:NSStringFromClass([self.ppABPeoplePickerNavigationBarView.backButton class])] maxWidth:0.0];
        }

        //////////////////////////////////////////////////

        PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppABPeoplePickerNavigationBarView.backButton];
        
        if(itemModel!=nil)
        {
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppABPeoplePickerNavigationBarView setItemModels:@[itemModel]
                                                     forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        
        PPBarViewItemModel *allSelectItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppABPeoplePickerNavigationBarView.allSelectButton];
        
        if(allSelectItemModel!=nil)
        {
            allSelectItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
        }
        
        //////////////////////////////////////////////////
        
        PPBarViewItemModel *doneItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppABPeoplePickerNavigationBarView.doneButton];
        
        if(doneItemModel!=nil)
        {
            doneItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
        }
        
        //////////////////////////////////////////////////
        
        if(self.multiSelect==YES &&
           allSelectItemModel!=nil &&
           doneItemModel!=nil)
        {
            [self.ppABPeoplePickerNavigationBarView setItemModels:@[allSelectItemModel,doneItemModel]
                                                     forBlockType:PPBarViewBlockType_Right];
        }
    }
    
    //////////////////////////////////////////////////
    
    if(self.navigationController!=nil)
    {
        UIBarButtonItem *leftButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.ppABPeoplePickerNavigationBarView];
        
        self.navigationItem.leftBarButtonItem = leftButtonItem;
        
        [leftButtonItem release];
    }
    
    //////////////////////////////////////////////////

    [self loadSections];
}


//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    if(self.ppABPeoplePickerTableView!=nil)
    {
        self.ppABPeoplePickerTableView.frame = [self layoutFrame];
        
        if(self.ppABPeoplePickerSectionIndexView!=nil)
        {
            self.ppABPeoplePickerSectionIndexView.frame = CGRectMake(self.ppABPeoplePickerTableView.frame.size.width-PPSectionIndexViewDefaultVerticalWidth,
                                                       self.ppABPeoplePickerTableView.frame.origin.y,
                                                       PPSectionIndexViewDefaultVerticalWidth,
                                                       self.ppABPeoplePickerTableView.frame.size.height);
        }
    }
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [super viewDidDisappear:animated];
    
    //////////////////////////////////////////////////

    [[NSNotificationCenter defaultCenter] removeObserver:self];
    
    //////////////////////////////////////////////////

    [[self.ppABPeoplePickerSectionController sectionModelsForSearching:NO] removeAllObjects];
    
    //////////////////////////////////////////////////
    
    self.ppABPeoplePickerSectionIndexView.delegate = nil;
    [self.ppABPeoplePickerSectionIndexView removeFromSuperview];
    self.ppABPeoplePickerSectionIndexView = nil;
    
    self.ppABPeoplePickerTableView.dataSource = nil;
    self.ppABPeoplePickerTableView.delegate   = nil;
    [self.ppABPeoplePickerTableView removeFromSuperview];
    self.ppABPeoplePickerTableView = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property methods

//================================================================================
//
//================================================================================
- (void)setNavigationViewButtonHighlightedBackgroundColor:(UIColor *)navigationViewButtonHighlightedBackgroundColor
{
    [_navigationViewButtonHighlightedBackgroundColor release];
    _navigationViewButtonHighlightedBackgroundColor = [navigationViewButtonHighlightedBackgroundColor retain];
}


//================================================================================
//
//================================================================================
- (void)setNavigationViewButtonHighlightedTitleColor:(UIColor *)navigationViewButtonHighlightedTitleColor
{
    [_navigationViewButtonHighlightedTitleColor release];
    _navigationViewButtonHighlightedTitleColor = [navigationViewButtonHighlightedTitleColor retain];
}


//================================================================================
//
//================================================================================
- (void)setNavigationViewButtonNormalTitleColor:(UIColor *)navigationViewButtonNormalTitleColor
{
    [_navigationViewButtonNormalTitleColor release];
    _navigationViewButtonNormalTitleColor = [navigationViewButtonNormalTitleColor retain];
}


//================================================================================
//
//================================================================================
- (void)setTableViewSeparatorColor:(UIColor *)tableViewSeparatorColor
{
    [_tableViewSeparatorColor release];
    _tableViewSeparatorColor = [tableViewSeparatorColor retain];
}


//================================================================================
//
//================================================================================
- (void)setNavigationViewButtonImageEdgeInsets:(UIEdgeInsets)navigationViewButtonImageEdgeInsets
{
    _navigationViewButtonImageEdgeInsets = navigationViewButtonImageEdgeInsets;
}


//================================================================================
//
//================================================================================
- (void)setControllerTitle:(NSString *)controllerTitle
{
    [_controllerTitle release];
    _controllerTitle = [controllerTitle copy];
    
    self.selectedStringFormat = nil;
}


//==============================================================================
//
//==============================================================================
- (void)updateControllerTitle
{
    if([self.selectedStringFormat length]>0)
    {
        self.ppABPeoplePickerNavigationBarView.titleLabel.text = [NSString stringWithFormat:self.selectedStringFormat, [self.selectedPeopleIndexPaths count]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification Method

//================================================================================
//
//================================================================================
- (void)recvFetchCardModelsProgressNotification:(NSNotification *)notification
{
    if(notification!=nil &&
       [notification.object isKindOfClass:[NSString class]]==YES)
    {
        [PPBusyView postMessage:notification.object];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)sendSelectedContactResult
{
    if([self.delegate respondsToSelector:@selector(ppABPeoplePickerViewController:didSelectCardModels:)]==YES)
    {
        if(self.selectedPeopleIndexPaths.count>0)
        {
            [self showBusyView:YES withSuperView:nil];
            
            //////////////////////////////////////////////////
            
            __block typeof(self) blockself = self;
            
            dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                
                NSMutableArray *cardModels = [self selectedABCardModels];
                
                dispatch_sync(dispatch_get_main_queue(), ^{
                    
                    [blockself showBusyView:NO withSuperView:nil];
                    
                    //////////////////////////////////////////////////
                    
                    if(cardModels.count>0)
                    {
                        [blockself.delegate ppABPeoplePickerViewController:self
                                                       didSelectCardModels:cardModels];
                        
                    }
                });
            });
            
        }
        else
        {
            [WCToastController showMessageToastFromSuperView:self.view
                                                 withMessage:WCAIS_MLS_PleaseSelectContacts
                                                    position:PPToastPositionCenter];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAppearance protocol methods

//================================================================================
//
//================================================================================
+ (id)appearance
{
    // MARK: 實作+appearance的方式固定如下
    return [PPAppearance appearanceForClass:[self class]];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCABPeoplePickerNavigationBarViewButtonTag_AllSelect:
        {
            [self showBusyView:YES withSuperView:nil];
            
            //////////////////////////////////////////////////

            __block typeof(self) blockself = self;

            dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
    
                //全選，所以此時是做移除
                if([self.ppABPeoplePickerSectionController rowObjectsCountForSearching:NO]==blockself.selectedPeopleIndexPaths.count)
                {
                    [blockself.selectedPeopleIndexPaths removeAllObjects];
                }
                else
                {
                    [blockself.selectedPeopleIndexPaths removeAllObjects];
                
                    //////////////////////////////////////////////////

                    NSUInteger totalSection = [blockself.ppABPeoplePickerSectionController sectionModelsForSearching:NO].count;
                    
                    for(NSUInteger sectionIndex = 0; sectionIndex<totalSection ; sectionIndex++)
                    {
                        PPSectionModel *sectionModel =  [[blockself.ppABPeoplePickerSectionController sectionModelsForSearching:NO] objectAtIndex:sectionIndex];
                        
                        NSUInteger totalRow = sectionModel.rowModels.count;
                        
                        for(NSUInteger rowIndex = 0; rowIndex<totalRow; rowIndex++)
                        {
                            NSIndexPath *currentIndexPath = [NSIndexPath indexPathForRow:rowIndex inSection:sectionIndex];
                            
                            [blockself.selectedPeopleIndexPaths addObject:currentIndexPath];
                        }
                    }
                }
                
                //////////////////////////////////////////////////
                
                dispatch_async(dispatch_get_main_queue(), ^{
                    
                    [blockself showBusyView:NO withSuperView:nil];
                    
                    //////////////////////////////////////////////////
                    [self updateControllerTitle];

                    [blockself.ppABPeoplePickerTableView reloadData];
                });

            });
            
            break;
        }
        case WCABPeoplePickerNavigationBarViewButtonTag_Back:
        {
            [self goBackAnimated:YES];
            
            break;
        }
        case WCABPeoplePickerNavigationBarViewButtonTag_Done:
        {
            [self sendSelectedContactResult];
            
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSectionIndexViewDelgate Method

//================================================================================
//
//================================================================================
- (void)sectionIndexView:(PPSectionIndexView *)sectionIndexView didSelectedIndexTitle:(NSString *)indexTitle
{
    if([indexTitle isEqualToString:PPSectionIndexTitleForSearch]==YES)
    {
        [self.ppABPeoplePickerTableView setContentOffset:CGPointZero animated:NO];
    }
    else
    {
        NSInteger section = [self.ppABPeoplePickerSectionController sectionForSectionIndexTitle:indexTitle
                                                                                   forSearching:self.searchDisplayController.active];
        if(section>=0)
		{
			[self.ppABPeoplePickerTableView scrollToRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:section]
                                                  atScrollPosition:UITableViewScrollPositionTop
                                                          animated:NO];
		}
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSource Method

//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
	return (self.searchDisplayController.active==YES?0:20);
}


//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return WCABPeoplePickerViewControllerTableViewCellHeight;
}


//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return [self.ppABPeoplePickerSectionController numberOfSectionsForSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [self.ppABPeoplePickerSectionController numberOfRowsInSection:section forSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    return [self.ppABPeoplePickerSectionController titleForHeaderInSection:section
                                                              forSearching:NO];
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    WCABPeoplePickerTableViewCell *ppABPeoplerPickerTableViewCell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([WCABPeoplePickerTableViewCell class])];

    if(ppABPeoplerPickerTableViewCell==nil)
    {
        ppABPeoplerPickerTableViewCell = [[[WCABPeoplePickerTableViewCell alloc] initWithReuseIdentifier:NSStringFromClass([WCABPeoplePickerTableViewCell class])] autorelease];
    }
    
    //////////////////////////////////////////////////

    if(ppABPeoplerPickerTableViewCell.selectedBackgroundView!=nil)
    {
        ppABPeoplerPickerTableViewCell.selectedBackgroundView = [[[UIView alloc] init] autorelease];
        ppABPeoplerPickerTableViewCell.selectedBackgroundView.backgroundColor = WCAppearanceDefine_CellHighlightedBGColor;
    }
    
    ppABPeoplerPickerTableViewCell.peopleNameLabelEdgeInsets = WCABPeoplePickerTableViewCellEdgeInsets;
    
    //////////////////////////////////////////////////
    
    PPRowModel *rowModel = [self.ppABPeoplePickerSectionController rowModelAtIndexPath:indexPath forSearching:NO];
    
    if(ppABPeoplerPickerTableViewCell!=nil)
    {
        ppABPeoplerPickerTableViewCell.peopleNameLabel.text = rowModel.text;
        
        if(self.multiSelect==YES)
        {
            if([self.selectedPeopleIndexPaths containsObject:indexPath]==YES)
            {
                [ppABPeoplerPickerTableViewCell setSelectStatus:PPSelectStatus_Select];
            }
            else
            {
                [ppABPeoplerPickerTableViewCell setSelectStatus:PPSelectStatus_Unselect];
            }
        }
        else
        {
            [ppABPeoplerPickerTableViewCell setSelectStatus:PPSelectStatus_None];
        }
    }

    return ppABPeoplerPickerTableViewCell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDelegate Method

//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if([self.selectedPeopleIndexPaths containsObject:indexPath]==YES)
    {
        [self.selectedPeopleIndexPaths removeObject:indexPath];
    }
    else
    {
        [self.selectedPeopleIndexPaths addObject:indexPath];
    }
 
    [self updateControllerTitle];
    
    if(self.multiSelect==YES)
    {
        __block typeof(self) blockself = self;
        
        dispatch_async(dispatch_get_main_queue(), ^{
            [blockself.ppABPeoplePickerTableView reloadRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationNone];
        });
    }
    else
    {
        [self sendSelectedContactResult];
    }
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didHighlightRowAtIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        if(self.multiSelect==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        WCABPeoplePickerTableViewCell *abPeoplerPickerTableViewCell = (WCABPeoplePickerTableViewCell *)[tableView cellForRowAtIndexPath:indexPath];
        
        if(abPeoplerPickerTableViewCell!=nil)
        {
            if([self.selectedPeopleIndexPaths containsObject:indexPath]==YES)
            {
                [abPeoplerPickerTableViewCell setSelectStatus:PPSelectStatus_SelectHighlighted];
            }
            else
            {
                [abPeoplerPickerTableViewCell setSelectStatus:PPSelectStatus_UnSelectHighlighted];
            }
        }
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didUnhighlightRowAtIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        if(self.multiSelect==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        WCABPeoplePickerTableViewCell *abPeoplerPickerTableViewCell = (WCABPeoplePickerTableViewCell *)[tableView cellForRowAtIndexPath:indexPath];
        
        if(abPeoplerPickerTableViewCell!=nil)
        {
            //回復 didHighlighted 的選取狀態
            if([self.selectedPeopleIndexPaths containsObject:indexPath]==YES)
            {
                [abPeoplerPickerTableViewCell setSelectStatus:PPSelectStatus_Select];
            }
            else
            {
                [abPeoplerPickerTableViewCell setSelectStatus:PPSelectStatus_Unselect];
            }
        }
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)loadSections
{
    [self showBusyView:YES withSuperView:nil];
    
    //////////////////////////////////////////////////

    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        [blockself.ppABPeoplePickerSectionController fetchSectionModelFromGroupID:self.groupID
                                                                         sourceID:self.sourceID
                                                                        searching:NO];
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            [blockself showBusyView:NO withSuperView:nil];
            
            [blockself.ppABPeoplePickerTableView reloadData];
            
        });
    });
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)selectedABCardModels
{
    NSMutableArray *cardModels = nil;
    
    CGFloat updateProgress = 0;
    
    PPProgressModel *progressModel = nil;
    
    do
    {
        cardModels = [NSMutableArray array];
        
        if(cardModels==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        progressModel = [[PPProgressModel alloc] init];
        
        if(progressModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        [PPBusyView postMessage:@"0%"];
        
        //////////////////////////////////////////////////

        WCABDataController *abDataController = [[WCABDataController alloc] initWithError:nil];
        
        if(abDataController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        progressModel.denominator = self.selectedPeopleIndexPaths.count;
        
        //////////////////////////////////////////////////

        for(NSIndexPath *indexPath in self.selectedPeopleIndexPaths)
        {
            @autoreleasepool
            {
                PPRowModel *rowModel = [self.ppABPeoplePickerSectionController rowModelAtIndexPath:indexPath
                                                                                      forSearching:NO];
                
                if(rowModel!=nil &&
                   rowModel.object!=nil &&
                   [rowModel.object isKindOfClass:[WCABCardModel class]]==YES)
                {
                    WCABCardModel *infoCardModel = rowModel.object;
                    
                    WCABCardModel *detailCardModel = [abDataController copyCardModelWithPersonID:infoCardModel.abPersonID
                                                                                           error:nil];
                    
                    //////////////////////////////////////////////////
                    
                    if(detailCardModel!=nil)
                    {
                        detailCardModel.abGroupID = infoCardModel.abGroupID;
                        detailCardModel.abSourceID = infoCardModel.abSourceID;
                        
                        //////////////////////////////////////////////////

                        UIImage *abPhotoImage = [abDataController copyPhotoImageWithPersonID:infoCardModel.abPersonID error:nil];
                        
                        detailCardModel.abPhotoImage = abPhotoImage;
                        
                        [abPhotoImage release];
                        
                        //////////////////////////////////////////////////
                        
                        [cardModels addObject:detailCardModel];
                    }
                    else
                    {
                        NSLog(@"=================轉換失敗，找無此連絡人");
                    }
                    [detailCardModel release];
                }
              
                //////////////////////////////////////////////////
                
                progressModel.numerator++;
                
                //不要每次一直丟
                if([progressModel progress]>(updateProgress+0.01) ||progressModel.progress==1)
                {
                    updateProgress = [progressModel progress];
                    
                    [PPBusyView postMessage:[NSString stringWithFormat:@"%d%%", (int)(progressModel.progress*100)]];
                }
                
                // autorelease pool end
            }
        // loop end
        }

        //////////////////////////////////////////////////

        [abDataController release];
    }
    while (0);

    [progressModel release];

    return cardModels;
}





//////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)showBusyView:(BOOL)show withSuperView:(UIView *)superView
{
    if(show==YES)
    {
        if(self.ppBusyView==nil)
        {
            _ppBusyView = [[PPBusyView alloc] initWithSuperView:superView];
        }
    }
    else
    {
        [self.ppBusyView removeFromSuperview];
        self.ppBusyView = nil;
    }
}

@end
