//
//  WCABPeoplePickerTableViewCell.m
//
//
//  Created by Howard.Lin on 2014/3/26.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "WCABPeoplePickerTableViewCell.h"
#import "PPSelectImageView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static CGSize  const WCABPeoplePickerTableViewCell_DefaultSelectImageSize = {17, 17};

////////////////////////////////////////////////////////////////////////////////////////////////////


@interface WCABPeoplePickerTableViewCell()
{
    PPSelectImageView *ppSelectImageView_;
    UILabel           *peopleNameLabel_;
}

@property (nonatomic,retain) PPSelectImageView *ppSelectImageView;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCABPeoplePickerTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
 peopleNameLabel   = peopleNameLabel_,
 ppSelectImageView = ppSelectImageView_;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithReuseIdentifier:(NSString *)reuseIdentifier
{
    if(self=[super initCustomStyleWithReuseIdentifier:reuseIdentifier])
    {
        ppSelectImageView_ = [[PPSelectImageView alloc] init];
        
        if(ppSelectImageView_!=nil)
        {
            [self.contentView addSubview:ppSelectImageView_];
        }
        
        //////////////////////////////////////////////////
        
        peopleNameLabel_ = [[UILabel alloc] init];
        
        if(peopleNameLabel_!=nil)
        {
            peopleNameLabel_.backgroundColor = [UIColor clearColor];
            peopleNameLabel_.textAlignment   = NSTextAlignmentLeft;
            peopleNameLabel_.font            = [UIFont fontWithName:@"Helvetica-Bold" size:16];
            peopleNameLabel_.numberOfLines   = 1;
            peopleNameLabel_.adjustsFontSizeToFitWidth=YES;
            peopleNameLabel_.textColor       = [UIColor blackColor];
            
            [self.contentView addSubview:peopleNameLabel_];
        }
        
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [ppSelectImageView_ removeFromSuperview];
    [ppSelectImageView_ release];
    ppSelectImageView_ = nil;
    
    [peopleNameLabel_ removeFromSuperview];
    [peopleNameLabel_ release];
    peopleNameLabel_ = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    self.ppSelectImageView.frame = CGRectMake(self.contentView.bounds.origin.x,
                                              self.contentView.bounds.origin.y,
                                              WCABPeoplePickerTableViewCell_DefaultSelectImageSize.width,
                                              WCABPeoplePickerTableViewCell_DefaultSelectImageSize.height);
    
    self.ppSelectImageView.center = CGPointMake(self.contentView.bounds.origin.x+WCABPeoplePickerTableViewCell_DefaultSelectImageSize.width,self.contentView.bounds.origin.y+self.bounds.size.height/2);
    
    
    self.peopleNameLabel.frame   = CGRectMake(self.ppSelectImageView.frame.origin.x+self.ppSelectImageView.frame.size.width+self.peopleNameLabelEdgeInsets.left, self.contentView.bounds.origin.y, self.bounds.size.width-(self.ppSelectImageView.frame.origin.x+self.ppSelectImageView.frame.size.width+self.peopleNameLabelEdgeInsets.right), self.bounds.size.height);
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)setSelectStatus:(PPSelectStatus)seletStatus
{
    self.ppSelectImageView.status = seletStatus;
}


//================================================================================
//
//================================================================================
- (PPSelectStatus)selectStatus
{
    return self.ppSelectImageView.status;
}
@end
