//
//  WCABPeoplePickerSectionController.m
//
//
//  Created by Howard.Lin on 2014/3/26.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "WCABPeoplePickerSectionController.h"

// Define
#import "WCABPeoplePickerViewController+ResourceDefine.h"

// Controller
#import "PPIndexingController.h"
#import "WCDisplayNameController.h"
#import "PPWorldcardAddressController.h"

// View
#import "PPBusyView.h"


// Category
#import "NSString+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCABPeoplePickerSectionController()

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCABPeoplePickerSectionController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (PPIndexingStyle )ppIndexingStyleFromPPIndexSectionStyle
{
    PPIndexingStyle style;
    
    switch (self.style)
    {
        case PPIndexSectionControllerStyle_Zhuyin:
        {
            style = PPIndexingStyle_Zhuyin;
            
            break;
        }
        case PPIndexSectionControllerStyle_Hanpin:
        {
            style = PPIndexingStyle_Hanpin;
            
            break;
        }
        case PPIndexSectionControllerStyle_Stroke:
        {
            style = PPIndexingStyle_Stroke;
            
            break;
        }
        case PPIndexSectionControllerStyle_Hiragana:
        {
            style = PPIndexingStyle_Hiragana;
            
            break;
        }
        case PPIndexSectionControllerStyle_Hangul:
        {
            style = PPIndexingStyle_Hangul;
            
            break;
        }
        case PPIndexSectionControllerStyle_HangulAndEnglish:
        {
            style = PPIndexingStyle_Hangul;
            break;
        }
        case PPIndexSectionControllerStyle_HiraganaAndEnglish:
        {
            style = PPIndexingStyle_Hiragana;
            break;
        }
        case PPIndexSectionControllerStyle_StrokeAndEnglish:
        {
            style = PPIndexingStyle_Stroke;
            break;
        }
        case PPIndexSectionControllerStyle_ZhuyinAndEnglish:
        {
            style = PPIndexingStyle_Zhuyin;
            break;
        }
        case PPIndexSectionControllerStyle_English:
        default:
        {
            style = PPIndexingStyle_English;
            
            break;
        }
    }
    
    return style;
}


//================================================================================
//
//================================================================================
- (PPSectionModel *)sectionModelWithString:(NSString *)string
                                 searching:(BOOL)searching;
{
    PPSectionModel *sectionModel = nil;
    
    do
    {
        if(string==nil || string.length==0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(NSUInteger sectionIndex = 0; sectionIndex < [self sectionModelsForSearching:searching].count ; sectionIndex++)
        {
            PPSectionModel *existSectionModel = [[self sectionModelsForSearching:searching] objectAtIndex:sectionIndex];
            
            if([existSectionModel.title isEqualToString:string]==YES)
            {
                sectionModel = existSectionModel;
                break;
            }
        }
        
    } while (0);
    
    return sectionModel;
}


//================================================================================
//
//================================================================================
- (void)addSectionModel:(PPSectionModel *)sectionModel
              searching:(BOOL)searching;

{
    if([self sectionModelsForSearching:searching].count==0)
    {
        [[self sectionModelsForSearching:searching] addObject:sectionModel];
    }
    else
    {
        NSArray *array = [self indexs];
        
        NSInteger targetIndex = - 1;
        
        for (NSString *key in array)
        {
            if([key compare:sectionModel.title options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                targetIndex = [array indexOfObject:key];
                
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        NSUInteger sectionIndex = 0;
        NSUInteger existIndex  = 0;
        
        for(; sectionIndex < [self sectionModelsForSearching:searching].count ; sectionIndex++)
        {
            PPSectionModel *existSectionModel = [[self sectionModelsForSearching:searching] objectAtIndex:sectionIndex];

            
            for (NSString *key in array)
            {
                if([key compare:existSectionModel.title options:NSCaseInsensitiveSearch]==NSOrderedSame)
                {
                    existIndex = [array indexOfObject:key];
                    
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            if(targetIndex<existIndex)
            {
                break;
            }
        }
        
     
        if(sectionIndex>[self sectionModelsForSearching:searching].count)
        {
            [[self sectionModelsForSearching:NO] addObject:sectionModel];
        }
        else
        {
            [[self sectionModelsForSearching:NO] insertObject:sectionModel atIndex:sectionIndex];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)fetchSectionModelFromGroupID:(NSString *)groupID
                            sourceID:(NSString *)sourceID
                           searching:(BOOL)searching
    
{
    NSArray *cardModels = nil;
    
    do
    {
        NSError *error = nil;
        
        WCABDataController *abDataController = [[WCABDataController alloc] initWithError:&error];
        
        if(abDataController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        cardModels = [abDataController copyCardModelsForListingWithSourceID:sourceID groupID:groupID error:&error];
        
        [abDataController release];
        
        if(cardModels==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSString *rowText = nil;

        for(WCABCardModel *abCardModel in cardModels)
        {
            @autoreleasepool
            {  
                // 存在姓名欄位
                if([abCardModel fieldCountWithFieldType:WC_FT_Name]>0)
                { 
                    WCFieldModel *nameFieldModel = [abCardModel fieldWithType:WC_FT_Name index:0];
                    
                    NSString *firstName = nil;
                    NSString *lastName = nil;
//                    NSString *middleName = nil;
                    
                    for (WC_FieldSubType2 subType2 = WC_FST2_Name_First; subType2 <=WC_FST2_Name_Suffix; subType2++)
                    {
                        if ([nameFieldModel hasFieldWithSubType2:(WC_FieldSubType2)subType2])
                        {
                            WCFieldModel *subFieldModel = [nameFieldModel fieldWithSubType2:subType2];
                            
                            //////////////////////////////////////////////////
                            
                            switch (subType2)
                            {
                                case WC_FST2_Name_First:
                                {
                                    firstName = subFieldModel.value;
                                    break;
                                }
                                case WC_FST2_Name_Last:
                                {
                                    lastName = subFieldModel.value;
                                    break;
                                }
                                case WC_FST2_Name_Middle:
                                {
//                                    middleName = subFieldModel.value;
                                    break;
                                }
                                case WC_FST2_Name_FirstPhonetic:
                                case WC_FST2_Name_LastPhonetic:
                                case WC_FST2_Name_Prefix:
                                case WC_FST2_Name_Suffix:
                                default:
                                {
                                    break;
                                }
                            }
                        }
                    }
                    
                    //////////////////////////////////////////////////
                    
                    rowText = [WCDisplayNameController displayNameWithFirstName:firstName
                                                                       lastName:lastName
                                                                      eastOrder:self.eastDisplayNameOrder
                                                                      westOrder:self.westDisplayNameOrder];
                }
                else if([abCardModel fieldCountWithFieldType:WC_FT_Company]>0)
                {
                    WCFieldModel *companyFieldModel = [abCardModel fieldWithType:WC_FT_Company index:0];
                    
                    //////////////////////////////////////////////////

                    rowText = [companyFieldModel fieldWithSubType2:WC_FST2_Company_Name].value;
                }
                else if([abCardModel fieldCountWithFieldType:WC_FT_Phone]>0)
                {
                    WCFieldModel *phoneFieldModel = [abCardModel fieldWithType:WC_FT_Phone index:0];
                    
                    //////////////////////////////////////////////////
                    
                    rowText = phoneFieldModel.value;
                }
                else if([abCardModel fieldCountWithFieldType:WC_FT_Email]>0)
                {
                    WCFieldModel *emailFieldModel = [abCardModel fieldWithType:WC_FT_Email index:0];
                    
                    //////////////////////////////////////////////////
                    
                    rowText = emailFieldModel.value;
                }
                else if([abCardModel fieldCountWithFieldType:WC_FT_InstantMessage]>0)
                {
                    WCFieldModel *instantMessageFieldModel = [abCardModel fieldWithType:WC_FT_InstantMessage index:0];
                    
                    //////////////////////////////////////////////////
                    
                    rowText = instantMessageFieldModel.value;
                }
                else if([abCardModel fieldCountWithFieldType:WC_FT_Address]>0)
                {
                    WCFieldModel *addressFieldModel = [abCardModel fieldWithType:WC_FT_Address index:0];
                    
                    //////////////////////////////////////////////////
                
                    NSString *city  = [addressFieldModel fieldWithSubType2:WC_FST2_Address_City].value;
                    NSString *street = [addressFieldModel fieldWithSubType2:WC_FST2_Address_Street].value;
                    NSString *country = [addressFieldModel fieldWithSubType2:WC_FST2_Address_Country].value;
                    NSInteger format = [[[addressFieldModel fieldWithSubType2:WC_FST2_Address_Format] value] integerValue];
                    NSString *state = [addressFieldModel fieldWithSubType2:WC_FST2_Address_State].value;
                    NSString *zip = [addressFieldModel fieldWithSubType2:WC_FST2_Address_ZIP].value;
                    
                    rowText = [PPWorldcardAddressController addressFromStreet:street
                                                                         city:city
                                                                     province:state
                                                                   postalCode:zip
                                                                  countryName:country
                                                                       format:format];
                }
                else if([abCardModel fieldCountWithFieldType:WC_FT_URL]>0)
                {
                    WCFieldModel *urlFieldModel = [abCardModel fieldWithType:WC_FT_URL index:0];
                    
                    //////////////////////////////////////////////////
                    
                    rowText = urlFieldModel.value;
                }
                
                //!! 滿足上傳的case，但最後rowText還是空的，所以這邊強制設定為no name
                // 如，有WC_FT_Company，但沒有公司名，而是只有職稱或部門
                if ([rowText length]==0)
                {
                    rowText = WCABPPV_MLS_NoName;
                }
                
                //////////////////////////////////////////////////
                
                if(rowText!=nil && rowText.length>0)
                {
                    NSString *key = [PPIndexingController indexOfString:rowText forStyle:[self ppIndexingStyleFromPPIndexSectionStyle]];
                    
                    if([key compare:@"#"]==NSOrderedSame)
                    {
                        key = [PPIndexingController indexOfString:rowText forStyle:PPIndexingStyle_English];
                    }
                
                    //////////////////////////////////////////////////

                    PPSectionModel *sectionModel = [self sectionModelWithString:key searching:searching];
                    
                    if(sectionModel==nil)
                    {
                        sectionModel = [[[PPSectionModel alloc] init] autorelease];
                        
                        if(sectionModel!=nil)
                        {
                            sectionModel.title = key;
                            [self addSectionModel:sectionModel searching:searching];
                        }
                    }
                    
                    //////////////////////////////////////////////////
                    
                    PPRowModel *rowModel = [PPRowModel rowModelWithRow:0 text:rowText detailText:nil object:abCardModel];
                    
                    if(rowModel!=nil && sectionModel!=nil)
                    {
                        [sectionModel.rowModels addObject:rowModel];
                    }
                }
  
                // autorelease pool
            }
            
            // loop end
        }
    }
    while (0);
    
    //////////////////////////////////////////////////
    
    [cardModels release];
}

@end
