//
//  WCABPeoplePickerNavigationBarView.m
//
//
//  Created by Howard.Lin on 2014/3/28.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "WCABPeoplePickerNavigationBarView.h"

// Define
#import "WCABPeoplePickerViewController+ResourceDefine.h"
#import "WCAppearanceDefine.h"


// Category
#import "NSString+Additions.h"
#import "PPButton+Factory.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCABPeoplePickerNavigationBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocatinb Object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if(self=[super initWithFrame:frame])
    {
        self.style = PPBarViewStyle_CenteredAbsolute;
        
        //////////////////////////////////////////////////
        
        _backButton = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if(_backButton!=nil)
        {
            [_backButton setTag:WCABPeoplePickerNavigationBarViewButtonTag_Back];
        }
        
        //////////////////////////////////////////////////
        
        _allSelectButton = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if(_allSelectButton!=nil)
        {
            [_allSelectButton setTag:WCABPeoplePickerNavigationBarViewButtonTag_AllSelect];
            [_allSelectButton setImageWithName:WCABPeoplePickerNavigationBarViewAllSelectImage];
        }
        
        //////////////////////////////////////////////////
        
        _doneButton = [[PPButton ppButtonWithIconImageName:WCABPeoplePickerViewControllerButtonDone
                                                       tag:WCABPeoplePickerNavigationBarViewButtonTag_Done
                                                  delegate:nil
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:nil
                                           imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset] retain];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_allSelectButton setDelegate:nil];
    [_allSelectButton removeControlEvents:UIControlEventAllEvents];
    [_allSelectButton removeFromSuperview];
    [_allSelectButton release];
    _allSelectButton = nil;

    [_backButton setDelegate:nil];
    [_backButton removeControlEvents:UIControlEventAllEvents];
    [_backButton removeFromSuperview];
    [_backButton release];
    _backButton = nil;
    
    [_doneButton setDelegate:nil];
    [_doneButton removeControlEvents:UIControlEventAllEvents];
    [_doneButton removeFromSuperview];
    [_doneButton release];
    _doneButton = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}

@end
