//
//  WCABItemSelectFlowControllerDelegate.h
//
//
//  Created by Howard on 2015/10/15.
//
//

#import <Foundation/Foundation.h>
#import <AddressBook/AddressBook.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

@class WCABItemSelectFlowController;
@class WCABGroupModel;

@protocol WCABItemSelectFlowControllerDelegate <NSObject>

@required

/**
 *  選擇的群組
 *
 *  @param abSelectFlowController 委託者
 *  @param abGroupModel           群組模型
 */
- (void)abSelectFlowController:(WCABItemSelectFlowController *)abSelectFlowController
            fromViewController:(UIViewController *)fromViewController
         didSelectABGroupModel:(WCABGroupModel *)abGroupModel;

/**
 *  選擇的連絡人
 *
 *  @param abSelectFlowController 委託者
 *  @param fromViewController     來源視圖
 *  @param abCardModels           連絡人模型集合
 */
- (void)abSelectFlowController:(WCABItemSelectFlowController *)abSelectFlowController
            fromViewController:(UIViewController *)fromViewController
         didSelectABCardModels:(NSArray *)abCardModels;

@optional

/**
 *  預設 GroupID
 *
 *  @param abSelectFlowController 委託者
 *
 *  @return NSString 預設GroupID
 */
- (NSString *)defaultSelectedABGroupIDInABSelectFlowController:(WCABItemSelectFlowController *)abSelectFlowController;


/**
 *  預設 Source ID
 *
 *  @param abSelectFlowController 委託者
 *
 *  @return NSString 預設 Source ID
 */
- (NSString *)defaultSelectedABSourceIDInABSelectFlowController:(WCABItemSelectFlowController *)abSelectFlowController;


/**
 *  連絡人選擇元件發生錯誤
 *
 *  @param error 錯誤
 *
 */
- (void)abSelectFlowControllerFailWithError:(NSError *)error;


@end
