//
//  WCABItemSelectFlowController.m
//
//
//  Created by Howard on 2015/7/28.
//
//

#import "WCABItemSelectFlowController.h"

// Define
#import "WCAppearanceDefine.h"
#import "WCABDataController+ResourceDefine.h"
#import "WCABItemSelectFlowController+ResourceDefine.h"
#import "WCABItemSelectFlowController+SettingsKey.h"

// Controller
#import "PPNavigationController.h"
#import "WCABGroupViewController.h"
#import "WCABPeoplePickerViewController.h"
#import "WCABDataController.h"
#import "WCToastController.h"
#import "PPSettingsController.h"

// Category
#import "NSError+Custom.h"

NSString *const WCABItemSelectFlowController_SettingsKey_ShowExportLimitationAlert = @"WCExportFlowController_SettingsKey_ShowExportLimitationAlert";

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCABItemSelectFlowController ()<WCABGroupViewControllerDelegate,WCABPeoplePickerViewControllerDelegate>

@property (nonatomic,assign,readwrite) WCABItemSelectFlowControllerMode abSelectFlowControllerMode;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCABItemSelectFlowController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

- (id)init
{
    if(self=[super init])
    {
        [PPSettingsController setDefaultIntegerValue:1 withKey:WCABItemSelectFlowControllerSettingKey_PeopleMultiSelect];
    
        //////////////////////////////////////////////////

        [[WCABGroupViewController appearance] setNavigationViewButtonImageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        [[WCABGroupViewController appearance] setNavigationViewButtonHighlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor];
        [[WCABGroupViewController appearance] setTableViewSeparatorColor:WCAppearanceDefine_SeparatorColor];
        
        //////////////////////////////////////////////////

        [[WCABPeoplePickerViewController appearance] setNavigationViewButtonImageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        [[WCABPeoplePickerViewController appearance] setNavigationViewButtonHighlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor];
        [[WCABPeoplePickerViewController appearance] setNavigationViewButtonHighlightedTitleColor:WCAppearanceDefine_LightBlueColor];
        [[WCABPeoplePickerViewController appearance] setTableViewSeparatorColor:WCAppearanceDefine_SeparatorColor];
    }
    
    return self;
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Methods (Send delegate)

//================================================================================
//
//================================================================================
+ (void)requestSendError:(NSError *)error delegate:(id<WCABItemSelectFlowControllerDelegate>)delegate
{
    if([delegate respondsToSelector:@selector(abSelectFlowControllerFailWithError:)]==YES)
    {
        [delegate abSelectFlowControllerFailWithError:error];
    }
}








////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCABGroupViewControllerDelegate Method

//================================================================================
//
//================================================================================
- (void)abGroupViewController:(WCABGroupViewController *)abGroupViewController
        didSelectABGroupModel:(WCABGroupModel *)abGroupModel
{
    if(self.abSelectFlowControllerMode==WCABItemSelectFlowControllerMode_ApToSystemContact)
    {
        if([self.abSelectFlowControllerDelegate respondsToSelector:@selector(abSelectFlowController:fromViewController:didSelectABGroupModel:)]==YES)
        {
            [self.abSelectFlowControllerDelegate abSelectFlowController:self
                                                     fromViewController:abGroupViewController
                                                  didSelectABGroupModel:abGroupModel];
        }
    }
    else
    {
        [WCABDataController checkAccessPermissionWithCompletion:^(BOOL authorized){
            
            if(authorized==YES)
            {
                WCABPeoplePickerViewController *abPeoplePickerViewController = [[WCABPeoplePickerViewController alloc] init];
                
                if(abPeoplePickerViewController!=nil)
                {
                    abPeoplePickerViewController.delegate = self;
                    abPeoplePickerViewController.groupID  = abGroupModel.abGroupID;
                    abPeoplePickerViewController.sourceID = abGroupModel.abSourceID;
                    
                    //////////////////////////////////////////////////

                    abPeoplePickerViewController.multiSelect = [PPSettingsController integerValueWithKey:WCABItemSelectFlowControllerSettingKey_PeopleMultiSelect];
                    
                    //////////////////////////////////////////////////
                    
                    abPeoplePickerViewController.ppIndexSectionControllerStyle = self.indexSectionControllerStyle;
                    
                    abPeoplePickerViewController.eastDisplayNameOrder = self.eastDisplayNameOrder;
                    abPeoplePickerViewController.westDisplayNameOrder = self.westDisplayNameOrder;
                    
                    //////////////////////////////////////////////////
                    
                    [abGroupViewController.navigationController pushViewController:abPeoplePickerViewController animated:YES];
                }
                
                [abPeoplePickerViewController release];
            }
            else
            {
                NSError *showError = nil;
                
                showError = PPErrorMake(WCABItemSelectFlowControllerErrorCode_NoAddressBookPermission, WCAIS_MLS_NoAddressBookPermission, showError);
                
                //////////////////////////////////////////////////
                
                [WCABItemSelectFlowController requestSendError:showError delegate:self.abSelectFlowControllerDelegate];
            }
        }];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCABPeoplePickerViewControllerDelegate Method

//================================================================================
//
//================================================================================
- (void)ppABPeoplePickerViewController:(WCABPeoplePickerViewController *)ppABPeoplePickerViewController
                   didSelectCardModels:(NSMutableArray *)cardModels
{
    if([self.abSelectFlowControllerDelegate respondsToSelector:@selector(abSelectFlowController:fromViewController:didSelectABCardModels:)]==YES)
    {
        [self.abSelectFlowControllerDelegate abSelectFlowController:self
                                                 fromViewController:ppABPeoplePickerViewController
                                              didSelectABCardModels:cardModels];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (instancetype)sharedInstance
{
    static id sharedInstance = nil;
    static dispatch_once_t onceToken;
    
    dispatch_once(&onceToken, ^{
        sharedInstance = [[self alloc] init];
    });
    
    return sharedInstance;
}


//================================================================================
//
//================================================================================
+ (void)showGroupViewControllerWithABSelectFlowControllerMode:(WCABItemSelectFlowControllerMode)abSelectFlowControllerMode
                               abSelectFlowControllerDelegate:(id<WCABItemSelectFlowControllerDelegate>)abSelectFlowControllerDelegate
                                              syncAccountName:(NSString *)syncAccountName
                                      fromSuperViewController:(UIViewController *)superViewController
{
    [WCABDataController checkAccessPermissionWithCompletion:^(BOOL authorized){

        if(authorized==YES)
        {
            // 如果只有一個gmail, 並帳號與目前登入的帳號一樣，就不允許開啟
            WCABDataController *abDataController = [[WCABDataController alloc] initWithError:nil];
        
            if([abDataController defaultSourceIDWithExcludedGmailAccount:syncAccountName]==nil)
            {
                NSString *message = [NSString stringWithFormat:WCAIS_MLS_NoUsableSourceAndGroup, syncAccountName];
                [WCToastController showMessageToastFromSuperView:superViewController.view
                                                     withMessage:message
                                                        position:PPToastPositionCenter];
            }
            else
            {
                [WCABItemSelectFlowController sharedInstance].abSelectFlowControllerDelegate = abSelectFlowControllerDelegate;
                [WCABItemSelectFlowController sharedInstance].abSelectFlowControllerMode     = abSelectFlowControllerMode;
                
                //////////////////////////////////////////////////

                // 單多選切換
                if(abSelectFlowControllerMode==WCABItemSelectFlowControllerMode_MergeSystemContact)
                {
                    [PPSettingsController setIntegerValue:0 withKey:WCABItemSelectFlowControllerSettingKey_PeopleMultiSelect];
                }
                else
                {
                    [PPSettingsController setIntegerValue:1 withKey:WCABItemSelectFlowControllerSettingKey_PeopleMultiSelect];
                }
                
                //////////////////////////////////////////////////
                
                WCABGroupViewController *abGroupViewController = [[WCABGroupViewController alloc] init];
                
                if(abGroupViewController!=nil)
                {
                    abGroupViewController.delegate = [WCABItemSelectFlowController sharedInstance];
                    
                    //////////////////////////////////////////////////
                    
                    abGroupViewController.syncAccountName = syncAccountName;
                    
                    //////////////////////////////////////////////////
                    
                    if([abSelectFlowControllerDelegate respondsToSelector:@selector(defaultSelectedABGroupIDInABSelectFlowController:)]==YES &&
                       [abSelectFlowControllerDelegate respondsToSelector:@selector(defaultSelectedABSourceIDInABSelectFlowController:)]==YES)
                    {
                        abGroupViewController.selectedGroupID = [abSelectFlowControllerDelegate defaultSelectedABGroupIDInABSelectFlowController:[WCABItemSelectFlowController sharedInstance]];
                        
                        abGroupViewController.selectedSourceID = [abSelectFlowControllerDelegate defaultSelectedABSourceIDInABSelectFlowController:[WCABItemSelectFlowController sharedInstance]];
                        
                        //////////////////////////////////////////////////
                        
                        abGroupViewController.checkMarkCell = YES;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
                    {
                        
                        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:abGroupViewController];
                        
                        if(navigationController!=nil)
                        {
                            [superViewController presentViewController:navigationController animated:YES completion:nil];
                        }
                        
                        [navigationController release];
                    }
                    else
                    {
                        if(superViewController.navigationController!=nil)
                        {
                            [superViewController.navigationController pushViewController:abGroupViewController animated:YES];
                        }
                        else
                        {
                            PPNavigationController *navigationController =[[PPNavigationController alloc] initWithRootViewController:abGroupViewController];
                            
                            if(navigationController!=nil)
                            {
                                [superViewController presentViewController:navigationController animated:YES completion:nil];
                            }
                            
                            [navigationController release];
                        }
                    }
                }
                
                [abGroupViewController release];
                
                //////////////////////////////////////////////////
                if([PPSettingsController integerValueWithKey:WCABItemSelectFlowController_SettingsKey_ShowExportLimitationAlert])
                {
                    // 等頁面出現後再顯示toast所以等0.3秒
                    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.3 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
                        [WCToastController showMessageToastFromSuperView:[UIApplication sharedApplication].keyWindow
                                                             withMessage:WCAIS_MLS_ExportLimitationAlert
                                                    messageTextAlignment:NSTextAlignmentLeft
                                                                position:PPToastPositionCenter];
                    });
                }
            }
            
            [abDataController release];

        }
        else
        {
            NSError *showError = nil;
            
            showError = PPErrorMake(WCABItemSelectFlowControllerErrorCode_NoAddressBookPermission, WCAIS_MLS_NoAddressBookPermission, showError);
            
            //////////////////////////////////////////////////

            [WCABItemSelectFlowController requestSendError:showError delegate:abSelectFlowControllerDelegate];
        }
    }];
}

@end
