//
//  WCABGroupViewController.m
//
//
//  Created by Howard.Lin on 2014/3/26.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "UIViewController+ShareApplication.h"
#import "WCABGroupViewController.h"

// Define
#import "WCABGroupViewController+ResourceDefine.h"
#import "WCAppearanceDefine.h"

// View
#import "WCABGroupNavigationBarView.h"
#import "PPButton.h"
#import "PPTableView.h"

// Controller
#import "WCABGroupSectionController.h"
#import "WCToastController.h"

// Category
#import "NSString+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCABGroupViewController () <PPButtonDelegate,UITableViewDataSource,UITableViewDelegate>

@property (nonatomic,retain) WCABGroupSectionController *ppABGroupSectionController;
@property (nonatomic,retain) WCABGroupNavigationBarView *ppABGroupNavigationBarView;
@property (nonatomic,retain) PPTableView                *ppABGroupTableView;
@property (nonatomic,retain) NSIndexPath                *lastSelectIndexPath;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCABGroupViewController


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object Method

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        [[WCABGroupViewController appearance] applyInvocationTo:self];
        
        //////////////////////////////////////////////////

        self.hidesBottomBarWhenPushed = YES;
        
        _ppABGroupSectionController = [[WCABGroupSectionController alloc] init];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_userInfo release];
    _userInfo = nil;
    
    [_ppABGroupSectionController release];
    _ppABGroupSectionController = nil;
    
    [_ppABGroupTableView setDataSource:nil];
    [_ppABGroupTableView setDelegate:nil];
    [_ppABGroupTableView removeFromSuperview];
    [_ppABGroupTableView release];
    _ppABGroupTableView = nil;
    
    [_ppABGroupNavigationBarView removeFromSuperview];
    [_ppABGroupNavigationBarView release];
    _ppABGroupNavigationBarView = nil;
    
    [_lastSelectIndexPath release];
    _lastSelectIndexPath = nil;
    
    [_navigationViewButtonHighlightedBackgroundColor release];
    _navigationViewButtonHighlightedBackgroundColor = nil;

    [_tableViewSeparatorColor release];
    _tableViewSeparatorColor = nil;
    
    [_syncAccountName release];
    _syncAccountName = nil;
    
    [_selectedGroupID release];
    _selectedGroupID = nil;
    
    [_selectedSourceID release];
    _selectedSourceID = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark -  Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////

    [self.ppABGroupSectionController fetchSectionModelWithSyncAccountName:self.syncAccountName];
    
    //////////////////////////////////////////////////
    
    if(self.ppABGroupTableView==nil)
    {
        _ppABGroupTableView = [[PPTableView alloc] initWithFrame:CGRectZero style:UITableViewStylePlain];
    }
    
    if(self.ppABGroupTableView!=nil)
    {
        self.ppABGroupTableView.dataSource = self;
        self.ppABGroupTableView.delegate   = self;
        
        if(self.tableViewSeparatorColor!=nil)
        {
            self.ppABGroupTableView.separatorColor = self.tableViewSeparatorColor;
        }
        
        [self.view addSubview:self.ppABGroupTableView];
    }
    
    //////////////////////////////////////////////////
    
    if(self.ppABGroupNavigationBarView==nil)
    {
        _ppABGroupNavigationBarView = [[WCABGroupNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    }
    
    if(self.ppABGroupNavigationBarView!=nil)
    {
        [self.ppABGroupNavigationBarView.backButton addControlEvents:UIControlEventTouchUpInside];
        self.ppABGroupNavigationBarView.backButton.delegate = self;
        
        //////////////////////////////////////////////////
        
        if(self.navigationViewButtonHighlightedBackgroundColor!=nil)
        {
            [self.ppABGroupNavigationBarView.backButton setBackgroundImage:[UIImage imageWithColor:self.navigationViewButtonHighlightedBackgroundColor] forState:UIControlStateHighlighted];
        }
        
        //////////////////////////////////////////////////
        
        [self.ppABGroupNavigationBarView.backButton setImageWithName:ImageNamePPButtonIconForSystemBackImitation];
        [self.ppABGroupNavigationBarView.backButton setImageEdgeInsets:self.navigationViewButtonImageEdgeInsets];
        
        //////////////////////////////////////////////////

        if(self.ppABGroupNavigationBarView.backButton.imageView.image==nil)
        {
            [self.ppABGroupNavigationBarView.backButton setTitle:[@"MLS_Back" localizedFromTable:NSStringFromClass([self.ppABGroupNavigationBarView.backButton class])] maxWidth:0.0];
        }
        else
        {
            PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppABGroupNavigationBarView.backButton];
            
            if(itemModel!=nil)
            {
                itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                [self.ppABGroupNavigationBarView setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
            }
        }
        
        //////////////////////////////////////////////////

        if(self.navigationController!=nil)
        {
            UIBarButtonItem *leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.ppABGroupNavigationBarView];
            
            if(leftBarButtonItem!=nil)
            {
                self.navigationItem.leftBarButtonItem = leftBarButtonItem;
            }
            
            [leftBarButtonItem release];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    self.ppABGroupTableView.frame = [self layoutFrame];
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [super viewDidDisappear:animated];
    
    //////////////////////////////////////////////////
    
    [self.ppABGroupNavigationBarView removeFromSuperview];
    self.ppABGroupNavigationBarView = nil;
    
    self.ppABGroupTableView.dataSource = nil;
    self.ppABGroupTableView.delegate   = nil;
    
    [self.ppABGroupTableView removeFromSuperview];
    self.ppABGroupTableView = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property methods

//================================================================================
//
//================================================================================
- (void)setNavigationViewButtonHighlightedBackgroundColor:(UIColor *)navigationViewButtonHighlightedBackgroundColor
{
    [_navigationViewButtonHighlightedBackgroundColor release];
    _navigationViewButtonHighlightedBackgroundColor = [navigationViewButtonHighlightedBackgroundColor retain];
}


//================================================================================
//
//================================================================================
- (void)setTableViewSeparatorColor:(UIColor *)tableViewSeparatorColor
{
    [_tableViewSeparatorColor release];
    _tableViewSeparatorColor = [tableViewSeparatorColor retain];
}


//================================================================================
//
//================================================================================
- (void)setNavigationViewButtonImageEdgeInsets:(UIEdgeInsets)navigationViewButtonImageEdgeInsets
{
    _navigationViewButtonImageEdgeInsets = navigationViewButtonImageEdgeInsets;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAppearance protocol methods

//================================================================================
//
//================================================================================
+ (id)appearance
{
    // MARK: 實作+appearance的方式固定如下
    return [PPAppearance appearanceForClass:[self class]];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButton Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCABGroupNavigationBarViewButtonTag_Back:
        {
            [self goBackAnimated:YES];
            
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSource Method

//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [self.ppABGroupSectionController numberOfRowsInSection:section forSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return [self.ppABGroupSectionController numberOfSectionsForSearching:NO];
}


//===============================================================================
//
//===============================================================================
- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    NSString *title = nil;
    
    if([self.ppABGroupSectionController sectionModelsForSearching:NO].count>section)
    {
        PPSectionModel *sectionModel = [[self.ppABGroupSectionController sectionModelsForSearching:NO] objectAtIndex:section];
        
        title = sectionModel.title;
    }
    
    return title;
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSString *CellIdentifier = NSStringFromClass([UITableViewCell class]);
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    
    if (cell == nil)
	{
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
    }
 
    //////////////////////////////////////////////////
    
    if(cell.selectedBackgroundView!=nil)
    {
        cell.selectedBackgroundView = [[[UIView alloc] init] autorelease];
        cell.selectedBackgroundView.backgroundColor = WCAppearanceDefine_CellHighlightedBGColor;
    }
   
    //////////////////////////////////////////////////

    PPRowModel *rowModel = [self.ppABGroupSectionController rowModelAtIndexPath:indexPath forSearching:NO];

    if(rowModel!=nil &&
       rowModel.object!=nil &&
       [rowModel.object isKindOfClass:[WCABGroupModel class]]==YES)
    {
        WCABGroupModel *dispGroup = rowModel.object;
        cell.textLabel.text = dispGroup.name;

        // 如果dispGroup.abGroupID與self.selectedGroupID都是nil，也算是一樣
        if(self.checkMarkCell==YES &&
           [dispGroup.abSourceID isEqualToString:self.selectedSourceID]==YES &&
           ((dispGroup.abGroupID==nil&&self.selectedGroupID==nil)||([dispGroup.abGroupID isEqualToString:self.selectedGroupID]==YES)))
        {
            cell.accessoryType = UITableViewCellAccessoryCheckmark;
            self.lastSelectIndexPath = indexPath;
        }
        else
        {
            cell.accessoryType = UITableViewCellAccessoryNone;
        }
    }

    return cell;
}


//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return WCABGroupViewControllerSectionHeaderHeight;
}


//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return WCABGroupViewControllerTableViewCellHeight;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDelegate Method

//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    PPRowModel *rowModel = [self.ppABGroupSectionController rowModelAtIndexPath:indexPath forSearching:NO];
    
    if(rowModel!=nil &&
       rowModel.object!=nil &&
       [rowModel.object isKindOfClass:[WCABGroupModel class]]==YES)
    {
        WCABGroupModel *dispGroupModel = rowModel.object;
        
        //////////////////////////////////////////////////

        //有同步帳號時，gmail群組不能選
        NSString *sectionTitle = [self.ppABGroupSectionController titleForHeaderInSection:indexPath.section forSearching:NO];
        
        if([self.syncAccountName length]>0 &&
           [sectionTitle compare:@"Gmail" options:NSCaseInsensitiveSearch]==NSOrderedSame)
        {
            if(self.checkMarkCell==YES)
            {
                //////////////////////////////////////////////////
                
                if(self.lastSelectIndexPath!=nil &&
                   (self.lastSelectIndexPath.section!=indexPath.section ||
                    self.lastSelectIndexPath.row!=indexPath.row))
                {
                    [tableView reloadRowsAtIndexPaths:@[self.lastSelectIndexPath,indexPath] withRowAnimation:UITableViewRowAnimationNone];
                }
            }
            
            [WCToastController showMessageToastFromSuperView:self.view withMessage:WCABGVC_ExistGmailAccountDontUseGmailAtSystemContacts position:PPToastPositionCenter];
        }
        else
        {
            if(self.checkMarkCell==YES)
            {
                self.selectedGroupID = dispGroupModel.abGroupID;
                self.selectedSourceID = dispGroupModel.abSourceID;
                
                //////////////////////////////////////////////////
                
                if(self.lastSelectIndexPath!=nil &&
                   (self.lastSelectIndexPath.section!=indexPath.section ||
                    self.lastSelectIndexPath.row!=indexPath.row))
                {
                    [tableView reloadRowsAtIndexPaths:@[self.lastSelectIndexPath,indexPath] withRowAnimation:UITableViewRowAnimationNone];
                }
            }
            
            //////////////////////////////////////////////////
            
            if([self.delegate respondsToSelector:@selector(abGroupViewController:didSelectABGroupModel:)]==YES)
            {
                [self.delegate abGroupViewController:self
                               didSelectABGroupModel:dispGroupModel];
            }
        }
    }
}

@end
