//
//  WCABGroupSectionController.m
//
//
//  Created by Howard.Lin on 2014/3/26.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "WCABGroupSectionController.h"

// Model
#import "WCABSourceModel.h"

// View

// Controller
#import "WCABDataController.h"

// Category


////////////////////////////////////////////////////////////////////////////////////////////////////


@implementation WCABGroupSectionController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)fetchSectionModelWithSyncAccountName:(NSString *)syncAccountName
{
    [[self sectionModelsForSearching:NO] removeAllObjects];
    
    //////////////////////////////////////////////////

    WCABDataController *dataController = [[WCABDataController alloc] initWithError:nil];
    
    if(dataController!=nil)
    {
        NSArray *sources = [dataController copyAllSourcesAndGroups];
        
        //////////////////////////////////////////////////
        
        PPSectionModel *sectionModel = nil;
        
        for(WCABSourceModel *sourceModel in sources)
        {
//            //有同步帳號時，gmail群組不列出
//            if([syncAccountName length]>0 &&
//               [sourceModel.name compare:@"Gmail" options:NSCaseInsensitiveSearch]==NSOrderedSame)
//            {
//                continue;
//            }
            
            //////////////////////////////////////////////////

            sectionModel = [[PPSectionModel alloc] init];
            
            if(sectionModel!=nil)
            {
                sectionModel.section = sectionModel.rowModels.count;
                sectionModel.title   = sourceModel.name;
                
                for(WCABGroupModel *groupModel in sourceModel.groupModels)
                {
                    PPRowModel *rowModel = [[PPRowModel alloc] init];
                    
                    rowModel.object = groupModel;
                    
                    [sectionModel.rowModels addObject:rowModel];
                    
                    [rowModel release];
                }
                
                [[self sectionModelsForSearching:NO] addObject:sectionModel];
            }

            [sectionModel release];
        }
        
        [sources release];
        sources = nil;
    }
    
    [dataController release];
}

@end
