//
//  WCABDataController.h
//
//
//  NOTE
//  --------------------
//  1. 拿掉isCanUseAddressbook，新作法沒有權限init回傳nil。
//  2. 拿掉copySystemPropleWithSourceID/comparePeopleArrayWithCardModel/copyDisplayWCCardModelFromABRecordRef，personID會由外部紀錄。
//  3. AB的label可以填自訂的字串
//  4. 取ABPerson資料時需要特別處理exchageType的資料？(目前不處理 2015/07/23)
//  5. Address資料在source為exchange時，本來會將順序調整成Other/Work/Home，但不知道用意在哪，先不做。
//

// Container
// local: name: null, type:1
// Penpower exchange: name: 連絡人, type:2
// Outlook.com: name: 連絡人, type:2
// icloud: name: Card, type:3
// Gmail: name: Address book, type:3
// Facebook: name: @"", type:3


////////////////////////////////////////////////////////////////////////////////////////////////////
//exchange匯出欄位限制
//姓氏    1
//中間名    1
//名字    1
//姓名前稱謂    1
//姓名後稱謂    1
//公司    1
//*姓氏讀音    1
//*名字讀音    1
//*公司讀音    1
//部門    1
//職稱    1
//
//電話(12)
//公司：2
//住家：2
//行動電話：1
//公司傳真：1
//家用傳真：1
//呼叫器：1
//
//Email(3)
//公司：1
//住家：1
//其他：1
//
//網址(1)
//首頁
//
//地址(3)
//公司：1
//住家：1
//
//
//生日(1)
//紀念日/其他(1)
//即時通訊(3)
//Note(1)
//暱稱(1)
////////////////////////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
#import "WCABSourceModel.h"
#import "WCABGroupModel.h"
#import "WCABCardModel.h"
#import <Contacts/Contacts.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification Parameter

extern NSString * const WCABDC_FetchCardModelsProgress;

////////////////////////////////////////////////////////////////////////////////////////////////////

/// Error code of WCABDataController
typedef NS_OPTIONS(NSInteger, WCABDataController_Error)
{
    WCABDataController_Error_Unknown = 0,
    WCABDataController_Error_NoAccessPermission,
    WCABDataController_Error_InvalidParameters,
    WCABDataController_Error_FailedToInitObject,
    WCABDataController_Error_FailedToCreatePerson,
    WCABDataController_Error_FailedToCreateContactStore,
    WCABDataController_Error_FailedToGetSourceController,
    WCABDataController_Error_FailedToGetSourceID,
    WCABDataController_Error_FailedToGetContact,
    WCABDataController_Error_FailedToConvertImageData,
    WCABDataController_Error_FailedToSetImageData,
    WCABDataController_Error_FailedToGetImageData,
    WCABDataController_Error_FailedToAddRecord,
    WCABDataController_Error_FailedToSaveAddressBook,
    WCABDataController_Error_FailedToRemoveRecord,
    WCABDataController_Error_FailedToSetPropertyValue,
    WCABDataController_Error_FailedToRemovePersonFromCurrentGroup,
    WCABDataController_Error_FailedToAddPersonToNewGroup,
    WCABDataController_Error_FailedToConvertVCard,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCABDataController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods

/**
 * 檢查操作權限 （init前一定要使用）
 *
 * @param completion - completion block
 */
+ (void)checkAccessPermissionWithCompletion:(void (^)(BOOL authorized))completion;


// 是否加入備註欄位轉換 (IOS 13要額外權限)
+ (void)setNoteFieldTransform:(BOOL)noteFieldTransform;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods (init)

/**
 * initialize
 *
 * @param error - return error
 * @return WCABDataController instance
 */
- (id)initWithError:(NSError **)error;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods (person)
/**
 * 新增群組
 * @param sourceID 指定要新增到哪一個群組
 * @param name 群組名稱
 * @return NSString 新增的群組的groupID
 */
- (NSString *)addGroupWithSourceID:(NSString *)sourceID name:(NSString *)name;

- (void)deleteGroupWithGroupID:(NSString *)groupID;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods (person)

/**
 * 取得顯示AddressBook聯絡人列表時所需的資料 (姓名資料及personID）
 *
 * @param sourceID source ID of contact in container
 * @param groupID Address book group ID, nil代表取整個source資料。
 * @param error return error
 * @return Array of WCABCardModel，回傳WC_FT_Name欄位資料/abPersonID。
 */
- (NSArray *)copyCardModelsForListingWithSourceID:(NSString *)sourceID groupID:(NSString *)groupID error:(NSError **)error;

/**
 * 取得AddressBook聯絡人完整資料 (所有欄位資料及影像)
 *
 * @param name - 欲取得資料的名片名稱
 * @param error - return error
 * @return 回傳所有欄位資料/abPhotoImage。
 */
- (WCABCardModel *)copyCardModelWithName:(NSString *)name error:(NSError **)error;

/**
 * 取得AddressBook聯絡人完整資料 (所有欄位資料及影像)
 *
 * @param personID - 欲取得資料的AddressBook person ID
 * @param error - return error
 * @return 回傳所有欄位資料/abPhotoImage。
 */
- (WCABCardModel *)copyCardModelWithPersonID:(NSString *)personID error:(NSError **)error;

/**
 * 新增AddressBook聯絡人
 *
 * @param cardModel - 要新增的資料內容。若abSourceID及abGroupID沒有指定，代表使用預設值。
 * @param error - return error
 * @return YES if success（新的abPrsonID/abGroupID/abSourceID會更新在cardModel中）
 */
- (BOOL)addPersonWithCardModel:(WCABCardModel *)cardModel error:(NSError **)error;

/**
 * 刪除AddressBook聯絡人
 *
 * @param personID - 欲刪除的AddressBook personID
 * @param error - return error
 * @return YES if success
 */
- (BOOL)removePersonWithPersonID:(NSString *)personID error:(NSError **)error;

/**
 * 更新AddressBook聯絡人
 *
 * @param cardModel - 欲更新的AddressBook聯絡人資料，abSourceID/abGroupID/abPersonID必須要填入目前所在的位置。
 * @param newSourceID - 新的source位置
 * @param newGroupID - 新的group位置
 * @param error - return error
 * @return YES if success
 */
- (BOOL)updatePersonWithCardModel:(WCABCardModel *)cardModel
                      newSourceID:(NSString *)newSourceID
                       newGroupID:(NSString *)newGroupID
                            error:(NSError **)error;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods (OpenIn)

/**
 * Update Photo
 *
 * @param photoImage - ID photo image, nil表示要刪除圖片
 * @param personID - AddressBook person ID
 * @param error - return error
 * @return YES if update success
 */
- (BOOL)updatePersonPhotoImage:(UIImage *)photoImage withPersonID:(NSString *)personID error:(NSError **)error;

/**
 * Get Photo
 *
 * @param personID - AddressBook person ID
 * @param error - return error
 * @return ID photo image
 */
- (UIImage *)copyPhotoImageWithPersonID:(NSString *)personID error:(NSError **)error;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods (source)

/**
 * 取得預設sourceID
 *
 * @param excludedGmailAccount - 如果該source是gmail, 且account與excludedGmailAccount一樣，就不能當預設
 * @return Source record ID，如果都沒有可以當預設的，回傳kABRecordInvalidID
 */
- (NSString*)defaultSourceIDWithExcludedGmailAccount:(NSString *)excludedGmailAccount;

/**
 * 檢查source是否存在
 *
 * @param sourceID - source record ID
 * @return YES if exist
 */
- (BOOL)isSourceExist:(NSString*)sourceID;

/**
 * 取得所有source及group資料
 *
 * @return Array of WCABSourceModel
 */
- (NSArray *)copyAllSourcesAndGroups;

/**
 * 取得顯示名稱(source.group)
 *
 * @param sourceID - source record ID
 * @param groupID - group record ID
 * @return 顯示名稱(source.group)
 */
- (NSString *)displayNameWithSourceID:(NSString *)sourceID
                              groupID:(NSString *)groupID;

/**
 * 取得source資料
 *
 * @param sourceID - source record ID
 * @return WCABSourceModel
 */
- (WCABSourceModel *)sourceModelWithSourceID:(NSString *)sourceID;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods (vCard)

/**
 * 從vCard資料產生WCABCardModel
 * 目前不讀取影像
 *
 * @param vCardData - Input vCard data
 * @param error - return error
 * @return WCABCardModel
 */
- (WCABCardModel *)cardModelWithVCardData:(NSData *)vCardData error:(NSError **)error;


/**
 * 從WCABCardModel產生vCard資料
 * 目前不寫入Anniversary/Other Date
 * 影像由外部傳入的值(cardModel.abPhotoImage)決定是否要寫入
 *
 * @param cardModel - WCABCardModel
 * @param error - return error
 * @return vCard data
 */
- (NSData *)vCardDataWithCardModel:(WCABCardModel *)cardModel error:(NSError **)error;

@end
