//
//  ABDCSourceController.m
//  Pods
//
//  Created by eddie on 2015/7/21.
//
//

#import "ABDCSourceController.h"
#import "WCABSourceModel.h"
#import "WCABGroupModel.h"
#import "WCABDataController+ResourceDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString * const ABDCSC_TempExchangePrefix = @"TempExchangeID-";
static NSString *const ABDCSC_SourceName_Local = @"iPhone";
static NSString *const ABDCSC_SourceName_iCloud = @"iCloud";
static NSString *const ABDCSC_SourceName_Gmail = @"Gmail";
static NSString *const ABDCSC_SourceName_Exchange = @"Exchange";
static NSString *const ABDCSC_SourceName_Facebook = @"Facebook";
static NSString *const ABDCSC_SourceName_Yahoo = @"Yahoo!";
//static NSString *const ABDCSC_SourceName_Outlook = @"Outlook";

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ABDCSC_SourceInfoModel

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.sourceName = nil;
    self.displayName = nil;
    self.host = nil;
    self.prop5Value = nil;
    
    [super dealloc];
}


//===============================================================================
//
//===============================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"type:%td, sourceName:%@, displayName:%@ host:%@", self.type, self.sourceName, self.displayName, self.host];
}

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ABDCSourceController ()

/// 只允許某個server的source (測試用)  ex: @"mail.penpower.com.tw"
@property (nonatomic, retain) NSString *availableServer;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ABDCSourceController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods



//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.contactStore = nil;
    self.availableServer = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private methods


//==============================================================================
//
//==============================================================================
- (NSString *)containerNameWithName:(NSString *)name type:(CNContainerType)type
{
    NSString *containerName = @"";
    switch (type)
    {
        case CNContainerTypeCardDAV:
        {
            if ([name isEqualToString:@""])
            {
                containerName = ABDCSC_SourceName_Facebook;
            }
            else if([name isEqualToString:@"Address Book"])
            {
                containerName = ABDCSC_SourceName_Gmail;
            }
            else if([name isEqualToString:@"Card"])
            {
                containerName = ABDCSC_SourceName_iCloud;
            }
            else  if([name isEqualToString:@"Contacts"])
            {
                containerName = ABDCSC_SourceName_Yahoo;
            }
            break;
        }
        case CNContainerTypeExchange:
        {
            containerName = ABDCSC_SourceName_Exchange;
            break;
        }
        case CNContainerTypeLocal:
        default:
        {
            containerName = ABDCSC_SourceName_Local;
            break;
        }
    }
    
    return containerName;
}


//===============================================================================
//
//===============================================================================
- (WCABSourceModel *)findSourceInSourceModels:(NSArray *)sourceModels name:(NSString *)name
{
    for(WCABSourceModel *dispSource in sourceModels)
    {
        if([dispSource.name isEqualToString:name])
            return dispSource;
    }
    
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)copyGroupModelsWithSourceID:(NSString *_Nonnull)sourceID allGroupName:(NSString*)allGroupName
{
    NSError *error = nil;
    WCABGroupModel *dispGroupModel = nil;
    NSMutableArray *dispGroupArray = [[NSMutableArray alloc] init];

    
    NSPredicate *groupPredicate = [CNGroup predicateForGroupsInContainerWithIdentifier:sourceID];
    
    NSArray *groups = [self.contactStore groupsMatchingPredicate:groupPredicate error:&error];
    for (CNGroup *group in groups)
    {
        dispGroupModel = [[WCABGroupModel alloc] init];
        dispGroupModel.abSourceID = sourceID;
        dispGroupModel.abGroupID = group.identifier;
        dispGroupModel.name = group.name;
        [dispGroupArray addObject:dispGroupModel];
        [dispGroupModel release];
    }
    
    // add default group
    dispGroupModel = [[WCABGroupModel alloc] init];
    dispGroupModel.abSourceID = sourceID;
    dispGroupModel.abGroupID = nil;
    dispGroupModel.name = WCABDC_MLS_All;
    [dispGroupArray insertObject:dispGroupModel atIndex:0];
    [dispGroupModel release];
    
    return dispGroupArray;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - local source methods


//==============================================================================
//
//==============================================================================
- (NSString *)localSourceID
{
    return [self.contactStore defaultContainerIdentifier];
}


//==============================================================================
// 回傳Local的SourceModel
//==============================================================================
- (WCABSourceModel *)sourceModelForLocal
{
    NSString *abSourceID = [self localSourceID];
    
    if([abSourceID length]==0)
    {
        return nil;
    }
    
    NSMutableArray *groups = [NSMutableArray array];
    WCABGroupModel *localGroupModel = [[WCABGroupModel alloc] init];
    localGroupModel.abSourceID = abSourceID;
    localGroupModel.abGroupID = nil;
    localGroupModel.name = WCABDC_MLS_All;
    [groups addObject:localGroupModel];
    [localGroupModel release];
    
    //////////////////////////////////////////////////
    WCABSourceModel *localSourceModel = [[WCABSourceModel alloc] init];
    // !! source name用大寫，與系統類似
    localSourceModel.name = [ABDCSC_SourceName_Local uppercaseString];
    localSourceModel.abSourceID = abSourceID;
    localSourceModel.abSourceType = CNContainerTypeLocal;
    localSourceModel.groupModels = groups;
    
    return [localSourceModel autorelease];
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods

//===============================================================================
//
//===============================================================================
- (NSString *)defaultSourceID
{
    return [self.contactStore defaultContainerIdentifier];
    NSError *error = nil;

    NSPredicate *defaultContainerPredicate = [CNContainer predicateForContainersWithIdentifiers:@[[self.contactStore defaultContainerIdentifier]]];
    NSArray *container = [self.contactStore containersMatchingPredicate:defaultContainerPredicate error:&error];
    
    return [[container firstObject] identifier];
}



//===============================================================================
// !! 檢查source是否還存在
//===============================================================================
- (BOOL)isSourceExist:(NSString *)sourceID
{
    NSError *error = nil;
    BOOL isExist = NO;
    
    if ([sourceID length]==0)
    {
        return NO;
    }
    
    NSPredicate *containerPredicate = [CNContainer predicateForContainersWithIdentifiers:@[sourceID]];
    
    NSArray *container = [self.contactStore containersMatchingPredicate:containerPredicate error:&error];
    
    if(error==nil &&
       [container count])
    {
        isExist = YES;
    }
    
    return isExist;
}


//===============================================================================
//
//===============================================================================
- (NSMutableArray *)copyAllSourcesAndGroups
{
    NSError *error = nil;
    NSMutableArray  *sourceModels = [[NSMutableArray alloc] init];

    //////////////////////////////////////////////////

    NSArray *allContainers = [self.contactStore containersMatchingPredicate:nil error:&error];
    
    for (CNContainer *container in allContainers) {
        
        NSMutableArray *groupModels = nil;
        NSString *sourceName = [self containerNameWithName:container.name type:container.type];
        
        // !! facebook只能匯入，不能匯出，這邊先濾掉
        if ([sourceName isEqualToString:ABDCSC_SourceName_Facebook])
        {
            continue ;
        }
        

        //////////////////////////////////////////////////
        if (container.type==CNContainerTypeExchange)
        {
            NSMutableArray *dispGroupArray = [[NSMutableArray alloc] init];
            // add default group
            WCABGroupModel *dispGroupModel = [[WCABGroupModel alloc] init];
            dispGroupModel.abSourceID = container.identifier;
            dispGroupModel.abGroupID = nil;
            dispGroupModel.name = [container.name length]?container.name:WCABDC_MLS_All;
            [dispGroupArray insertObject:dispGroupModel atIndex:0];
            [dispGroupModel release];
            
            groupModels = dispGroupArray;            
        }
        else
        {
            groupModels = [self copyGroupModelsWithSourceID:container.identifier allGroupName:sourceName];
        }
        
        //////////////////////////////////////////////////
        WCABSourceModel *dispSourceModel = nil;
        
        dispSourceModel = [[WCABSourceModel alloc] init];
        // !! source name用大寫，與系統類似
        dispSourceModel.name = [sourceName uppercaseString];
        dispSourceModel.abSourceID = container.identifier;
        dispSourceModel.abSourceType = container.type;
        dispSourceModel.groupModels = groupModels;
        [sourceModels addObject:dispSourceModel];
        [dispSourceModel release];
        
        
        [groupModels release];
    }
    
    return sourceModels;

}


//===============================================================================
//
//===============================================================================
- (NSString *)displayNameWithSourceID:(NSString *)sourceID
                              groupID:(NSString *)groupID
{
    NSString *dispString = nil;
    NSMutableArray *dispSourceArray = [self copyAllSourcesAndGroups];
    
    for(WCABSourceModel *dispSource in dispSourceArray)
    {
        for(WCABGroupModel *dispGroup in dispSource.groupModels)
        {
            // 如果groupID = nil, groupModel也是nil, 也算一樣
            if([dispGroup.abSourceID isEqualToString:sourceID] &&
               (([groupID length]==0 &&[dispGroup.abGroupID length]==0) || [dispGroup.abGroupID isEqualToString:groupID]))
            {
                dispString = [NSString stringWithFormat:@"%@.%@", dispSource.name, dispGroup.name];
                break;
            }
        }
        
        if([dispString length])
            break;
    }
    
    [dispSourceArray release];
    
    // !! need to trace why we can't get systemGroupString, this is temparary for debug.
    if([dispString length] == 0)
    {
        dispString = [NSString stringWithFormat:@"Unknown (%@, %@)", sourceID, groupID];
    }
    
    return dispString;
}


//================================================================================
//
//================================================================================
- (WCABSourceModel *)sourceModelWithSourceID:(NSString *)sourceID
{
    NSMutableArray *sourceArray = [self copyAllSourcesAndGroups];
    WCABSourceModel *returnSource = nil;
    
    for(WCABSourceModel *sourceModel in sourceArray)
    {
        if([sourceModel.abSourceID isEqualToString:sourceID])
        {
            returnSource = [sourceModel retain];
            break;
        }
        
    }
    
    [sourceArray release];
    
    return [returnSource autorelease];
}
@end
