/*
 *  PPWString.h
 *  Test
 *
 *  Created by user on 5/22/07.
 *  Copyright 2007 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef PPWString_H_
#define PPWString_H_

// Mac version
#include "PPType.h"
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <math.h>

typedef class PPWString
{
public:
    PPWString();
    ~PPWString();
    
    PPWCHAR *wcsncpy(PPWCHAR *dest, const PPWCHAR *source, size_t count);
    int wcsncmp(const PPWCHAR *s1, const PPWCHAR *s2, size_t count);
    int wcsicmp(const PPWCHAR *s1, const PPWCHAR *s2);
    int wcsicmp_fromAnsi(const PPWCHAR *s1, const char *s2);
    int wcsnicmp(const PPWCHAR *s1, const PPWCHAR *s2, size_t count);
    PPWCHAR *wcschr(const PPWCHAR *s, int ch);
    PPWCHAR *wcsrchr(const PPWCHAR *s, int ch);
    PPWCHAR *wcsstr(const PPWCHAR *str1, const PPWCHAR *str2);
    PPWCHAR *wcsstr_fromAnsi(const PPWCHAR *str1, const char *szBuffer);
    size_t wcsspn(const PPWCHAR *string, const PPWCHAR *control);
    size_t wcscspn(const PPWCHAR *string, const PPWCHAR *control);
    PPWCHAR *wcspbrk(const PPWCHAR *string, const PPWCHAR *control);
    PPWCHAR *wcscpy(PPWCHAR *dst, const PPWCHAR *src);
    PPWCHAR *wcscpy_fromAnsi(PPWCHAR *dst, const char *src);
    int wcslen(const PPWCHAR *s);
    int wcscmp(const PPWCHAR *s1, const PPWCHAR *s2);
    int wcscmp_fromAnsi(const PPWCHAR *s1, const char *s2);
    PPWCHAR *wcscat(PPWCHAR *dst, const PPWCHAR *src);
    PPWCHAR *wcscat_fromAnsi(PPWCHAR *dst, const char *src);
    PPWCHAR *wcsset(PPWCHAR *s, int c);
    int swprintf(PPWCHAR *buf, const PPWCHAR *fmt, ...);
    const int swprintf_fromAnsi(PPWCHAR *buf, const char *fmt, ...);
    size_t wcsnlen(const PPWCHAR *s, size_t count);
    //int ConvertCFStringToPPWCHARBuffer(CFStringRef src,PPWCHAR *dest,int iLen);
    //int ConvertCharToPPWCHARBuffer(char *src,PPWCHAR *dest,int iLen);
    //CFStringRef ConvertPPWCHARBufferToCFString(PPWCHAR *dest);
    int  Find(PPWCHAR* theString,PPWCHAR *findStr,int iOffset);
    int  Replace(PPWCHAR* theString,PPWCHAR *findStr,PPWCHAR *replaceStr);
    void TrimPlus(PPWCHAR *data);
    //int ConvertPPWCHARBufferToUTF8Buffer(PPWCHAR *dest,UInt8 *uint8Buffer,int buffLen);
    PPWCHAR *wcstok(PPWCHAR *srcBuffer,PPWCHAR *checkToken);
    PPWCHAR *wcsupr(PPWCHAR * str);
    PPWCHAR *wcstok_containToken(PPWCHAR *srcBuffer,PPWCHAR oneToken);
    PPWCHAR *wcslwr(PPWCHAR * str);
    int vswprintf(PPWCHAR *buf, const PPWCHAR *fmt, va_list args);
private:
    int skip_atoi(const PPWCHAR **s);
    PPWCHAR *number(PPWCHAR *str, long num, int base, int size, int precision, int type);
    PPWCHAR *eaddr(PPWCHAR *str, PPWCHAR *addr, int size, int precision, int type);
    PPWCHAR *iaddr(PPWCHAR *str, PPWCHAR *addr, int size, int precision, int type);
    PPWCHAR *flt(PPWCHAR *str, double num, int size, int precision, PPWCHAR fmt, int flags);
    PPWCHAR *cvt(double arg, int ndigits, int *decpt, int *sign, PPWCHAR *buf, int eflag);
    PPWCHAR *ecvtbuf(double arg, int ndigits, int *decpt, int *sign, PPWCHAR *buf);
    PPWCHAR *fcvtbuf(double arg, int ndigits, int *decpt, int *sign, PPWCHAR *buf);
    void cfltcvt(double value, PPWCHAR *buffer, PPWCHAR fmt, int precision);
    void forcdecpt(PPWCHAR *buffer);
    void cropzeros(PPWCHAR *buffer);
    int findInStr(PPWCHAR oneChar,PPWCHAR *Buffer);
}PPWString;

#endif	
