#include "stdafx.h"
#include "PPWString.h"
#include "PPMem.h"

#define PP_ZEROPAD 1               // Pad with zero
#define PP_SIGN    2               // Unsigned/signed long
#define PP_PLUS    4               // Show plus
#define PP_SPACE   8               // Space if plus
#define PP_LEFT    16              // Left justified
#define PP_SPECIAL 32              // 0x
#define PP_LARGE   64              // Use 'ABCDEF' instead of 'abcdef'

#define PP_is_digit(c) ((c) >= '0' && (c) <= '9')


#define PP_CVTBUFSIZE        (309 + 43)

static PPWCHAR PP_digits[37] = {'0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z',0};
static PPWCHAR PP_upper_digits[37] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z',0};

static PPWCHAR gbl_TokenBuffer[4096];
static PPWCHAR gbl_OneToken[4096];


PPWString::PPWString()
{
}

PPWString::~PPWString()
{
}

PPWCHAR *PPWString::wcsncpy(PPWCHAR *dest, const PPWCHAR *source, size_t count)
{
    PPWCHAR *start = dest;
    
    while (count && (*dest++ = *source++)) count--;
    if (count) while (--count) *dest++ = '\0';
    return start;
}

int PPWString::wcsncmp(const PPWCHAR *s1, const PPWCHAR *s2, size_t count)
{
    if (!count) return 0;
    
    while (--count && *s1 && *s1 == *s2)
    {
        s1++;
        s2++;
    }
    
    return (*(PPWCHAR *) s1 - *(PPWCHAR *) s2);
}

int PPWString::wcsicmp(const PPWCHAR *s1, const PPWCHAR *s2)
{
    PPWCHAR f, l;
    
    do
    {
        f = ((*s1 <= 'Z') && (*s1 >= 'A')) ? *s1 + 'a' - 'A' : *s1;
        l = ((*s2 <= 'Z') && (*s2 >= 'A')) ? *s2 + 'a' - 'A' : *s2;
        s1++;
        s2++;
    } while ((f) && (f == l));
    
    return (int) (f - l);
}

int PPWString::wcsnicmp(const PPWCHAR *s1, const PPWCHAR *s2, size_t count)
{
    int f, l;
    
    do
    {
        if (((f = (PPWCHAR)(*(s1++))) >= 'A') && (f <= 'Z')) f -= 'A' - 'a';
        if (((l = (PPWCHAR)(*(s2++))) >= 'A') && (l <= 'Z')) l -= 'A' - 'a';
    } while (--count && f && (f == l));
    
    return f - l;
}

int PPWString::wcsicmp_fromAnsi(const PPWCHAR *s1, const char *s2)
{
    PPWCHAR f, l;
    
    do
    {
        f = ((*s1 <= 'Z') && (*s1 >= 'A')) ? *s1 + 'a' - 'A' : *s1;
        l = ((*s2 <= 'Z') && (*s2 >= 'A')) ? *s2 + 'a' - 'A' : *s2;
        s1++;
        s2++;
    } while ((f) && (f == l));
    
    return (int) (f - l);
}



PPWCHAR *PPWString::wcschr(const PPWCHAR *s, int ch)
{
    while (*s && *s != (PPWCHAR) ch) s++;
    if (*s == (PPWCHAR) ch) return (PPWCHAR *) s;
    return PPNULL;
}

PPWCHAR *PPWString::wcsrchr(const PPWCHAR *s, int ch)
{
    PPWCHAR *start = (PPWCHAR *) s;
    
    while (*s++);
    while (--s != start && *s != (PPWCHAR) ch);
    if (*s == (PPWCHAR) ch) return (PPWCHAR *) s;
    
    return PPNULL;
}

PPWCHAR *PPWString::wcsstr(const PPWCHAR *str1, const PPWCHAR *str2)
{
    PPWCHAR *cp = (PPWCHAR *) str1;
    PPWCHAR *s1, *s2;
    
    if (!*str2) return (PPWCHAR *) str1;
    
    while (*cp)
    {
        s1 = cp;
        s2 = (PPWCHAR *) str2;
        
        while (*s1 && *s2 && !(*s1 - *s2)) s1++, s2++;
        if (!*s2) return cp;
        cp++;
    }
    
    return PPNULL;
}

PPWCHAR *PPWString::wcsstr_fromAnsi(const PPWCHAR *str1, const char *szBuffer)
{
    PPWCHAR *cp = (PPWCHAR *) str1;
    PPWCHAR *s1 = NULL;
    char    *s2 = NULL;
    
    if (!*szBuffer) return (PPWCHAR *) str1;
    
    while (*cp)
    {
        s1 = cp;
        s2 = (char*)szBuffer;
        
        while (*s1 && *s2 && !(*s1 - (*s2 & 0xFF) )) s1++, s2++;
        if (!*s2) return cp;
        cp++;
    }
    
    return PPNULL;
}

size_t PPWString::wcsspn(const PPWCHAR *string, const PPWCHAR *control)
{
    const PPWCHAR *str = string;
    const PPWCHAR *ctrl = control;
    
    PPWCHAR map[32];
    int count;
    
    // Clear out bit map
    for (count = 0; count < 32; count++) map[count] = 0;
    
    // Set bits in control map
    while (*ctrl)
    {
        map[*ctrl >> 3] |= (1 << (*ctrl & 7));
        ctrl++;
    }
    
    // 1st PPWCHAR NOT in control map stops search
    if (*str)
    {
        count = 0;
        while (map[*str >> 3] & (1 << (*str & 7)))
        {
            count++;
            str++;
        }
        
        return count;
    }
    
    return 0;
}

size_t PPWString::wcscspn(const PPWCHAR *string, const PPWCHAR *control)
{
    const PPWCHAR *str = string;
    const PPWCHAR *ctrl = control;
    
    PPWCHAR map[32];
    int count;
    
    // Clear out bit map
    for (count = 0; count < 32; count++) map[count] = 0;
    
    // Set bits in control map
    while (*ctrl)
    {
        map[*ctrl >> 3] |= (1 << (*ctrl & 7));
        ctrl++;
    }
    
    // 1st PPWCHAR in control map stops search
    count = 0;
    map[0] |= 1;
    while (!(map[*str >> 3] & (1 << (*str & 7))))
    {
        count++;
        str++;
    }
    return count;
}

PPWCHAR *PPWString::wcspbrk(const PPWCHAR *string, const PPWCHAR *control)
{
    const PPWCHAR *str = string;
    const PPWCHAR *ctrl = control;
    
    PPWCHAR map[32];
    int count;
    
    // Clear out bit map
    for (count = 0; count < 32; count++) map[count] = 0;
    
    // Set bits in control map
    while (*ctrl)
    {
        map[*ctrl >> 3] |= (1 << (*ctrl & 7));
        ctrl++;
    }
    
    // 1st PPWCHAR in control map stops search
    while (*str)
    {
        if (map[*str >> 3] & (1 << (*str & 7))) return (PPWCHAR *) str;
        str++;
    }
    
    return PPNULL;
}


PPWCHAR *PPWString::wcscpy(PPWCHAR *dst, const PPWCHAR *src)
{
    PPWCHAR *cp = dst;
    
    //while (*cp++ = *src++);
    while ( (*cp++ = *src++) != 0 );
    
    return dst;
}

PPWCHAR *PPWString::wcscpy_fromAnsi(PPWCHAR *dst, const char *src)
{
    //PPWCHAR *cp = dst;
    int idx1 = 0,idx2 = 0;
    
    while(src[idx1] != 0)
    {
        dst[idx2++] = src[idx1++];
    }
    dst[idx2] = 0;
    
    return dst;
}


int PPWString::wcslen(const PPWCHAR *s)
{
    const PPWCHAR *eos = s;
    while (*eos++);
    return (int) (eos - s - 1);
}

int PPWString::wcscmp(const PPWCHAR *s1, const PPWCHAR *s2)
{
    int ret = 0;
    while (!(ret = *(PPWCHAR *) s1 - *(PPWCHAR *) s2) && *s2) ++s1, ++s2;
    
    if (ret < 0)
        ret = -1;
    else if (ret > 0)
        ret = 1 ;
    
    return ret;
}


int PPWString::wcscmp_fromAnsi(const PPWCHAR *s1, const char *s2)
{
    int ret = 0;
    while (!(ret = *(PPWCHAR *) s1 - *(char *) s2) && *s2) ++s1, ++s2;
    
    if (ret < 0)
        ret = -1;
    else if (ret > 0)
        ret = 1 ;
    
    return ret;
}



PPWCHAR *PPWString::wcscat(PPWCHAR *dst, const PPWCHAR *src)
{
    PPWCHAR *cp = dst;
    while (*cp) cp++;
    while ((*cp++ = *src++));
    return dst;
}

PPWCHAR *PPWString::wcscat_fromAnsi(PPWCHAR *dst, const char *src)
{
    PPWCHAR *cp = dst;
    while (*cp) cp++;
    while ((*cp++ = *src++));
    return dst;
}

PPWCHAR *PPWString::wcsset(PPWCHAR *s, int c)
{
    PPWCHAR *start = s;
    while (*s) *s++ = (PPWCHAR) c;
    return start;
}

int  PPWString::Find(PPWCHAR* theString,PPWCHAR *findStr,int iOffset)
{
    int i;
    size_t sLen,ifLen;
    PPWString onePPWStr;
    
    
    if ((theString != PPNULL) && (findStr != 0))
    {
        ifLen = onePPWStr.wcslen(findStr);
        sLen = onePPWStr.wcslen(theString);
        
        if ((iOffset < sLen) && (sLen >= (iOffset + ifLen)) )
        {
            for (i = iOffset;i < sLen;i++)
            {
                if (onePPWStr.wcsncmp(&theString[i],findStr,ifLen) == 0)
                {
                    return i;
                }
            }
        }
    }
    return -1;
}

int  PPWString::Replace(PPWCHAR* theString,PPWCHAR *findStr,PPWCHAR *replaceStr)
{
    int i,idx,j;
    size_t sLen,ifLen,rpLen;
    PPWString onePPWStr;
    PPWCHAR tmpBuffer[4096];
    int inFlag;
    
    idx = 0;
    inFlag = 0;
    if ((theString != PPNULL) && (findStr != 0) && (replaceStr != 0))
    {
        ifLen = onePPWStr.wcslen(findStr);
        rpLen = onePPWStr.wcslen(replaceStr);
        sLen = onePPWStr.wcslen(theString);
        
        if (sLen >= ifLen)
        {
            for (i = 0;i < sLen;i++)
            {
                if (onePPWStr.wcsncmp(&theString[i],findStr,ifLen) == 0)
                {
                    for (j = 0;j < rpLen;j++)
                    {
                        tmpBuffer[idx++] = replaceStr[j];
                    }
                    inFlag = 1;
                }else
                {
                    tmpBuffer[idx++] = theString[i];
                }
            }
            
        }
    }
    if (inFlag == 1)
    {
        onePPWStr.wcscpy(theString,tmpBuffer);
        return 1;
    }
    return 0;
}


void PPWString::TrimPlus(PPWCHAR *data)
{
    int i,tmpIdx;
    size_t dataLen;
    PPWCHAR *tmpData;
    int SpaceFlag;
    int startPos,endPos;
    
    if (data == PPNULL)
        return;
    dataLen = wcslen(data);
    if (dataLen == 0)
        return;
    tmpData = (PPWCHAR*)malloc(sizeof(PPWCHAR)*(dataLen+2));
    if (tmpData == PPNULL)
    {
        return;
    }
    tmpIdx = 0;
    
    SpaceFlag = 0;
    for (i =0 ;i < dataLen;i++)
    {
        if ((data[i] == 0x20) || (data[i] == 0x9) || (data[i] == '"' ) || (data[i] == '/' ) || (data[i] == '\\' ))
        {
            if (SpaceFlag == 0){
                SpaceFlag = 1;
                tmpData[tmpIdx++] = 0x20;
            }
        }else
        {
            tmpData[tmpIdx++] = data[i];
            SpaceFlag = 0;
        }
    }
    tmpData[tmpIdx] = 0;
    startPos = 0;
    endPos = 0;
    if (tmpIdx == 1){
        if (tmpData[0] == 0x20){
            data[0] = 0;
            free(tmpData);
//            delete [] tmpData;
            return;
        }else
        {
            data[0] = tmpData[0];
            data[1] = 0;
            free(tmpData);
//            delete [] tmpData;
            return;
        }
    }else
    {
        if (tmpData[0] == 0x20)
        {
            startPos = 1;
        }
        if (tmpData[tmpIdx-1] == 0x20)
        {
            tmpData[tmpIdx-1] = 0;
        }
        wcscpy(data,&tmpData[startPos]);
    }
    free(tmpData);
//    delete [] tmpData;
    
}


int PPWString::swprintf(PPWCHAR *buf, const PPWCHAR *fmt, ...)
{
    va_list args;
    int n;
    
    va_start(args, fmt);
    n = vswprintf(buf, fmt, args);
    va_end(args);
    
    return n;
}

const int PPWString::swprintf_fromAnsi(PPWCHAR *buf, const char *fmt, ...)
{
    va_list args;
    int n,i;
    size_t iLen;
    PPWCHAR fmtBuffer[512];
    
    iLen = strlen(fmt);
    for (i = 0;i < iLen;i++)
    {
        fmtBuffer[i] = fmt[i];
    }
    fmtBuffer[i] = 0;
    va_start(args, fmt);
    n = vswprintf(buf, fmtBuffer, args);
    va_end(args);
    
    return n;
}


int PPWString::vswprintf(PPWCHAR *buf, const PPWCHAR *fmt, va_list args)
{
    size_t len;
    unsigned long num;
    int i, base;
    PPWCHAR ppNullStr[] = {'<','N','U','L','L','>',0};
    PPWCHAR *str;
    PPWCHAR *s;
    
    int flags;            // Flags to number()
    
    int field_width;      // Width of output field
    int precision;        // Min. # of digits for integers; max number of chars for from string
    int qualifier;        // 'h', 'l', or 'L' for integer fields
    
    for (str = buf; *fmt; fmt++)
    {
        if (*fmt != '%')
        {
            *str++ = *fmt;
            continue;
        }
        
        // Process flags
        flags = 0;
    repeat:
        fmt++; // This also skips first '%'
        switch (*fmt)
        {
            case '-': flags |= PP_LEFT; goto repeat;
            case '+': flags |= PP_PLUS; goto repeat;
            case ' ': flags |= PP_SPACE; goto repeat;
            case '#': flags |= PP_SPECIAL; goto repeat;
            case '0': flags |= PP_ZEROPAD; goto repeat;
        }
        
        // Get field width
        field_width = -1;
        if (PP_is_digit(*fmt))
            field_width = skip_atoi(&fmt);
        else if (*fmt == '*')
        {
            fmt++;
            field_width = va_arg(args, int);
            if (field_width < 0)
            {
                field_width = -field_width;
                flags |= PP_LEFT;
            }
        }
        
        // Get the precision
        precision = -1;
        if (*fmt == '.')
        {
            ++fmt;
            if (PP_is_digit(*fmt))
                precision = skip_atoi(&fmt);
            else if (*fmt == '*')
            {
                ++fmt;
                precision = va_arg(args, int);
            }
            if (precision < 0) precision = 0;
        }
        
        // Get the conversion qualifier
        qualifier = -1;
        if (*fmt == 'h' || *fmt == 'l' || *fmt == 'L')
        {
            qualifier = *fmt;
            fmt++;
        }
        
        // Default base
        base = 10;
        
        switch (*fmt)
        {
            case 'c':
                if (!(flags & PP_LEFT)) while (--field_width > 0) *str++ = ' ';
                *str++ = (PPWCHAR) va_arg(args, int);
                while (--field_width > 0) *str++ = ' ';
                continue;
                
            case 's':
                s = va_arg(args, PPWCHAR *);
                if (!s) s = ppNullStr;
                len = wcsnlen(s, precision);
                if (!(flags & PP_LEFT)) while (len < field_width--) *str++ = ' ';
                for (i = 0; i < len; ++i) *str++ = *s++;
                while (len < field_width--) *str++ = ' ';
                continue;
                
            case 'p':
                if (field_width == -1)
                {
                    field_width = 2 * sizeof(void *);
                    flags |= PP_ZEROPAD;
                }
                str = number(str, (unsigned long) va_arg(args, void *), 16, field_width, precision, flags);
                continue;
                
            case 'n':
                if (qualifier == 'l')
                {
                    long *ip = va_arg(args, long *);
                    *ip = (str - buf);
                }
                else
                {
                    int *ip = va_arg(args, int *);
                    *ip = (int)(str - buf);
                }
                continue;
                
            case 'A':
                flags |= PP_LARGE;
                
            case 'a':
                if (qualifier == 'l')
                    str = eaddr(str, va_arg(args, PPWCHAR *), field_width, precision, flags);
                else
                    str = iaddr(str, va_arg(args, PPWCHAR *), field_width, precision, flags);
                continue;
                
                // Integer number formats - set up the flags and "break"
            case 'o':
                base = 8;
                break;
                
            case 'X':
                flags |= PP_LARGE;
                
            case 'x':
                base = 16;
                break;
                
            case 'd':
            case 'i':
                flags |= PP_SIGN;
                
            case 'u':
                break;
                
#ifndef NOFLOAT
                
            case 'E':
            case 'G':
            case 'e':
            case 'f':
            case 'g':
                str = flt(str, va_arg(args, double), field_width, precision, *fmt, flags | PP_SIGN);
                continue;
                
#endif
                
            default:
                if (*fmt != '%') *str++ = '%';
                if (*fmt)
                    *str++ = *fmt;
                else
                    --fmt;
                continue;
        }
        
        if (qualifier == 'l')
            num = va_arg(args, unsigned long);
        else if (qualifier == 'h')
        {
            if (flags & PP_SIGN)
                num = va_arg(args, int);
            else
                num = va_arg(args, unsigned int);
        }
        else if (flags & PP_SIGN)
            num = va_arg(args, int);
        else
            num = va_arg(args, unsigned int);
        
        str = number(str, num, base, field_width, precision, flags);
    }
    
    *str = '\0';
    return (int)(str - buf);
}

int PPWString::skip_atoi(const PPWCHAR **s)
{
    int i = 0;
    while (PP_is_digit(**s)) i = i*10 + *((*s)++) - '0';
    return i;
}


PPWCHAR *PPWString::number(PPWCHAR *str, long num, int base, int size, int precision, int type)
{
    PPWCHAR c, sign, tmp[66];
    PPWCHAR *dig = PP_digits;
    int i;
    
    if (type & PP_LARGE)  dig = PP_upper_digits;
    if (type & PP_LEFT) type &= ~PP_ZEROPAD;
    if (base < 2 || base > 36) return 0;
    
    c = (type & PP_ZEROPAD) ? '0' : ' ';
    sign = 0;
    if (type & PP_SIGN)
    {
        if (num < 0)
        {
            sign = '-';
            num = -num;
            size--;
        }
        else if (type & PP_PLUS)
        {
            sign = '+';
            size--;
        }
        else if (type & PP_SPACE)
        {
            sign = ' ';
            size--;
        }
    }
    
    if (type & PP_SPECIAL)
    {
        if (base == 16)
            size -= 2;
        else if (base == 8)
            size--;
    }
    
    i = 0;
    
    if (num == 0)
        tmp[i++] = '0';
    else
    {
        while (num != 0)
        {
            tmp[i++] = dig[((unsigned long) num) % (unsigned) base];
            num = ((unsigned long) num) / (unsigned) base;
        }
    }
    
    if (i > precision) precision = i;
    size -= precision;
    if (!(type & (PP_ZEROPAD | PP_LEFT))) while (size-- > 0) *str++ = ' ';
    if (sign) *str++ = sign;
    
    if (type & PP_SPECIAL)
    {
        if (base == 8)
            *str++ = '0';
        else if (base == 16)
        {
            *str++ = '0';
            *str++ = PP_digits[33];
        }
    }
    
    if (!(type & PP_LEFT)) while (size-- > 0) *str++ = c;
    while (i < precision--) *str++ = '0';
    while (i-- > 0) *str++ = tmp[i];
    while (size-- > 0) *str++ = ' ';
    
    return str;
}


PPWCHAR *PPWString::eaddr(PPWCHAR *str, PPWCHAR *addr, int size, int precision, int type)
{
    PPWCHAR tmp[24];
    PPWCHAR *dig = PP_digits;
    int i, len;
    
    if (type & PP_LARGE)  dig = PP_upper_digits;
    len = 0;
    for (i = 0; i < 6; i++)
    {
        if (i != 0) tmp[len++] = ':';
        tmp[len++] = dig[addr[i] >> 4];
        tmp[len++] = dig[addr[i] & 0x0F];
    }
    
    if (!(type & PP_LEFT)) while (len < size--) *str++ = ' ';
    for (i = 0; i < len; ++i) *str++ = tmp[i];
    while (len < size--) *str++ = ' ';
    
    return str;
}

PPWCHAR *PPWString::iaddr(PPWCHAR *str, PPWCHAR *addr, int size, int precision, int type)
{
    PPWCHAR tmp[24];
    int i, n, len;
    
    len = 0;
    for (i = 0; i < 4; i++)
    {
        if (i != 0) tmp[len++] = '.';
        n = addr[i];
        
        if (n == 0)
            tmp[len++] = PP_digits[0];
        else
        {
            if (n >= 100)
            {
                tmp[len++] = PP_digits[n / 100];
                n = n % 100;
                tmp[len++] = PP_digits[n / 10];
                n = n % 10;
            }
            else if (n >= 10)
            {
                tmp[len++] = PP_digits[n / 10];
                n = n % 10;
            }
            
            tmp[len++] = PP_digits[n];
        }
    }
    
    if (!(type & PP_LEFT)) while (len < size--) *str++ = ' ';
    for (i = 0; i < len; ++i) *str++ = tmp[i];
    while (len < size--) *str++ = ' ';
    
    return str;
}

size_t PPWString::wcsnlen(const PPWCHAR *s, size_t count)
{
    const PPWCHAR *sc;
    for (sc = s; *sc != '\0' && count--; ++sc);
    return sc - s;
}


PPWCHAR *PPWString::flt(PPWCHAR *str, double num, int size, int precision, PPWCHAR fmt, int flags)
{
    PPWCHAR tmp[80];
    PPWCHAR c, sign;
    int i;
    size_t n;
    
    // Left align means no zero padding
    if (flags & PP_LEFT) flags &= ~PP_ZEROPAD;
    
    // Determine padding and sign PPWCHAR
    c = (flags & PP_ZEROPAD) ? '0' : ' ';
    sign = 0;
    if (flags & PP_SIGN)
    {
        if (num < 0.0)
        {
            sign = '-';
            num = -num;
            size--;
        }
        else if (flags & PP_PLUS)
        {
            sign = '+';
            size--;
        }
        else if (flags & PP_SPACE)
        {
            sign = ' ';
            size--;
        }
    }
    
    // Compute the precision value
    if (precision < 0)
        precision = 6; // Default precision: 6
    else if (precision == 0 && fmt == 'g')
        precision = 1; // ANSI specified
    
    // Convert floating point number to text
    cfltcvt(num, tmp, fmt, precision);
    
    // '#' and precision == 0 means force a decimal point
    if ((flags & PP_SPECIAL) && precision == 0) forcdecpt(tmp);
    
    // 'g' format means crop zero unless '#' given
    if (fmt == 'g' && !(flags & PP_SPECIAL)) cropzeros(tmp);
    
    n = wcslen(tmp);
    
    // Output number with alignment and padding
    size -= n;
    if (!(flags & (PP_ZEROPAD | PP_LEFT))) while (size-- > 0) *str++ = ' ';
    if (sign) *str++ = sign;
    if (!(flags & PP_LEFT)) while (size-- > 0) *str++ = c;
    for (i = 0; i < n; i++) *str++ = tmp[i];
    while (size-- > 0) *str++ = ' ';
    
    return str;
}

PPWCHAR *PPWString::cvt(double arg, int ndigits, int *decpt, int *sign, PPWCHAR *buf, int eflag)
{
    int r2;
    double fi, fj;
    PPWCHAR *p, *p1;
    
    if (ndigits < 0) ndigits = 0;
    if (ndigits >= PP_CVTBUFSIZE - 1) ndigits = PP_CVTBUFSIZE - 2;
    r2 = 0;
    *sign = 0;
    p = &buf[0];
    if (arg < 0)
    {
        *sign = 1;
        arg = -arg;
    }
    arg = modf(arg, &fi);
    p1 = &buf[PP_CVTBUFSIZE];
    
    if (fi != 0)
    {
        p1 = &buf[PP_CVTBUFSIZE];
        while (fi != 0)
        {
            fj = modf(fi / 10, &fi);
            *--p1 = (int)((fj + .03) * 10) + '0';
            r2++;
        }
        while (p1 < &buf[PP_CVTBUFSIZE]) *p++ = *p1++;
    }
    else if (arg > 0)
    {
        while ((fj = arg * 10) < 1)
        {
            arg = fj;
            r2--;
        }
    }
    p1 = &buf[ndigits];
    if (eflag == 0) p1 += r2;
    *decpt = r2;
    if (p1 < &buf[0])
    {
        buf[0] = '\0';
        return buf;
    }
    while (p <= p1 && p < &buf[PP_CVTBUFSIZE])
    {
        arg *= 10;
        arg = modf(arg, &fj);
        *p++ = (int) fj + '0';
    }
    if (p1 >= &buf[PP_CVTBUFSIZE])
    {
        buf[PP_CVTBUFSIZE - 1] = '\0';
        return buf;
    }
    p = p1;
    *p1 += 5;
    while (*p1 > '9')
    {
        *p1 = '0';
        if (p1 > buf)
            ++*--p1;
        else
        {
            *p1 = '1';
            (*decpt)++;
            if (eflag == 0)
            {
                if (p > buf) *p = '0';
                p++;
            }
        }
    }
    *p = '\0';
    return buf;
}

PPWCHAR *PPWString::ecvtbuf(double arg, int ndigits, int *decpt, int *sign, PPWCHAR *buf)
{
    return cvt(arg, ndigits, decpt, sign, buf, 1);
}



PPWCHAR *PPWString::fcvtbuf(double arg, int ndigits, int *decpt, int *sign, PPWCHAR *buf)
{
    return cvt(arg, ndigits, decpt, sign, buf, 0);
}

void PPWString::cfltcvt(double value, PPWCHAR *buffer, PPWCHAR fmt, int precision)
{
    int decpt, sign, exp, pos;
    PPWCHAR *digits = NULL;
    PPWCHAR cvtbuf[80];
    int capexp = 0;
    int magnitude;
    
    if (fmt == 'G' || fmt == 'E')
    {
        capexp = 1;
        fmt += 'a' - 'A';
    }
    
    if (fmt == 'g')
    {
        digits = ecvtbuf(value, precision, &decpt, &sign, cvtbuf);
        magnitude = decpt - 1;
        if (magnitude < -4  ||  magnitude > precision - 1)
        {
            fmt = 'e';
            precision -= 1;
        }
        else
        {
            fmt = 'f';
            precision -= decpt;
        }
    }
    
    if (fmt == 'e')
    {
        digits = ecvtbuf(value, precision + 1, &decpt, &sign, cvtbuf);
        
        if (sign) *buffer++ = '-';
        *buffer++ = *digits;
        if (precision > 0) *buffer++ = '.';
        memcpy(buffer, digits + 1, precision);
        buffer += precision;
        *buffer++ = capexp ? 'E' : 'e';
        
        if (decpt == 0)
        {
            if (value == 0.0)
                exp = 0;
            else
                exp = -1;
        }
        else
            exp = decpt - 1;
        
        if (exp < 0)
        {
            *buffer++ = '-';
            exp = -exp;
        }
        else
            *buffer++ = '+';
        
        buffer[2] = (exp % 10) + '0';
        exp = exp / 10;
        buffer[1] = (exp % 10) + '0';
        exp = exp / 10;
        buffer[0] = (exp % 10) + '0';
        buffer += 3;
    }
    else if (fmt == 'f')
    {
        digits = fcvtbuf(value, precision, &decpt, &sign, cvtbuf);
        if (sign) *buffer++ = '-';
        if (*digits)
        {
            if (decpt <= 0)
            {
                *buffer++ = '0';
                *buffer++ = '.';
                for (pos = 0; pos < -decpt; pos++) *buffer++ = '0';
                while (*digits) *buffer++ = *digits++;
            }
            else
            {
                pos = 0;
                while (*digits)
                {
                    if (pos++ == decpt) *buffer++ = '.';
                    *buffer++ = *digits++;
                }
            }
        }
        else
        {
            *buffer++ = '0';
            if (precision > 0)
            {
                *buffer++ = '.';
                for (pos = 0; pos < precision; pos++) *buffer++ = '0';
            }
        }
    }
    
    *buffer = '\0';
}

void PPWString::forcdecpt(PPWCHAR *buffer)
{
    while (*buffer)
    {
        if (*buffer == '.') return;
        if (*buffer == 'e' || *buffer == 'E') break;
        buffer++;
    }
    
    if (*buffer)
    {
        size_t n = wcslen(buffer);
        while (n > 0)
        {
            buffer[n + 1] = buffer[n];
            n--;
        }
        
        *buffer = '.';
    }
    else
    {
        *buffer++ = '.';
        *buffer = '\0';
    }
}

void PPWString::cropzeros(PPWCHAR *buffer)
{
    PPWCHAR *stop;
    
    while (*buffer && *buffer != '.') buffer++;
    if (*buffer++)
    {
        while (*buffer && *buffer != 'e' && *buffer != 'E') buffer++;
        stop = buffer--;
        while (*buffer == '0') buffer--;
        if (*buffer == '.') buffer--;
        while ((*++buffer = *stop++));
    }
}



PPWCHAR *PPWString::wcsupr(PPWCHAR * str)
{
    unsigned int i = 0;
    while (str[i]) {
        if (str[i] >= 'a' && str[i] <= 'z')
            str[i] += ('A'-'a');
        i++;
    }
    return str;
}

PPWCHAR *PPWString::wcslwr(PPWCHAR * str)
{
    unsigned int i = 0;
    while (str[i]) {
        if (str[i] >= 'A' && str[i] <= 'Z')
            str[i] -= ('A'-'a');
        i++;
    }
    
    return str;
}

/*
 int PPWString::ConvertCFStringToPPWCHARBuffer(CFStringRef src,PPWCHAR *dest,int iLen)
 {
	const UniChar *chars;
	int okFlag = 0;
	
	if (src == 0)
	{
 return 0;
	}
	chars = CFStringGetCharactersPtr(src);
	if (chars != 0)
	{
 wcsncpy(dest,chars,iLen);
 okFlag = 1;
	}else
	{
 CFIndex tmpLen = CFStringGetLength(src);
 if (tmpLen > 0)
 {
 PPWCHAR *tmpBuffer = (PPWCHAR*)malloc((tmpLen+1) * sizeof(PPWCHAR));
 if (tmpBuffer != 0)
 {
 memset(tmpBuffer,0,sizeof(PPWCHAR)*(tmpLen+1));
 CFStringGetCharacters(src,CFRangeMake(0,tmpLen),tmpBuffer);
 wcsncpy(dest,tmpBuffer,iLen);
 free(tmpBuffer);
 okFlag = 1;
 }
 }else
 {
 dest[0] = 0;
 okFlag = 1;
 }
	}
	return okFlag;
 }
 */
/*
 int PPWString::ConvertCharToPPWCHARBuffer(char *src,PPWCHAR *dest,int iLen)
 {
	//const UniChar *chars;
	int okFlag = 0;
	CFStringRef tmpCFStr;
	
	if (src == 0)
	{
 return 0;
	}
	
	tmpCFStr = CFStringCreateWithCString(kCFAllocatorDefault,src,kCFStringEncodingUTF8);
	if (tmpCFStr != 0)
	{
 okFlag = ConvertCFStringToPPWCHARBuffer(tmpCFStr,dest,iLen);
 CFRelease(tmpCFStr);
	}
	return okFlag;
 }
 */

/*
 CFStringRef PPWString::ConvertPPWCHARBufferToCFString(PPWCHAR *dest)
 {
	int iLen;
	if (dest == 0)
	{
 return 0;
	}
	iLen = wcslen(dest);
	return CFStringCreateWithCharacters(0,dest,iLen);
 }
 */
/*
 int PPWString::ConvertPPWCHARBufferToUTF8Buffer(PPWCHAR *dest,UInt8 *uint8Buffer,int buffLen)
 {	
	CFStringRef oneStrRef;
	CFRange oneCFRange;
	CFIndex retLen;
	int retValue = 0;
	
 oneStrRef = ConvertPPWCHARBufferToCFString(dest);
 if (oneStrRef != 0)
 {
 oneCFRange.location = 0;
 oneCFRange.length = CFStringGetLength(oneStrRef);
 CFStringGetBytes(oneStrRef,oneCFRange,kCFStringEncodingUTF8,0,false,uint8Buffer,buffLen,&retLen);
 uint8Buffer[retLen] = 0;
 retValue = 1;
 CFRelease(oneStrRef);
 }
	return retValue;
 }
 */
PPWCHAR *PPWString::wcstok(PPWCHAR *srcBuffer,PPWCHAR *checkToken)
{
    size_t iLen;
    int i;
    int inFlagIdx,iFirstFlag = 0;
    int outFlagIdx;
    int idx;
    
    if (srcBuffer != 0)
    {
        wcsncpy(gbl_TokenBuffer,srcBuffer,4000);
    }
    inFlagIdx = -1;
    outFlagIdx = -1;
    idx = 0;
    iLen = wcslen(gbl_TokenBuffer);
    for (i = 0;i < iLen;i++)
    {
        if (findInStr(gbl_TokenBuffer[i],checkToken) == -1)
        {
            if (iFirstFlag == 0)
            {
                inFlagIdx = i; 
                iFirstFlag = 1;
            }
        }else
        {
            if (iFirstFlag == 1)
            {
                outFlagIdx = i;
                iFirstFlag = 0;
                break;
            }
        }
        if (iFirstFlag == 1)
        {
            gbl_OneToken[idx] = gbl_TokenBuffer[i];
            idx++;
        }
    }
    gbl_OneToken[idx] = 0;
    
    if (idx != 0)
    {
        if (outFlagIdx == -1)
        {
            gbl_TokenBuffer[0] = 0;
        }else
        {
            memmove(gbl_TokenBuffer,&gbl_TokenBuffer[outFlagIdx],(iLen-outFlagIdx)*sizeof(PPWCHAR));
            gbl_TokenBuffer[iLen-outFlagIdx] = 0;
        }
        return gbl_OneToken;
    }else
    {
        return 0; 
    }
    
    
    
}






//================================================
//  for vcard parsing
//  Ex: 
//      (1) ;;test1;test2; -> ; ; test; test;
//      (2) test1;;test2;;; -> test1; ; test2; ; ;
//================================================
PPWCHAR *PPWString::wcstok_containToken(PPWCHAR *srcBuffer,PPWCHAR oneToken)
{
    size_t iLen;
    int i;
    int inFlagIdx,iFirstFlag = 0;
    int outFlagIdx;
    int idx;
    PPWCHAR checkToken[2] = {0};
    
    //  Set checkToken
    checkToken[0] = oneToken;
    checkToken[1] = 0;    
    
    if (srcBuffer != 0)
    {
        wcsncpy(gbl_TokenBuffer,srcBuffer,4000);
    }
    inFlagIdx = -1;
    outFlagIdx = -1;
    idx = 0;
    iLen = wcslen(gbl_TokenBuffer);
    for (i = 0;i < iLen;i++)
    {
        if (findInStr(gbl_TokenBuffer[i],checkToken) == -1)
        {
            if (iFirstFlag == 0)
            {
                inFlagIdx = i; 
                iFirstFlag = 1;
            }
        }
        else
        {
            if (iFirstFlag == 0)
            {
                inFlagIdx = i; 
                iFirstFlag = 1;
            }
            
            if (iFirstFlag == 1)
            {
                outFlagIdx = i;
                iFirstFlag = 0;
                
                gbl_OneToken[idx] = gbl_TokenBuffer[i];
                idx++;
                break;
            }
        }
        if (iFirstFlag == 1)
        {
            gbl_OneToken[idx] = gbl_TokenBuffer[i];
            idx++;
        }
    }
    gbl_OneToken[idx] = 0;
    
    if (idx != 0)
    {
        if (outFlagIdx == -1 || (outFlagIdx+1) >= iLen)
        {
            //  字串中都沒有找到token 或是 最後一個字元是token的情況
            gbl_TokenBuffer[0] = 0;
        }else
        {
            outFlagIdx += 1;
            memmove(gbl_TokenBuffer,&gbl_TokenBuffer[outFlagIdx],(iLen-outFlagIdx)*sizeof(PPWCHAR));
            gbl_TokenBuffer[iLen-outFlagIdx] = 0;
        }
        return gbl_OneToken;
    }else
    {
        return 0; 
    }
}

int PPWString::findInStr(PPWCHAR oneChar,PPWCHAR *Buffer)
{
    int i;
    size_t iLen;
    
    if (Buffer != 0)
    {
        iLen = wcslen(Buffer);
        for (i = 0;i < iLen ;i++)
        {
            if (Buffer[i] == oneChar)
            {
                return i;
            }
        }
    }
    return -1;
}

