#include <stdio.h>
#include "PPMisc.h"


CPPMisc::CPPMisc()
{
	
}

CPPMisc::~CPPMisc()
{
	
}


void CPPMisc::Seedit(void)
{
    struct timeval tv;

    Gettimeofday(&tv, NULL);

    srand((unsigned int)(tv.tv_sec * tv.tv_usec));
}


int CPPMisc::Gettimeofday(struct timeval *tp, void *tzp)
{
#ifdef WIN32
    time_t clock;
    struct tm tm;
    SYSTEMTIME wtm;
    GetLocalTime(&wtm);
    tm.tm_year     = wtm.wYear - 1900;
    tm.tm_mon     = wtm.wMonth - 1;
    tm.tm_mday     = wtm.wDay;
    tm.tm_hour     = wtm.wHour;
    tm.tm_min     = wtm.wMinute;
    tm.tm_sec     = wtm.wSecond;
    tm. tm_isdst    = -1;
    clock = mktime(&tm);
    tp->tv_sec = clock;
    tp->tv_usec = wtm.wMilliseconds * 1000;
	return 0;
#elif defined __OBJECTIVEC__
    return gettimeofday(tp,(struct timezone*)tzp);
#else
	return gettimeofday(tp,(struct timezone*)tzp);
#endif 
}


PPCStringW CPPMisc::GenerateUuID()
{
	PPBYTE szTmpUuID[10];
	unsigned long ulTime;
//	unsigned int checkSum;
	int i;
	PPWCHAR tmpWChar[4];
	PPCStringW retStr;
	PPCStringW tmpStr;
	unsigned long uCheckSum = 0;
	PPWString oneWStr;
	
	retStr = "";
				
#ifdef WIN32
		ulTime = (unsigned long)time(NULL) + GetTickCount();
#elif defined __OBJECTIVEC__
    clock_serv_t cclock;
    mach_timespec_t ts;
    
    host_get_clock_service(mach_host_self(), SYSTEM_CLOCK, &cclock);
    
    if(clock_get_time(cclock,&ts) != 0) {
        //error
    }
    ulTime = (unsigned long)time(NULL) + ts.tv_nsec;
#else
		struct timespec ts;
	#ifdef NestedVM_VERSION
		if(PPclock_gettime(1/*CLOCK_MONOTONIC*/,&ts) != 0) {
			//error
		}
	#else
		if(clock_gettime(1/*CLOCK_MONOTONIC*/,&ts) != 0) {
			//error
		}
	#endif
		ulTime = (unsigned long)time(NULL) + ts.tv_nsec;
#endif
		szTmpUuID[0] = (PPBYTE)((ulTime >> 24) & 0xFF);
		szTmpUuID[1] = (PPBYTE)((ulTime >> 16) & 0xFF);
		szTmpUuID[2] = (PPBYTE)((ulTime >> 8) & 0xFF);
		szTmpUuID[3] = (PPBYTE)(ulTime & 0xFF);
		szTmpUuID[4] = rand() % 0xFF;
		szTmpUuID[5] = rand() % 0xFF;
		szTmpUuID[6] = rand() % 0xFF;
		szTmpUuID[7] = rand() % 0xFF;

		for (i = 0; i < 8; i++)
        {
            uCheckSum += szTmpUuID[i];
        }
        szTmpUuID[8] = (PPBYTE)((uCheckSum >> 8) % 0xff);
        szTmpUuID[9] = (PPBYTE)((uCheckSum) % 0xff);

		tmpStr = "%02x";
		for (i = 0; i < 10; i++)
        {
			oneWStr.swprintf(tmpWChar,tmpStr,szTmpUuID[i]);
			tmpWChar[2] = 0;
			retStr += tmpWChar;
        }
		
		return retStr;
}

PPCStringW CPPMisc::FixUUID(PPCStringW srcStr)
{
	PPCStringW  tmpOneStr = srcStr;
	PPCStringW  tmpOneStr1;
	PPCStringW  retString;
	int i;
	tmpOneStr1 = "";
	retString = "";

	if ((tmpOneStr.GetLength() > 20) || (tmpOneStr.GetLength() == 0))
	{
		retString = GenerateUuID();
	}else
	{
		if (tmpOneStr.GetLength() == 20)
		{
			retString = tmpOneStr;
		}else
		{
			tmpOneStr1 = "";
			for (i = 0;i < (20-tmpOneStr.GetLength());i++)
			{
				tmpOneStr1 += "0";
			}
			tmpOneStr1 += tmpOneStr;
			retString = tmpOneStr1;
		}
	}
	return retString;
}

#ifdef NestedVM_VERSION
int CPPMisc::PPclock_gettime(int clk_id /*ignored*/, struct timespec *tp)
{
	struct timeval now;
	int rv = gettimeofday(&now, NULL);
	if (rv != 0)
	{
	tp->tv_sec = 0;
	tp->tv_nsec = 0;
	return rv;
	}
	tp->tv_sec = now.tv_sec;
	tp->tv_nsec = now.tv_usec * 1000;
	return 0;
}
#endif
