#ifdef __ANDROID__
	#include "../GlobalDefine.h"
	#include "../stdafx.h"
	#include <stdio.h>
	#include "../PPFileIo.h"
#elif defined __OBJECTIVEC__
    #include "./GlobalDefine.h"
//    #include "./Stdafx.h"
    #include <stdio.h>
    #include "./PPFileIo.h"
#else
	#include "GlobalDefine.h"
	#include "stdafx.h"
	#include <stdio.h>
	#include "PPFileIo.h"
#endif

#define PPWCXF_BUFFER_SIZE	8192


CPPFileIo::CPPFileIo()
{
	
}

CPPFileIo::~CPPFileIo()
{

}

#if defined _WINDOWS

void *CPPFileIo::OpenFile(PPWCHAR *fileName,char *openMode)
{
	char *tmpPtr = 0;
	int iMode;
	DWORD dwDesc; 
	HANDLE tmpFileH;

	
	tmpPtr = strstr(openMode,"b");
	if (tmpPtr != 0)
	{
		tmpPtr = strstr(openMode,"r+");
		if (tmpPtr != 0)
		{
			iMode = GENERIC_READ | GENERIC_WRITE;
			dwDesc = OPEN_EXISTING;
		}else
		{
			tmpPtr = strstr(openMode,"r");
			if (tmpPtr != 0)
			{
				iMode = GENERIC_READ;
				dwDesc = OPEN_EXISTING;
			}else
			{
				tmpPtr = strstr(openMode,"w");
				if (tmpPtr != 0)
				{
					iMode = GENERIC_WRITE;
					dwDesc = CREATE_ALWAYS;
				}
			}
		}
		tmpFileH = CreateFileW(fileName,iMode,FILE_SHARE_READ | FILE_SHARE_WRITE,0,dwDesc,FILE_ATTRIBUTE_NORMAL,0);
		if (INVALID_HANDLE_VALUE == tmpFileH)
		{
			return 0;
		}else
		{
			return tmpFileH;
		}
	}else	// non support text file
	{
		return 0; 
	}
}

int  CPPFileIo::CloseFile(void *fp)
{
	HANDLE tmpFileH = (HANDLE)fp;

	return CloseHandle(tmpFileH);
}

PPINT64 CPPFileIo::GetFilePos(void *fp)
{
	HANDLE tmpFileH = (HANDLE)fp;

	return myGetFilePos(tmpFileH);
}


int CPPFileIo::FileSeek(void *fp,PPINT64 sd,int spos)
{
	HANDLE tmpFileH = (HANDLE)fp;
	int iPos = FILE_BEGIN;
	PPINT64 retV;


	if (spos == SEEK_CUR)
	{
		iPos = FILE_CURRENT;
	}else if (spos == SEEK_END)
	{
		iPos = FILE_END;
	}else
	{
		iPos = FILE_BEGIN;
	}
	retV = myFileSeek(tmpFileH, sd,iPos);
	if (retV == -1)
	{
		return -1;
	}else
	{
		return 0;
	}
}


unsigned int CPPFileIo::ReadFile(void *fp,void *Buffer,int iEsz,int iCount)
{
	/* 
	FILE *fp1 = (FILE *)fp;

		if (fp1 != 0)
		{
			return fread(Buffer,iEsz,iCount,fp1);
		}
		return 0;
		*/
	HANDLE tmpFileH = (HANDLE)fp;
	DWORD tmpSize = 0;

	if (iEsz == 0)
	{
		return 0;
	}
	if (::ReadFile(tmpFileH,Buffer,iEsz*iCount,&tmpSize,0) == FALSE)
	{
		return 0;
	}else
	{
		return tmpSize/iEsz;
	}
}

unsigned int CPPFileIo::WriteFile(void *fp,void *Buffer,int iEsz,int iCount)
{
	/* 
	FILE *fp1 = (FILE *)fp;
	
		if (fp1 != 0)
		{
			return fwrite(Buffer,iEsz,iCount,fp1);
		}
		return 0;
		*/
	HANDLE tmpFileH = (HANDLE)fp;
	DWORD tmpSize = 0;

	if (iEsz == 0)
	{
		return 0;
	}

	if (::WriteFile(tmpFileH,Buffer,iEsz*iCount,&tmpSize,0) == FALSE)
	{
		return 0;
	}else
	{
		return tmpSize/iEsz;
	}
}

void CPPFileIo::PPOutputDebugString( char *inStrP)
{
	PPCStringW oneStrW;
		oneStrW = inStrP;
		PPOutputDebugString(oneStrW);
}

void CPPFileIo::PPOutputDebugString(PPWCHAR *inStrP)
{
	PPCStringW oneStrW;
		oneStrW = inStrP;

		PPOutputDebugString(oneStrW);
}

void CPPFileIo::PPOutputDebugString(PPCStringW inStr)
{
	FILE *fp;
	int iOffset;
	PPBYTE BBB[4096];
	

		fp = fopen(DEF_LOG_PATH,"a+b");
		if (fp != 0)
		{
			fseek(fp,0,SEEK_END);
			iOffset = ftell(fp);
			if (iOffset == 0)
			{
				fclose(fp);
				fp = fopen(DEF_LOG_PATH,"wb");
				if (fp != 0)
				{
					BBB[0] = 0xFF;	
					BBB[1] = 0xFE;
					fwrite(BBB,1,2,fp);
					fclose(fp);
					fp = fopen(DEF_LOG_PATH,"a+b");
					fseek(fp,0,SEEK_END);
				}
			}
			fwrite((char*)inStr.GetBuffer(),1,inStr.GetLength()*sizeof(PPWCHAR),fp);
			fclose(fp);
		}
}

int CPPFileIo::CreateFileByBuffer(char *tmpFile,PPBYTE *Buffer,int iLen)
{
	FILE *fp;
	int iRetV = 0;
	

		fp = fopen(tmpFile,"wb");
		if (fp != 0) 
		{
			if (fwrite(Buffer,sizeof(PPBYTE),iLen,fp) == (unsigned int)iLen)
			{
				iRetV = 1;
			}
			fclose(fp);
		}
		return iRetV;
}



PPINT64 CPPFileIo::myFileSeek (HANDLE hf, PPINT64 distance, DWORD MoveMethod)
{
   LARGE_INTEGER li;

   li.QuadPart = distance;
   
   li.LowPart = SetFilePointer (hf, li.LowPart, &li.HighPart, MoveMethod);

   if (li.LowPart == -1 && GetLastError() != NO_ERROR)
   {
      li.QuadPart = -1;
   }

   return li.QuadPart;
}


PPINT64 CPPFileIo::myGetFilePos(HANDLE hf)
{
   LARGE_INTEGER li;

   li.QuadPart = 0;

   li.HighPart = 0;
   li.LowPart = SetFilePointer (hf, 0, &li.HighPart, FILE_CURRENT);

   if (li.LowPart == -1 && GetLastError() != NO_ERROR)
   {
      li.QuadPart = -1;
   }
   return li.QuadPart;
}


#else


#endif
