#include "stdafx.h"
#include "PPCode.h"
#include <stdio.h>


CPPCode::CPPCode()
{
    
}

CPPCode::~CPPCode()
{
    
}


int CPPCode::PPUTF82Unicode(char *utf8Buffer,int iLen,PPWCHAR *ucodeBuffer,int iULen)
{
    int nowLen = iLen;
    char *nowPtr;
    int iTmpUCode=0;
    int nLen;
    int iUcodeCount = 0;
    
    if (utf8Buffer != 0)
    {
        if (ucodeBuffer == 0)
        {
            iUcodeCount = 0;
            nowPtr = utf8Buffer;
            nLen = UTF8toUnicode((unsigned char*)nowPtr,nowLen,&iTmpUCode);
            while (nLen > 0)
            {
                nowPtr += nLen;
                nowLen -= nLen;
                iUcodeCount++;
                nLen = UTF8toUnicode((unsigned char*)nowPtr,nowLen,&iTmpUCode);
            }
        }
        else
        {
            iUcodeCount = 0;
            nowPtr = utf8Buffer;
            nLen = UTF8toUnicode((unsigned char*)nowPtr,nowLen,&iTmpUCode);
            while (nLen > 0)
            {
                nowPtr += nLen;
                nowLen -= nLen;
                if (iULen > iUcodeCount)
                {
                    ucodeBuffer[iUcodeCount] = iTmpUCode;
                }
                iUcodeCount++;
                nLen = UTF8toUnicode((unsigned char*)nowPtr,nowLen,&iTmpUCode);
            }
        }
    }
    return iUcodeCount;
    
}

int CPPCode::PPUnicode2UTF8(PPWCHAR *ucodeBuffer,int iULen,char *utf8Buffer,int iLen)
{
    int i,j,nLen;
    char cBuffer[1024];
    int idx = 0;
    
    
    if (ucodeBuffer != 0)
    {
        if (utf8Buffer != 0)
        {
            idx = 0;
            for (i = 0;i < iULen;i++)
            {
                nLen = UnicodetoUTF8(ucodeBuffer[i],(unsigned char*)cBuffer,6);
                for (j = 0;j < nLen;j++)
                {
                    if (idx < iLen)
                    {
                        utf8Buffer[idx] = cBuffer[j];
                        idx++;
                    }
                }
            }
        }
        else
        {
            idx = 0;
            for (i = 0;i < iULen;i++)
            {
                nLen = UnicodetoUTF8(ucodeBuffer[i],(unsigned char*)cBuffer,6);
                idx += 	nLen;
            }
        }
    }
    return idx;
}

int CPPCode::UnicodetoUTF8(int unicode, unsigned char *p,int iLen)
{
    unsigned char *e = NULL;
    int n = 0;
    
    if((e = p))
    {
        if(unicode < 0x80)
        {
            if (iLen >= 1)
            {
                *e++ = unicode;
                n = 1;
            }
        }
        else if(unicode < 0x800)
        {
            if (iLen >= 2)
            {
                // <11011111> < 000 0000 0000>
                *e++ = ((unicode >> 6) & 0x1f)|0xc0;
                *e++ = (unicode & 0x3f)|0x80;
                n = 2;
            }
        }
        else if(unicode < 0x10000)
        {
            if (iLen >= 3)
            {
                // <11101111> <0000 0000 0000 0000>
                *e++ = ((unicode >> 12) & 0x0f)|0xe0;
                *e++ = ((unicode >> 6) & 0x3f)|0x80;
                *e++ = (unicode & 0x3f)|0x80;
                n = 3;
            }
        }
        else if(unicode < 0x200000)
        {
            if (iLen >= 4)
            {
                // <11110111> <0 0000 0000 0000 0000 0000>
                *e++ = ((unicode >> 18) & 0x07)|0xf0;
                *e++ = ((unicode >> 12) & 0x3f)|0x80;
                *e++ = ((unicode >> 6) & 0x3f)|0x80;
                *e++ = (unicode & 0x3f)|0x80;
                n = 4;
            }
        }
        else if(unicode < 0x4000000)
        {
            if (iLen >= 5)
            {
                // <00 0000 0000 0000 0000 0000 0000>
                *e++ = ((unicode >> 24) & 0x03)|0xf8 ;
                *e++ = ((unicode >> 18) & 0x3f)|0x80;
                *e++ = ((unicode >> 12) & 0x3f)|0x80;
                *e++ = ((unicode >> 6) & 0x3f)|0x80;
                *e++ = (unicode & 0x3f)|0x80;
                n = 5;
            }
        }
        else
        {
            if (iLen >= 6)
            {
                // <11111101> <0000 0000 0000 0000 0000 0000 0000 0000>
                *e++ = ((unicode >> 30) & 0x01)|0xfc;
                *e++ = ((unicode >> 24) & 0x3f)|0x80;
                *e++ = ((unicode >> 18) & 0x3f)|0x80;
                *e++ = ((unicode >> 12) & 0x3f)|0x80;
                *e++ = ((unicode >> 6) & 0x3f)|0x80;
                *e++ = (unicode & 0x3f)|0x80;
                n = 6;
            }
        }
    }
    return n;
}

/* convert UTF-8 to unicode */
int CPPCode::UTF8toUnicode(unsigned char *ch,int iLen, int *unicode)
{
    unsigned char *p = NULL;
    int e = 0, n = 0;
    
    if((p = ch) && unicode)
    {
        if(*p >= 0xfc)
        {
            /*6:<11111100>*/
            if (iLen >= 6)
            {
                e = (p[0] & 0x01) << 30;
                e |= (p[1] & 0x3f) << 24;
                e |= (p[2] & 0x3f) << 18;
                e |= (p[3] & 0x3f) << 12;
                e |= (p[4] & 0x3f) << 6;
                e |= (p[5] & 0x3f);
                n = 6;
            }
        }
        else if(*p >= 0xf8) 
        {
            /*5:<11111000>*/
            if (iLen >= 5)
            {
                e = (p[0] & 0x03) << 24;
                e |= (p[1] & 0x3f) << 18;
                e |= (p[2] & 0x3f) << 12;
                e |= (p[3] & 0x3f) << 6;
                e |= (p[4] & 0x3f);
                n = 5;
            }
        }
        else if(*p >= 0xf0)
        {
            if (iLen >= 4)
            {
                /*4:<11110000>*/
                e = (p[0] & 0x07) << 18;
                e |= (p[1] & 0x3f) << 12;
                e |= (p[2] & 0x3f) << 6;
                e |= (p[3] & 0x3f);
                n = 4;
            }
        }
        else if(*p >= 0xe0)
        {
            if (iLen >= 3)
            {
                /*3:<11100000>*/
                e = (p[0] & 0x0f) << 12;
                e |= (p[1] & 0x3f) << 6;
                e |= (p[2] & 0x3f);
                n = 3;
            }
        }
        else if(*p >= 0xc0) 
        {
            if (iLen >= 2)
            {
                /*2:<11000000>*/
                e = (p[0] & 0x1f) << 6;
                e |= (p[1] & 0x3f);
                n = 2;
            }
        }
        else 
        {
            if (iLen >= 1)
            {
                e = p[0];
                n = 1;
            }
        }
        *unicode = e;
    }
    return n;
}
