//
//  PPWebViewController.m
//  
//
//  Created by Mike on 13/5/27.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPWebViewController.h"
#import "UIViewController+ShareApplication.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static PPButton *PPWebViewController_DefaultBackButton = nil;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPWebViewController()

@interface PPWebViewController() <WKScriptMessageHandler>
@property(nonatomic,readwrite,retain) PPButton				*ppButtonBack;
@property(nonatomic,readwrite,retain) PPNavigationBarView   *ppNavigationBarView;
@property(nonatomic,readwrite,retain) PPWebView				*ppWebView;
@property(nonatomic,retain) NSArray *scriptMessages;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPWebViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize	ppButtonBack        = ppButtonBack_;
@synthesize	ppNavigationBarView = ppNavigationBarView_;
@synthesize	ppWebView           = ppWebView_;
@synthesize	request             = request_;
@synthesize	webTitle            = webTitle_;
@synthesize	delegate            = delegate_;
@synthesize	openLinkInNewWindow = openLinkInNewWindow_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        _customNavigationBar = YES;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    if(self.navigationItem!=nil)
    {
        self.navigationItem.leftBarButtonItem = nil;
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    self.ppNavigationBarView    = nil;
    self.ppButtonBack           = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    for (NSString *scriptMessage in self.scriptMessages)
    {
        [[[self.ppWebView configuration] userContentController] removeScriptMessageHandlerForName:scriptMessage];
    }
    self.scriptMessages = nil;
    
    [self.ppWebView removeFromSuperview];
    self.ppWebView = nil;

    //////////////////////////////////////////////////
	[request_ release];
    [webTitle_ release];
    
    [_navigationTitleColor release];
    _navigationTitleColor = nil;
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
	[super viewWillAppear:animated];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    [[NSURLCache sharedURLCache] removeAllCachedResponses];

    do
    {
        if (self.ppWebView==nil)
        {
            // !! 使用WKWebView顯示網頁內容時，要加入"<meta name="viewport" content="width=device-width, shrink-to-fit=YES">"
            // 但因為書籤內容可能是外部或舊的，沒有這個meta data所以顯示會錯誤，這邊直接在WebView加入script強制加入
            NSString *jScript = @"var meta = document.createElement('meta'); meta.setAttribute('name', 'viewport'); meta.setAttribute('content', 'width=device-width'); document.getElementsByTagName('head')[0].appendChild(meta);";

            WKUserScript *wkUScript = [[[WKUserScript alloc] initWithSource:jScript injectionTime:WKUserScriptInjectionTimeAtDocumentEnd forMainFrameOnly:YES] autorelease];
            WKUserContentController *wkUController = [[[WKUserContentController alloc] init] autorelease];
            [wkUController addUserScript:wkUScript];

            
            WKWebViewConfiguration *wkWebConfig = [[[WKWebViewConfiguration alloc] init] autorelease];
            
            if([self.delegate respondsToSelector:@selector(scriptMessagesWithPPWebViewController:)])
            {
                self.scriptMessages = [self.delegate scriptMessagesWithPPWebViewController:self];
            }

            for (NSString *scriptMessage in self.scriptMessages)
            {
                [wkUController addScriptMessageHandler:self name:scriptMessage];
            }
            wkWebConfig.userContentController = wkUController;

            if (@available(iOS 11.0, *)) {
                if(self.urlSchemeHandlerDictioanry)
                {
                    for (NSString *key in [self.urlSchemeHandlerDictioanry allKeys])
                    {
                        [wkWebConfig setURLSchemeHandler:[self.urlSchemeHandlerDictioanry objectForKey:key] forURLScheme:key];
                    }
                }
            }
//            
            ppWebView_ = [[PPWebView alloc] initWithFrame:self.view.bounds configuration:wkWebConfig];

//            ppWebView_ = [[PPWebView alloc] initWithFrame:self.view.bounds];
            if(ppWebView_!=nil)
            {
                ppWebView_.openLinkInNewWindow   = self.openLinkInNewWindow;
                ppWebView_.wkNavigationDelegateProxy = self;
                ppWebView_.forceOpenHttps        = self.forceOpenHttps;
                
                if(self.request!=nil)
                {
                    [ppWebView_ loadRequest:self.request];
                }
                
                [self.view addSubview:ppWebView_];
            }
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(self.navigationController==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(self.customNavigationBar==YES)
        {
            ppNavigationBarView_ = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
            if(ppNavigationBarView_!=nil)
            {
                ppNavigationBarView_.style              = PPBarViewStyle_CenteredAbsolute;
                ppNavigationBarView_.tintColor          = self.navigationController.navigationBar.tintColor;
                ppNavigationBarView_.titleLabel.text    = self.webTitle;
                
                if (self.navigationTitleColor)
                {
                    ppNavigationBarView_.titleLabel.textColor = self.navigationTitleColor;
                }
                
                ////////////////////////////////////////////////////////////////////////////////////////////////////
                
                if(self.splitViewController==nil)
                {
                    //////////////////////////////////////////////////
                    // Get buttonClose by delegate or default, if not respond to delegate.
                    
                    if (PPWebViewController_DefaultBackButton!=nil)
                    {
                        self.ppButtonBack = PPWebViewController_DefaultBackButton;
                    }
                    else
                    {
                        PPButton *ppButtonBack = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
                        
                        if( ppButtonBack != nil)
                        {
                            self.ppButtonBack = ppButtonBack;
                            [self.ppButtonBack setBackgroundImageWithName:ImageNamePPButtonBackgroundForBack];
                            [self.ppButtonBack setTitle:NSLocalizedStringFromTable(@"MLS_Back", NSStringFromClass(self.ppButtonBack.class), nil) maxWidth:0];
                            [ppButtonBack release];
                        }
                        
                    }
                    
                    if(self.ppButtonBack != nil)
                    {
                        [self.ppButtonBack addControlEvents:UIControlEventTouchUpInside];
                        self.ppButtonBack.delegate    = self;
                        self.ppButtonBack.tag         = PPWebViewControllerButtonTag_Back;
                        [self.ppNavigationBarView setViews:@[self.ppButtonBack]
                                              forBlockType:PPBarViewBlockType_Left];
                    }
                }
                
                ////////////////////////////////////////////////////////////////////////////////////////////////////
                
                UIBarButtonItem *leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView];
                if(leftBarButtonItem!=nil)
                {
                    self.navigationItem.leftBarButtonItem = leftBarButtonItem;
                    [leftBarButtonItem release];
                }
            }
        }
        else
        {
            self.title = self.webTitle;
        }
       
    }while(0);
    
    if ([self.delegate respondsToSelector:@selector(willShowPPWebViewController:)])
    {
        [self.delegate willShowPPWebViewController:self];
    }
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    if ([self.delegate respondsToSelector:@selector(didHiddenPPWebViewController:)])
    {
        [self.delegate didHiddenPPWebViewController:self];
    }

    if(self.navigationItem!=nil)
    {
        self.navigationItem.leftBarButtonItem = nil;
	}
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    self.ppNavigationBarView    = nil;
	self.ppButtonBack           = nil;

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if (self.isPresentView==NO)
    {
        for (NSString *scriptMessage in self.scriptMessages)
        {
            [[[self.ppWebView configuration] userContentController] removeScriptMessageHandlerForName:scriptMessage];
        }
        self.scriptMessages = nil;
        
        [self.ppWebView removeFromSuperview];
        self.ppWebView = nil;
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Rotation Events


//==============================================================================
//
//==============================================================================
- (BOOL)shouldAutorotate
{
    return (([self.ppWebView isBusy]==YES)?NO:[super shouldAutorotate]);
}


//==============================================================================
//
//==============================================================================
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation
{
	return (([self.ppWebView isBusy]==YES)?NO:[super shouldAutorotateToInterfaceOrientation:toInterfaceOrientation]);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overriding Methods


//==============================================================================
//
//==============================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	self.ppWebView.frame = [self layoutFrame];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Methods


//==============================================================================
//
//==============================================================================
- (void)setRequest:(NSURLRequest *)request
{
    [request retain];
    [request_ release];
    request_ = request;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(self.request!=nil && self.ppWebView!=nil)
    {
        [self.ppWebView loadRequest:self.request];
    }
}


//==============================================================================
//
//==============================================================================
- (void)setWebTitle:(NSString *)webTitle
{
    [webTitle retain];
    [webTitle_ release];
    webTitle_ = webTitle;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(self.ppNavigationBarView!=nil)
    {
        self.ppNavigationBarView.titleLabel.text = self.webTitle;
    }
}






///////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WKNavigationDelegate


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didFailProvisionalNavigation:(WKNavigation *)navigation withError:(NSError *)error
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppWebViewController:didFailLoadWithError:)]==YES)
    {
        [self.delegate ppWebViewController:self didFailLoadWithError:error];
    }
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didFailNavigation:(WKNavigation *)navigation withError:(NSError *)error
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppWebViewController:didFailLoadWithError:)]==YES)
    {
        [self.delegate ppWebViewController:self didFailLoadWithError:error];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WKScriptMessageHandler

- (void)userContentController:(WKUserContentController *)userContentController didReceiveScriptMessage:(WKScriptMessage *)message
{
    if([self.delegate respondsToSelector:@selector(ppWebViewController:didReceiveScriptMessage:)])
    {
        [self.delegate ppWebViewController:self didReceiveScriptMessage:message];
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
	switch(ppButton.tag)
	{
		case PPWebViewControllerButtonTag_Back:
		default:
		{
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppWebViewController:ppButton:controlEvent:)]==YES)
            {
                [self.delegate ppWebViewController:self ppButton:ppButton controlEvent:controlEvent];
            }
            else
            {
                [self goBackAnimated:YES];
            }
			
			break;
		}
	}
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (void)setDefaultBackButton:(PPButton *)backButton
{
    [PPWebViewController_DefaultBackButton release];
    
    PPWebViewController_DefaultBackButton = [backButton retain];
}


@end
