//
//  PPWebViewController.h
//  
//
//  Created by Mike on 13/5/27.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPButton.h"
#import "PPNavigationBarView.h"
#import "PPViewController.h"
#import "PPWebView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPWebViewControllerButtonTag)
{
	PPWebViewControllerButtonTag_Back = 0,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPWebViewController;
@protocol PPWebViewControllerDelegate <NSObject>
@optional
- (void)willShowPPWebViewController:(PPWebViewController *)ppWebViewController;
- (void)didHiddenPPWebViewController:(PPWebViewController *)ppWebViewController;
- (void)ppWebViewController:(PPWebViewController *)ppWebViewController ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent;
- (void)ppWebViewController:(PPWebViewController *)ppWebViewController didFailLoadWithError:(NSError *)error;


#pragma mark Script message
- (void)ppWebViewController:(PPWebViewController *)wctWebViewController didReceiveScriptMessage:(WKScriptMessage *)message;
- (NSArray *)scriptMessagesWithPPWebViewController:(PPWebViewController *)ppWebViewController;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface PPWebViewController : PPViewController   <
                                                    WKNavigationDelegate,
                                                    PPButtonDelegate
                                                    > 
{
@protected
    PPButton							*ppButtonBack_;
	PPNavigationBarView                 *ppNavigationBarView_;
	PPWebView							*ppWebView_;
    NSURLRequest						*request_;
    NSString                            *webTitle_;
    id<PPWebViewControllerDelegate>		delegate_;
    BOOL								openLinkInNewWindow_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - property

@property(nonatomic,readonly,retain)    PPButton                            *ppButtonBack;
@property(nonatomic,readonly,retain)    PPNavigationBarView                 *ppNavigationBarView;
@property(nonatomic,readonly,retain)    PPWebView                           *ppWebView;
@property(nonatomic,retain)             NSURLRequest                        *request;
@property(nonatomic,retain)             NSString                            *webTitle;
@property(nonatomic,assign)             id<PPWebViewControllerDelegate>     delegate;
@property(nonatomic,assign)             BOOL                                openLinkInNewWindow;
@property(nonatomic,assign)             BOOL                                customNavigationBar;
@property(nonatomic,assign)             BOOL                                forceOpenHttps; //default NO;
@property (nonatomic, retain)           UIColor                             *navigationTitleColor;
@property (nonatomic, assign) BOOL isPresentView; //是否呈現其他畫面，default NO
@property(nonatomic,retain)             NSDictionary <NSString *,id<WKURLSchemeHandler>> *urlSchemeHandlerDictioanry API_AVAILABLE(ios(11.0));

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (void)setDefaultBackButton:(PPButton *)backButton;

@end
