//
//  PPWebViewController+HelpMethods.m
//  Pods
//
//  Created by Sanhue Cheng on 2014/2/14.
//
//

#import "PPWebViewController+Dictionary.h"
#import "PPSystemInfoController.h"

@implementation PPWebViewController (Dictionary)





//==============================================================================
#pragma mark
#pragma mark - HelpMethods


//==============================================================================
//
//==============================================================================
+ (PPWebViewController*)webViewControllerWithDictioanry:(NSDictionary*)dictionary
{
    PPWebViewController *webViewController = nil;
    if(dictionary==nil)
    {
#ifdef DEBUG
        NSLog(@"!! dictionary不能為空");
#endif
        return webViewController;
    }
        
    NSString * language = [PPSystemInfoController stringWithLanguage:[PPSystemInfoController language]];
    NSString *urlString = [dictionary objectForKey:language];
    // !!找不到目前語系時，取第一個
    if(urlString==nil||[urlString length]==0)
    {
        urlString = [dictionary objectForKey:@"en"];
    }
    
    // 如果還是沒有，就失敗
    if(urlString==nil||[urlString length]==0)
    {
#ifdef DEBUG
        NSLog(@"!!! 無法取得路徑，請檢查dictionary");
#endif
        return webViewController;
    }
    
    // 判斷是file的話就以bundle當相對路徑
    if(![urlString hasPrefix:@"http"])
    {
        urlString = [[[NSBundle mainBundle] bundlePath] stringByAppendingPathComponent:urlString];
    }

    //////////////////////////////////////////////////
    
    NSURLRequest * request =
    [[NSURLRequest alloc] initWithURL:[NSURL URLWithString:urlString]
                          cachePolicy:NSURLRequestReloadIgnoringLocalCacheData
                      timeoutInterval:60];
    if (request)
    {
        webViewController = [[[PPWebViewController alloc] init] autorelease];
        webViewController.request = request;
        [request release];
    }

    return webViewController;
}



@end
