//
//  PPWebView.m
//  
//
//  Created by Mike on 13/5/22.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPWebView.h"
#import "NSObject+PPBusyView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPWebView()

@interface PPWebView()
@property(nonatomic,assign) id<WKUIDelegate>            wkUIDelegateProxy;
@property(nonatomic,retain) NSURLConnection *urlConnection;
@property(nonatomic,assign) BOOL authenticated;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPWebView





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//==============================================================================
//
//==============================================================================
- (instancetype)initWithFrame:(CGRect)frame configuration:(WKWebViewConfiguration *)configuration
{
    if((self = [super initWithFrame:frame configuration:configuration]))
    {
        self.UIDelegate = self; //dafault為自己,若想自己處理可之後更改delegate
        self.navigationDelegate = self;
    }
    
    return self;
}


//==============================================================================
//
//==============================================================================
- (instancetype)initWithFrame:(CGRect)frame
{
	if((self = [super initWithFrame:frame]))
	{
		self.UIDelegate = self; //dafault為自己,若想自己處理可之後更改delegate
        self.navigationDelegate = self;
	}
	
	return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    [self setBusy:@(NO)];
    
    self.UIDelegate = nil;
    self.navigationDelegate = nil;
    self.scrollView.delegate = nil;
    
    self.wkUIDelegateProxy = nil;
    self.wkNavigationDelegateProxy = nil;
    
    self.urlConnection = nil;
    
	////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Message Proxy Methods


//==============================================================================
//
//==============================================================================
//- (BOOL)respondsToSelector:(SEL)selector
//{
//    BOOL result = NO;
//
//    do {
//        //檢查自己是否有實作該message
//        if([[self class] instancesRespondToSelector:selector])
//        {
//            result = YES;
//            break;
//        }
//
//        if(self.wkUIDelegateProxy!=nil && [self.wkUIDelegateProxy respondsToSelector:selector])
//        {
//            result = YES;
//            break;
//        }
//
//        if(self.wkNavigationDelegateProxy!=nil && [self.wkNavigationDelegateProxy respondsToSelector:selector])
//        {
//            result = YES;
//            break;
//        }
//    } while (0);
//
//    return result;
//}

//
////==============================================================================
////
////==============================================================================
//- (void)forwardInvocation:(NSInvocation *)invocation
//{
//    NSLog(@"forwardInvocation:%@",NSStringFromSelector( [invocation selector]));
//    SEL selector = [invocation selector];
//
//    //將沒有處理到的message轉送出去
//    if(self.wkUIDelegateProxy!=nil && [self.wkUIDelegateProxy respondsToSelector:selector])
//    {
//        [invocation invokeWithTarget:self.wkUIDelegateProxy];
//    }
//    else if(self.wkNavigationDelegateProxy!=nil && [self.wkNavigationDelegateProxy respondsToSelector:selector])
//    {
//        [invocation invokeWithTarget:self.wkNavigationDelegateProxy];
//    }
//    else
//    {
//        [self doesNotRecognizeSelector:selector];
//    }
//}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Configuring the Bounds and Frame Rectangles


//==============================================================================
//
//==============================================================================
- (void)setFrame:(CGRect)frame
{
    [super setFrame:frame];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(self.busyView!=nil)
    {
        self.busyView.frame = self.bounds;
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods


//==============================================================================
//
//==============================================================================
- (BOOL)isBusy
{
    return (self.busyView!=nil);
}


//==============================================================================
//
//==============================================================================
- (void)setBusy:(NSNumber *)busy
{
    [super setBusy:busy];
}





///////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WKNavigationDelegate


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView decidePolicyForNavigationAction:(WKNavigationAction *)navigationAction decisionHandler:(void (^)(WKNavigationActionPolicy))decisionHandler
{
#ifdef DEBUG
    NSLog(@"%s - %@", __PRETTY_FUNCTION__, navigationAction);
#endif
    
    if([self.wkNavigationDelegateProxy respondsToSelector:_cmd]==YES)
    {
        [self.wkNavigationDelegateProxy webView:webView decidePolicyForNavigationAction:navigationAction decisionHandler:^(WKNavigationActionPolicy policy) {

            decisionHandler(policy);
            // !! 如果是cancel就不再往下做
            if(policy==WKNavigationActionPolicyCancel)
            {
                return ;
            }
        }];

        return;
    }
    
    //////////////////////////////////////////////////
    
    if(navigationAction.navigationType==WKNavigationTypeLinkActivated)
    {
        //////////////////////////////////////////////////
        BOOL openAtNewWindow = NO;
        if(self.openLinkInNewWindow==YES)
        {
            //如果link是檔案還是要在內部開
            openAtNewWindow = ![navigationAction.request.URL isFileURL];
        }

        
        if(openAtNewWindow==YES)
        {
            [[UIApplication sharedApplication] openURL:navigationAction.request.URL];
            decisionHandler(WKNavigationActionPolicyCancel);
            return;
        }
        
    }
    else if(navigationAction.navigationType==WKNavigationTypeOther)
    {
        //////////////////////////////////////////////////
        // !! item-appss:// 在外部開
        if ([[navigationAction.request.URL scheme] hasPrefix:@"itms-apps"]==YES)
        {
            [[UIApplication sharedApplication] openURL:navigationAction.request.URL];
            decisionHandler(WKNavigationActionPolicyCancel);
            return;
        }
        
    }
    
    
    decisionHandler(WKNavigationActionPolicyAllow);
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView decidePolicyForNavigationResponse:(WKNavigationResponse *)navigationResponse decisionHandler:(void (^)(WKNavigationResponsePolicy))decisionHandler
{
#ifdef DEBUG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    if([self.wkNavigationDelegateProxy respondsToSelector:_cmd]==YES)
    {
        [self.wkNavigationDelegateProxy webView:webView decidePolicyForNavigationResponse:navigationResponse decisionHandler:^(WKNavigationResponsePolicy policy) {
            
            decisionHandler(policy);
        }];
        
        return;
    }
    
    decisionHandler(WKNavigationResponsePolicyAllow);
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didStartProvisionalNavigation:(WKNavigation *)navigation
{
    if([self isBusy]==NO)
    {
        [self setBusy:@(YES)];
    }
#ifdef DEBUG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    
    if([self.wkNavigationDelegateProxy respondsToSelector:_cmd]==YES)
    {
        [self.wkNavigationDelegateProxy webView:webView didStartProvisionalNavigation:navigation];
        
        return;
    }
}


//==============================================================================
// MARK: HTML redirect
//==============================================================================
- (void)webView:(WKWebView *)webView didReceiveServerRedirectForProvisionalNavigation:(null_unspecified WKNavigation *)navigation
{
#ifdef DEBUG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    
    
    if([self.wkNavigationDelegateProxy respondsToSelector:_cmd]==YES)
    {
        [self.wkNavigationDelegateProxy webView:webView didReceiveServerRedirectForProvisionalNavigation:navigation];
        
        return;
    }

}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didFailProvisionalNavigation:(WKNavigation *)navigation withError:(NSError *)error
{
#ifdef DEBUG
    NSLog(@"%s %@", __PRETTY_FUNCTION__, error);
#endif
    [self setBusy:@(NO)];

    if ([error.domain isEqualToString:NSURLErrorDomain] && error.code == NSURLErrorCancelled)
    {
        // NSURLErrorCancelled is reported when a page has a redirect OR if you load
        // a new URL in the WebView before the previous one came back. We can just
        // ignore these since they aren't real errors.
        // http://stackoverflow.com/questions/1024748/how-do-i-fix-nsurlerrordomain-error-999-in-iphone-3-0-os
        return;
    }
    
    if([self.wkNavigationDelegateProxy respondsToSelector:_cmd]==YES)
    {
        [self.wkNavigationDelegateProxy webView:webView didFailProvisionalNavigation:navigation withError:error];
        
        return;
    }
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didCommitNavigation:(null_unspecified WKNavigation *)navigation
{
#ifdef DEBUG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    
    if([self.wkNavigationDelegateProxy respondsToSelector:_cmd]==YES)
    {
        [self.wkNavigationDelegateProxy webView:webView didCommitNavigation:navigation];
        
        return;
    }

}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didFinishNavigation:(WKNavigation *)navigation
{
#ifdef DEBUG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    [self setBusy:@(NO)];
    
    if([self.wkNavigationDelegateProxy respondsToSelector:_cmd]==YES)
    {
        [self.wkNavigationDelegateProxy webView:webView didFinishNavigation:navigation];
        
        return;
    }

}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didFailNavigation:(WKNavigation *)navigation withError:(NSError *)error
{
#ifdef DEBUG
    NSLog(@"%s %@", __PRETTY_FUNCTION__, error);
#endif
    
    [self setBusy:@(NO)];
    if ([error.domain isEqualToString:NSURLErrorDomain] && error.code == NSURLErrorCancelled)
    {
        // NSURLErrorCancelled is reported when a page has a redirect OR if you load
        // a new URL in the WebView before the previous one came back. We can just
        // ignore these since they aren't real errors.
        // http://stackoverflow.com/questions/1024748/how-do-i-fix-nsurlerrordomain-error-999-in-iphone-3-0-os
        return;
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    // !!如果錯誤不是主要連線網址發生的，就不要顯示錯誤
    NSDictionary*userinfo = [error userInfo];
    NSString *errorURL = [userinfo objectForKey:NSURLErrorFailingURLStringErrorKey];

    // !! 主要網址是空的表示網址不正確，也要顯示錯誤
    if(([[self.URL absoluteString] length]==0)||
       ([errorURL length]>0 &&
        [errorURL isEqualToString:[self.URL absoluteString]]==YES))
    {
        if([self.wkNavigationDelegateProxy respondsToSelector:_cmd]==YES)
        {
            [self.wkNavigationDelegateProxy webView:webView didFailNavigation:navigation withError:error];
            
            return;
        }
    }

}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didReceiveAuthenticationChallenge:(NSURLAuthenticationChallenge *)challenge completionHandler:(void (^)(NSURLSessionAuthChallengeDisposition disposition, NSURLCredential * _Nullable credential))completionHandler
{
#ifdef DEBUG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    
    if([self.wkNavigationDelegateProxy respondsToSelector:_cmd]==YES)
    {
        [self.wkNavigationDelegateProxy webView:webView didReceiveAuthenticationChallenge:challenge completionHandler:completionHandler];
        
        return;
    }
    
    if(self.forceOpenHttps==YES)
    {
        NSURLCredential * credential = [[NSURLCredential alloc] initWithTrust:[challenge protectionSpace].serverTrust];
        completionHandler(NSURLSessionAuthChallengeUseCredential, credential);
    }
    else
    {
        completionHandler(NSURLSessionAuthChallengePerformDefaultHandling, nil);
    }

}


//==============================================================================
//
//==============================================================================
- (void)webViewWebContentProcessDidTerminate:(WKWebView *)webView
{
#ifdef DEBUG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    
    if([self.wkNavigationDelegateProxy respondsToSelector:_cmd]==YES)
    {
        [self.wkNavigationDelegateProxy webViewWebContentProcessDidTerminate:webView];
        
        return;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WKUIDelegate


//==============================================================================
//
//==============================================================================
- (WKWebView *)webView:(WKWebView *)webView createWebViewWithConfiguration:(WKWebViewConfiguration *)configuration forNavigationAction:(WKNavigationAction *)navigationAction windowFeatures:(WKWindowFeatures *)windowFeatures
{
#ifdef DEBUG
    NSLog(@"%s - %@", __PRETTY_FUNCTION__, navigationAction);
#endif
    
    // MARK: 響應javascript的window.open, 這邊要做openURL
    // html link, target=_blank, _new也會進來
    if ([[UIApplication sharedApplication] canOpenURL:navigationAction.request.URL]==NO)
    {
        // MARK: 這邊是否要顯示訊息??
        return nil;
    }
    
    if (@available(iOS 10.0, *))
    {
        [[UIApplication sharedApplication] openURL:navigationAction.request.URL options:@{} completionHandler:nil];
    }
    else
    {
        [[UIApplication sharedApplication] openURL:navigationAction.request.URL];
    }
    return nil;
}


////==============================================================================
////
////==============================================================================
//- (void)webViewDidClose:(WKWebView *)webView
//{
//#ifdef DEBUG
//    NSLog(@"%s", __PRETTY_FUNCTION__);
//#endif
//    
//    if([self.wkUIDelegateProxy respondsToSelector:_cmd]==YES)
//    {
//        [self.wkUIDelegateProxy webViewDidClose:webView];
//        
//        return;
//    }
//}
//
//
////==============================================================================
////
////==============================================================================
- (void)webView:(WKWebView *)webView runJavaScriptAlertPanelWithMessage:(NSString *)message initiatedByFrame:(WKFrameInfo *)frame completionHandler:(void (^)(void))completionHandler
{
#ifdef DEBUG
    NSLog(@"%s- %@", __PRETTY_FUNCTION__, message);
#endif
    
//    if([self.wkUIDelegateProxy respondsToSelector:_cmd]==YES)
//    {
//        [self.wkUIDelegateProxy webView:webView runJavaScriptAlertPanelWithMessage:message initiatedByFrame:frame completionHandler:completionHandler];
//
//        return;
//    }
    completionHandler();
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView runJavaScriptConfirmPanelWithMessage:(NSString *)message initiatedByFrame:(WKFrameInfo *)frame completionHandler:(void (^)(BOOL result))completionHandler
{
#ifdef DEBUG
    NSLog(@"%s- %@", __PRETTY_FUNCTION__, message);
#endif
    
//    if([self.wkUIDelegateProxy respondsToSelector:_cmd]==YES)
//    {
//        [self.wkUIDelegateProxy webView:webView runJavaScriptAlertPanelWithMessage:message initiatedByFrame:frame completionHandler:completionHandler];
//
//        return;
//    }
    completionHandler(YES);

}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView runJavaScriptTextInputPanelWithPrompt:(NSString *)prompt defaultText:(nullable NSString *)defaultText initiatedByFrame:(WKFrameInfo *)frame completionHandler:(void (^)(NSString * _Nullable result))completionHandler
{
#ifdef DEBUG
    NSLog(@"%s- %@", __PRETTY_FUNCTION__, prompt);
#endif
    completionHandler(nil);
}

//
////==============================================================================
////
////==============================================================================
//- (BOOL)webView:(WKWebView *)webView shouldPreviewElement:(WKPreviewElementInfo *)elementInfo
//{
//    <#Do something here#>
//}





@end
